/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel;

import dr.inference.loggers.LogColumn;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.util.Transform;

public interface LogAdditiveCtmcRateProvider
extends Model {
    public double[] getXBeta();

    public LogColumn[] getColumns();

    default public double[] getRates() {
        double[] dArray = this.getXBeta();
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Math.exp(dArray[i]);
        }
        return dArray;
    }

    default public Transform getTransform() {
        return null;
    }

    public static interface DataAugmented
    extends LogAdditiveCtmcRateProvider {
        public Parameter getLogRateParameter();

        public static class ArbitraryTransform
        extends Basic {
            private final Transform transform;

            public ArbitraryTransform(String string, Parameter parameter, Transform transform) {
                super(string, parameter);
                this.transform = transform;
            }

            @Override
            public Transform getTransform() {
                return this.transform;
            }

            @Override
            public double[] getRates() {
                double[] dArray = this.transformedRateParameter.getParameterValues();
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = this.transform.transform(dArray[i]);
                }
                return dArray;
            }

            @Override
            @Deprecated
            public double[] getXBeta() {
                throw new RuntimeException("Deprecated function");
            }
        }

        public static class Basic
        extends AbstractModelLikelihood
        implements DataAugmented {
            final Parameter transformedRateParameter;

            public Basic(String string, Parameter parameter) {
                super(string);
                this.transformedRateParameter = parameter;
                this.addVariable(parameter);
            }

            @Override
            public Parameter getLogRateParameter() {
                return this.transformedRateParameter;
            }

            @Override
            public double[] getXBeta() {
                return this.getLogRateParameter().getParameterValues();
            }

            @Override
            protected void handleModelChangedEvent(Model model, Object object, int n) {
            }

            @Override
            protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
            }

            @Override
            protected void storeState() {
            }

            @Override
            protected void restoreState() {
            }

            @Override
            protected void acceptState() {
            }

            @Override
            public Model getModel() {
                return this;
            }

            @Override
            public double getLogLikelihood() {
                return 0.0;
            }

            @Override
            public void makeDirty() {
            }
        }
    }

    public static interface Integrated
    extends LogAdditiveCtmcRateProvider {
    }
}

