/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Statistic;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractAlgebraStatistic
extends Statistic.Abstract {
    private int firstDataDimension = 0;
    private int dimension = 0;
    private boolean elementwise;
    private final double[] constants;
    private final List<Statistic> statistics = new ArrayList<Statistic>();

    public AbstractAlgebraStatistic(String string, boolean bl, double[] dArray) {
        super(string);
        this.elementwise = bl;
        this.constants = dArray;
        if (dArray != null) {
            this.firstDataDimension = dArray.length;
        }
    }

    public void addStatistic(Statistic statistic) {
        if (this.dimension > 0) {
            throw new IllegalArgumentException("Cannot add more data after the statistic has been evaluated.");
        }
        if (!this.elementwise) {
            if (this.firstDataDimension == 0) {
                this.firstDataDimension = statistic.getDimension();
            } else if (this.firstDataDimension != statistic.getDimension()) {
                throw new IllegalArgumentException("Data added doesn't match previous dimensions");
            }
        }
        this.statistics.add(statistic);
    }

    @Override
    public int getDimension() {
        if (this.dimension == 0) {
            if (!(this.constants == null && this.statistics.size() <= 1 || this.elementwise)) {
                this.dimension = this.statistics.get(0).getDimension();
            } else {
                this.elementwise = true;
                this.dimension = 1;
            }
        }
        return this.dimension;
    }

    @Override
    public double getStatisticValue(int n) {
        this.getDimension();
        double d = Double.NaN;
        for (Statistic statistic : this.statistics) {
            if (this.elementwise) {
                if (Double.isNaN(d)) {
                    d = statistic.getStatisticValue(0);
                }
                for (int i = 1; i < statistic.getDimension(); ++i) {
                    d = this.doOperation(d, statistic.getStatisticValue(i));
                }
                continue;
            }
            if (Double.isNaN(d)) {
                d = statistic.getStatisticValue(n);
                continue;
            }
            d = this.doOperation(d, statistic.getStatisticValue(n));
        }
        if (this.constants != null && this.constants.length > 1) {
            d = this.constants.length == 1 ? this.doOperation(d, this.constants[0]) : this.doOperation(d, this.constants[n]);
        }
        return d;
    }

    protected abstract double doOperation(double var1, double var3);
}

