/*
 * Decompiled with CFR 0.152.
 */
package dr.util;

import dr.util.Author;
import java.util.Arrays;

public class Citation {
    private final Author[] authors;
    private final String title;
    private final int year;
    private final String journal;
    private final String location;
    private final int volume;
    private final int startpage;
    private final int endpage;
    private final Status status;
    private final String DOI;

    public Citation(Author[] authorArray, Status status) {
        this(authorArray, null, null, status);
        if (status != Status.IN_PREPARATION) {
            throw new CitationException("Only citations in preparation may not contain titles or journals");
        }
    }

    public Citation(Author[] authorArray, String string, String string2, Status status) {
        this(authorArray, string, -1, string2, -1, -1, -1, null, status);
        if (status == Status.PUBLISHED) {
            throw new CitationException("Published citations must have years, volumes and pages");
        }
    }

    public Citation(Author[] authorArray, String string, int n, String string2, int n2, int n3, int n4, Status status) {
        this(authorArray, string, n, string2, n2, n3, n4, null, status);
    }

    public Citation(Author[] authorArray, String string, int n, String string2, int n2, int n3, int n4) {
        this(authorArray, string, n, string2, n2, n3, n4, null, Status.PUBLISHED);
    }

    public Citation(Author[] authorArray, String string, int n, String string2, int n2, int n3, int n4, String string3) {
        this(authorArray, string, n, string2, n2, n3, n4, string3, Status.PUBLISHED);
    }

    public Citation(Author[] authorArray, String string, int n, String string2, int n2, int n3, int n4, String string3, Status status) {
        this.authors = authorArray;
        this.title = string;
        this.year = n;
        this.journal = string2;
        this.volume = n2;
        this.startpage = n3;
        this.endpage = n4;
        this.location = null;
        this.DOI = string3;
        this.status = status;
    }

    public Citation(Author[] authorArray, String string, int n, String string2, int n2, String string3) {
        this(authorArray, string, n, string2, n2, string3, null);
    }

    public Citation(Author[] authorArray, String string, int n, String string2, String string3) {
        this(authorArray, string, n, string2, -1, string3, null);
    }

    public Citation(Author[] authorArray, String string, int n, String string2, int n2, String string3, String string4) {
        this.authors = authorArray;
        this.title = string;
        this.year = n;
        this.journal = string2;
        this.location = string3;
        this.volume = n2;
        this.startpage = -1;
        this.endpage = -1;
        this.DOI = string4;
        this.status = Status.PUBLISHED;
    }

    public Citation(Author[] authorArray, String string, int n, String string2, String string3, String string4) {
        this(authorArray, string, n, string2, -1, string3, string4);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.authors[0].toString());
        for (int i = 1; i < this.authors.length; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(this.authors[i].toString());
        }
        stringBuilder.append(" (");
        switch (this.status) {
            case PUBLISHED: {
                stringBuilder.append(this.year);
                break;
            }
            default: {
                stringBuilder.append(this.status.getText());
            }
        }
        stringBuilder.append(") ");
        if (this.title != null) {
            stringBuilder.append(this.title);
        }
        if (this.journal != null) {
            stringBuilder.append(". ");
            stringBuilder.append(this.journal);
        }
        if (this.status == Status.PUBLISHED) {
            stringBuilder.append(". ");
            if (this.location != null) {
                stringBuilder.append(this.location);
            } else {
                stringBuilder.append(this.volume);
                stringBuilder.append(", ");
                stringBuilder.append(this.startpage);
                if (this.endpage > 0) {
                    stringBuilder.append("-").append(this.endpage);
                }
            }
            if (this.DOI != null) {
                stringBuilder.append(". DOI:" + this.DOI);
            }
        }
        return stringBuilder.toString();
    }

    public String toHTML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append(this.authors[0].toString());
        for (int i = 1; i < this.authors.length; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(this.authors[i].toString());
        }
        stringBuilder.append(" (").append(this.year).append(") ");
        stringBuilder.append(this.title).append(". ");
        stringBuilder.append("<i>").append(this.journal).append("</i>");
        if (this.location != null) {
            stringBuilder.append(" ").append(this.location);
        } else {
            stringBuilder.append(" <b>").append(this.volume).append("</b>:");
            stringBuilder.append(this.startpage);
            if (this.endpage > 0) {
                stringBuilder.append("-").append(this.endpage);
            }
        }
        if (this.DOI != null) {
            stringBuilder.append(" <a href=\"http://doi.org/").append(this.DOI).append("\">DOI:").append(this.DOI).append("</a>");
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Citation citation = (Citation)object;
        if (this.year != citation.year) {
            return false;
        }
        if (this.volume != citation.volume) {
            return false;
        }
        if (this.startpage != citation.startpage) {
            return false;
        }
        if (this.endpage != citation.endpage) {
            return false;
        }
        if (!Arrays.equals(this.authors, citation.authors)) {
            return false;
        }
        if (!this.title.equals(citation.title)) {
            return false;
        }
        if (this.journal != null ? !this.journal.equals(citation.journal) : citation.journal != null) {
            return false;
        }
        if (this.location != null ? !this.location.equals(citation.location) : citation.location != null) {
            return false;
        }
        if (this.status != citation.status) {
            return false;
        }
        return this.DOI != null ? this.DOI.equals(citation.DOI) : citation.DOI == null;
    }

    public int hashCode() {
        int n = Arrays.hashCode(this.authors);
        n = 31 * n + this.title.hashCode();
        n = 31 * n + this.year;
        n = 31 * n + (this.journal != null ? this.journal.hashCode() : 0);
        n = 31 * n + (this.location != null ? this.location.hashCode() : 0);
        n = 31 * n + this.volume;
        n = 31 * n + this.startpage;
        n = 31 * n + this.endpage;
        n = 31 * n + this.status.hashCode();
        n = 31 * n + (this.DOI != null ? this.DOI.hashCode() : 0);
        return n;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getDOI() {
        return this.DOI;
    }

    public static enum Status {
        IN_PREPARATION("in preparation"),
        IN_SUBMISSION("in submission"),
        IN_PRESS("in press"),
        ACCEPTED("accepted"),
        PUBLISHED("published");

        private final String text;

        private Status(String string2) {
            this.text = string2;
        }

        public String getText() {
            return this.text;
        }
    }

    class CitationException
    extends RuntimeException {
        CitationException(String string) {
            super(string);
        }
    }

    public static enum Category {
        FRAMEWORK("Framework"),
        COMPUTATIONAL_LIBRARY("High-Performance Computing"),
        ADVANCED_ESTIMATION_METHODS("Advanced Estimation Methods"),
        SUBSTITUTION_MODELS("Substitution Models"),
        PRIOR_MODELS("Prior Models"),
        TRAIT_MODELS("Trait Models"),
        DATA_MODELS("Data Models"),
        SPECIES_MODELS("Species Models"),
        COUNTING_PROCESSES("Counting Processes"),
        TREE_PRIORS("Tree Density Models"),
        MOLECULAR_CLOCK("Molecular Clock Models"),
        TREE_METRICS("Tree Metrics"),
        MISC("Misc");

        private final String text;

        private Category(String string2) {
            this.text = string2;
        }

        public String toString() {
            return this.text;
        }
    }
}

