/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.menu;

import javax.swing.DefaultListModel;
import javax.swing.JOptionPane;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.menu.SubsetDialog;

public class CorModel {
    public String dataName = "";
    public DefaultListModel variables = new DefaultListModel();
    public DefaultListModel with = new DefaultListModel();
    public String subset = "";
    public String method = "pearson";
    public OptModel options = new OptModel();
    public Plots plots = new Plots();

    public boolean run() {
        String string;
        boolean bl = true;
        if (this.dataName == null) {
            return false;
        }
        if (this.variables.size() == 0) {
            JOptionPane.showMessageDialog(null, "Please select one or more outcome variables.");
            return false;
        }
        if (this.with.size() == 0) {
            bl = false;
        }
        this.subset = this.subset.trim();
        String string2 = "";
        String string3 = Deducer.makeRCollection(this.variables, "d", false);
        String string4 = bl ? Deducer.makeRCollection(this.with, "d", false) : "";
        String string5 = Deducer.getUniqueName("corr.mat");
        if (this.dataName == "") {
            return false;
        }
        boolean bl2 = false;
        if (!this.subset.equals("")) {
            if (!SubsetDialog.isValidSubsetExp(this.subset, this.dataName)) {
                JOptionPane.showMessageDialog(null, "Sorry, the subset expression seems to be invalid.");
                return false;
            }
            string = Deducer.getUniqueName(this.dataName + ".sub");
            string2 = string + "<-subset(" + this.dataName + "," + this.subset + ")\n";
            bl2 = true;
        } else {
            string = this.dataName;
        }
        if (this.plots.matrix && bl) {
            int n = JOptionPane.showConfirmDialog(null, "The type of plot selected can only be used when\nno with variables are selected.\nWould you like tocontinue without the plot?", "Invalid plot type", 0);
            if (n == 2) {
                return false;
            }
            this.plots.matrix = false;
        }
        string2 = string2 + string5 + "<-cor.matrix(variables=" + string3 + (bl ? ",\n\twith.variables=" + string4 : ",") + ",\n\t data=" + string + ",\n\t test=cor.test,\n\t method='" + this.method + "'" + (this.options.confLevel == 0.95 ? "" : ",\n\tconf.level=" + this.options.confLevel) + ",\n\talternative=\"" + this.options.alternative + "\"" + (this.method.equals("spearman") ? ",\n\texact=FALSE" : "") + ")\n";
        if (this.options.showTable) {
            string2 = string2 + "print(" + string5 + (this.options.digits.equals("<auto>") ? "" : ",digits=" + this.options.digits) + (this.options.n ? "" : ",N=FALSE") + (this.options.ci ? "" : ",CI=FALSE") + (this.options.stat ? "" : ",stat=FALSE") + (this.options.pValue ? "" : ",p.value=FALSE") + ")\n";
        }
        if (!this.plots.none) {
            if (this.plots.scatterArray) {
                string2 = string2 + "qscatter_array(" + string3 + ",\n\t" + (bl ? string4 : string3) + ",\n\tdata=" + string + (!this.plots.common ? ",common.scales=FALSE" : "") + (this.plots.saAlpha != 0.25 ? ",alpha=" + this.plots.saAlpha : "") + ")";
                string2 = this.plots.saLines.equals("Linear") ? string2 + " + geom_smooth(method=\"lm\")\n" : (this.plots.saLines.equals("Loess") ? string2 + " + geom_smooth()\n" : string2 + "\n");
            }
            if (this.plots.matrix) {
                string2 = string2 + "ggcorplot(cor.mat=" + string5 + ",data=" + string + ",\n\tcor_text_limits=c(5," + this.plots.mSize + ")" + (this.plots.mAlpha != 0.25 ? ",\n\talpha=" + new Double(this.plots.mAlpha).toString() : "");
                string2 = this.plots.mLines.equals("Linear") ? string2 + ",\n\tline.method=\"lm\"" : (this.plots.mLines.equals("Loess") ? string2 + ",\n\tline.method=\"loess\"" : string2 + ",\n\tlines=FALSE");
                string2 = string2 + ")\n";
            }
            if (this.plots.circles) {
                string2 = string2 + "plot(" + string5 + (this.plots.cRadius != 10 ? ",size=" + this.plots.cRadius : "") + ")\n";
            }
        }
        string2 = bl2 ? string2 + "rm('" + string + "','" + string5 + "')\n" : string2 + "rm('" + string5 + "')\n";
        Deducer.execute(string2);
        return true;
    }

    public class OptModel {
        public boolean showTable = true;
        public boolean ci = true;
        public boolean n = true;
        public boolean stat = true;
        public boolean pValue = true;
        public String digits = "<auto>";
        public String alternative = "two.sided";
        public double confLevel = 0.95;
    }

    public class Plots {
        public boolean scatterArray = false;
        public boolean common = true;
        public String saLines = "Linear";
        public double saAlpha = 0.25;
        public boolean matrix = false;
        public String mLines = "Linear";
        public int mSize = 20;
        public double mAlpha = 0.25;
        public boolean ellipse = false;
        public boolean circles = false;
        public int cRadius = 10;
        public boolean none = true;
    }
}

