/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.plots;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.rosuda.deducer.plots.Aes;
import org.rosuda.deducer.plots.CompoundElementModel;
import org.rosuda.deducer.plots.ElementModel;
import org.rosuda.deducer.plots.ElementView;
import org.rosuda.deducer.plots.Layer;
import org.rosuda.deducer.plots.PlotBuilderModel;
import org.rosuda.deducer.plots.PlottingElement;
import org.rosuda.deducer.plots.TemplateView;
import org.rosuda.deducer.widgets.param.Param;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Template
implements CompoundElementModel {
    protected PlottingElement[] elements = new PlottingElement[0];
    private String data;
    protected MaskingAes[] mAess = new MaskingAes[0];
    protected MaskingParam[] mParams = new MaskingParam[0];

    @Override
    public PlottingElement[] getElements() {
        return this.elements;
    }

    @Override
    public String checkValid() {
        for (int i = 0; i < this.getModels().length; ++i) {
            String string = this.getModels()[i].checkValid();
            if (string == null) continue;
            return string;
        }
        return null;
    }

    @Override
    public String getCall() {
        String string = "";
        for (int i = 0; i < this.getModels().length; ++i) {
            if (!this.elements[i].isActive()) continue;
            string = string + (i == 0 ? "" : " +\n\t") + this.getModels()[i].getCall();
        }
        return string;
    }

    @Override
    public Vector getParams() {
        Vector<Param> vector = new Vector<Param>();
        for (int i = 0; i < this.mParams.length; ++i) {
            if (!this.mParams[i].show) continue;
            vector.add(this.mParams[i].param);
        }
        return vector;
    }

    public Vector getAess() {
        Vector<Aes> vector = new Vector<Aes>();
        for (int i = 0; i < this.mAess.length; ++i) {
            if (!this.mAess[i].show) continue;
            vector.add(this.mAess[i].aes);
        }
        return vector;
    }

    public Vector getMAess() {
        Vector<MaskingAes> vector = new Vector<MaskingAes>();
        for (int i = 0; i < this.mAess.length; ++i) {
            if (!this.mAess[i].show) continue;
            vector.add(this.mAess[i]);
        }
        return vector;
    }

    @Override
    public String getType() {
        return "template";
    }

    @Override
    public ElementView getView() {
        return new TemplateView(this);
    }

    @Override
    public void setFromXML(Element element) {
        Object object;
        Element element2;
        int n;
        String string = element.getAttribute("className");
        if (!string.equals("org.rosuda.deducer.plots.Template")) {
            System.out.println("Error Template: class mismatch: " + string);
            new Exception().printStackTrace();
        }
        this.data = element.hasAttribute("data") ? element.getAttribute("data") : null;
        Element element3 = (Element)element.getElementsByTagName("elements").item(0);
        NodeList nodeList = element3.getElementsByTagName("PlottingElement");
        this.elements = new PlottingElement[nodeList.getLength()];
        for (n = 0; n < nodeList.getLength(); ++n) {
            element2 = (Element)nodeList.item(n);
            object = new PlottingElement();
            ((PlottingElement)object).setFromXML(element2);
            this.elements[n] = object;
        }
        element3 = (Element)element.getElementsByTagName("mAess").item(0);
        nodeList = element3.getElementsByTagName("MaskingAes");
        this.mAess = new MaskingAes[nodeList.getLength()];
        for (n = 0; n < nodeList.getLength(); ++n) {
            element2 = (Element)nodeList.item(n);
            object = new MaskingAes();
            ((MaskingAes)object).setFromXML(element2);
            this.mAess[n] = object;
        }
        element3 = (Element)element.getElementsByTagName("mParams").item(0);
        nodeList = element3.getElementsByTagName("MaskingParam");
        this.mParams = new MaskingParam[nodeList.getLength()];
        for (n = 0; n < nodeList.getLength(); ++n) {
            element2 = (Element)nodeList.item(n);
            object = new MaskingParam();
            ((MaskingParam)object).setFromXML(element2);
            this.mParams[n] = object;
        }
        this.updateElementModels();
    }

    @Override
    public Element toXML() {
        try {
            Element element;
            int n;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element2 = document.createElement("ElementModel");
            element2.setAttribute("className", "org.rosuda.deducer.plots.Template");
            if (this.data != null) {
                element2.setAttribute("data", this.data);
            }
            Element element3 = document.createElement("elements");
            for (n = 0; n < this.elements.length; ++n) {
                element = this.elements[n].toXML();
                element = (Element)document.importNode(element, true);
                element3.appendChild(element);
            }
            element2.appendChild(element3);
            element3 = document.createElement("mAess");
            for (n = 0; n < this.mAess.length; ++n) {
                element = this.mAess[n].toXML();
                element = (Element)document.importNode(element, true);
                element3.appendChild(element);
            }
            element2.appendChild(element3);
            element3 = document.createElement("mParams");
            for (n = 0; n < this.mParams.length; ++n) {
                element = this.mParams[n].toXML();
                element = (Element)document.importNode(element, true);
                element3.appendChild(element);
            }
            element2.appendChild(element3);
            return element2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public Object clone() {
        int n;
        Template template = new Template();
        template.elements = new PlottingElement[this.elements.length];
        for (n = 0; n < this.elements.length; ++n) {
            template.elements[n] = (PlottingElement)this.elements[n].clone();
        }
        template.mAess = new MaskingAes[this.mAess.length];
        for (n = 0; n < this.mAess.length; ++n) {
            template.mAess[n] = (MaskingAes)this.mAess[n].clone(template);
        }
        template.mParams = new MaskingParam[this.mParams.length];
        for (n = 0; n < this.mParams.length; ++n) {
            template.mParams[n] = (MaskingParam)this.mParams[n].clone(template);
        }
        template.data = this.data;
        return template;
    }

    public void addElement(PlottingElement plottingElement, boolean bl) {
        PlottingElement[] plottingElementArray = new PlottingElement[this.elements.length + 1];
        for (int i = 0; i < this.elements.length; ++i) {
            plottingElementArray[i] = this.elements[i];
        }
        plottingElementArray[this.getModels().length] = plottingElement;
        this.elements = plottingElementArray;
    }

    private void addMaskingAes(MaskingAes maskingAes) {
        MaskingAes[] maskingAesArray = new MaskingAes[this.mAess.length + 1];
        for (int i = 0; i < this.mAess.length; ++i) {
            maskingAesArray[i] = this.mAess[i];
        }
        maskingAesArray[this.mAess.length] = maskingAes;
        this.mAess = maskingAesArray;
    }

    private void addMaskingParam(MaskingParam maskingParam) {
        MaskingParam[] maskingParamArray = new MaskingParam[this.mParams.length + 1];
        for (int i = 0; i < this.mParams.length; ++i) {
            maskingParamArray[i] = this.mParams[i];
        }
        maskingParamArray[this.mParams.length] = maskingParam;
        this.mParams = maskingParamArray;
    }

    public void addParam(Param param, int n, boolean bl) {
        MaskingParam maskingParam = new MaskingParam();
        maskingParam.param = (Param)param.clone();
        maskingParam.paramName = param.getName();
        maskingParam.elementIndex = n;
        maskingParam.show = bl;
        this.addMaskingParam(maskingParam);
    }

    public void addAes(Aes aes, Vector vector, int n, String string, boolean bl) {
        int n2;
        boolean bl2 = false;
        for (int i = 0; i < this.mAess.length; ++i) {
            if (!this.mAess[i].name.equals(aes.name) || aes.useVariable != this.mAess[i].isMap || !aes.useVariable || aes.variable == null || !aes.variable.equals(this.mAess[i].aes.variable)) continue;
            if (!this.mAess[i].elementIndices.contains(new Integer(n))) {
                this.mAess[i].elementIndices.add(new Integer(n));
            }
            this.mAess[i].aes.name = string;
            this.mAess[i].show = bl;
            for (n2 = 0; n2 < vector.size(); ++n2) {
                this.mAess[i].generated.add(vector.get(n2));
            }
            bl2 = true;
            break;
        }
        if (!bl2) {
            MaskingAes maskingAes = new MaskingAes();
            maskingAes.aes = (Aes)aes.clone();
            maskingAes.aes.name = string;
            maskingAes.name = aes.name;
            maskingAes.elementIndices.add(new Integer(n));
            maskingAes.isMap = aes.useVariable;
            maskingAes.show = bl;
            for (n2 = 0; n2 < vector.size(); ++n2) {
                maskingAes.generated.add(vector.get(n2));
            }
            this.addMaskingAes(maskingAes);
        }
    }

    public void updateElementModels() {
        int n;
        for (n = 0; n < this.elements.length; ++n) {
            ElementModel elementModel = this.elements[n].getModel();
            if (!(elementModel instanceof Layer)) continue;
            ((Layer)elementModel).data = this.data;
        }
        for (n = 0; n < this.mAess.length; ++n) {
            this.mAess[n].update();
        }
        for (n = 0; n < this.mParams.length; ++n) {
            this.mParams[n].update();
        }
    }

    public static Template makeTemplate(PlotBuilderModel plotBuilderModel) {
        Template template = new Template();
        DefaultListModel defaultListModel = plotBuilderModel.getListModel();
        for (int i = 0; i < defaultListModel.size(); ++i) {
            boolean bl;
            Object object;
            int n;
            Vector vector;
            ElementModel elementModel = ((PlottingElement)defaultListModel.get(i)).getModel();
            if (elementModel.getData() != null) {
                template.data = elementModel.getData();
            }
            template.addElement((PlottingElement)defaultListModel.get(i), true);
            if (elementModel instanceof Layer) {
                vector = ((Layer)elementModel).aess;
                for (n = 0; n < vector.size(); ++n) {
                    object = (Aes)vector.get(n);
                    bl = ((Aes)object).useVariable ? ((Aes)object).getAesCalls().length > 0 : ((Aes)object).getParamCalls().length > 0;
                    Vector vector2 = ((Layer)elementModel).stat.generated;
                    template.addAes((Aes)((Aes)object).clone(), vector2, i, ((Aes)object).name, bl);
                }
            }
            vector = elementModel.getParams();
            for (n = 0; n < vector.size(); ++n) {
                object = (Param)vector.get(n);
                bl = ((Param)object).getParamCalls().length > 0;
                template.addParam((Param)((Param)object).clone(), i, bl);
            }
        }
        return template;
    }

    protected ElementModel[] getModels() {
        ElementModel[] elementModelArray = new ElementModel[this.elements.length];
        for (int i = 0; i < this.elements.length; ++i) {
            elementModelArray[i] = this.elements[i].getModel();
        }
        return elementModelArray;
    }

    public void saveToFile(File file) {
        Template template = (Template)this.clone();
        for (int i = 0; i < template.mAess.length; ++i) {
            template.mAess[i].aes.variable = null;
            template.mAess[i].update();
        }
        Element element = template.toXML();
        Document document = element.getOwnerDocument();
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            DOMSource dOMSource = new DOMSource(document);
            transformer.transform(dOMSource, streamResult);
            String string = stringWriter.toString();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            outputStreamWriter.write(string);
            outputStreamWriter.close();
            fileOutputStream.close();
            stringWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setFromFile(File file) {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            Element element = (Element)document.getChildNodes().item(0);
            this.setFromXML(element);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setData(String string) {
        this.data = string;
    }

    @Override
    public String getData() {
        return this.data;
    }

    public class MaskingAes {
        Aes aes;
        Vector elementIndices = new Vector();
        String name;
        boolean isMap = true;
        boolean show = true;
        public Vector generated = new Vector();

        public Object clone(Template template) {
            int n;
            MaskingAes maskingAes = template.new MaskingAes();
            maskingAes.aes = (Aes)this.aes.clone();
            for (n = 0; n < this.elementIndices.size(); ++n) {
                maskingAes.elementIndices.add(new Integer((Integer)this.elementIndices.get(n)));
            }
            maskingAes.name = this.name;
            maskingAes.isMap = this.isMap;
            maskingAes.show = this.show;
            maskingAes.generated = new Vector();
            for (n = 0; n < this.generated.size(); ++n) {
                maskingAes.generated.add(this.generated.get(n));
            }
            return maskingAes;
        }

        public void update() {
            for (int i = 0; i < this.elementIndices.size(); ++i) {
                Aes aes;
                int n;
                Layer layer = (Layer)Template.this.getModels()[(Integer)this.elementIndices.get(i)];
                Vector vector = layer.aess;
                for (n = 0; n < vector.size(); ++n) {
                    aes = (Aes)vector.get(n);
                    if (!aes.name.equals(this.name) || !this.show) continue;
                    if (this.isMap) {
                        aes.variable = this.aes.variable;
                        continue;
                    }
                    aes.value = this.aes.value;
                }
                vector = layer.stat.aess;
                for (n = 0; n < vector.size(); ++n) {
                    aes = (Aes)vector.get(n);
                    if (!aes.name.equals(this.name) || !this.show) continue;
                    if (this.isMap) {
                        aes.variable = this.aes.variable;
                        continue;
                    }
                    aes.value = this.aes.value;
                }
                vector = layer.geom.aess;
                for (n = 0; n < vector.size(); ++n) {
                    aes = (Aes)vector.get(n);
                    if (!aes.name.equals(this.name) || !this.show) continue;
                    if (this.isMap) {
                        aes.variable = this.aes.variable;
                        continue;
                    }
                    aes.value = this.aes.value;
                }
            }
        }

        public Element toXML() {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.newDocument();
                Element element = document.createElement("MaskingAes");
                element.setAttribute("className", "org.rosuda.deducer.plots.Template.MaskingAes");
                if (this.name != null) {
                    element.setAttribute("name", this.name);
                }
                Element element2 = document.createElement("elementIndices");
                if (this.elementIndices != null) {
                    for (int i = 0; i < this.elementIndices.size(); ++i) {
                        element2.setAttribute("element_" + i, this.elementIndices.get(i).toString());
                    }
                }
                element.appendChild(element2);
                Element element3 = document.createElement("generated");
                if (this.generated != null) {
                    for (int i = 0; i < this.generated.size(); ++i) {
                        element3.setAttribute("element_" + i, this.generated.get(i).toString());
                    }
                }
                element.appendChild(element3);
                element.setAttribute("isMap", this.isMap ? "true" : "false");
                element.setAttribute("show", this.show ? "true" : "false");
                Element element4 = this.aes.toXML();
                element4 = (Element)document.importNode(element4, true);
                element.appendChild(element4);
                document.appendChild(element);
                return element;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }

        public void setFromXML(Element element) {
            Node node;
            String string = element.getAttribute("className");
            if (!string.equals("org.rosuda.deducer.plots.Template.MaskingAes")) {
                System.out.println("Error MaskingAes: class mismatch: " + string);
                new Exception().printStackTrace();
            }
            this.name = element.hasAttribute("name") ? element.getAttribute("name") : null;
            Node node2 = element.getElementsByTagName("generated").item(0);
            NamedNodeMap namedNodeMap = node2.getAttributes();
            if (namedNodeMap.getLength() > 0) {
                this.generated = new Vector();
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    this.generated.add(i, namedNodeMap.item(i).getNodeValue());
                }
            }
            if ((namedNodeMap = (node = element.getElementsByTagName("elementIndices").item(0)).getAttributes()).getLength() > 0) {
                this.elementIndices = new Vector();
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    this.elementIndices.add(new Integer(Integer.parseInt(namedNodeMap.item(i).getNodeValue())));
                }
            }
            this.show = element.getAttribute("show").equals("true");
            this.isMap = element.getAttribute("isMap").equals("true");
            Element element2 = (Element)element.getElementsByTagName("Aes").item(0);
            Aes aes = new Aes();
            aes.setFromXML(element2);
            this.aes = aes;
        }
    }

    public class MaskingParam {
        Param param;
        String paramName = "";
        int elementIndex = -1;
        boolean show = true;

        public Object clone(Template template) {
            MaskingParam maskingParam = template.new MaskingParam();
            maskingParam.param = (Param)this.param.clone();
            maskingParam.paramName = this.paramName;
            maskingParam.elementIndex = this.elementIndex;
            maskingParam.show = this.show;
            return maskingParam;
        }

        public void update() {
            ElementModel elementModel = Template.this.getModels()[this.elementIndex];
            Vector vector = elementModel.getParams();
            for (int i = 0; i < vector.size(); ++i) {
                Param param = (Param)vector.get(i);
                if (!param.getName().equals(this.paramName) || !this.show) continue;
                param.setValue(this.param.getValue());
            }
        }

        public Element toXML() {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.newDocument();
                Element element = document.createElement("MaskingParam");
                element.setAttribute("className", "org.rosuda.deducer.plots.Template.MaskingParam");
                if (this.paramName != null) {
                    element.setAttribute("paramName", this.paramName);
                }
                element.setAttribute("elementIndex", this.elementIndex + "");
                element.setAttribute("show", this.show ? "true" : "false");
                Element element2 = this.param.toXML();
                element2 = (Element)document.importNode(element2, true);
                element.appendChild(element2);
                document.appendChild(element);
                return element;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }

        public void setFromXML(Element element) {
            String string = element.getAttribute("className");
            if (!string.equals("org.rosuda.deducer.plots.Template.MaskingParam")) {
                System.out.println("Error MaskingParam: class mismatch: " + string);
                new Exception().printStackTrace();
            }
            this.paramName = element.hasAttribute("paramName") ? element.getAttribute("paramName") : null;
            this.elementIndex = Integer.parseInt(element.getAttribute("elementIndex"));
            this.show = element.getAttribute("show").equals("true");
            Element element2 = (Element)element.getElementsByTagName("Param").item(0);
            string = element2.getAttribute("className");
            Param param = Param.makeParam(string);
            param.setFromXML(element2);
            this.param = param;
        }
    }
}

