/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.sql;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Stack;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ohdsi.sql.BigQuerySparkTranslate;
import org.ohdsi.sql.SqlSplit;
import org.ohdsi.sql.StringUtils;

public class SqlTranslate {
    public static int SESSION_ID_LENGTH = 8;
    public static int MAX_TABLE_NAME_LENGTH = 63;
    private static Map<String, List<String[]>> targetToReplacementPatterns = null;
    private static ReentrantLock lock = new ReentrantLock();
    private static Random random = new Random();
    private static String globalSessionId = null;
    private static String BIG_QUERY = "bigquery";
    private static String IMPALA = "impala";
    private static String SPARK = "spark";

    protected static List<Block> parseSearchPattern(String pattern) {
        List<StringUtils.Token> tokens = StringUtils.tokenizeSql(pattern.toLowerCase());
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (int i = 0; i < tokens.size(); ++i) {
            Block block = new Block(tokens.get(i));
            if (block.text.length() > 2 && block.text.charAt(0) == '@') {
                block.isVariable = true;
            }
            if (block.text.equals("@@") && i < tokens.size() - 2 && tokens.get((int)(i + 1)).text.equals("(")) {
                boolean escape = false;
                int nesting = 0;
                for (int j = i + 2; j < tokens.size(); ++j) {
                    if (escape) {
                        escape = false;
                        continue;
                    }
                    if (tokens.get((int)j).text.equals("\\")) {
                        escape = true;
                        continue;
                    }
                    if (!escape && tokens.get((int)j).text.equals("(")) {
                        ++nesting;
                        continue;
                    }
                    if (escape || !tokens.get((int)j).text.equals(")")) continue;
                    if (nesting == 0) {
                        block.text = "@@" + tokens.get((int)(j + 1)).text;
                        block.regEx = pattern.substring(tokens.get((int)(i + 1)).end, tokens.get((int)j).start);
                        block.end = tokens.get((int)(j + 1)).end;
                        block.isVariable = true;
                        i = j + 1;
                        break;
                    }
                    --nesting;
                }
            }
            blocks.add(block);
        }
        if (((Block)blocks.get((int)0)).isVariable && ((Block)blocks.get((int)0)).regEx == null || ((Block)blocks.get((int)(blocks.size() - 1))).isVariable && ((Block)blocks.get((int)(blocks.size() - 1))).regEx == null) {
            throw new RuntimeException("Error in search pattern: pattern cannot start or end with a non-regex variable: " + pattern);
        }
        return blocks;
    }

    protected static MatchedPattern search(String sql, List<Block> parsedPattern, int startToken) {
        String lowercaseSql = sql.toLowerCase();
        List<StringUtils.Token> tokens = StringUtils.tokenizeSql(lowercaseSql);
        int matchCount = 0;
        int varStart = 0;
        Stack<String> nestStack = new Stack<String>();
        boolean inPatternQuote = false;
        MatchedPattern matchedPattern = new MatchedPattern();
        for (int cursor = startToken; cursor < tokens.size(); ++cursor) {
            StringUtils.Token token = tokens.get(cursor);
            if (parsedPattern.get((int)matchCount).isVariable) {
                if (parsedPattern.get((int)matchCount).regEx != null && (matchCount == parsedPattern.size() - 1 || parsedPattern.get((int)(matchCount + 1)).isVariable)) {
                    Pattern pattern = Pattern.compile(parsedPattern.get((int)matchCount).regEx, 42);
                    Matcher matcher = pattern.matcher(sql.substring(token.start));
                    if (matcher.find() && matcher.start() == 0) {
                        if (matchCount == 0) {
                            matchedPattern.start = token.start;
                            matchedPattern.startToken = cursor;
                        }
                        matchedPattern.variableToValue.put(parsedPattern.get((int)matchCount).text, sql.substring(token.start, token.start + matcher.end()));
                        if (++matchCount == parsedPattern.size()) {
                            matchedPattern.end = token.start + matcher.end();
                            return matchedPattern;
                        }
                        if (parsedPattern.get((int)matchCount).isVariable) {
                            varStart = token.start + matcher.end();
                        }
                        while (cursor < tokens.size() && tokens.get((int)cursor).start < token.start + matcher.end()) {
                            ++cursor;
                        }
                        --cursor;
                    } else {
                        matchCount = 0;
                    }
                } else if (nestStack.size() == 0 && matchCount < parsedPattern.size() - 1 && token.text.equals(parsedPattern.get((int)(matchCount + 1)).text)) {
                    if (parsedPattern.get((int)matchCount).regEx != null && matchCount == 0) {
                        int start = SqlTranslate.matchesEnd(parsedPattern.get((int)matchCount).regEx, sql.substring(varStart, token.start));
                        if (start != -1) {
                            matchedPattern.variableToValue.put(parsedPattern.get((int)matchCount).text, sql.substring(start + varStart, token.start));
                            matchedPattern.start = start + varStart;
                            matchedPattern.startToken = cursor;
                            if ((matchCount += 2) == parsedPattern.size()) {
                                matchedPattern.end = token.end;
                                return matchedPattern;
                            }
                            if (parsedPattern.get((int)matchCount).isVariable) {
                                int n = varStart = cursor < tokens.size() - 1 ? tokens.get((int)(cursor + 1)).start : -1;
                            }
                            if (token.text.equals("'") || token.text.equals("'")) {
                                inPatternQuote = !inPatternQuote;
                            }
                        }
                    } else if (parsedPattern.get((int)matchCount).regEx != null && !SqlTranslate.matches(parsedPattern.get((int)matchCount).regEx, sql.substring(varStart, token.start))) {
                        matchCount = 0;
                        cursor = matchedPattern.startToken;
                    } else {
                        matchedPattern.variableToValue.put(parsedPattern.get((int)matchCount).text, sql.substring(varStart, token.start));
                        if ((matchCount += 2) == parsedPattern.size()) {
                            matchedPattern.end = token.end;
                            return matchedPattern;
                        }
                        if (parsedPattern.get((int)matchCount).isVariable) {
                            int n = varStart = cursor < tokens.size() - 1 ? tokens.get((int)(cursor + 1)).start : -1;
                        }
                        if (token.text.equals("'") || token.text.equals("'")) {
                            inPatternQuote = !inPatternQuote;
                        }
                    }
                } else if (matchCount != 0 && nestStack.size() == 0 && !inPatternQuote && (token.text.equals(";") || token.text.equals(")"))) {
                    matchCount = 0;
                    cursor = matchedPattern.startToken;
                } else if (nestStack.size() != 0 && (((String)nestStack.peek()).equals("\"") || ((String)nestStack.peek()).equals("'"))) {
                    if (token.text.equals(nestStack.peek())) {
                        nestStack.pop();
                    }
                } else if (token.text.equals("\"") || token.text.equals("'")) {
                    nestStack.push(token.text);
                } else if (!inPatternQuote && token.text.equals("(")) {
                    nestStack.push(token.text);
                } else if (!inPatternQuote && nestStack.size() != 0 && token.text.equals(")") && ((String)nestStack.peek()).equals("(")) {
                    nestStack.pop();
                }
            } else if (token.text.equals(parsedPattern.get((int)matchCount).text) && (matchCount != 0 || !token.inQuotes)) {
                if (matchCount == 0) {
                    matchedPattern.start = token.start;
                    matchedPattern.startToken = cursor;
                }
                if (++matchCount == parsedPattern.size()) {
                    matchedPattern.end = token.end;
                    return matchedPattern;
                }
                if (parsedPattern.get((int)matchCount).isVariable) {
                    int n = varStart = cursor < tokens.size() - 1 ? tokens.get((int)(cursor + 1)).start : -1;
                }
                if (token.text.equals("'") || token.text.equals("\"")) {
                    inPatternQuote = !inPatternQuote;
                }
            } else if (matchCount != 0) {
                matchCount = 0;
                cursor = matchedPattern.startToken;
            }
            if (matchCount == 0 || cursor != tokens.size() - 1) continue;
            matchCount = 0;
            cursor = matchedPattern.startToken;
        }
        matchedPattern.start = -1;
        return matchedPattern;
    }

    private static boolean matches(String regex, String string) {
        Pattern pattern = Pattern.compile(regex, 42);
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    private static int matchesEnd(String regex, String string) {
        string = string.replaceAll("\\s$", "");
        Pattern pattern = Pattern.compile(regex, 42);
        Matcher matcher = pattern.matcher(string);
        int start = -1;
        while (matcher.find()) {
            if (matcher.end() != string.length()) continue;
            start = matcher.start();
        }
        return start;
    }

    private static String searchAndReplace(String sql, List<Block> parsedPattern, String replacePattern) {
        MatchedPattern matchedPattern = SqlTranslate.search(sql, parsedPattern, 0);
        while (matchedPattern.start != -1) {
            String replacement = replacePattern;
            for (Map.Entry<String, String> pair : matchedPattern.variableToValue.entrySet()) {
                replacement = StringUtils.replaceAll(replacement, pair.getKey(), pair.getValue());
            }
            sql = sql.substring(0, matchedPattern.start) + replacement + sql.substring(matchedPattern.end, sql.length());
            int delta = 1;
            if (StringUtils.tokenizeSql(replacement).size() == 0) {
                delta = 0;
            }
            if (delta > 0 && replacePattern.startsWith("@@") && replacement.toLowerCase().trim().startsWith(parsedPattern.get((int)0).text)) {
                delta = 0;
            }
            matchedPattern = SqlTranslate.search(sql, parsedPattern, matchedPattern.startToken + delta);
        }
        return sql;
    }

    private static String translateSql(String sql, List<String[]> replacementPatterns, String sessionId, String oracleTempPrefix) {
        for (int i = 0; i < replacementPatterns.size(); ++i) {
            String[] pair = (String[])replacementPatterns.get(i).clone();
            pair[1] = pair[1].replace("%session_id%", sessionId);
            pair[1] = pair[1].replace("%temp_prefix%", oracleTempPrefix);
            List<Block> parsedPattern = SqlTranslate.parseSearchPattern(pair[0]);
            sql = SqlTranslate.searchAndReplace(sql, parsedPattern, pair[1]).replaceAll("(?m)^[ \t]*\r?\n", "");
        }
        return sql.replaceAll("(?m)^[ \t]*\r?\n", "");
    }

    @Deprecated
    public static String translateSql(String sql, String sourceDialect, String targetDialect) {
        return SqlTranslate.translateSql(sql, sourceDialect, targetDialect, null, null);
    }

    public static String translateSql(String sql, String targetDialect) {
        return SqlTranslate.translateSql(sql, targetDialect, null, null);
    }

    @Deprecated
    public static String translateSql(String sql, String sourceDialect, String targetDialect, String sessionId, String oracleTempSchema) {
        return SqlTranslate.translateSql(sql, targetDialect, sessionId, oracleTempSchema);
    }

    public static String translateSql(String sql, String targetDialect, String sessionId, String tempEmulationSchema) {
        return SqlTranslate.translateSqlWithPath(sql, targetDialect, sessionId, tempEmulationSchema, null);
    }

    public static String translateSingleStatementSql(String sql, String targetDialect) {
        return SqlTranslate.translateSingleStatementSql(sql, targetDialect, null, null);
    }

    public static String translateSingleStatementSql(String sql, String targetDialect, String sessionId, String tempEmulationSchema) {
        return SqlTranslate.translateSingleStatementSqlWithPath(sql, targetDialect, sessionId, tempEmulationSchema, null);
    }

    public static String translateSingleStatementSqlWithPath(String sql, String targetDialect, String sessionId, String tempEmulationSchema, String pathToReplacementPatterns) {
        String[] sqlStatements = SqlSplit.splitSql(sql = SqlTranslate.translateSqlWithPath(sql, targetDialect, sessionId, tempEmulationSchema, pathToReplacementPatterns));
        if (sqlStatements.length > 1) {
            throw new RuntimeException("SQL contains more than one statement: " + sql);
        }
        return sqlStatements[0];
    }

    public static String translateSqlWithPath(String sql, String targetDialect, String sessionId, String tempEmulationSchema, String pathToReplacementPatterns) {
        SqlTranslate.ensurePatternsAreLoaded(pathToReplacementPatterns);
        if (sessionId == null) {
            sessionId = SqlTranslate.getGlobalSessionId();
        } else {
            SqlTranslate.validateSessionId(sessionId);
        }
        String oracleTempPrefix = tempEmulationSchema == null ? "" : tempEmulationSchema + ".";
        List<String[]> replacementPatterns = targetToReplacementPatterns.get(targetDialect);
        if (replacementPatterns == null) {
            throw new RuntimeException("Don't know how to translate to " + targetDialect + ". Valid target dialects are " + StringUtils.join(targetToReplacementPatterns.keySet(), ", "));
        }
        if (targetDialect.equalsIgnoreCase(BIG_QUERY)) {
            sql = BigQuerySparkTranslate.translatebigQuery(sql);
        } else if (targetDialect.equalsIgnoreCase(SPARK)) {
            sql = BigQuerySparkTranslate.translateSpark(sql);
        }
        sql = SqlTranslate.translateSql(sql, replacementPatterns, sessionId, oracleTempPrefix);
        if (targetDialect.equalsIgnoreCase(IMPALA) || targetDialect.equalsIgnoreCase(BIG_QUERY) || targetDialect.equals(SPARK)) {
            sql = StringUtils.replaceWithConcat(sql);
        }
        return sql;
    }

    private static void validateSessionId(String sessionId) {
        if (sessionId.length() != SESSION_ID_LENGTH) {
            throw new RuntimeException("Session ID has length " + sessionId.length() + ", should be " + SESSION_ID_LENGTH);
        }
        if (!Character.isLetter(sessionId.charAt(0))) {
            throw new RuntimeException("Session ID does not start with a letter");
        }
        for (int i = 1; i < sessionId.length(); ++i) {
            if (Character.isLetterOrDigit(sessionId.charAt(i))) continue;
            throw new RuntimeException("Illegal character in session ID");
        }
    }

    public static String generateSessionId() {
        char[] chars = "abcdefghijklmnopqrstuvwxyz0123456789".toCharArray();
        StringBuilder sb = new StringBuilder();
        sb.append(chars[random.nextInt(26)]);
        for (int i = 1; i < SESSION_ID_LENGTH; ++i) {
            char c = chars[random.nextInt(chars.length)];
            sb.append(c);
        }
        return sb.toString();
    }

    private static List<String> line2columns(String line) {
        List<String> columns = StringUtils.safeSplit(line, ',');
        for (int i = 0; i < columns.size(); ++i) {
            String column = columns.get(i);
            if (column.startsWith("\"") && column.endsWith("\"") && column.length() > 1) {
                column = column.substring(1, column.length() - 1);
            }
            column = column.replace("\\\"", "\"");
            column = column.replace("\\n", "\n");
            columns.set(i, column);
        }
        return columns;
    }

    private static void ensurePatternsAreLoaded(String pathToReplacementPatterns) {
        if (targetToReplacementPatterns != null) {
            return;
        }
        lock.lock();
        if (targetToReplacementPatterns == null) {
            try {
                String line;
                InputStream inputStream = pathToReplacementPatterns == null ? SqlTranslate.class.getResourceAsStream("/inst/csv/replacementPatterns.csv") : new FileInputStream(pathToReplacementPatterns);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                targetToReplacementPatterns = new HashMap<String, List<String[]>>();
                boolean first = true;
                while ((line = bufferedReader.readLine()) != null) {
                    if (first) {
                        first = false;
                        continue;
                    }
                    List<String> row = SqlTranslate.line2columns(line);
                    String target = row.get(0);
                    List<String[]> replacementPatterns = targetToReplacementPatterns.get(target);
                    if (replacementPatterns == null) {
                        replacementPatterns = new ArrayList<String[]>();
                        targetToReplacementPatterns.put(target, replacementPatterns);
                    }
                    replacementPatterns.add(new String[]{row.get(1).replaceAll("@", "@@"), row.get(2).replaceAll("@", "@@")});
                }
            }
            catch (UnsupportedEncodingException e) {
                System.err.println("Computer does not support UTF-8 encoding");
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        lock.unlock();
    }

    public static String[] check(String sql, String targetDialect) {
        ArrayList<String> warnings = new ArrayList<String>();
        Pattern pattern = Pattern.compile("#[0-9a-zA-Z_]+");
        Matcher matcher = pattern.matcher(sql);
        HashSet<String> longTempNames = new HashSet<String>();
        while (matcher.find()) {
            if (matcher.group().length() <= MAX_TABLE_NAME_LENGTH - SESSION_ID_LENGTH - 1) continue;
            longTempNames.add(matcher.group());
        }
        for (String longName : longTempNames) {
            warnings.add("Temp table name '" + longName + "' is too long. Temp table names should be shorter than " + (MAX_TABLE_NAME_LENGTH - SESSION_ID_LENGTH) + " characters to prevent some DMBSs from throwing an error.");
        }
        pattern = Pattern.compile("(create|drop|truncate)\\s+table +[0-9a-zA-Z_]+");
        matcher = pattern.matcher(sql.toLowerCase());
        HashSet<String> longNames = new HashSet<String>();
        while (matcher.find()) {
            String name = sql.substring(matcher.start() + matcher.group().lastIndexOf(" "), matcher.end());
            if (name.length() <= MAX_TABLE_NAME_LENGTH || longTempNames.contains("#" + name)) continue;
            longNames.add(name);
        }
        for (String longName : longNames) {
            warnings.add("Table name '" + longName + "' is too long. Table names should be shorter than " + MAX_TABLE_NAME_LENGTH + " characters to prevent some DMBSs from throwing an error.");
        }
        return warnings.toArray(new String[warnings.size()]);
    }

    public static void setReplacementPatterns(String pathToReplacementPatterns) {
        targetToReplacementPatterns = null;
        SqlTranslate.ensurePatternsAreLoaded(pathToReplacementPatterns);
    }

    public static String getGlobalSessionId() {
        if (globalSessionId == null) {
            globalSessionId = SqlTranslate.generateSessionId();
        }
        return globalSessionId;
    }

    protected static class MatchedPattern {
        public int start;
        public int end;
        public int startToken;
        public Map<String, String> variableToValue = new HashMap<String, String>();

        protected MatchedPattern() {
        }
    }

    protected static class Block
    extends StringUtils.Token {
        public boolean isVariable = false;
        public String regEx;

        public Block(StringUtils.Token other) {
            super(other);
        }
    }
}

