## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup, include=FALSE-----------------------------------------------------
library(LightFitR)

## -----------------------------------------------------------------------------
calibration <- LightFitR::calibration
head(calibration)

## -----------------------------------------------------------------------------
target <- LightFitR::target_irradiance
print(target)

## -----------------------------------------------------------------------------
times <- LightFitR::time_vector
print(times)

## -----------------------------------------------------------------------------
regime <- makeRegime(times, target, calibration$led, calibration$wavelength, calibration$intensity, calibration$irradiance)
print(regime)

## -----------------------------------------------------------------------------
write.helioSchedule(regime, filename='my_regime.txt', format='json')

## -----------------------------------------------------------------------------
closest <- LightFitR::internal.closestIntensities(target, calibration[, c(3,5,4,6)])
rownames(closest) <- LightFitR::helio.dyna.leds$name
print(closest)

## -----------------------------------------------------------------------------

# Define variables

## Calibration
calib_wavelengths <- unique(calibration$wavelength)
calib_intensities <- unique(calibration$intensity)

## Subset the closest matrix to the first event
closest_first <- closest[,1]
print(closest_first)

## Subset the targets
target_first <- target[,1]
print(target_first)

# Go through each channel of the first event
sanity_check <- sapply(1:length(closest_first), function(i){
  
  ## Set relevant variables
  tar <- target_first[i]
  clo <- closest_first[i]
  led <- helio.dyna.leds[i, 'wavelength']
  
  ## Subset calibration data to the LED at the peak wavelengths
  criteria <- calibration$led==led & calibration$wavelength==LightFitR:::internal.closestWavelength(calib_wavelengths, led)
  calib_subset <- calibration[criteria, 3:6]
  
  # Print outputs for user
  print(names(clo))
  print('This is the calibration data')
  print(calib_subset)
  print(paste('The target irradiance is', tar))
  print(paste('The closest intensity is', clo))
  print('---')
  
  return()
})
rm(sanity_check)


## -----------------------------------------------------------------------------

# Define variables
peakWavelengths <- LightFitR:::internal.closestWavelength(unique(calibration$wavelength), helio.dyna.leds[-9, 'wavelength'])
firstEvent <- data.frame(led=LightFitR::helio.dyna.leds[-9, 'wavelength'], closest=closest_first[-9], intended=target_first[-9])
rm(closest_first, target_first)

# closest matrix

mat <- sapply(1:nrow(firstEvent), function(j){
  criteria <- (calibration$led == firstEvent[j, 'led']) & (calibration$intensity == firstEvent[j, 'closest']) & (calibration$wavelength %in% peakWavelengths) # We want the irradiances (from calibration data) of each LED at the intensity where it is closest to the intended irradiance
  calibration[criteria, 'irradiance']
})

print(mat)
image(mat)


## -----------------------------------------------------------------------------
mod <- nnls::nnls(mat, firstEvent[,'intended'])
print(mod)

## -----------------------------------------------------------------------------
intensities <- mod$x * firstEvent[, 'closest']
print(intensities)

## -----------------------------------------------------------------------------
tidied <- LightFitR:::internal.tidyIntensities(intensities, calib_intensities)
print(tidied)

