/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef H5FDros3_s3comms_H
#define H5FDros3_s3comms_H

#include "H5private.h" 
#include "H5FDros3.h"  

#ifdef H5_HAVE_ROS3_VFD

#define S3COMMS_DEBUG 0

#define HTTP_CLIENT_SUCCESS_MIN 200 
#define HTTP_CLIENT_SUCCESS_MAX 299 

#define HTTP_CLIENT_ERROR_MIN 400 
#define HTTP_CLIENT_ERROR_MAX 499 

#define HTTP_SERVER_ERROR_MIN 500 
#define HTTP_SERVER_ERROR_MAX 599 

#define HTTP_CLIENT_SUCCESS(status_code)                                                                     \
    (status_code >= HTTP_CLIENT_SUCCESS_MIN && status_code <= HTTP_CLIENT_SUCCESS_MAX)
#define HTTP_CLIENT_ERROR(status_code)                                                                       \
    (status_code >= HTTP_CLIENT_ERROR_MIN && status_code <= HTTP_CLIENT_ERROR_MAX)
#define HTTP_SERVER_ERROR(status_code)                                                                       \
    (status_code >= HTTP_SERVER_ERROR_MIN && status_code <= HTTP_SERVER_ERROR_MAX)

typedef struct {
    char *scheme; 
    char *host;   
    char *port;
    char *path;
    char *query;
    char *bucket_name;
    char *key;
} parsed_url_t;

typedef struct {
    parsed_url_t *purl;
    parsed_url_t *alternate_purl;
    size_t        filesize;
    char         *aws_region;

    
    void *priv_data;
} s3r_t;

#ifdef __cplusplus
extern "C" {
#endif

H5_DLL herr_t H5FD__s3comms_init(void);
H5_DLL herr_t H5FD__s3comms_term(void);

H5_DLL s3r_t *H5FD__s3comms_s3r_open(const char *url, const H5FD_ros3_fapl_t *fa, const char *fapl_token,
                                     const char *alt_endpoint);
H5_DLL herr_t H5FD__s3comms_s3r_close(s3r_t *handle);
H5_DLL size_t H5FD__s3comms_s3r_get_filesize(s3r_t *handle);
H5_DLL herr_t H5FD__s3comms_s3r_read(s3r_t *handle, haddr_t offset, size_t len, void *dest, size_t dest_size);

#ifdef __cplusplus
}
#endif

#endif 

#endif 
