/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.graph.cost.tsp.heap;

import org.chocosolver.solver.constraints.graph.cost.tsp.heap.ISimpleHeap;

public class BinarySimpleHeap
implements ISimpleHeap {
    private final int[] elements;
    private final int[] positions;
    private final double[] values;
    private int firstEmpty;

    public BinarySimpleHeap(int n) {
        this.elements = new int[n];
        this.positions = new int[n];
        this.values = new double[n];
        for (int i = 0; i < n; ++i) {
            this.elements[i] = -1;
            this.positions[i] = -1;
        }
        this.firstEmpty = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.firstEmpty == 0;
    }

    @Override
    public int removeFirstElement() {
        if (this.firstEmpty == 0) {
            return -1;
        }
        int first = this.elements[0];
        this.positions[first] = -1;
        --this.firstEmpty;
        int last = this.firstEmpty;
        if (last > 0) {
            this.moveAtFirst(last);
            this.decrease(0);
        } else {
            this.positions[first] = -1;
            this.elements[0] = -1;
        }
        return first;
    }

    private void decrease(int node) {
        int left = (node << 1) + 1;
        int right = (node << 1) + 2;
        int next = left;
        if (left < this.firstEmpty) {
            if (right < this.firstEmpty && this.values[this.elements[right]] < this.values[this.elements[left]]) {
                next = right;
            }
            if (this.values[this.elements[node]] > this.values[this.elements[next]]) {
                this.swap(node, next);
                this.decrease(next);
            }
        }
    }

    public boolean addElement(int element, double value) {
        assert (this.positions[element] == -1) : element + " is already in the heap";
        this.elements[this.firstEmpty] = element;
        this.values[element] = value;
        this.positions[element] = this.firstEmpty++;
        if (this.firstEmpty > 1) {
            int last = this.firstEmpty - 1;
            int current = last - 1 >> 1;
            int idx = last;
            while (current != idx && current >= 0 && this.values[this.elements[idx]] < this.values[this.elements[current]]) {
                this.swap(current, idx);
                idx = current;
                current = current - 1 >> 1;
            }
        }
        return true;
    }

    public boolean updateElement(int element, double value) {
        assert (this.positions[element] != -1) : element + " is not in the heap";
        if (value >= this.values[element]) {
            return false;
        }
        this.values[element] = value;
        int last = this.positions[element];
        int current = last - 1 >> 1;
        int idx = last;
        while (current != idx && current >= 0 && this.values[this.elements[idx]] < this.values[this.elements[current]]) {
            this.swap(current, idx);
            idx = current;
            current = current - 1 >> 1;
        }
        return true;
    }

    @Override
    public boolean addOrUpdateElement(int element, double value) {
        if (this.positions[element] != -1) {
            return this.updateElement(element, value);
        }
        return this.addElement(element, value);
    }

    private void swap(int n, int m) {
        int eN;
        int eM = this.elements[m];
        this.elements[m] = eN = this.elements[n];
        this.elements[n] = eM;
        this.positions[eM] = n;
        this.positions[eN] = m;
    }

    private void moveAtFirst(int n_from) {
        int eT = this.elements[0];
        int eF = this.elements[n_from];
        this.positions[eT] = -1;
        this.positions[eF] = 0;
        this.elements[0] = eF;
        this.elements[n_from] = -1;
    }

    public String toString() {
        String s = "heap:\n";
        int k = 1;
        int tot = 0;
        while (tot < this.firstEmpty) {
            String st = "\n";
            for (int i = tot; i < tot + k && i < this.firstEmpty; ++i) {
                st = st + this.elements[i] + "(" + this.values[this.elements[i]] + ")\t";
            }
            tot += k;
            k *= 2;
            s = s + st;
        }
        return s;
    }

    @Override
    public void clear() {
        while (this.firstEmpty > 0) {
            --this.firstEmpty;
            this.positions[this.elements[this.firstEmpty]] = -1;
            this.elements[this.firstEmpty] = -1;
        }
    }
}

