/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.circuit;

import gnu.trove.list.array.TIntArrayList;
import java.util.Arrays;
import java.util.BitSet;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.sat.Reason;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Explained;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

@Explained
public class PropNoSubtour
extends Propagator<IntVar> {
    private final int n;
    private final int offset;
    private final IStateInt[] origin;
    private final IStateInt[] end;
    private final IStateInt[] size;

    public PropNoSubtour(IntVar[] variables, int offset) {
        super((Variable[])variables, (Priority)PropagatorPriority.UNARY, true);
        this.n = ((IntVar[])this.vars).length;
        this.origin = new IStateInt[this.n];
        this.end = new IStateInt[this.n];
        this.size = new IStateInt[this.n];
        IEnvironment environment = this.model.getEnvironment();
        for (int i = 0; i < this.n; ++i) {
            this.origin[i] = environment.makeInt(i);
            this.end[i] = environment.makeInt(i);
            this.size[i] = environment.makeInt(1);
        }
        this.offset = offset;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int i;
        TIntArrayList fixedVar = new TIntArrayList();
        for (i = 0; i < this.n; ++i) {
            ((IntVar[])this.vars)[i].removeValue(i + this.offset, this, Reason.undef());
            ((IntVar[])this.vars)[i].updateLowerBound(this.offset, this, Reason.undef());
            ((IntVar[])this.vars)[i].updateUpperBound(this.n - 1 + this.offset, this, Reason.undef());
            if (!((IntVar[])this.vars)[i].isInstantiated()) continue;
            fixedVar.add(i);
        }
        for (i = 0; i < fixedVar.size(); ++i) {
            this.varInstantiated(fixedVar.get(i), ((IntVar[])this.vars)[fixedVar.get(i)].getValue() - this.offset);
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.varInstantiated(idxVarInProp, ((IntVar[])this.vars)[idxVarInProp].getValue() - this.offset);
    }

    private void varInstantiated(int var, int val) throws ContradictionException {
        if (this.isPassive()) {
            return;
        }
        int last = this.end[val].get();
        int start = this.origin[var].get();
        if (this.origin[val].get() != val) {
            this.fails(this.lcg() ? Propagator.reason(null, this.vars) : Reason.undef());
        }
        if (this.end[var].get() != var) {
            throw new UnsupportedOperationException("unexpected situation");
        }
        if (val == start) {
            if (this.size[start].get() != this.n) {
                throw new UnsupportedOperationException("unexpected situation");
            }
        } else {
            this.size[start].add(this.size[val].get());
            if (this.size[start].get() == this.n) {
                ((IntVar[])this.vars)[last].instantiateTo(start + this.offset, this, this.lcg() ? Propagator.reason(((IntVar[])this.vars)[last], this.vars) : Reason.undef());
                this.setPassive();
            }
            boolean isInst = false;
            if (this.size[start].get() < this.n && ((IntVar[])this.vars)[last].contains(start + this.offset) && ((IntVar[])this.vars)[last].removeValue(start + this.offset, this, this.explainPrevent(start))) {
                isInst = ((IntVar[])this.vars)[last].isInstantiated();
            }
            this.origin[last].set(start);
            this.end[start].set(last);
            if (isInst) {
                this.varInstantiated(last, ((IntVar[])this.vars)[last].getValue() - this.offset);
            }
        }
    }

    private Reason explainPrevent(int start) {
        if (this.lcg()) {
            int[] ps = new int[this.size[start].get()];
            int var = this.origin[start].get();
            for (int m = 1; m < ps.length; ++m) {
                ps[m] = ((IntVar[])this.vars)[var].getValLit();
                var = ((IntVar[])this.vars)[var].getValue() - this.offset;
            }
            return Reason.r(ps);
        }
        return Reason.undef();
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.instantiation();
    }

    @Override
    public ESat isEntailed() {
        for (int i = 0; i < this.n; ++i) {
            if (((IntVar[])this.vars)[i].isInstantiated()) continue;
            return ESat.UNDEFINED;
        }
        BitSet visited = new BitSet(this.n);
        int i = 0;
        for (int size = 0; size != this.n; ++size) {
            if (visited.get(i = ((IntVar[])this.vars)[i].getValue() - this.offset)) {
                return ESat.FALSE;
            }
            visited.set(i);
        }
        if (i == 0) {
            return ESat.TRUE;
        }
        return ESat.FALSE;
    }

    @Override
    public String toString() {
        return "PropNoSubTour(" + Arrays.toString(this.vars) + ")";
    }
}

