/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.sum;

import org.chocosolver.sat.Reason;
import org.chocosolver.solver.constraints.Explained;
import org.chocosolver.solver.constraints.Operator;
import org.chocosolver.solver.constraints.nary.sum.PropSum;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.ESat;

@Explained
public class PropScalar
extends PropSum {
    private final int[] c;

    public PropScalar(IntVar[] variables, int[] coeffs, int pos, Operator o, int b) {
        super(variables, pos, o, b);
        this.c = coeffs;
    }

    @Override
    protected void prepare() {
        int ub;
        int lb;
        int i;
        this.sumUB = 0;
        this.sumLB = 0;
        this.maxI = 0;
        for (i = 0; i < this.pos; ++i) {
            lb = ((IntVar[])this.vars)[i].getLB() * this.c[i];
            ub = ((IntVar[])this.vars)[i].getUB() * this.c[i];
            this.sumLB += lb;
            this.sumUB += ub;
            this.I[i] = ub - lb;
            if (this.maxI >= this.I[i]) continue;
            this.maxI = this.I[i];
        }
        while (i < this.l) {
            lb = ((IntVar[])this.vars)[i].getUB() * this.c[i];
            ub = ((IntVar[])this.vars)[i].getLB() * this.c[i];
            this.sumLB += lb;
            this.sumUB += ub;
            this.I[i] = ub - lb;
            if (this.maxI < this.I[i]) {
                this.maxI = this.I[i];
            }
            ++i;
        }
    }

    @Override
    protected void filterOnEq() throws ContradictionException {
        boolean anychange;
        int F2 = this.b - this.sumLB;
        int E = this.sumUB - this.b;
        do {
            anychange = false;
            if (!(this.lcg() || F2 >= 0 && E >= 0)) {
                this.fails();
            }
            if (this.maxI > F2 || this.maxI > E) {
                int nlb;
                int ub;
                int lb;
                int i;
                this.maxI = 0;
                for (i = 0; i < this.pos; ++i) {
                    if (this.I[i] - F2 > 0) {
                        lb = ((IntVar[])this.vars)[i].getLB() * this.c[i];
                        ub = lb + this.I[i];
                        int bnd = this.divFloor(F2 + lb, this.c[i]);
                        if (((IntVar[])this.vars)[i].getUB() > bnd && ((IntVar[])this.vars)[i].updateUpperBound(bnd, this, this.explainByMin(i))) {
                            int nub = ((IntVar[])this.vars)[i].getUB() * this.c[i];
                            E += nub - ub;
                            this.I[i] = nub - lb;
                            anychange = true;
                        }
                    }
                    if (this.I[i] - E > 0) {
                        ub = ((IntVar[])this.vars)[i].getUB() * this.c[i];
                        lb = ub - this.I[i];
                        if (((IntVar[])this.vars)[i].updateLowerBound(this.divCeil(ub - E, this.c[i]), this, this.explainByMax(i))) {
                            nlb = ((IntVar[])this.vars)[i].getLB() * this.c[i];
                            F2 -= nlb - lb;
                            this.I[i] = ub - nlb;
                            anychange = true;
                        }
                    }
                    if (this.maxI >= this.I[i]) continue;
                    this.maxI = this.I[i];
                }
                while (i < this.l) {
                    if (this.I[i] - F2 > 0) {
                        lb = ((IntVar[])this.vars)[i].getUB() * this.c[i];
                        ub = lb + this.I[i];
                        if (((IntVar[])this.vars)[i].updateLowerBound(this.divCeil(-F2 - lb, -this.c[i]), this, this.explainByMin(i))) {
                            int nub = ((IntVar[])this.vars)[i].getLB() * this.c[i];
                            E += nub - ub;
                            this.I[i] = nub - lb;
                            anychange = true;
                        }
                    }
                    if (this.I[i] - E > 0) {
                        ub = ((IntVar[])this.vars)[i].getLB() * this.c[i];
                        lb = ub - this.I[i];
                        if (((IntVar[])this.vars)[i].updateUpperBound(this.divFloor(-ub + E, -this.c[i]), this, this.explainByMax(i))) {
                            nlb = ((IntVar[])this.vars)[i].getUB() * this.c[i];
                            F2 -= nlb - lb;
                            this.I[i] = ub - nlb;
                            anychange = true;
                        }
                    }
                    if (this.maxI < this.I[i]) {
                        this.maxI = this.I[i];
                    }
                    ++i;
                }
            }
            if (F2 > 0 || E > 0) continue;
            this.setPassive();
            return;
        } while (anychange);
    }

    @Override
    protected void filterOnLeq() throws ContradictionException {
        int F2 = this.b - this.sumLB;
        int E = this.sumUB - this.b;
        if (!this.lcg() && F2 < 0) {
            this.fails();
        }
        if (this.maxI > F2) {
            int nub;
            int ub;
            int lb;
            int i;
            this.maxI = 0;
            for (i = 0; i < this.pos; ++i) {
                this.maxI = 0;
                if (this.I[i] - F2 > 0) {
                    lb = ((IntVar[])this.vars)[i].getLB() * this.c[i];
                    ub = lb + this.I[i];
                    if (((IntVar[])this.vars)[i].updateUpperBound(this.divFloor(F2 + lb, this.c[i]), this, this.explainByMin(i))) {
                        nub = ((IntVar[])this.vars)[i].getUB() * this.c[i];
                        E += nub - ub;
                        this.I[i] = nub - lb;
                    }
                }
                if (this.maxI >= this.I[i]) continue;
                this.maxI = this.I[i];
            }
            while (i < this.l) {
                if (this.I[i] - F2 > 0) {
                    lb = ((IntVar[])this.vars)[i].getUB() * this.c[i];
                    ub = lb + this.I[i];
                    if (((IntVar[])this.vars)[i].updateLowerBound(this.divCeil(-F2 - lb, -this.c[i]), this, this.explainByMin(i))) {
                        nub = ((IntVar[])this.vars)[i].getLB() * this.c[i];
                        E += nub - ub;
                        this.I[i] = nub - lb;
                    }
                }
                if (this.maxI < this.I[i]) {
                    this.maxI = this.I[i];
                }
                ++i;
            }
        }
        if (E <= 0) {
            this.setPassive();
        }
    }

    @Override
    protected void filterOnGeq() throws ContradictionException {
        int F2 = this.b - this.sumLB;
        int E = this.sumUB - this.b;
        if (!this.lcg() && E < 0) {
            this.fails();
        }
        if (this.maxI > E) {
            int nlb;
            int lb;
            int ub;
            int i;
            this.maxI = 0;
            for (i = 0; i < this.pos; ++i) {
                if (this.I[i] - E > 0) {
                    ub = ((IntVar[])this.vars)[i].getUB() * this.c[i];
                    lb = ub - this.I[i];
                    if (((IntVar[])this.vars)[i].updateLowerBound(this.divCeil(ub - E, this.c[i]), this, this.explainByMax(i))) {
                        nlb = ((IntVar[])this.vars)[i].getLB() * this.c[i];
                        F2 -= nlb - lb;
                        this.I[i] = ub - nlb;
                    }
                }
                if (this.maxI >= this.I[i]) continue;
                this.maxI = this.I[i];
            }
            while (i < this.l) {
                if (this.I[i] - E > 0) {
                    ub = ((IntVar[])this.vars)[i].getLB() * this.c[i];
                    lb = ub - this.I[i];
                    if (((IntVar[])this.vars)[i].updateUpperBound(this.divFloor(-ub + E, -this.c[i]), this, this.explainByMax(i))) {
                        nlb = ((IntVar[])this.vars)[i].getUB() * this.c[i];
                        F2 -= nlb - lb;
                        this.I[i] = ub - nlb;
                    }
                }
                if (this.maxI < this.I[i]) {
                    this.maxI = this.I[i];
                }
                ++i;
            }
        }
        if (F2 <= 0) {
            this.setPassive();
        }
    }

    @Override
    protected void filterOnNeq() throws ContradictionException {
        int F2 = this.b - this.sumLB;
        int E = this.sumUB - this.b;
        if (F2 < 0 || E < 0) {
            this.setPassive();
            return;
        }
        int w = -1;
        int sum = 0;
        for (int i = 0; i < this.l; ++i) {
            if (((IntVar[])this.vars)[i].isInstantiated()) {
                sum += ((IntVar[])this.vars)[i].getValue() * this.c[i];
                continue;
            }
            if (w == -1) {
                w = i;
                continue;
            }
            return;
        }
        if (w == -1) {
            if (sum == this.b) {
                this.fails();
            }
        } else if (this.c[w] != 0 && (this.b - sum) % this.c[w] == 0) {
            ((IntVar[])this.vars)[w].removeValue((this.b - sum) / this.c[w], this, this.lcg() ? this.defaultReason(((IntVar[])this.vars)[w]) : Reason.undef());
        }
    }

    @Override
    public ESat isEntailed() {
        int i;
        int sumUB = 0;
        int sumLB = 0;
        for (i = 0; i < this.pos; ++i) {
            sumLB += ((IntVar[])this.vars)[i].getLB() * this.c[i];
            sumUB += ((IntVar[])this.vars)[i].getUB() * this.c[i];
        }
        while (i < this.l) {
            sumLB += ((IntVar[])this.vars)[i].getUB() * this.c[i];
            sumUB += ((IntVar[])this.vars)[i].getLB() * this.c[i];
            ++i;
        }
        return this.check(sumLB, sumUB);
    }

    @Override
    public String toString() {
        int i;
        StringBuilder linComb = new StringBuilder(20);
        linComb.append(this.c[0]).append('.').append(((IntVar[])this.vars)[0].getName());
        for (i = 1; i < this.pos; ++i) {
            linComb.append(" + ").append(this.c[i]).append('.').append(((IntVar[])this.vars)[i].getName());
        }
        while (i < this.l) {
            linComb.append(" - ").append(-this.c[i]).append('.').append(((IntVar[])this.vars)[i].getName());
            ++i;
        }
        linComb.append(" ").append((Object)this.o).append(" ");
        linComb.append(this.b);
        return linComb.toString();
    }

    private int divFloor(int a, int b) {
        if (a >= 0) {
            return a / b;
        }
        return (a - b + 1) / b;
    }

    private int divCeil(int a, int b) {
        if (a >= 0) {
            return (a + b - 1) / b;
        }
        return a / b;
    }

    @Override
    protected PropSum opposite() {
        return new PropScalar((IntVar[])this.vars, this.c, this.pos, PropScalar.nop(this.o), this.b + PropScalar.nb(this.o));
    }
}

