/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.ISetDeltaMonitor;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.procedure.IntProcedure;

public class PropSubsetEq
extends Propagator<SetVar> {
    private final ISetDeltaMonitor[] sdm = new ISetDeltaMonitor[2];
    private final IntProcedure elementForced;
    private final IntProcedure elementRemoved;

    public PropSubsetEq(SetVar X, SetVar Y) {
        super((Variable[])new SetVar[]{X, Y}, (Priority)PropagatorPriority.LINEAR, true);
        for (int i = 0; i < 2; ++i) {
            this.sdm[i] = ((SetVar[])this.vars)[i].monitorDelta(this);
        }
        this.elementForced = element -> ((SetVar[])this.vars)[1].force(element, this);
        this.elementRemoved = element -> ((SetVar[])this.vars)[0].remove(element, this);
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx == 0) {
            return SetEventType.ADD_TO_KER.getMask();
        }
        return SetEventType.REMOVE_FROM_ENVELOPE.getMask();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        ISetIterator iter = ((SetVar[])this.vars)[0].getLB().iterator();
        while (iter.hasNext()) {
            ((SetVar[])this.vars)[1].force(iter.nextInt(), this);
        }
        iter = ((SetVar[])this.vars)[0].getUB().iterator();
        while (iter.hasNext()) {
            int j = iter.nextInt();
            if (((SetVar[])this.vars)[1].getUB().contains(j)) continue;
            ((SetVar[])this.vars)[0].remove(j, this);
        }
        this.sdm[0].startMonitoring();
        this.sdm[1].startMonitoring();
    }

    @Override
    public void propagate(int i, int mask) throws ContradictionException {
        if (i == 0) {
            this.sdm[i].forEach(this.elementForced, SetEventType.ADD_TO_KER);
        } else {
            this.sdm[i].forEach(this.elementRemoved, SetEventType.REMOVE_FROM_ENVELOPE);
        }
    }

    @Override
    public ESat isEntailed() {
        ISetIterator iter = ((SetVar[])this.vars)[0].getLB().iterator();
        while (iter.hasNext()) {
            if (((SetVar[])this.vars)[1].getUB().contains(iter.nextInt())) continue;
            return ESat.FALSE;
        }
        iter = ((SetVar[])this.vars)[0].getUB().iterator();
        while (iter.hasNext()) {
            if (((SetVar[])this.vars)[1].getLB().contains(iter.nextInt())) continue;
            return ESat.UNDEFINED;
        }
        return ESat.TRUE;
    }
}

