/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.expression.discrete.logical;

import org.chocosolver.solver.Model;
import org.chocosolver.solver.expression.discrete.relational.ReExpression;
import org.chocosolver.solver.variables.BoolVar;

public abstract class LoExpression
implements ReExpression {
    protected final Model model;
    protected BoolVar me = null;
    protected final Operator op;

    public LoExpression(Model model, Operator op) {
        this.model = model;
        this.op = op;
    }

    @Override
    public abstract Model getModel();

    @Override
    public abstract BoolVar boolVar();

    public static enum Operator {
        AND{

            @Override
            boolean eval(boolean b1, boolean b2) {
                return b1 && b2;
            }
        }
        ,
        OR{

            @Override
            boolean eval(boolean b1, boolean b2) {
                return b1 || b2;
            }
        }
        ,
        XOR{

            @Override
            boolean eval(boolean b1, boolean b2) {
                return b1 != b2;
            }
        }
        ,
        IFF{

            @Override
            boolean eval(boolean b1, boolean b2) {
                return b1 == b2;
            }
        }
        ,
        IMP{

            @Override
            boolean eval(boolean b1, boolean b2) {
                return !b1 || b2;
            }
        }
        ,
        NOT{

            @Override
            boolean eval(boolean b1, boolean b2) {
                return !b1 || !b2;
            }
        };


        abstract boolean eval(boolean var1, boolean var2);
    }
}

