/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Random;
import weka.classifiers.Classifier;
import weka.classifiers.RandomizableIteratedSingleClassifierEnhancer;
import weka.classifiers.trees.RandomTree;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Randomizable;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class RandomCommittee
extends RandomizableIteratedSingleClassifierEnhancer
implements WeightedInstancesHandler {
    static final long serialVersionUID = -9204394360557300092L;

    public RandomCommittee() {
        this.m_Classifier = new RandomTree();
    }

    @Override
    protected String defaultClassifierString() {
        return "weka.classifiers.trees.RandomTree";
    }

    public String globalInfo() {
        return "Class for building an ensemble of randomizable base classifiers. Each base classifiers is built using a different random number seed (but based one the same data). The final prediction is a straight average of the predictions generated by the individual base classifiers.";
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        data = new Instances(data);
        data.deleteWithMissingClass();
        if (!(this.m_Classifier instanceof Randomizable)) {
            throw new IllegalArgumentException("Base learner must implement Randomizable!");
        }
        this.m_Classifiers = Classifier.makeCopies(this.m_Classifier, this.m_NumIterations);
        Random random = data.getRandomNumberGenerator(this.m_Seed);
        int j = 0;
        while (j < this.m_Classifiers.length) {
            ((Randomizable)((Object)this.m_Classifiers[j])).setSeed(random.nextInt());
            this.m_Classifiers[j].buildClassifier(data);
            ++j;
        }
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] sums = new double[instance.numClasses()];
        int i = 0;
        while (i < this.m_NumIterations) {
            if (instance.classAttribute().isNumeric()) {
                sums[0] = sums[0] + this.m_Classifiers[i].classifyInstance(instance);
            } else {
                double[] newProbs = this.m_Classifiers[i].distributionForInstance(instance);
                int j = 0;
                while (j < newProbs.length) {
                    int n = j;
                    sums[n] = sums[n] + newProbs[j];
                    ++j;
                }
            }
            ++i;
        }
        if (instance.classAttribute().isNumeric()) {
            sums[0] = sums[0] / (double)this.m_NumIterations;
            return sums;
        }
        if (Utils.eq(Utils.sum(sums), 0.0)) {
            return sums;
        }
        Utils.normalize(sums);
        return sums;
    }

    public String toString() {
        if (this.m_Classifiers == null) {
            return "RandomCommittee: No model built yet.";
        }
        StringBuffer text = new StringBuffer();
        text.append("All the base classifiers: \n\n");
        int i = 0;
        while (i < this.m_Classifiers.length) {
            text.append(String.valueOf(this.m_Classifiers[i].toString()) + "\n\n");
            ++i;
        }
        return text.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.13 $");
    }

    public static void main(String[] argv) {
        RandomCommittee.runClassifier(new RandomCommittee(), argv);
    }
}

