/*
 * Decompiled with CFR 0.152.
 */
public class Classification
extends AssocRuleMining {
    protected short[][] testDataArray = null;
    protected short[][][] tenthDataSets = new short[10][][];
    protected short[] classifiers = null;
    protected double[][] attributes = null;
    protected double[][] attributes2 = null;
    protected final int K_VALUE = 5;
    protected final double MIN_BEST_GAIN = 0.7;
    protected int numRowsInInputSet;
    protected int numRowsInTestSet;
    protected int numRowsInTrainingSet;
    protected RuleList currentRlist = new RuleList();

    public Classification(String[] stringArray) {
        super(stringArray);
    }

    public double startClassification() {
        return 0.0;
    }

    protected int getBestGain() {
        int n = 0;
        double d = 0.0;
        for (int i = 1; i < this.attributes2.length; ++i) {
            if ((int)this.attributes2[i][0] != 0 || !(this.attributes2[i][1] > d)) continue;
            n = i;
            d = this.attributes2[i][1];
        }
        return n;
    }

    protected double testClassification() {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this.testDataArray == null) {
            System.out.println("ERROR: No test data");
            return 0.0;
        }
        if (this.currentRlist.startRulelist == null) {
            System.out.println("No classification rules generated!");
            return 0.0;
        }
        for (n = 0; n < this.testDataArray.length; ++n) {
            short s = this.currentRlist.classifyRecordBestKaverage(5, this.classifiers, this.testDataArray[n]);
            if (s == 0) {
                ++n4;
                continue;
            }
            short s2 = this.getLastElement(this.testDataArray[n]);
            if (s == s2) {
                ++n2;
                continue;
            }
            ++n3;
        }
        double d = (double)n2 * 100.0 / (double)n;
        return d;
    }

    public double commenceTCV() {
        double[] dArray = new double[10];
        for (int i = 0; i < 10; ++i) {
            System.out.println("[--- " + i + " ---]");
            this.createTrainingAndTestDataSets(i);
            dArray[i] = this.startClassification();
        }
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
        }
        return d / 10.0;
    }

    public void commenceTCVwithOutput() {
        double[][] dArray = new double[10][2];
        for (int i = 0; i < 10; ++i) {
            System.out.println("[--- " + i + " ---]");
            this.createTrainingAndTestDataSets(i);
            dArray[i][0] = this.startClassification();
            dArray[i][1] = this.currentRlist.getNumCRs();
        }
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            System.out.println("(" + (i + 1) + ") Accuracy = " + this.twoDecPlaces(dArray[i][0]) + ", Num CRs = " + (int)dArray[i][1]);
            d += dArray[i][0];
            d2 += dArray[i][1];
        }
        System.out.println("---------------------------------------");
        System.out.println("Average Accuracy = " + this.twoDecPlaces(d / 10.0) + ", Average Num CRs = " + this.twoDecPlaces(d2 / 10.0));
    }

    public void inputDataSet() {
        this.readFile();
        if (this.inputFormatOkFlag) {
            if (this.checkOrdering()) {
                this.countNumCols();
                this.numRowsInInputSet = this.numRows;
                this.createClassifiersArray();
            } else {
                System.out.println("Error reading file: " + this.fileName + "\n");
                System.exit(1);
            }
        }
    }

    public void createTrainingAndTestDataSets() {
        int n;
        this.numRowsInTestSet = (int)((double)this.numRows * 50.0 / 100.0);
        this.numRows = this.numRowsInTrainingSet = this.numRows - this.numRowsInTestSet;
        System.out.println("Num. of recs. in training set = " + this.numRowsInTrainingSet + "\nNum. of recs. in test set     = " + this.numRowsInTestSet);
        short[][] sArrayArray = new short[this.numRowsInTrainingSet][];
        for (n = 0; n < this.numRowsInTrainingSet; ++n) {
            sArrayArray[n] = this.dataArray[n];
        }
        this.testDataArray = new short[this.numRowsInTestSet][];
        int n2 = 0;
        while (n < this.dataArray.length) {
            this.testDataArray[n2] = this.dataArray[n];
            ++n;
            ++n2;
        }
        this.dataArray = sArrayArray;
    }

    private void createTrainingAndTestDataSets(int n) {
        int n2;
        int n3;
        this.numRowsInTestSet = this.tenthDataSets[n].length;
        this.testDataArray = this.tenthDataSets[n];
        this.numRows = this.numRowsInTrainingSet = this.numRowsInInputSet - this.numRowsInTestSet;
        short[][] sArrayArray = new short[this.numRows][];
        int n4 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            n2 = 0;
            while (n2 < this.tenthDataSets[n3].length) {
                sArrayArray[n4] = this.tenthDataSets[n3][n2];
                ++n2;
                ++n4;
            }
        }
        for (n3 = n + 1; n3 < this.tenthDataSets.length; ++n3) {
            n2 = 0;
            while (n2 < this.tenthDataSets[n3].length) {
                sArrayArray[n4] = this.tenthDataSets[n3][n2];
                ++n2;
                ++n4;
            }
        }
        System.out.println("Num. of recs. in training set = " + this.numRows + "\nNum. of recs. in test set     = " + this.numRowsInTestSet);
        this.dataArray = sArrayArray;
    }

    public void createTenthsDataSets() {
        int n;
        if (this.numRows < 10) {
            System.out.println("ERROR: only " + this.numRows + ", therefore cannot create tenths data sets!");
            System.exit(1);
        }
        int n2 = this.numRows / 10;
        for (n = 0; n < this.tenthDataSets.length - 1; ++n) {
            this.tenthDataSets[n] = new short[n2][];
        }
        this.tenthDataSets[n] = new short[this.numRows - n2 * 9][];
        int n3 = 0;
        for (n = 0; n < this.tenthDataSets.length; ++n) {
            int n4 = 0;
            while (n4 < this.tenthDataSets[n].length) {
                this.tenthDataSets[n][n4] = this.dataArray[n3];
                ++n4;
                ++n3;
            }
        }
    }

    private void createClassifiersArray() {
        this.classifiers = new short[this.numClasses];
        short s = (short)(this.numOneItemSets - this.numClasses + 1);
        for (int i = 0; i < this.classifiers.length; ++i) {
            this.classifiers[i] = (short)(s + i);
        }
    }

    @Override
    protected void CheckInputArguments() {
        this.checkFileName();
        this.checkNumClasses();
        if (this.errorFlag) {
            this.outputSettings();
        } else {
            this.outputMenu();
        }
    }

    private void checkNumClasses() {
        if (this.numClasses == 0) {
            System.out.println("ERROR 3: Must specify number of classes (-N)");
            this.errorFlag = false;
        }
        if (this.numClasses < 0) {
            System.out.println("ERROR 4: Number of classes must be a positive integer");
            this.errorFlag = false;
        }
    }

    protected void processRules() {
        this.removeDuplicateRules();
    }

    private void removeDuplicateRules() {
        RuleList.RuleNode ruleNode = this.currentRlist.startRulelist;
        while (ruleNode != null) {
            this.removeDuplicate(ruleNode, ruleNode.antecedent, ruleNode.consequent);
            ruleNode = ruleNode.next;
        }
    }

    private void removeDuplicate(RuleList.RuleNode ruleNode, short[] sArray, short[] sArray2) {
        RuleList.RuleNode ruleNode2 = ruleNode;
        RuleList.RuleNode ruleNode3 = ruleNode.next;
        while (ruleNode3 != null) {
            if (this.isEqual(sArray, ruleNode3.antecedent) && this.isEqual(sArray2, ruleNode3.consequent)) {
                ruleNode2.next = ruleNode3.next;
            } else {
                ruleNode2 = ruleNode3;
            }
            ruleNode3 = ruleNode3.next;
        }
    }

    public RuleList getCurrentRuleListObject() {
        return this.currentRlist;
    }

    protected double[][] copyDouble2Darray(double[][] dArray) {
        double[][] dArray2 = new double[dArray.length][2];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i][0] = dArray[i][0];
            dArray2[i][1] = dArray[i][1];
        }
        return dArray2;
    }

    protected short[][] copy2DshortArray(short[][] sArray) {
        if (sArray == null) {
            return null;
        }
        short[][] sArrayArray = new short[sArray.length][];
        for (int i = 0; i < sArray.length; ++i) {
            if (sArray[i] == null) {
                sArrayArray[i] = null;
                continue;
            }
            sArrayArray[i] = new short[sArray[i].length];
            for (int j = 0; j < sArray[i].length; ++j) {
                sArrayArray[i][j] = sArray[i][j];
            }
        }
        return sArrayArray;
    }
}

