## ----include = FALSE----------------------------------------------------------
Sys.setenv(R_USER_LIBS = tempdir())  #Just in case for CRAN
library(biodosetools)
knitr::opts_chunk$set(
  fig.dpi = 96,
  collapse = TRUE,
  comment = "#>"
)

## ----sc-dic-mixed-01, echo=FALSE, out.width='100%', fig.align='center', fig.cap="'Curve fitting data options' and '.rds input curves' tabbed box in the dose estimation module for criticality accidents when loading curve from an `.rds` file."----
knitr::include_graphics("figures/screenshot-dicentrics-mixed-01.png")

## ----sc-dic-mixed-01b, echo=FALSE, out.width='100%', fig.cap="'Curve fitting data options'  in the dose estimation module for criticality accidents when inputting curve coefficients manually. Note that if no variance-covariance matrix is provided, only the variances calculated from the coefficients' standard errors will be used in calculations."----
knitr::include_graphics("figures/screenshot-dicentrics-mixed-01c.png")

## ----load-fitting-results-mixed, tidy=TRUE, tidy.opts=list(width.cutoff=60)----

fit_results_gamma <- system.file("extdata", "gamma_dicentrics-fitting-results.rds", package = "biodosetools") %>%
  readRDS()

fit_results_neutrons <- system.file("extdata", "neutrons-mixed-dicentrics-fitting-results.rds", package = "biodosetools") %>%
  readRDS()

## ----fit-results-mixed--------------------------------------------------------
fit_results_gamma$fit_coeffs

fit_results_neutrons$fit_coeffs

## ----sc-dic-mixed-02, echo=FALSE, out.width='100%', fig.align='center', fig.cap="'Data input' box in the dose estimation module for criticality accidents."----
knitr::include_graphics("figures/screenshot-dicentrics-mixed-02.png")
knitr::include_graphics("figures/screenshot-dicentrics-mixed-02b.png")

## ----sc-dic-mixed-03, echo=FALSE, out.width='60%', fig.align='center', fig.cap="'Results' tabbed box, 'Curve plot' and 'Save results' boxes in the dose estimation module for criticality accidents."----
knitr::include_graphics("figures/screenshot-dicentrics-mixed-03a.png")
knitr::include_graphics("figures/screenshot-dicentrics-mixed-03b.png")

## ----dic-parse-fit-results-mixed----------------------------------------------

coef_gamma <- fit_results_gamma[["fit_coeffs"]][,1]
cov_gamma <- fit_results_gamma[["fit_var_cov_mat"]]
coef_neutron <- fit_results_neutrons[["fit_coeffs"]][,1]
cov_neutron <-  fit_results_neutrons[["fit_var_cov_mat"]]


## ----dic-dose-estimation-mixed------------------------------------------------
est_doses <- fun.estimate.criticality(
  num_cases = 1,
  dics = 380, 
  cells = 218, 
  coef_gamma, 
  cov_gamma, 
  coef_neutron, 
  cov_neutron, 
  ratio = 1.2, 
  p = 0)


## -----------------------------------------------------------------------------
est_doses

## ----dic-estimated-dose-curve-mixed, fig.width=6, fig.height=3.5, fig.align='center', fig.cap="Plot of estimated doses generated by \\{biodosetools\\ criticality accidents module}. The grey shading indicates the uncertainties associated with the calibration curve."----

plot_estimated_dose_curve_mx(
  name = "Sample1", 
  est_doses = est_doses[[1]], 
  fit_coeffs = coef_gamma, 
  fit_var_cov_mat = cov_gamma,
  curve_type = "gamma",
  protracted_g_value = 1,
  conf_int_curve = 0.95, 
  place = "UI")
  

plot_estimated_dose_curve_mx(
  name = "Sample1", 
  est_doses = est_doses[[1]], 
  fit_coeffs = coef_neutron, 
  fit_var_cov_mat = cov_neutron,
  curve_type = "neutron",
  protracted_g_value = 1,
  conf_int_curve = 0.95, 
  place = "UI")

