<!-- This file requires commonmark and xml2 packages to be treated correctly -->

# Changes in distfreereg version 1.1

* Support for `glm` and `lmerMod` (from **lme4**) objects has been added.

* Grouping is now available for all ordering options, and `group` now defaults
to `TRUE`. The `res_order` object can now contain repeated elements, which are
now used to determine the groups. The aggregator matrix has been renamed the
"grouping matrix".

* The `control` argument of `distfreereg()` can now have an element named
`return_on_error`, which allows for partial output from `distfreereg()` when an
error occurs.

* A covariance list element can now be a list of matrices, corresponding to the
block diagonal matrix with blocks given by the list elements.

* `compare` now uses `simulate()` to generate observed outcome variable values
when `true_mean` is neither a `function` nor an `nls` object. The `theta`
argument in `compare()` is therefore now only allowed when `test_mean` has class
`function`.

* To promote reliability, specifying columns to order the residuals must now be
done using column names, not column numbers.

* The `compare` argument `err_dist_fun` must now be a character string naming
the desired function.

* A simple `compare` method for `print()` has been added.

* The `method` argument in `distfreereg.formula()` no longer has a default
value.

* `distfreereg.formula()` no longer has a `covariance` argument.

* Only `distfreereg.function()` retains a `theta_init` argument. Starting values
for estimation for using `distfreereg.formula()` can be specified, when
applicable, using an appropriately named element of `method_args`.

* Computation of `mu` now uses a Cholesky decomposition instead of a matrix
square root based on an eigenvalue decomposition.

* The handling of weights has been improved. Specifically, the covariance
structure obtained from model objects is now determined from weights and the
estimated sigma value.

* Jacobians and Hessians are now calculated using **calculus** package. Because
of the speed improvement, `confint.distfreereg()` now always returns the matrix
or vector returned by the appropriate method of `confint()`. In particular, it
no longer returns a list that includes the output of `vcov.distfreereg()`.

* The `symmetry` argument has been replaced by a mandatory check for symmetry of
`Sigma` and `P`, with associated tolerance options.

* Minor changes: `rmvnorm()` no longer drops dimensions, and therefore always
returns a matrix. Error message in `get_n()` now contains more detail. Progress
messages for `distfreereg()` modified. Updates and improvements made to the
documentation.



# Changes in distfreereg version 1.0.1

* Modified tests for macos-arm64.

* Added access to `matsqrt_tol` value to control threshold for what
eigenvalue(s) are "too negative" when calculating the eigendecomposition for
determining the square root of a matrix.