!function(){var d3panels={version:"1.8.5"};"use strict";d3panels.formatAxis=function(d){var extra_digits=arguments.length>1&&arguments[1]!==undefined?arguments[1]:0;var gap,i,ndig,x;d=function(){var k,len,results;results=[];for(k=0,len=d.length;k<len;k++){x=d[k];if(x!=null){results.push(x)}}return results}();d.sort();if(d.length<=1){gap=1}else{d=function(){var k,ref,results;results=[];for(i=k=1,ref=d.length-1;1<=ref?k<=ref:k>=ref;i=1<=ref?++k:--k){results.push(d[i]-d[i-1])}return results}();gap=d3.mean(d)}ndig=Math.round(d3panels.log10(Math.abs(gap)));if(ndig<-8){ndig=-8}if(ndig>0){ndig=0}ndig=Math.abs(ndig)+extra_digits;return function(val){if(val!=null&&val!=="NA"){return d3.format("."+ndig+"f")(val)}return"NA"}};d3panels.unique=function(x){var k,len,output,v;output={};for(k=0,len=x.length;k<len;k++){v=x[k];if(v!=null){output[v]=v}}output=function(){var results;results=[];for(v in output){results.push(output[v])}return results}();return d3panels.forceAsArray(output)};d3panels.pullVarAsArray=function(data,variable){var i,results;results=[];for(i in data){results.push(data[i][variable])}return results};d3panels.reorgByChr=function(uniquechr,chr,vector){var c,i,k,len,result;if(chr.length!==vector.length){d3panels.displayError("reorgByChr: chr.length ("+chr.length+") != vector.length ("+vector.length+")")}result={};for(i=k=0,len=uniquechr.length;k<len;i=++k){c=uniquechr[i];result[c]=function(){var results;results=[];for(i in vector){if(chr[i]===c){results.push(vector[i])}}return results}()}return result};d3panels.reorgLodData=function(data){var i;data.posByChr=d3panels.reorgByChr(data.chrname,data.chr,data.pos);data.lodByChr=d3panels.reorgByChr(data.chrname,data.chr,data.lod);if(data.poslabel!=null){data.poslabelByChr=d3panels.reorgByChr(data.chrname,data.chr,data.poslabel)}if(data.marker!=null){data.markerinfo=function(){var results;results=[];for(i in data.marker){if(data.marker[i]!==""){results.push({name:data.marker[i],chr:data.chr[i],pos:data.pos[i],lod:data.lod[i]})}}return results}()}return data};d3panels.calc_chrscales=function(plot_width,left_margin,gap,chr,start,end){var reverse=arguments.length>6&&arguments[6]!==undefined?arguments[6]:false;var chr_end_pixels,chr_length,chr_start_pixels,domain,i,k,n_chr,range,ref,right,tot_chr_length,tot_pixels,xscale;n_chr=chr.length;chr_length=function(){var results;results=[];for(i in end){results.push(end[i]-start[i])}return results}();tot_chr_length=chr_length.reduce(function(t,s){return t+s});tot_pixels=plot_width-gap*n_chr;chr_start_pixels=[left_margin+gap/2];chr_end_pixels=[left_margin+gap/2+tot_pixels/tot_chr_length*chr_length[0]];for(i=k=1,ref=n_chr-1;1<=ref?k<=ref:k>=ref;i=1<=ref?++k:--k){chr_start_pixels.push(chr_end_pixels[i-1]+gap);chr_end_pixels.push(chr_start_pixels[i]+tot_pixels/tot_chr_length*chr_length[i])}right=plot_width+left_margin*2;xscale={};for(i in chr){domain=[start[i],end[i]];range=[chr_start_pixels[i],chr_end_pixels[i]];if(reverse){domain.reverse();range=[right-range[1],right-range[0]]}xscale[chr[i]]=d3.scaleLinear().domain(domain).range(range)}return xscale};d3panels.selectGroupColors=function(ngroup,palette){var cat20,pastel1,pastel20,set1;if(ngroup===0){return[]}set1=["#e41a1c","#377eb8","#4daf4a","#984ea3","#ff7f00","#ffff33","#a65628","#f781bf","#999999"];pastel1=["#fbb4ae","#b3cde3","#ccebc5","#decbe4","#fed9a6","#ffffcc","#e5d8bd","#fddaec","#f2f2f2"];cat20=["#1f77b4","#aec7e8","#ff7f0e","#ffbb78","#2ca02c","#98df8a","#d62728","#ff9896","#9467bd","#c5b0d5","#8c564b","#c49c94","#e377c2","#f7b6d2","#7f7f7f","#c7c7c7","#bcbd22","#dbdb8d","#17becf","#9edae5"];pastel20=["#8fc7f4","#fed7f8","#ffbf8e","#fffbb8","#8ce08c","#d8ffca","#f68788","#ffd8d6","#d4a7fd","#f5f0f5","#cc968b","#f4dcd4","#f3b7f2","#f7f6f2","#bfbfbf","#f7f7f7","#fcfd82","#fbfbcd","#87feff","#defaf5"];if(palette==="dark"){if(ngroup===1){return["slateblue"]}if(ngroup===2){return["MediumVioletRed","slateblue"]}if(ngroup===3){return["MediumVioletRed","MediumSeaGreen","slateblue"]}if(ngroup<=9){return set1.slice(0,ngroup)}return cat20.slice(0,ngroup)}else{if(ngroup===1){return["#bebebe"]}if(ngroup===2){return["lightpink","lightblue"]}if(ngroup<=9){return pastel1.slice(0,ngroup)}return pastel20.slice(0,ngroup)}};d3panels.expand2vector=function(input,n){var i;if(input==null){return input}if(Array.isArray(input)&&input.length>=n){return input}if(!Array.isArray(input)){input=[input]}if(input.length>1&&n>1){input=function(){var results;results=[];for(i in d3.range(n)){results.push(input[i%input.length])}return results}()}if(input.length===1&&n>1){input=function(){var results;results=[];for(i in d3.range(n)){results.push(input[0])}return results}()}return input};d3panels.median=function(x){var n,xv;if(x==null){return null}x=function(){var k,len,results;results=[];for(k=0,len=x.length;k<len;k++){xv=x[k];if(xv!=null){results.push(xv)}}return results}();n=x.length;if(!(n>0)){return null}x.sort(function(a,b){return a-b});if(n%2===1){return x[(n-1)/2]}return(x[n/2]+x[n/2-1])/2};d3panels.pad_vector=function(x){var pad=arguments.length>1&&arguments[1]!==undefined?arguments[1]:null;if(pad==null){return[x[0]-(x[1]-x[0])].concat(x).concat([x[x.length-1]+(x[x.length-1]-x[x.length-2])])}return[x[0]-pad].concat(x).concat(x[x.length-1]+pad)};d3panels.calc_midpoints=function(x){var i,k,ref,results;results=[];for(i=k=0,ref=x.length-2;0<=ref?k<=ref:k>=ref;i=0<=ref?++k:--k){results.push((x[i]+x[i+1])/2)}return results};d3panels.calc_cell_rect=function(cells,xmid,ymid){var bottom,cell,k,left,len,results,right,top;results=[];for(k=0,len=cells.length;k<len;k++){cell=cells[k];left=xmid[cell.xindex];right=xmid[1+cell.xindex];top=ymid[cell.yindex];bottom=ymid[1+cell.yindex];cell.left=d3.min([left,right]);cell.width=Math.abs(right-left);cell.top=d3.min([top,bottom]);results.push(cell.height=Math.abs(bottom-top))}return results};d3panels.calc_chrcell_rect=function(cells,xmid,ymid){var bottom,cell,k,left,len,results,right,top;results=[];for(k=0,len=cells.length;k<len;k++){cell=cells[k];left=xmid[cell.chr][cell.posindex];right=xmid[cell.chr][1+cell.posindex];top=ymid[cell.lodindex];bottom=ymid[1+cell.lodindex];cell.left=d3.min([left,right]);cell.width=Math.abs(right-left);cell.top=d3.min([top,bottom]);results.push(cell.height=Math.abs(bottom-top))}return results};d3panels.calc_2dchrcell_rect=function(cells,xmid,ymid){var bottom,cell,k,left,len,results,right,top;results=[];for(k=0,len=cells.length;k<len;k++){cell=cells[k];left=xmid[cell.chrx][cell.xindexByChr];right=xmid[cell.chrx][1+cell.xindexByChr];top=ymid[cell.chry][cell.yindexByChr];bottom=ymid[cell.chry][1+cell.yindexByChr];cell.left=d3.min([left,right]);cell.width=Math.abs(right-left);cell.top=d3.min([top,bottom]);results.push(cell.height=Math.abs(bottom-top))}return results};d3panels.maxdiff=function(x){var d,i,k,ref,result;if(x.length<2){return null}result=x[1]-x[0];if(x.length<3){return result}for(i=k=2,ref=x.length;2<=ref?k<ref:k>ref;i=2<=ref?++k:--k){d=x[i]-x[i-1];if(d>result){result=d}}return result};d3panels.matrixMin=function(mat){var i,j,result;result=mat[0][0];for(i in mat){for(j in mat[i]){if(!(result!=null)||result>mat[i][j]&&mat[i][j]!=null){result=mat[i][j]}}}return result};d3panels.matrixMax=function(mat){var i,j,result;result=mat[0][0];for(i in mat){for(j in mat[i]){if(!(result!=null)||result<mat[i][j]&&mat[i][j]!=null){result=mat[i][j]}}}return result};d3panels.matrixMaxAbs=function(mat){var i,j,result;result=Math.abs(mat[0][0]);for(i in mat){for(j in mat[i]){if(!(result!=null)||result<Math.abs(mat[i][j])&&mat[i][j]!=null){result=Math.abs(mat[i][j])}}}return result};d3panels.matrixExtent=function(mat){return[d3panels.matrixMin(mat),d3panels.matrixMax(mat)]};d3panels.forceAsArray=function(x){if(x==null){return x}if(Array.isArray(x)){return x}return[x]};d3panels.missing2null=function(vec){var missingvalues=arguments.length>1&&arguments[1]!==undefined?arguments[1]:["NA",""];return vec.map(function(value){if(missingvalues.indexOf(value)>-1){return null}else{return value}})};d3panels.displayError=function(message){var divid=arguments.length>1&&arguments[1]!==undefined?arguments[1]:null;var div;div="div.error";if(divid!=null){div+="#"+divid}if(d3.select(div).empty()){d3.select("body").insert("div",":first-child").attr("class","error")}return d3.select(div).append("p").text(message)};d3panels.sumArray=function(vec){var x;vec=function(){var k,len,results;results=[];for(k=0,len=vec.length;k<len;k++){x=vec[k];if(x!=null){results.push(x)}}return results}();if(!(vec.length>0)){return null}return vec.reduce(function(a,b){return a*1+b*1})};d3panels.calc_crosstab=function(data){var col,cs,i,k,l,ncol,nrow,ref,ref1,result,row,rs;nrow=data.ycat.length;ncol=data.xcat.length;result=function(){var k,ref,results;results=[];for(row=k=0,ref=nrow;0<=ref?k<=ref:k>=ref;row=0<=ref?++k:--k){results.push(function(){var l,ref1,results1;results1=[];for(col=l=0,ref1=ncol;0<=ref1?l<=ref1:l>=ref1;col=0<=ref1?++l:--l){results1.push(0)}return results1}())}return results}();for(i in data.x){result[data.y[i]][data.x[i]]+=1}rs=d3panels.rowSums(result);cs=d3panels.colSums(result);for(i=k=0,ref=ncol;0<=ref?k<ref:k>ref;i=0<=ref?++k:--k){result[nrow][i]=cs[i]}for(i=l=0,ref1=nrow;0<=ref1?l<ref1:l>ref1;i=0<=ref1?++l:--l){result[i][ncol]=rs[i]}result[nrow][ncol]=d3panels.sumArray(rs);return result};d3panels.rowSums=function(mat){var k,len,results,x;results=[];for(k=0,len=mat.length;k<len;k++){x=mat[k];results.push(d3panels.sumArray(x))}return results};d3panels.transpose=function(mat){var i,j,k,ref,results;results=[];for(j=k=0,ref=mat[0].length;0<=ref?k<ref:k>ref;j=0<=ref?++k:--k){results.push(function(){var l,ref1,results1;results1=[];for(i=l=0,ref1=mat.length;0<=ref1?l<ref1:l>ref1;i=0<=ref1?++l:--l){results1.push(mat[i][j])}return results1}())}return results};d3panels.colSums=function(mat){return d3panels.rowSums(d3panels.transpose(mat))};d3panels.log2=function(x){if(x==null){return x}return Math.log(x)/Math.log(2)};d3panels.log10=function(x){if(x==null){return x}return Math.log(x)/Math.log(10)};d3panels.abs=function(x){if(x==null){return x}return Math.abs(x)};d3panels.mean_by_group=function(g,y){var i,means,n;means={};n={};for(i in g){if(n[g[i]]!=null){if(y[i]!=null){means[g[i]]+=y[i]}if(y[i]!=null){n[g[i]]+=1}}else{if(y[i]!=null){means[g[i]]=y[i]}if(y[i]!=null){n[g[i]]=1}}}for(i in means){means[i]/=n[i]}return means};d3panels.sd_by_group=function(g,y){var dev,i,means,n,sds;means=d3panels.mean_by_group(g,y);sds={};n={};for(i in g){dev=y[i]-means[g[i]];if(n[g[i]]!=null){if(y[i]!=null){sds[g[i]]+=dev*dev}if(y[i]!=null){n[g[i]]+=1}}else{if(y[i]!=null){sds[g[i]]=dev*dev}if(y[i]!=null){n[g[i]]=1}}}for(i in sds){sds[i]=n[i]<2?null:Math.sqrt(sds[i]/(n[i]-1))}return sds};d3panels.count_groups=function(g,y){var i,n;n={};for(i in g){if(n[g[i]]!=null){if(y[i]!=null){n[g[i]]+=1}}else{if(y[i]!=null){n[g[i]]=1}}}return n};d3panels.ci_by_group=function(g,y){var m=arguments.length>2&&arguments[2]!==undefined?arguments[2]:2;var ci,dev,i,means,n,sds;means=d3panels.mean_by_group(g,y);sds={};n={};for(i in g){dev=y[i]-means[g[i]];if(n[g[i]]!=null){if(y[i]!=null){sds[g[i]]+=dev*dev}if(y[i]!=null){n[g[i]]+=1}}else{if(y[i]!=null){sds[g[i]]=dev*dev}if(y[i]!=null){n[g[i]]=1}}}for(i in sds){sds[i]=n[i]<2?null:Math.sqrt(sds[i]/(n[i]-1))}ci={};for(i in means){ci[i]={mean:means[i],low:n[i]>0?means[i]-m*sds[i]/Math.sqrt(n[i]):means[i],high:n[i]>0?means[i]+m*sds[i]/Math.sqrt(n[i]):means[i]}}return ci};d3panels.pad_ylim=function(ylim){var p=arguments.length>1&&arguments[1]!==undefined?arguments[1]:.025;var d;d=ylim[1]-ylim[0];return[ylim[0]-d*p,ylim[1]+d*p]};d3panels.add_chrname_start_end=function(data){var c,i,k,l,len,len1,ref,ref1,these_pos;if(data.chrname==null){data.chrname=d3panels.unique(data.chr)}data.chrname=d3panels.forceAsArray(data.chrname);if(data.chrstart==null){data.chrstart=[];ref=data.chrname;for(k=0,len=ref.length;k<len;k++){c=ref[k];these_pos=function(){var results;results=[];for(i in data.chr){if(data.chr[i]===c){results.push(data.pos[i])}}return results}();data.chrstart.push(d3.min(these_pos))}}if(data.chrend==null){data.chrend=[];ref1=data.chrname;for(l=0,len1=ref1.length;l<len1;l++){c=ref1[l];these_pos=function(){var results;results=[];for(i in data.chr){if(data.chr[i]===c){results.push(data.pos[i])}}return results}();data.chrend.push(d3.max(these_pos))}}data.start=d3panels.forceAsArray(data.start);data.end=d3panels.forceAsArray(data.end);return data};d3panels.calc_breaks=function(number,low,high){var d,i,results;if(low>=high){d3panels.displayError("calc_breaks: should have low < high");if(low>high){var _ref=[high,low];low=_ref[0];high=_ref[1]}if(low===high){low-=.5;high+=.5}}if(number<2){d3panels.displayError("calc_breaks: number should be >= 2");number=2}d=(high-low)/(number-1);results=[];for(i in d3.range(number)){results.push(low+d*i)}return results};d3panels.calc_freq=function(values,breaks){var return_counts=arguments.length>2&&arguments[2]!==undefined?arguments[2]:false;var br,i,k,len,n,ref,result,v,z;v=values.slice(0);v.sort(function(a,b){return+a-b});br=breaks.slice(0);br.sort(function(a,b){return+a-b});br[0]-=1e-6;br[br.length-1]+=1e-6;result=function(){var k,len,ref,results;ref=d3.range(br.length-1);results=[];for(k=0,len=ref.length;k<len;k++){i=ref[k];results.push(0)}return results}();n=v.length;v=function(){var k,len,results;results=[];for(k=0,len=v.length;k<len;k++){z=v[k];if(z>br[0]&&z<br[br.length-1]){results.push(z)}}return results}();if(v.length<n){d3panels.displayError("calc_freq: values out of range of breaks")}n=v.length;ref=d3.range(br.length-1);for(k=0,len=ref.length;k<len;k++){i=ref[k];result[i]=function(){var l,len1,results;results=[];for(l=0,len1=v.length;l<len1;l++){z=v[l];if(z>=br[i]&&z<br[i+1]){results.push(z)}}return results}().length;if(!return_counts){result[i]/=n*(br[i+1]-br[i])}}return result};d3panels.calc_hist_path=function(freq,breaks){var i,result;if(freq.length!==breaks.length-1){d3panels.displayError("freq.length ("+freq.length+") should be breaks.length - 1 ("+(breaks.length-1)+")")}result=[{x:breaks[0],y:0}];for(i in freq){result.push({x:breaks[i],y:freq[i]});result.push({x:breaks[+i+1],y:freq[i]})}result.push({x:breaks[breaks.length-1],y:0});return result};d3panels.index_of_nearest=function(d,vec){var abs_diff;abs_diff=vec.map(function(val){return Math.abs(val-d)});return abs_diff.indexOf(d3.min(abs_diff))};d3panels.check_listarg_v_default=function(arg,defaults){var key;for(key in defaults){if(arg[key]==null){arg[key]=defaults[key]}}return arg};d3panels.object_position=function(object){var obj,x,y;obj=object.node().getBoundingClientRect();x=obj.left/2+obj.right/2;y=obj.top/2+obj.bottom/2;return{x:x,y:y}};"use strict";d3panels.lod2dheatmap=function(chartOpts){var cellSelect,cells,celltip,chart,chrGap,colors,equalCells,height,hilitcolor,margin,nullcolor,oneAtTop,ref,ref1,ref10,ref11,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,svg,tipclass,width,xscale,yscale,zlim,zscale,zthresh;if(chartOpts==null){chartOpts={}}width=(ref=chartOpts!=null?chartOpts.width:void 0)!=null?ref:800;height=(ref1=chartOpts!=null?chartOpts.height:void 0)!=null?ref1:800;margin=(ref2=chartOpts!=null?chartOpts.margin:void 0)!=null?ref2:{left:60,top:40,right:40,bottom:60};chrGap=(ref3=chartOpts!=null?chartOpts.chrGap:void 0)!=null?ref3:6;equalCells=(ref4=chartOpts!=null?chartOpts.equalCells:void 0)!=null?ref4:false;oneAtTop=(ref5=chartOpts!=null?chartOpts.oneAtTop:void 0)!=null?ref5:false;colors=(ref6=chartOpts!=null?chartOpts.colors:void 0)!=null?ref6:["slateblue","white","crimson"];nullcolor=(ref7=chartOpts!=null?chartOpts.nullcolor:void 0)!=null?ref7:"#e6e6e6";zlim=(ref8=chartOpts!=null?chartOpts.zlim:void 0)!=null?ref8:null;zthresh=(ref9=chartOpts!=null?chartOpts.zthresh:void 0)!=null?ref9:null;hilitcolor=(ref10=chartOpts!=null?chartOpts.hilitcolor:void 0)!=null?ref10:"black";tipclass=(ref11=chartOpts!=null?chartOpts.tipclass:void 0)!=null?ref11:"tooltip";xscale=null;yscale=null;zscale=null;celltip=null;cells=null;svg=null;cellSelect=null;chart=function chart(selection,data){var cellg,chr,i,indexWithinChr,j,k,l,len,len1,len2,m,myframe,n_pos,posByChr,ref12,ref13,ref14,tooltipfunc,x,xmid_scaled,y,ymid_scaled,zmax,zmin;margin=d3panels.check_listarg_v_default(margin,{left:60,top:40,right:40,bottom:60});if(data.chr==null){d3panels.displayError("lod2dheatmap: data.chr is missing")}if(data.pos==null){d3panels.displayError("lod2dheatmap: data.pos is missing")}if(data.lod==null){d3panels.displayError("lod2dheatmap: data.lod is missing")}n_pos=data.chr.length;if(data.pos.length!==n_pos){d3panels.displayError("lod2dheatmap: data.pos.length ("+data.pos.length+") != data.chr.length ("+n_pos+")")}if(data.lod.length!==n_pos){d3panels.displayError("lod2dheatmap: data.lod.length ("+data.lod.length+") != data.chr.length ("+n_pos+")")}for(i in data.lod){if(data.lod[i].length!==n_pos){d3panels.displayError("lod2dheatmap: data.lod["+i+"].length ("+data.lod[i].length+") != data.chr.length ("+n_pos+")")}}if(data.poslabel!=null){if(data.poslabel.length!==n_pos){d3panels.displayError("lod2dheatmap: data.poslabel.length ("+data.poslabel.length+") != data.chr.length ("+n_pos+")")}}else{data.poslabel=function(){var results;results=[];for(i in data.chr){results.push(data.chr[i]+"@"+d3panels.formatAxis(data.pos)(data.pos[i]))}return results}()}if(data.chrname==null){data.chrname=d3panels.unique(data.chr)}data.chrname=d3panels.forceAsArray(data.chrname);if(equalCells){data.pos=[];ref12=data.chrname;for(k=0,len=ref12.length;k<len;k++){chr=ref12[k];data.pos=data.pos.concat(function(){var results;results=[];for(i in data.chr){if(data.chr[i]===chr){results.push(+i)}}return results}())}}data=d3panels.add_chrname_start_end(data);if(equalCells){chrGap=(width-margin.left-margin.right-2*data.chrname.length)/data.chr.length+2}chartOpts.chrGap=chrGap;chartOpts.width=width;chartOpts.height=height;chartOpts.margin=margin;myframe=d3panels.chr2dpanelframe(chartOpts);myframe(selection,{chr:data.chrname,start:data.chrstart,end:data.chrend});svg=myframe.svg();xscale=myframe.xscale();yscale=myframe.yscale();posByChr=d3panels.reorgByChr(data.chrname,data.chr,data.pos);xmid_scaled={};ymid_scaled={};ref13=data.chrname;for(l=0,len1=ref13.length;l<len1;l++){chr=ref13[l];xmid_scaled[chr]=d3panels.calc_midpoints(d3panels.pad_vector(function(){var len2,m,ref14,results;ref14=posByChr[chr];results=[];for(m=0,len2=ref14.length;m<len2;m++){x=ref14[m];results.push(xscale[chr](x))}return results}(),chrGap-2));ymid_scaled[chr]=d3panels.calc_midpoints(d3panels.pad_vector(function(){var len2,m,ref14,results;ref14=posByChr[chr];results=[];for(m=0,len2=ref14.length;m<len2;m++){y=ref14[m];results.push(yscale[chr](y))}return results}(),oneAtTop?chrGap-2:2-chrGap))}zmin=d3panels.matrixMin(data.lod);zmax=d3panels.matrixMaxAbs(data.lod);zlim=zlim!=null?zlim:[-zmax,0,zmax];if(zlim.length!==colors.length){d3panels.displayError("lod2dheatmap: zlim.length ("+zlim.length+") != colors.length ("+colors.length+")")}zscale=d3.scaleLinear().domain(zlim).range(colors);zthresh=zthresh!=null?zthresh:zmin-1;indexWithinChr=[];ref14=data.chrname;for(m=0,len2=ref14.length;m<len2;m++){chr=ref14[m];indexWithinChr=indexWithinChr.concat(function(){var results;results=[];for(i in posByChr[chr]){results.push(+i)}return results}())}cells=[];for(i in data.chr){for(j in data.chr){if(Math.abs(data.lod[i][j])>=zthresh){cells.push({lod:data.lod[i][j],chrx:data.chr[i],chry:data.chr[j],poslabelx:data.poslabel[i],poslabely:data.poslabel[j],xindex:i,yindex:j,xindexByChr:indexWithinChr[i],yindexByChr:indexWithinChr[j]})}}}d3panels.calc_2dchrcell_rect(cells,xmid_scaled,ymid_scaled);cellg=svg.append("g").attr("id","cells");cellSelect=cellg.selectAll("empty").data(cells).enter().append("rect").attr("x",function(d){return d.left}).attr("y",function(d){return d.top}).attr("width",function(d){return d.width}).attr("height",function(d){return d.height}).attr("class",function(d,i){return"cell"+i}).attr("fill",function(d){if(d.lod!=null){return zscale(d.lod)}else{return nullcolor}}).attr("stroke","none").attr("stroke-width","1").on("mouseover",function(){return d3.select(this).attr("stroke",hilitcolor).raise()}).on("mouseout",function(){return d3.select(this).attr("stroke","none")});tooltipfunc=function tooltipfunc(d){var z;z=d3.format(".2f")(Math.abs(d.lod));return"("+d.poslabelx+","+d.poslabely+") &rarr; "+z};return celltip=d3panels.tooltip_create(d3.select("body"),cellg.selectAll("rect"),{tipclass:tipclass},tooltipfunc)};chart.xscale=function(){return xscale};chart.yscale=function(){return yscale};chart.zscale=function(){return zscale};chart.cells=function(){return cellSelect};chart.celltip=function(){return celltip};chart.svg=function(){return svg};chart.remove=function(){svg.remove();d3panels.tooltip_destroy(celltip);return null};return chart};"use strict";d3panels.panelframe=function(chartOpts){var axispos,box,boxcolor,boxwidth,chart,height,margin,nxticks,nyticks,plot_height,plot_width,rectcolor,ref,ref1,ref10,ref11,ref12,ref13,ref14,ref15,ref16,ref17,ref18,ref19,ref2,ref20,ref21,ref22,ref23,ref24,ref25,ref26,ref3,ref4,ref5,ref6,ref7,ref8,ref9,rotate_ylab,svg,title,titlepos,v_over_h,width,xNA,xNA_size,xlab,xlabels,xlim,xlineOpts,xlines,xscale,xscale_wnull,xticklab,xticks,yNA,yNA_size,ylab,ylabels,ylim,ylineOpts,ylines,yscale,yscale_wnull,yticklab,yticks;if(chartOpts==null){chartOpts={}}width=(ref=chartOpts!=null?chartOpts.width:void 0)!=null?ref:800;height=(ref1=chartOpts!=null?chartOpts.height:void 0)!=null?ref1:500;margin=(ref2=chartOpts!=null?chartOpts.margin:void 0)!=null?ref2:{left:60,top:40,right:40,bottom:40,inner:3};axispos=(ref3=chartOpts!=null?chartOpts.axispos:void 0)!=null?ref3:{xtitle:25,ytitle:45,xlabel:5,ylabel:5};titlepos=(ref4=chartOpts!=null?chartOpts.titlepos:void 0)!=null?ref4:20;title=(ref5=chartOpts!=null?chartOpts.title:void 0)!=null?ref5:"";xlab=(ref6=chartOpts!=null?chartOpts.xlab:void 0)!=null?ref6:"X";ylab=(ref7=chartOpts!=null?chartOpts.ylab:void 0)!=null?ref7:"Y";rotate_ylab=(ref8=chartOpts!=null?chartOpts.rotate_ylab:void 0)!=null?ref8:null;xNA=(ref9=chartOpts!=null?chartOpts.xNA:void 0)!=null?ref9:false;yNA=(ref10=chartOpts!=null?chartOpts.yNA:void 0)!=null?ref10:false;xNA_size=(ref11=chartOpts!=null?chartOpts.xNA_size:void 0)!=null?ref11:{width:20,gap:10};yNA_size=(ref12=chartOpts!=null?chartOpts.yNA_size:void 0)!=null?ref12:{width:20,gap:10};xlim=(ref13=chartOpts!=null?chartOpts.xlim:void 0)!=null?ref13:[0,1];ylim=(ref14=chartOpts!=null?chartOpts.ylim:void 0)!=null?ref14:[0,1];nxticks=(ref15=chartOpts!=null?chartOpts.nxticks:void 0)!=null?ref15:5;xticks=(ref16=chartOpts!=null?chartOpts.xticks:void 0)!=null?ref16:null;xticklab=(ref17=chartOpts!=null?chartOpts.xticklab:void 0)!=null?ref17:null;nyticks=(ref18=chartOpts!=null?chartOpts.nyticks:void 0)!=null?ref18:5;yticks=(ref19=chartOpts!=null?chartOpts.yticks:void 0)!=null?ref19:null;yticklab=(ref20=chartOpts!=null?chartOpts.yticklab:void 0)!=null?ref20:null;rectcolor=(ref21=chartOpts!=null?chartOpts.rectcolor:void 0)!=null?ref21:"#e6e6e6";boxcolor=(ref22=chartOpts!=null?chartOpts.boxcolor:void 0)!=null?ref22:"black";boxwidth=(ref23=chartOpts!=null?chartOpts.boxwidth:void 0)!=null?ref23:2;xlineOpts=(ref24=chartOpts!=null?chartOpts.xlineOpts:void 0)!=null?ref24:{color:"white",width:2};ylineOpts=(ref25=chartOpts!=null?chartOpts.ylineOpts:void 0)!=null?ref25:{color:"white",width:2};v_over_h=(ref26=chartOpts!=null?chartOpts.v_over_h:void 0)!=null?ref26:false;xscale=null;yscale=null;xNA=xNA;yNA=yNA;xlines=null;ylines=null;xlabels=null;ylabels=null;plot_width=null;plot_height=null;box=null;svg=null;xscale_wnull=null;yscale_wnull=null;chart=function chart(selection){var boxes,boxes2include,d,g,i,inner_height,inner_width,xNA_xpos,xaxis,xrange,yNA_ypos,yaxis,ylabpos_x,ylabpos_y,yrange;margin=d3panels.check_listarg_v_default(margin,{left:60,top:40,right:40,bottom:40,inner:3});axispos=d3panels.check_listarg_v_default(axispos,{xtitle:25,ytitle:45,xlabel:5,ylabel:5});xNA_size=d3panels.check_listarg_v_default(xNA_size,{width:20,gap:10});yNA_size=d3panels.check_listarg_v_default(yNA_size,{width:20,gap:10});xlineOpts=d3panels.check_listarg_v_default(xlineOpts,{color:"white",width:2});ylineOpts=d3panels.check_listarg_v_default(ylineOpts,{color:"white",width:2});svg=selection.append("svg");svg.attr("width",width).attr("height",height).attr("class","d3panels");g=svg.append("g").attr("id","frame");if(!xNA){xNA_size={width:0,gap:0}}if(!yNA){yNA_size={width:0,gap:0}}plot_width=width-(margin.left+margin.right);plot_height=height-(margin.top+margin.bottom);inner_width=width-(margin.right+margin.left+xNA_size.width+xNA_size.gap);inner_height=height-(margin.top+margin.bottom+yNA_size.width+yNA_size.gap);boxes={left:[margin.left+xNA_size.width+xNA_size.gap,margin.left,margin.left,margin.left+xNA_size.width+xNA_size.gap],width:[inner_width,xNA_size.width,xNA_size.width,inner_width],top:[margin.top,margin.top,height-(margin.bottom+yNA_size.width),height-(margin.bottom+yNA_size.width)],height:[inner_height,inner_height,yNA_size.width,yNA_size.width]};xNA_xpos=xNA?margin.left+xNA_size.width/2:-5e4;yNA_ypos=yNA?height-margin.bottom-yNA_size.width/2:-5e4;xrange=[boxes.left[0],boxes.left[0]+boxes.width[0]];yrange=[boxes.top[0]+boxes.height[0],boxes.top[0]];for(i in boxes.left){if(boxes.width[i]>0&&boxes.height[i]>0){g.append("rect").attr("x",boxes.left[i]).attr("y",boxes.top[i]).attr("height",boxes.height[i]).attr("width",boxes.width[i]).attr("fill",rectcolor).attr("stroke","none").attr("shape-rendering","crispEdges")}}g.append("g").attr("class","title").append("text").text(title).attr("x",(width-margin.left-margin.right)/2+margin.left).attr("y",titlepos);rotate_ylab=rotate_ylab!=null?rotate_ylab:ylab.length>1;if(v_over_h){yaxis=g.append("g").attr("class","y axis");xaxis=g.append("g").attr("class","x axis")}else{xaxis=g.append("g").attr("class","x axis");yaxis=g.append("g").attr("class","y axis")}xaxis.append("text").attr("class","title").text(xlab).attr("x",(width-margin.left-margin.right)/2+margin.left).attr("y",plot_height+margin.top+axispos.xtitle);ylabpos_y=(height-margin.top-margin.bottom)/2+margin.top;ylabpos_x=margin.left-axispos.ytitle;yaxis.append("text").attr("class","title").text(ylab).attr("y",ylabpos_y).attr("x",ylabpos_x).attr("transform",rotate_ylab?"rotate(270,"+ylabpos_x+","+ylabpos_y+")":"");xscale=d3.scaleLinear().domain(xlim).range([xrange[0]+margin.inner,xrange[1]-margin.inner]);yscale=d3.scaleLinear().domain(ylim).range([yrange[0]-margin.inner,yrange[1]+margin.inner]);xscale_wnull=function xscale_wnull(val){if(val==null){return xNA_xpos}return xscale(val)};yscale_wnull=function yscale_wnull(val){if(val==null){return yNA_ypos}return yscale(val)};xticks=xticks!=null?xticks:xscale.ticks(nxticks);if(xticklab!=null&&xticklab.length!==xticks.length){d3panels.displayError("panelframe: xticklab.length ("+xticklab.length+") != xticks.length ("+xticks.length+")")}if(!(xticklab!=null&&xticklab.length===xticks.length)){xticklab=function(){var j,len,results;results=[];for(j=0,len=xticks.length;j<len;j++){d=xticks[j];results.push(d3panels.formatAxis(xticks)(d))}return results}()}if(xNA){xticks=[null].concat(xticks)}if(xNA){xticklab=["NA"].concat(xticklab)}yticks=yticks!=null?yticks:yscale.ticks(nyticks);if(yticklab!=null&&yticklab.length!==yticks.length){d3panels.displayError("panelframe: yticklab.length ("+yticklab.length+") != yticks.length ("+yticks.length+")")}if(!(yticklab!=null&&yticklab.length===yticks.length)){yticklab=function(){var j,len,results;results=[];for(j=0,len=yticks.length;j<len;j++){d=yticks[j];results.push(d3panels.formatAxis(yticks)(d))}return results}()}if(yNA){yticks=[null].concat(yticks)}if(yNA){yticklab=["NA"].concat(yticklab)}ylines=yaxis.append("g").attr("id","ylines").selectAll("empty").data(yticks.concat(yticks)).enter().append("line").attr("y1",function(d){return yscale_wnull(d)}).attr("y2",function(d){return yscale_wnull(d)}).attr("x1",function(d,i){if(i<yticks.length){return xrange[0]}return margin.left}).attr("x2",function(d,i){if(i<yticks.length){return xrange[1]}return margin.left+xNA_size.width}).attr("fill","none").attr("stroke",ylineOpts.color).attr("stroke-width",ylineOpts.width).attr("shape-rendering","crispEdges").style("pointer-events","none");xlines=xaxis.append("g").attr("id","xlines").selectAll("empty").data(xticks.concat(xticks)).enter().append("line").attr("x1",function(d){return xscale_wnull(d)}).attr("x2",function(d){return xscale_wnull(d)}).attr("y1",function(d,i){if(i<xticks.length){return yrange[0]}return height-margin.bottom}).attr("y2",function(d,i){if(i<xticks.length){return yrange[1]}return height-margin.bottom-yNA_size.width}).attr("fill","none").attr("stroke",xlineOpts.color).attr("stroke-width",xlineOpts.width).attr("shape-rendering","crispEdges").style("pointer-events","none");xlabels=xaxis.append("g").attr("id","xlabels").selectAll("empty").data(xticklab).enter().append("text").attr("x",function(d,i){return xscale_wnull(xticks[i])}).attr("y",height-margin.bottom+axispos.xlabel).text(function(d){return d});ylabels=yaxis.append("g").attr("id","ylabels").selectAll("empty").data(yticklab).enter().append("text").attr("y",function(d,i){return yscale_wnull(yticks[i])}).attr("x",margin.left-axispos.ylabel).text(function(d){return d});boxes2include=function(){var results;results=[];for(i in boxes.left){if(boxes.width[i]>0&&boxes.height[i]>0){results.push(i)}}return results}();box=svg.append("g").attr("id","box");return box.selectAll("empty").data(boxes2include).enter().append("rect").attr("x",function(i){return boxes.left[i]}).attr("y",function(i){return boxes.top[i]}).attr("height",function(i){return boxes.height[i]}).attr("width",function(i){return boxes.width[i]}).attr("fill","none").attr("stroke",boxcolor).attr("stroke-width",boxwidth).attr("shape-rendering","crispEdges")};chart.xscale=function(){return xscale_wnull};chart.yscale=function(){return yscale_wnull};chart.xNA=function(){return xNA};chart.yNA=function(){return yNA};chart.xlines=function(){return xlines};chart.ylines=function(){return ylines};chart.xlabels=function(){return xlabels};chart.ylabels=function(){return ylabels};chart.plot_width=function(){return plot_width};chart.plot_height=function(){return plot_height};chart.width=function(){return width};chart.height=function(){return height};chart.margin=function(){return margin};chart.box=function(){return box};chart.svg=function(){return svg};chart.remove=function(){svg.remove();return null};return chart};"use strict";d3panels.chrpanelframe=function(chartOpts){var altrectcolor,axispos,box,boxcolor,boxwidth,chart,chrGap,chrSelect,chrlinecolor,chrlines,chrlinewidth,height,horizontal,margin,nyticks,rectcolor,ref,ref1,ref10,ref11,ref12,ref13,ref14,ref15,ref16,ref17,ref18,ref19,ref2,ref20,ref21,ref22,ref3,ref4,ref5,ref6,ref7,ref8,ref9,rotate_ylab,svg,title,titlepos,width,xlab,xlabels,xlineOpts,xscale,ylab,ylabels,ylim,ylineOpts,yscale,yticklab,yticks;if(chartOpts==null){chartOpts={}}width=(ref=chartOpts!=null?chartOpts.width:void 0)!=null?ref:800;height=(ref1=chartOpts!=null?chartOpts.height:void 0)!=null?ref1:500;margin=(ref2=chartOpts!=null?chartOpts.margin:void 0)!=null?ref2:{left:60,top:40,right:40,bottom:40};axispos=(ref3=chartOpts!=null?chartOpts.axispos:void 0)!=null?ref3:{xtitle:25,ytitle:45,xlabel:5,ylabel:5};titlepos=(ref4=chartOpts!=null?chartOpts.titlepos:void 0)!=null?ref4:20;title=(ref5=chartOpts!=null?chartOpts.title:void 0)!=null?ref5:"";xlab=(ref6=chartOpts!=null?chartOpts.xlab:void 0)!=null?ref6:null;ylab=(ref7=chartOpts!=null?chartOpts.ylab:void 0)!=null?ref7:"LOD score";rotate_ylab=(ref8=chartOpts!=null?chartOpts.rotate_ylab:void 0)!=null?ref8:null;ylim=(ref9=chartOpts!=null?chartOpts.ylim:void 0)!=null?ref9:[0,1];nyticks=(ref10=chartOpts!=null?chartOpts.nyticks:void 0)!=null?ref10:5;yticks=(ref11=chartOpts!=null?chartOpts.yticks:void 0)!=null?ref11:null;yticklab=(ref12=chartOpts!=null?chartOpts.yticklab:void 0)!=null?ref12:null;rectcolor=(ref13=chartOpts!=null?chartOpts.rectcolor:void 0)!=null?ref13:"#e6e6e6";altrectcolor=(ref14=chartOpts!=null?chartOpts.altrectcolor:void 0)!=null?ref14:"#d4d4d4";chrlinecolor=(ref15=chartOpts!=null?chartOpts.chrlinecolor:void 0)!=null?ref15:"";chrlinewidth=(ref16=chartOpts!=null?chartOpts.chrlinewidth:void 0)!=null?ref16:2;boxcolor=(ref17=chartOpts!=null?chartOpts.boxcolor:void 0)!=null?ref17:"black";boxwidth=(ref18=chartOpts!=null?chartOpts.boxwidth:void 0)!=null?ref18:2;xlineOpts=(ref19=chartOpts!=null?chartOpts.xlineOpts:void 0)!=null?ref19:{color:"#d4d4d4",width:2};ylineOpts=(ref20=chartOpts!=null?chartOpts.ylineOpts:void 0)!=null?ref20:{color:"white",width:2};chrGap=(ref21=chartOpts!=null?chartOpts.chrGap:void 0)!=null?ref21:6;horizontal=(ref22=chartOpts.horizontal)!=null?ref22:false;xscale=null;yscale=null;xlabels=null;ylabels=null;chrSelect=null;chrlines=null;box=null;svg=null;chart=function chart(selection,data){var c,d,g,plot_height,plot_width,thechr,xaxis,xlines,xticks,yaxis,ylabpos_x,ylabpos_y,ylines;margin=d3panels.check_listarg_v_default(margin,{left:60,top:40,right:40,bottom:60});axispos=d3panels.check_listarg_v_default(axispos,{xtitle:25,ytitle:45,xlabel:5,ylabel:5});xlineOpts=d3panels.check_listarg_v_default(xlineOpts,{color:"white",width:2});ylineOpts=d3panels.check_listarg_v_default(ylineOpts,{color:"white",width:2});if(data.chr==null){d3panels.displayError("chrpanelframe: data.chr is missing")}if(data.end==null){d3panels.displayError("chrpanelframe: data.end is missing")}if(xlab==null){xlab=data.chr.length===1?"Position":"Chromosome"}svg=selection.append("svg");svg.attr("width",width).attr("height",height).attr("class","d3panels");g=svg.append("g").attr("id","frame");plot_width=width-(margin.left+margin.right);plot_height=height-(margin.top+margin.bottom);if(!(data!=null?data.start:void 0)){data.start=function(){var j,len,ref23,results;ref23=data.chr;results=[];for(j=0,len=ref23.length;j<len;j++){c=ref23[j];results.push(0)}return results}()}if(data.chr.length!==data.start.length){d3panels.displayError("chrpanelframe: data.start.length ("+data.start.length+") != data.chr.length ("+data.chr.length+")")}if(data.chr.length!==data.end.length){d3panels.displayError("chrpanelframe: data.end.length ("+data.end.length+") != data.chr.length ("+data.chr.length+")")}if(horizontal){xscale=d3panels.calc_chrscales(plot_height,margin.top,chrGap,data.chr,data.start,data.end);yscale=d3.scaleLinear().domain(ylim.reverse()).range([plot_width+margin.left,margin.left])}else{xscale=d3panels.calc_chrscales(plot_width,margin.left,chrGap,data.chr,data.start,data.end);yscale=d3.scaleLinear().domain(ylim).range([plot_height+margin.top,margin.top])}g.append("rect").attr("x",margin.left).attr("width",plot_width).attr("y",margin.top).attr("height",plot_height).attr("fill",rectcolor).attr("shape-rendering","crispEdges");if(altrectcolor!==""){chrSelect=g.append("g").selectAll("empty").data(data.chr).enter().append("rect").attr("x",function(d,i){if(horizontal){return margin.left}return xscale[d](data.start[i])-chrGap/2}).attr("width",function(d,i){if(horizontal){return plot_width}return xscale[d](data.end[i])-xscale[d](data.start[i])+chrGap}).attr("y",function(d,i){if(horizontal){return xscale[d](data.start[i])-chrGap/2}return margin.top}).attr("height",function(d,i){if(horizontal){return xscale[d](data.end[i])-xscale[d](data.start[i])+chrGap}return plot_height}).attr("fill",function(d,i){if(i%2===0){return rectcolor}return altrectcolor}).attr("shape-rendering","crispEdges")}g.append("g").attr("class","title").append("text").text(title).attr("x",(width-margin.left-margin.right)/2+margin.left).attr("y",titlepos);if(horizontal){rotate_ylab=rotate_ylab!=null?rotate_ylab:xlab.length>1}else{rotate_ylab=rotate_ylab!=null?rotate_ylab:ylab.length>1}xaxis=g.append("g").attr("class",function(){if(horizontal){return"y axis"}return"x axis"});yaxis=g.append("g").attr("class",function(){if(horizontal){return"x axis"}return"y axis"});xaxis.append("text").attr("class","title").text(function(){if(horizontal){return ylab}return xlab}).attr("x",(width-margin.left-margin.right)/2+margin.left).attr("y",plot_height+margin.top+axispos.xtitle);ylabpos_y=(height-margin.top-margin.bottom)/2+margin.top;ylabpos_x=margin.left-axispos.ytitle;yaxis.append("text").attr("class","title").text(function(){if(horizontal){return xlab}return ylab}).attr("y",ylabpos_y).attr("x",ylabpos_x).attr("transform",rotate_ylab?"rotate(270,"+ylabpos_x+","+ylabpos_y+")":"");if(data.chr.length>1){xlabels=xaxis.append("g").attr("id","xlabels").selectAll("empty").data(data.chr).enter().append("text").attr("x",function(d,i){if(horizontal){return margin.left-axispos.ylabel}return(xscale[d](data.start[i])+xscale[d](data.end[i]))/2}).attr("y",function(d,i){if(horizontal){return(xscale[d](data.start[i])+xscale[d](data.end[i]))/2}return height-margin.bottom+axispos.xlabel}).text(function(d){return d})}else{thechr=data.chr[0];xticks=xscale[thechr].ticks(5);xlabels=xaxis.append("g").attr("id","xlabels").selectAll("empty").data(xticks).enter().append("text").attr("x",function(d){if(horizontal){return margin.left-axispos.ylabel}return xscale[thechr](d)}).attr("y",function(d,i){if(horizontal){return xscale[thechr](d)}return height-margin.bottom+axispos.xlabel}).text(function(d){return d});xlines=xaxis.append("g").attr("id","xlines").selectAll("empty").data(xticks).enter().append("line").attr("x1",function(d){if(horizontal){return margin.left}return xscale[thechr](d)}).attr("x2",function(d){if(horizontal){return margin.left+plot_width}return xscale[thechr](d)}).attr("y1",function(d,i){if(horizontal){return xscale[thechr](d)}return margin.top}).attr("y2",function(d,i){if(horizontal){return xscale[thechr](d)}return plot_height+margin.top}).attr("fill","none").attr("stroke",xlineOpts.color).attr("stroke-width",xlineOpts.width).attr("shape-rendering","crispEdges").style("pointer-events","none")}yticks=yticks!=null?yticks:yscale.ticks(nyticks);if(yticklab!=null&&yticklab.length!==yticks.length){displayError("chrpanelframe: yticklab.length ("+yticklab.length+") != yticks.length ("+yticks.length+")")}if(!(yticklab!=null&&yticklab.length===yticks.length)){yticklab=function(){var j,len,results;results=[];for(j=0,len=yticks.length;j<len;j++){d=yticks[j];results.push(d3panels.formatAxis(yticks)(d))}return results}()}ylines=yaxis.append("g").attr("id","ylines").selectAll("empty").data(yticks.concat(yticks)).enter().append("line").attr("y1",function(d){if(horizontal){return margin.top}return yscale(d)}).attr("y2",function(d){if(horizontal){return margin.top+plot_height}return yscale(d)}).attr("x1",function(d,i){if(horizontal){return yscale(d)}return margin.left}).attr("x2",function(d,i){if(horizontal){return yscale(d)}return plot_width+margin.left}).attr("fill","none").attr("stroke",ylineOpts.color).attr("stroke-width",ylineOpts.width).attr("shape-rendering","crispEdges").style("pointer-events","none");ylabels=yaxis.append("g").attr("id","ylabels").selectAll("empty").data(yticklab).enter().append("text").attr("y",function(d,i){if(horizontal){return height-margin.bottom+axispos.xlabel}return yscale(yticks[i])}).attr("x",function(d,i){if(horizontal){return yscale(yticks[i])}return margin.left-axispos.ylabel}).text(function(d){return d});if(chrlinecolor!==""&&data.chr.length>1){chrlines=svg.append("g").attr("id","chrlines");chrlines.selectAll("empty").data(data.chr.slice(0,+(data.chr.length-2)+1||9e9)).enter().append("line").attr("x1",function(d,i){if(horizontal){return margin.left}return xscale[d](data.end[i])+chrGap/2}).attr("x2",function(d,i){if(horizontal){return margin.left+plot_width}return xscale[d](data.end[i])+chrGap/2}).attr("y1",function(d,i){if(horizontal){return xscale[d](data.end[i])+chrGap/2}return margin.top}).attr("y2",function(d,i){if(horizontal){return xscale[d](data.end[i])+chrGap/2}return margin.top+plot_height}).attr("stroke",chrlinecolor).attr("stroke-width",chrlinewidth).attr("shape-rendering","crispEdges")}return box=svg.append("rect").attr("class","box").attr("x",margin.left).attr("y",margin.top).attr("height",plot_height).attr("width",plot_width).attr("fill","none").attr("stroke",boxcolor).attr("stroke-width",boxwidth).attr("shape-rendering","crispEdges")};chart.xscale=function(){return xscale};chart.yscale=function(){return yscale};chart.xlabels=function(){return xlabels};chart.ylabels=function(){return ylabels};chart.chrSelect=function(){return chrSelect};chart.chrlines=function(){return chrlines};chart.plot_width=function(){return plot_width};chart.plot_height=function(){return plot_height};chart.width=function(){return width};chart.height=function(){return height};chart.margin=function(){return margin};chart.box=function(){return box};chart.svg=function(){return svg};chart.remove=function(){svg.remove();return null};return chart};"use strict";d3panels.chr2dpanelframe=function(chartOpts){var altrectcolor,axispos,box,boxcolor,boxwidth,chart,chrGap,chrSelect,chrlinecolor,chrlines,chrlinewidth,height,margin,oneAtTop,rectcolor,ref,ref1,ref10,ref11,ref12,ref13,ref14,ref15,ref16,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,rotate_ylab,svg,title,titlepos,width,xlab,xlabels,xscale,ylab,ylabels,yscale;if(chartOpts==null){chartOpts={}}width=(ref=chartOpts!=null?chartOpts.width:void 0)!=null?ref:800;height=(ref1=chartOpts!=null?chartOpts.height:void 0)!=null?ref1:800;margin=(ref2=chartOpts!=null?chartOpts.margin:void 0)!=null?ref2:{left:60,top:40,right:40,bottom:60};axispos=(ref3=chartOpts!=null?chartOpts.axispos:void 0)!=null?ref3:{xtitle:25,ytitle:45,xlabel:5,ylabel:5};titlepos=(ref4=chartOpts!=null?chartOpts.titlepos:void 0)!=null?ref4:20;title=(ref5=chartOpts!=null?chartOpts.title:void 0)!=null?ref5:"";xlab=(ref6=chartOpts!=null?chartOpts.xlab:void 0)!=null?ref6:"Chromosome";ylab=(ref7=chartOpts!=null?chartOpts.ylab:void 0)!=null?ref7:"Chromosome";rotate_ylab=(ref8=chartOpts!=null?chartOpts.rotate_ylab:void 0)!=null?ref8:null;rectcolor=(ref9=chartOpts!=null?chartOpts.rectcolor:void 0)!=null?ref9:"#e6e6e6";altrectcolor=(ref10=chartOpts!=null?chartOpts.altrectcolor:void 0)!=null?ref10:"#d4d4d4";chrlinecolor=(ref11=chartOpts!=null?chartOpts.chrlinecolor:void 0)!=null?ref11:"";chrlinewidth=(ref12=chartOpts!=null?chartOpts.chrlinewidth:void 0)!=null?ref12:2;boxcolor=(ref13=chartOpts!=null?chartOpts.boxcolor:void 0)!=null?ref13:"black";boxwidth=(ref14=chartOpts!=null?chartOpts.boxwidth:void 0)!=null?ref14:2;chrGap=(ref15=chartOpts!=null?chartOpts.chrGap:void 0)!=null?ref15:6;oneAtTop=(ref16=chartOpts!=null?chartOpts.oneAtTop:void 0)!=null?ref16:false;xscale=null;yscale=null;xlabels=null;ylabels=null;chrSelect=null;chrlines=null;box=null;svg=null;chart=function chart(selection,data){var c,chrRect,chrx,chry,g,j,k,len,len1,plot_height,plot_width,ref17,ref18,x,xaxis,y,yaxis,ylabpos_x,ylabpos_y;margin=d3panels.check_listarg_v_default(margin,{left:60,top:40,right:40,bottom:60});axispos=d3panels.check_listarg_v_default(axispos,{xtitle:25,ytitle:45,xlabel:5,ylabel:5});if(data.chr==null){d3panels.displayError("chr2dpanelframe: data.chr is missing")}if(data.end==null){d3panels.displayError("chr2dpanelframe: data.end is missing")}svg=selection.append("svg");svg.attr("width",width).attr("height",height).attr("class","d3panels");g=svg.append("g").attr("id","frame");plot_width=width-(margin.left+margin.right);plot_height=height-(margin.top+margin.bottom);if(!(data!=null?data.start:void 0)){data.start=function(){var j,len,ref17,results;ref17=data.chr;results=[];for(j=0,len=ref17.length;j<len;j++){c=ref17[j];results.push(0)}return results}()}if(data.chr.length!==data.start.length){d3panels.displayError("chr2dpanelframe: data.start.length ("+data.start.length+") != data.chr.length ("+data.chr.length+")")}if(data.chr.length!==data.end.length){d3panels.displayError("chr2dpanelframe: data.end.length ("+data.end.length+") != data.chr.length ("+data.chr.length+")")}xscale=d3panels.calc_chrscales(plot_width,margin.left,chrGap,data.chr,data.start,data.end);yscale=d3panels.calc_chrscales(plot_height,margin.top,chrGap,data.chr,data.start,data.end,!oneAtTop);g.append("rect").attr("x",margin.left).attr("width",plot_width).attr("y",margin.top).attr("height",plot_height).attr("fill",rectcolor).attr("shape-rendering","crispEdges");chrRect=[];ref17=data.chr;for(x=j=0,len=ref17.length;j<len;x=++j){chrx=ref17[x];ref18=data.chr;for(y=k=0,len1=ref18.length;k<len1;y=++k){chry=ref18[y];chrRect.push({chrx:chrx,xi:x,chry:chry,yi:y,odd:(x+y)%2})}}if(altrectcolor!==""){chrSelect=g.append("g").selectAll("empty").data(chrRect).enter().append("rect").attr("x",function(d){return xscale[d.chrx](data.start[d.xi])-chrGap/2}).attr("width",function(d){return xscale[d.chrx](data.end[d.xi])-xscale[d.chrx](data.start[d.xi])+chrGap}).attr("y",function(d){if(oneAtTop){return yscale[d.chry](data.start[d.yi])-chrGap/2}return yscale[d.chry](data.end[d.yi])-chrGap/2}).attr("height",function(d){if(oneAtTop){return yscale[d.chry](data.end[d.yi])-yscale[d.chry](data.start[d.yi])+chrGap}return yscale[d.chry](data.start[d.yi])-yscale[d.chry](data.end[d.yi])+chrGap}).attr("fill",function(d,i){if(!d.odd){return rectcolor}return altrectcolor}).attr("shape-rendering","crispEdges")}g.append("g").attr("class","title").append("text").text(title).attr("x",(width-margin.left-margin.right)/2+margin.left).attr("y",titlepos);rotate_ylab=rotate_ylab!=null?rotate_ylab:ylab.length>1;xaxis=g.append("g").attr("class","x axis");yaxis=g.append("g").attr("class","y axis");xaxis.append("text").attr("class","title").text(function(){return xlab}).attr("x",(width-margin.left-margin.right)/2+margin.left).attr("y",plot_height+margin.top+axispos.xtitle);ylabpos_y=(height-margin.top-margin.bottom)/2+margin.top;ylabpos_x=margin.left-axispos.ytitle;yaxis.append("text").attr("class","title").text(function(){return ylab}).attr("y",ylabpos_y).attr("x",ylabpos_x).attr("transform",rotate_ylab?"rotate(270,"+ylabpos_x+","+ylabpos_y+")":"");xlabels=xaxis.append("g").attr("id","xlabels").selectAll("empty").data(data.chr).enter().append("text").attr("x",function(d,i){return(xscale[d](data.start[i])+xscale[d](data.end[i]))/2}).attr("y",height-margin.bottom+axispos.xlabel).text(function(d){return d});ylabels=yaxis.append("g").attr("id","ylabels").selectAll("empty").data(data.chr).enter().append("text").attr("y",function(d,i){return(yscale[d](data.start[i])+yscale[d](data.end[i]))/2}).attr("x",margin.left-axispos.ylabel).text(function(d){return d});if(chrlinecolor!==""&&data.chr.length>1){chrlines=svg.append("g").attr("id","chrlines");chrlines.selectAll("empty").data(data.chr.slice(0,+(data.chr.length-2)+1||9e9)).enter().append("line").attr("x1",function(d,i){return xscale[d](data.end[i])+chrGap/2}).attr("x2",function(d,i){return xscale[d](data.end[i])+chrGap/2}).attr("y1",margin.top).attr("y2",margin.top+plot_height).attr("stroke",chrlinecolor).attr("stroke-width",chrlinewidth).attr("shape-rendering","crispEdges");chrlines.selectAll("empty").data(data.chr.slice(0,+(data.chr.length-2)+1||9e9)).enter().append("line").attr("y1",function(d,i){if(oneAtTop){return yscale[d](data.end[i])+chrGap/2}return yscale[d](data.end[i])-chrGap/2}).attr("y2",function(d,i){if(oneAtTop){return yscale[d](data.end[i])+chrGap/2}return yscale[d](data.end[i])-chrGap/2}).attr("x1",margin.left).attr("x2",margin.left+plot_width).attr("stroke",chrlinecolor).attr("stroke-width",chrlinewidth).attr("shape-rendering","crispEdges")}return box=svg.append("rect").attr("class","box").attr("x",margin.left).attr("y",margin.top).attr("height",plot_height).attr("width",plot_width).attr("fill","none").attr("stroke",boxcolor).attr("stroke-width",boxwidth).attr("shape-rendering","crispEdges")};chart.xscale=function(){return xscale};chart.yscale=function(){return yscale};chart.xlabels=function(){return xlabels};chart.ylabels=function(){return ylabels};chart.chrSelect=function(){return chrSelect};chart.chrlines=function(){return chrlines};chart.plot_width=function(){return plot_width};chart.plot_height=function(){return plot_height};chart.width=function(){return width};chart.height=function(){return height};chart.margin=function(){return margin};chart.box=function(){return box};chart.svg=function(){return svg};chart.remove=function(){svg.remove();return null};return chart};"use strict";d3panels.cichart=function(chartOpts){var chart,horizontal,ref,ref1,ref10,ref11,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,segcolor,segments,segstrokewidth,segwidth,svg,tip,tipclass,v_over_h,vertsegcolor,xcatlabels,xlab,xlineOpts,xscale,ylab,ylim,yscale;if(chartOpts==null){chartOpts={}}xcatlabels=(ref=chartOpts!=null?chartOpts.xcatlabels:void 0)!=null?ref:null;segwidth=(ref1=chartOpts!=null?chartOpts.segwidth:void 0)!=null?ref1:.4;segcolor=(ref2=chartOpts!=null?chartOpts.segcolor:void 0)!=null?ref2:"slateblue";segstrokewidth=(ref3=chartOpts!=null?chartOpts.segstrokewidth:void 0)!=null?ref3:"3";vertsegcolor=(ref4=chartOpts!=null?chartOpts.vertsegcolor:void 0)!=null?ref4:"slateblue";xlab=(ref5=chartOpts!=null?chartOpts.xlab:void 0)!=null?ref5:"Group";ylab=(ref6=chartOpts!=null?chartOpts.ylab:void 0)!=null?ref6:"Response";ylim=(ref7=chartOpts!=null?chartOpts.ylim:void 0)!=null?ref7:null;xlineOpts=(ref8=chartOpts!=null?chartOpts.xlineOpts:void 0)!=null?ref8:{color:"#CDCDCD",width:5};horizontal=(ref9=chartOpts!=null?chartOpts.horizontal:void 0)!=null?ref9:false;v_over_h=(ref10=chartOpts!=null?chartOpts.v_over_h:void 0)!=null?ref10:horizontal;tipclass=(ref11=chartOpts!=null?chartOpts.tipclass:void 0)!=null?ref11:"tooltip";xscale=null;yscale=null;segments=null;tip=null;svg=null;chart=function chart(selection,data){var direction,high,i,low,mean,myframe,ncat,segmentGroup,tipfunc,xlim,xticks,xval,yval;xlineOpts=d3panels.check_listarg_v_default(xlineOpts,{color:"#CDCDCD",width:5});if(data.mean==null){d3panels.displayError("cichart: data.mean is missing")}if(data.low==null){d3panels.displayError("cichart: data.low is missing")}if(data.high==null){d3panels.displayError("cichart: data.high is missing")}mean=data.mean;low=data.low;high=data.high;ncat=mean.length;if(ncat!==low.length){d3panels.displayError("cichart: low.length ["+low.length+"] != mean.length ["+ncat+"]")}if(ncat!==high.length){d3panels.displayError("cichart: high.length ["+high.length+"] != mean.length ["+ncat+"]")}xticks=function(){var results;results=[];for(i in mean){results.push(+i+1)}return results}();xcatlabels=xcatlabels!=null?xcatlabels:xticks;if(xcatlabels.length!==mean.length){d3panels.displayError("cichart: xcatlabels.length ["+xcatlabels.length+"] != mean.length ["+ncat+"]")}ylim=ylim!=null?ylim:d3panels.pad_ylim(d3.extent(low.concat(high)));xlim=[.5,mean.length+.5];segcolor=d3panels.expand2vector(d3panels.forceAsArray(segcolor),mean.length);vertsegcolor=d3panels.expand2vector(d3panels.forceAsArray(vertsegcolor),mean.length);if(horizontal){chartOpts.ylim=xlim.reverse();chartOpts.xlim=ylim;chartOpts.xlab=ylab;chartOpts.ylab=xlab;chartOpts.xlineOpts=chartOpts.ylineOpts;chartOpts.ylineOpts=xlineOpts;chartOpts.yNA=chartOpts.xNA;chartOpts.xNA=chartOpts.yNA;chartOpts.yticks=xticks;chartOpts.yticklab=xcatlabels;chartOpts.v_over_h=v_over_h}else{chartOpts.ylim=ylim;chartOpts.xlim=xlim;chartOpts.xlab=xlab;chartOpts.ylab=ylab;chartOpts.ylineOpts=chartOpts.ylineOpts;chartOpts.xlineOpts=xlineOpts;chartOpts.xticks=xticks;chartOpts.xticklab=xcatlabels;chartOpts.v_over_h=v_over_h}myframe=d3panels.panelframe(chartOpts);myframe(selection);svg=myframe.svg();xscale=myframe.xscale();yscale=myframe.yscale();segmentGroup=svg.append("g").attr("id","segments");segments=segmentGroup.selectAll("empty").data(low).enter().append("line").attr("x1",function(d,i){if(!horizontal){return xscale(i+1)}return xscale(d)}).attr("x2",function(d,i){if(!horizontal){return xscale(i+1)}return xscale(high[i])}).attr("y1",function(d,i){if(!horizontal){return yscale(d)}return yscale(i+1)}).attr("y2",function(d,i){if(!horizontal){return yscale(high[i])}return yscale(i+1)}).attr("fill","none").attr("stroke",function(d,i){return vertsegcolor[i]}).attr("stroke-width",segstrokewidth).attr("shape-rendering","crispEdges");yval=mean.concat(low,high);xval=function(){var results;results=[];for(i in yval){results.push(+(i%ncat)+1)}return results}();segments=segmentGroup.selectAll("empty").data(yval).enter().append("line").attr("x1",function(d,i){if(horizontal){return xscale(d)}else{if(i<ncat){return xscale(xval[i]-segwidth/2)}return xscale(xval[i]-segwidth/3)}}).attr("x2",function(d,i){if(horizontal){return xscale(d)}else{if(i<ncat){return xscale(xval[i]+segwidth/2)}return xscale(xval[i]+segwidth/3)}}).attr("y1",function(d,i){if(horizontal){if(i<ncat){return yscale(xval[i]-segwidth/2)}return yscale(xval[i]-segwidth/3)}else{return yscale(d)}}).attr("y2",function(d,i){if(horizontal){if(i<ncat){return yscale(xval[i]+segwidth/2)}return yscale(xval[i]+segwidth/3)}else{return yscale(d)}}).attr("fill","none").attr("stroke",function(d,i){return segcolor[i%mean.length]}).attr("stroke-width",segstrokewidth).attr("shape-rendering","crispEdges");direction=horizontal?"north":"east";tipfunc=function tipfunc(d,i){var f,index;index=i%mean.length;f=d3panels.formatAxis([low[index],mean[index]],1);return f(mean[index])+" ("+f(low[index])+" - "+f(high[index])+")"};tip=d3panels.tooltip_create(d3.select("body"),segments,{direction:direction,tipclass:tipclass},tipfunc);return myframe.box().raise()};chart.yscale=function(){return yscale};chart.xscale=function(){return xscale};chart.segments=function(){return segments};chart.tip=function(){return tip};chart.svg=function(){return svg};chart.remove=function(){svg.remove();d3panels.tooltip_destroy(tip);return null};return chart};"use strict";d3panels.crosstab=function(chartOpts){var bordercolor,cellPad,chart,colrect,fontsize,height,hilitcolor,margin,rectcolor,ref,ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,rowrect,svg,title,titlepos,width;if(chartOpts==null){chartOpts={}}width=(ref=chartOpts!=null?chartOpts.width:void 0)!=null?ref:600;height=(ref1=chartOpts!=null?chartOpts.height:void 0)!=null?ref1:300;margin=(ref2=chartOpts!=null?chartOpts.margin:void 0)!=null?ref2:{left:60,top:80,right:40,bottom:20};cellPad=(ref3=chartOpts!=null?chartOpts.cellPad:void 0)!=null?ref3:null;titlepos=(ref4=chartOpts!=null?chartOpts.titlepos:void 0)!=null?ref4:50;title=(ref5=chartOpts!=null?chartOpts.title:void 0)!=null?ref5:"";fontsize=(ref6=chartOpts!=null?chartOpts.fontsize:void 0)!=null?ref6:null;rectcolor=(ref7=chartOpts!=null?chartOpts.rectcolor:void 0)!=null?ref7:"#e6e6e6";hilitcolor=(ref8=chartOpts!=null?chartOpts.hilitcolor:void 0)!=null?ref8:"#e9cfec";bordercolor=(ref9=chartOpts!=null?chartOpts.bordercolor:void 0)!=null?ref9:"black";rowrect=null;colrect=null;svg=null;chart=function chart(selection,data){var borders,cell,cellHeight,cellWidth,cells,collab,cols,denom,i,j,k,l,n,ncol,nrow,plot_height,plot_width,rect,ref10,ref11,ref12,ref13,ref14,ref15,ref16,ref17,rowlab,rows,tab,titles,values,xscale,xv,yscale,yv;margin=d3panels.check_listarg_v_default(margin,{left:60,top:40,right:40,bottom:60});if(data.x==null){d3panels.displayError("crosstab: data.x is missing")}if(data.y==null){d3panels.displayError("crosstab: data.y is missing")}n=data.x.length;if(data.y.length!==n){d3panels.displayError("crosstab: data.x.length ["+data.x.length+"] != data.y.length ["+data.y.length+"]")}data.xcat=(ref10=data!=null?data.xcat:void 0)!=null?ref10:function(){var k,len,ref11,results;ref11=d3.range(d3.max(data.x));results=[];for(k=0,len=ref11.length;k<len;k++){xv=ref11[k];results.push(xv+1)}return results}();data.ycat=(ref11=data!=null?data.ycat:void 0)!=null?ref11:function(){var k,len,ref12,results;ref12=d3.range(d3.max(data.y));results=[];for(k=0,len=ref12.length;k<len;k++){yv=ref12[k];results.push(yv+1)}return results}();ncol=data.xcat.length;if(d3.max(data.x)>ncol||d3.min(data.x)<=0){d3panels.displayError("crosstab: data.x should be in range 1-"+ncol+" [was "+d3.min(data.x)+" - "+d3.max(data.x)+"]")}nrow=data.ycat.length;if(d3.max(data.y)>nrow||d3.min(data.y)<=0){d3panels.displayError("crosstab: data.y should be in range 1-"+nrow+" [was "+d3.min(data.y)+" - "+d3.max(data.y)+"]")}data.x=function(){var k,len,ref12,results;ref12=data.x;results=[];for(k=0,len=ref12.length;k<len;k++){xv=ref12[k];results.push(xv-1)}return results}();data.y=function(){var k,len,ref12,results;ref12=data.y;results=[];for(k=0,len=ref12.length;k<len;k++){yv=ref12[k];results.push(yv-1)}return results}();tab=d3panels.calc_crosstab(data);data.xlabel=(ref12=data!=null?data.xlabel:void 0)!=null?ref12:"";data.ylabel=(ref13=data!=null?data.ylabel:void 0)!=null?ref13:"";cells=[];for(i=k=0,ref14=nrow;0<=ref14?k<=ref14:k>=ref14;i=0<=ref14?++k:--k){for(j=l=0,ref15=ncol;0<=ref15?l<=ref15:l>=ref15;j=0<=ref15?++l:--l){cell={value:tab[i][j],row:i,col:j,shaded:false,rowpercent:"",colpercent:""};if(i<nrow-1&&(j<ncol-1||j===ncol)){cell.shaded=true}if(j<ncol-1&&(i<nrow-1||i===nrow)){cell.shaded=true}if(i<nrow-1){denom=tab[nrow][j]-tab[nrow-1][j];cell.colpercent=denom>0?Math.round(100*tab[i][j]/denom)+"%":"—"}else if(i===nrow-1){denom=tab[nrow][j];cell.colpercent=denom>0?"("+Math.round(100*tab[i][j]/denom)+"%)":"—"}else{cell.colpercent=cell.value}if(j<ncol-1){denom=tab[i][ncol]-tab[i][ncol-1];cell.rowpercent=denom>0?Math.round(100*tab[i][j]/denom)+"%":"—"}else if(j===ncol-1){denom=tab[i][ncol];cell.rowpercent=denom>0?"("+Math.round(100*tab[i][j]/denom)+"%)":"—"}else{cell.rowpercent=cell.value}cells.push(cell)}}plot_width=width-margin.left-margin.right;plot_height=height-margin.top-margin.bottom;cellWidth=plot_width/(ncol+2);cellHeight=plot_height/(nrow+2);fontsize=fontsize!=null?fontsize:cellHeight*.5;cellPad=cellPad!=null?cellPad:cellWidth*.1;xscale=d3.scaleBand().domain(function(){var results=[];for(var m=0,ref16=ncol+1;0<=ref16?m<=ref16:m>=ref16;0<=ref16?m++:m--){results.push(m)}return results}.apply(this)).range([margin.left,width-margin.right]);yscale=d3.scaleBand().domain(function(){var results=[];for(var m=0,ref17=nrow+1;0<=ref17?m<=ref17:m>=ref17;0<=ref17?m++:m--){results.push(m)}return results}.apply(this)).range([margin.top,height-margin.bottom]);svg=selection.append("svg").attr("width",width).attr("height",height).attr("class","d3panels");rect=svg.append("g").attr("id","value_rect");rect.selectAll("empty").data(cells).enter().append("rect").attr("x",function(d){return xscale(d.col+1)}).attr("y",function(d){return yscale(d.row+1)}).attr("width",cellWidth).attr("height",cellHeight).attr("fill",function(d){if(d.shaded){return rectcolor}else{return"none"}}).attr("stroke",function(d){if(d.shaded){return rectcolor}else{return"none"}}).attr("stroke-width",0).style("pointer-events","none").attr("shape-rendering","crispEdges");values=svg.append("g").attr("id","values");values.selectAll("empty").data(cells).enter().append("text").attr("x",function(d){return xscale(d.col+1)+cellWidth-cellPad}).attr("y",function(d){return yscale(d.row+1)+cellHeight/2}).text(function(d){return d.value}).attr("class",function(d){return"crosstab row"+d.row+" col"+d.col}).style("font-size",fontsize).style("pointer-events","none");colrect=svg.append("g").attr("id","colrect");cols=colrect.selectAll("empty").data(data.xcat.concat("Total")).enter().append("rect").attr("x",function(d,i){return xscale(i+1)}).attr("y",yscale(0)).attr("width",cellWidth).attr("height",cellHeight).attr("fill","white").attr("stroke","white").attr("shape-rendering","crispEdges").on("mouseover",function(event,d){i=cols.nodes().indexOf(this);d3.select(this).attr("fill",hilitcolor).attr("stroke",hilitcolor);return values.selectAll(".col"+i).text(function(d){return d.colpercent})}).on("mouseout",function(event,d){i=cols.nodes().indexOf(this);d3.select(this).attr("fill","white").attr("stroke","white");return values.selectAll("text.col"+i).text(function(d){return d.value})});collab=svg.append("g").attr("id","collab");collab.selectAll("empty").data(data.xcat.concat("Total")).enter().append("text").attr("x",function(d,i){return xscale(i+1)+cellWidth-cellPad}).attr("y",yscale(0)+cellHeight/2).text(function(d){return d}).attr("class","crosstab").style("font-size",fontsize).style("pointer-events","none");rowrect=svg.append("g").attr("id","rowrect");rows=rowrect.selectAll("empty").data(data.ycat.concat("Total")).enter().append("rect").attr("x",xscale(0)).attr("y",function(d,i){return yscale(i+1)}).attr("width",cellWidth).attr("height",cellHeight).attr("fill","white").attr("stroke","white").attr("shape-rendering","crispEdges").on("mouseover",function(event,d){i=rows.nodes().indexOf(this);d3.select(this).attr("fill",hilitcolor).attr("stroke",hilitcolor);return values.selectAll(".row"+i).text(function(d){return d.rowpercent})}).on("mouseout",function(event,d){i=rows.nodes().indexOf(this);d3.select(this).attr("fill","white").attr("stroke","white");return values.selectAll(".row"+i).text(function(d){return d.value})});rowlab=svg.append("g").attr("id","rowlab");rowlab.selectAll("empty").data(data.ycat.concat("Total")).enter().append("text").attr("x",xscale(0)+cellWidth-cellPad).attr("y",function(d,i){return yscale(i+1)+cellHeight/2}).text(function(d){return d}).attr("class","crosstab").style("font-size",fontsize).style("pointer-events","none");borders=svg.append("g").attr("id","borders");borders.append("rect").attr("x",xscale(1)).attr("y",yscale(1)).attr("width",cellWidth*ncol).attr("height",cellHeight*nrow).attr("fill","none").attr("stroke",bordercolor).attr("stroke-width",2).style("pointer-events","none").attr("shape-rendering","crispEdges");borders.append("rect").attr("x",xscale(ncol+1)).attr("y",yscale(nrow+1)).attr("width",cellWidth).attr("height",cellHeight).attr("fill","none").attr("stroke",bordercolor).attr("stroke-width",2).style("pointer-events","none").attr("shape-rendering","crispEdges");titles=svg.append("g").attr("id","titles");titles.append("text").attr("class","crosstabtitle").attr("x",margin.left+(ncol+1)*cellWidth/2).attr("y",margin.top-cellHeight/2).text(data.xlabel).style("font-size",fontsize).style("font-weight","bold");titles.append("text").attr("class","crosstab").attr("x",xscale(0)+cellWidth-cellPad).attr("y",yscale(0)+cellHeight/2).text(data.ylabel).style("font-size",fontsize).style("font-weight","bold");return titles.append("text").attr("class","crosstabtitle").attr("x",margin.left+(width-margin.left-margin.right)/2).attr("y",margin.top-titlepos).text(title).style("font-size",fontsize)};chart.rowrect=function(){return rowrect};chart.colrect=function(){return colrect};chart.svg=function(){return svg};chart.remove=function(){svg.remove();return null};return chart};"use strict";d3panels.curvechart=function(chartOpts){var chart,curves,indtip,linecolor,linecolorhilit,linewidth,linewidthhilit,ref,ref1,ref2,ref3,ref4,ref5,ref6,svg,tipclass,xlim,xscale,ylim,yscale;if(chartOpts==null){chartOpts={}}xlim=(ref=chartOpts!=null?chartOpts.xlim:void 0)!=null?ref:null;ylim=(ref1=chartOpts!=null?chartOpts.ylim:void 0)!=null?ref1:null;linecolor=(ref2=chartOpts!=null?chartOpts.linecolor:void 0)!=null?ref2:null;linecolorhilit=(ref3=chartOpts!=null?chartOpts.linecolorhilit:void 0)!=null?ref3:null;linewidth=(ref4=chartOpts!=null?chartOpts.linewidth:void 0)!=null?ref4:2;linewidthhilit=(ref5=chartOpts!=null?chartOpts.linewidthhilit:void 0)!=null?ref5:2;tipclass=(ref6=chartOpts!=null?chartOpts.tipclass:void 0)!=null?ref6:"tooltip";xscale=null;yscale=null;curves=null;indtip=null;svg=null;chart=function chart(selection,data){var add_curves,i,j,myframe,n_ind,ref7,x,y;if(data.x==null){d3panels.displayError("curvechart: data.x is missing")}if(data.y==null){d3panels.displayError("curvechart: data.y is missing")}x=data.x;y=data.y;n_ind=y.length;if(x.length===1&&y.length>1){for(j=i=2,ref7=n_ind;2<=ref7?i<=ref7:i>=ref7;j=2<=ref7?++i:--i){x.push(x[0])}}if(x.length!==n_ind){d3panels.displayError("curvechart: data.x.length ("+x.length+") != data.y.length ("+n_ind+")")}xlim=xlim!=null?xlim:d3panels.matrixExtent(x);ylim=ylim!=null?ylim:d3panels.matrixExtent(y);chartOpts.xlim=xlim;chartOpts.ylim=ylim;chartOpts.xNA=false;chartOpts.yNA=false;myframe=d3panels.panelframe(chartOpts);myframe(selection);svg=myframe.svg();xscale=myframe.xscale();yscale=myframe.yscale();add_curves=d3panels.add_curves({linecolor:linecolor,linecolorhilit:linecolorhilit,linewidth:linewidth,linewidthhilit:linewidthhilit,tipclass:tipclass});add_curves(myframe,data);curves=add_curves.curves();indtip=add_curves.indtip();return myframe.box().raise()};chart.xscale=function(){return xscale};chart.yscale=function(){return yscale};chart.curves=function(){return curves};chart.indtip=function(){return indtip};chart.svg=function(){return svg};chart.remove=function(){svg.remove();d3panels.tooltip_destroy(indtip);return null};return chart};"use strict";var indexOf=[].indexOf;d3panels.dotchart=function(chartOpts){var chart,horizontal,indtip,jitter,pointcolor,points,pointsize,pointstroke,ref,ref1,ref10,ref11,ref12,ref13,ref14,ref15,ref16,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,svg,tipclass,v_over_h,xNA,xNA_size,xcategories,xcatlabels,xlab,xlineOpts,xscale,yNA,yNA_size,ylab,ylim,yscale;if(chartOpts==null){chartOpts={}}xcategories=(ref=chartOpts!=null?chartOpts.xcategories:void 0)!=null?ref:null;xcatlabels=(ref1=chartOpts!=null?chartOpts.xcatlabels:void 0)!=null?ref1:null;xNA=(ref2=chartOpts!=null?chartOpts.xNA:void 0)!=null?ref2:{handle:true,force:false};yNA=(ref3=chartOpts!=null?chartOpts.yNA:void 0)!=null?ref3:{handle:true,force:false};xNA_size=(ref4=chartOpts!=null?chartOpts.xNA_size:void 0)!=null?ref4:{width:20,gap:10};yNA_size=(ref5=chartOpts!=null?chartOpts.yNA_size:void 0)!=null?ref5:{width:20,gap:10};ylim=(ref6=chartOpts!=null?chartOpts.ylim:void 0)!=null?ref6:null;xlab=(ref7=chartOpts!=null?chartOpts.xlab:void 0)!=null?ref7:"Group";ylab=(ref8=chartOpts!=null?chartOpts.ylab:void 0)!=null?ref8:"Response";xlineOpts=(ref9=chartOpts!=null?chartOpts.xlineOpts:void 0)!=null?ref9:{color:"#cdcdcd",width:5};pointcolor=(ref10=chartOpts!=null?chartOpts.pointcolor:void 0)!=null?ref10:null;pointstroke=(ref11=chartOpts!=null?chartOpts.pointstroke:void 0)!=null?ref11:"black";pointsize=(ref12=chartOpts!=null?chartOpts.pointsize:void 0)!=null?ref12:3;jitter=(ref13=chartOpts!=null?chartOpts.jitter:void 0)!=null?ref13:"beeswarm";tipclass=(ref14=chartOpts!=null?chartOpts.tipclass:void 0)!=null?ref14:"tooltip";horizontal=(ref15=chartOpts!=null?chartOpts.horizontal:void 0)!=null?ref15:false;v_over_h=(ref16=chartOpts!=null?chartOpts.v_over_h:void 0)!=null?ref16:horizontal;xscale=null;yscale=null;xNA=xNA;yNA=yNA;points=null;indtip=null;svg=null;chart=function chart(selection,data){var force,g,group,i,indID,jitter_width,myframe,ngroup,pointGroup,ref17,ref18,ref19,ref20,scaledPoints,u,x,xlim,xv,y;xNA=d3panels.check_listarg_v_default(xNA,{handle:true,force:false});yNA=d3panels.check_listarg_v_default(yNA,{handle:true,force:false});xNA_size=d3panels.check_listarg_v_default(xNA,{width:20,gap:10});yNA_size=d3panels.check_listarg_v_default(yNA,{width:20,gap:10});if(data.x==null){d3panels.displayError("dotchart: data.x is missing")}if(data.y==null){d3panels.displayError("dotchart: data.y is missing")}x=d3panels.missing2null(data.x);y=d3panels.missing2null(data.y);indID=(ref17=data!=null?data.indID:void 0)!=null?ref17:function(){var results=[];for(var j=1,ref18=x.length;1<=ref18?j<=ref18:j>=ref18;1<=ref18?j++:j--){results.push(j)}return results}.apply(this);if(x.length!==y.length){d3panels.displayError("dotchart: length(x) ["+x.length+"] != length(y) ["+y.length+"]")}if(indID.length!==x.length){d3panels.displayError("dotchart: length(indID) ["+indID.length+"] != length(x) ["+x.length+"]")}group=(ref19=data!=null?data.group:void 0)!=null?ref19:function(){var j,len,results;results=[];for(j=0,len=x.length;j<len;j++){i=x[j];results.push(1)}return results}();group=d3panels.expand2vector(group,x.length);ngroup=d3.max(group);group=function(){var j,len,results;results=[];for(j=0,len=group.length;j<len;j++){g=group[j];results.push(g!=null?g-1:g)}return results}();if(d3panels.sumArray(function(){var j,len,results;results=[];for(j=0,len=group.length;j<len;j++){g=group[j];results.push(g<0||g>ngroup-1)}return results}())>0){d3panels.displayError("dotchart: group values out of range");console.log("ngroup: "+ngroup);console.log("distinct groups: "+d3panels.unique(group))}if(group.length!==x.length){d3panels.displayError("dotchart: group.length ("+group.length+") != x.length ("+x.length+")")}pointcolor=pointcolor!=null?pointcolor:d3panels.selectGroupColors(ngroup,"dark");pointcolor=d3panels.expand2vector(pointcolor,ngroup);if(pointcolor.length<ngroup){d3panels.displayError("add_points: pointcolor.length ("+pointcolor.length+") < ngroup ("+ngroup+")")}xcategories=xcategories!=null?xcategories:d3panels.unique(x);xcategories=d3panels.forceAsArray(xcategories);xcatlabels=xcatlabels!=null?xcatlabels:xcategories;xcatlabels=d3panels.forceAsArray(xcatlabels);if(xcatlabels.length!==xcategories.length){d3panels.displayError("dotchart: xcatlabels.length ["+xcatlabels.length+"] != xcategories.length ["+xcategories.length+"]")}if(d3panels.sumArray(function(){var j,len,results;results=[];for(j=0,len=x.length;j<len;j++){xv=x[j];results.push(xv!=null&&!(indexOf.call(xcategories,xv)>=0))}return results}())>0){d3panels.displayError("dotchart: Some x values not in xcategories");console.log("xcategories:");console.log(xcategories);console.log("x:");console.log(x);for(i in x){if(x[i]!=null&&!(ref20=x[i],indexOf.call(xcategories,ref20)>=0)){x[i]=null}}}ylim=ylim!=null?ylim:d3panels.pad_ylim(d3.extent(y));xlim=[d3.min(xcategories)-.5,d3.max(xcategories)+.5];xNA.handle=xNA.force||xNA.handle&&!x.every(function(v){return v!=null});yNA.handle=yNA.force||yNA.handle&&!y.every(function(v){return v!=null});if(horizontal){chartOpts.ylim=xlim.reverse();chartOpts.xlim=ylim;chartOpts.xlab=ylab;chartOpts.ylab=xlab;chartOpts.xlineOpts=chartOpts.ylineOpts;chartOpts.ylineOpts=xlineOpts;chartOpts.yNA=xNA.handle;chartOpts.xNA=yNA.handle;chartOpts.xNA_size=yNA_size;chartOpts.yNA_size=xNA_size;chartOpts.yticks=xcategories;chartOpts.yticklab=xcatlabels;chartOpts.v_over_h=v_over_h}else{chartOpts.ylim=ylim;chartOpts.xlim=xlim;chartOpts.xlab=xlab;chartOpts.ylab=ylab;chartOpts.ylineOpts=chartOpts.ylineOpts;chartOpts.xlineOpts=xlineOpts;chartOpts.xNA=xNA.handle;chartOpts.yNA=yNA.handle;chartOpts.xNA_size=xNA_size;chartOpts.yNA_size=yNA_size;chartOpts.xticks=xcategories;chartOpts.xticklab=xcatlabels;chartOpts.v_over_h=v_over_h}myframe=d3panels.panelframe(chartOpts);myframe(selection);svg=myframe.svg();xscale=myframe.xscale();yscale=myframe.yscale();if(horizontal){scaledPoints=function(){var results;results=[];for(i in x){results.push({x:xscale(y[i]),y:yscale(x[i])})}return results}()}else{scaledPoints=function(){var results;results=[];for(i in x){results.push({x:xscale(x[i]),y:yscale(y[i])})}return results}()}pointGroup=svg.append("g").attr("id","points");points=pointGroup.selectAll("empty").data(scaledPoints).enter().append("circle").attr("class",function(d,i){return"pt"+i}).attr("r",pointsize).attr("fill",function(d,i){return pointcolor[group[i]]}).attr("stroke",pointstroke).attr("stroke-width","1").attr("cx",function(d){return d.x}).attr("cy",function(d){return d.y});indtip=d3panels.tooltip_create(d3.select("body"),points,{tipclass:tipclass},function(d,i){return indID[i]});if(jitter==="random"){jitter_width=.2;u=function(){var results;results=[];for(i in scaledPoints){results.push((Math.random()-.5)*jitter_width)}return results}();if(horizontal){points.attr("cy",function(d,i){if(x[i]!=null){return yscale(x[i]+u[i])}return yscale(x[i])+u[i]/jitter_width*xNA_size.width/2})}else{points.attr("cx",function(d,i){if(x[i]!=null){return xscale(x[i]+u[i])}return xscale(x[i])+u[i]/jitter_width*xNA_size.width/2})}}else if(jitter==="beeswarm"){if(horizontal){d3.range(scaledPoints.length).map(function(i){return scaledPoints[i].fx=scaledPoints[i].x});force=d3.forceSimulation(scaledPoints).force("y",d3.forceY(function(d){return d.y})).force("collide",d3.forceCollide(pointsize*1.1)).stop()}else{d3.range(scaledPoints.length).map(function(i){return scaledPoints[i].fy=scaledPoints[i].y});force=d3.forceSimulation(scaledPoints).force("x",d3.forceX(function(d){return d.x})).force("collide",d3.forceCollide(pointsize*1.1)).stop()}(function(){var results=[];for(var j=0;j<=30;j++){results.push(j)}return results}).apply(this).map(function(d){force.tick();return points.attr("cx",function(d){return d.x}).attr("cy",function(d){return d.y})})}else if(jitter!=="none"){d3panels.displayError('dotchart: jitter should be "beeswarm", "random", or "none"')}return myframe.box().raise()};chart.xscale=function(){return xscale};chart.yscale=function(){return yscale};chart.xNA=function(){return xNA.handle};chart.yNA=function(){return yNA.handle};chart.points=function(){return points};chart.indtip=function(){return indtip};chart.svg=function(){return svg};chart.remove=function(){svg.remove();d3panels.tooltip_destroy(indtip);return null};return chart};"use strict";d3panels.heatmap=function(chartOpts){var cellSelect,cells,celltip,chart,colors,hilitcolor,margin,nullcolor,ref,ref1,ref2,ref3,ref4,ref5,ref6,ref7,ref8,svg,tipclass,xlim,xscale,ylim,yscale,zlim,zscale,zthresh;if(chartOpts==null){chartOpts={}}margin=(ref=chartOpts!=null?chartOpts.margin:void 0)!=null?ref:{left:60,top:40,right:40,bottom:40,inner:0};xlim=(ref1=chartOpts!=null?chartOpts.xlim:void 0)!=null?ref1:null;ylim=(ref2=chartOpts!=null?chartOpts.ylim:void 0)!=null?ref2:null;nullcolor=(ref3=chartOpts!=null?chartOpts.nullcolor:void 0)!=null?ref3:"#e6e6e6";colors=(ref4=chartOpts!=null?chartOpts.colors:void 0)!=null?ref4:["slateblue","white","crimson"];zlim=(ref5=chartOpts!=null?chartOpts.zlim:void 0)!=null?ref5:null;zthresh=(ref6=chartOpts!=null?chartOpts.zthresh:void 0)!=null?ref6:null;hilitcolor=(ref7=chartOpts!=null?chartOpts.hilitcolor:void 0)!=null?ref7:"black";tipclass=(ref8=chartOpts!=null?chartOpts.tipclass:void 0)!=null?ref8:"tooltip";xscale=null;yscale=null;zscale=null;cells=null;celltip=null;svg=null;cellSelect=null;chart=function chart(selection,data){var cell,cellrect,i,j,myframe,nx,ny,ref10,ref9,tooltipfunc,xlabels,xmid,xmid_scaled,xv,ylabels,ymid,ymid_scaled,yv,zmax,zmin;margin=d3panels.check_listarg_v_default(margin,{left:60,top:40,right:40,bottom:40,inner:0});if(!(data.x!=null||data.xcat!=null)){d3panels.displayError("heatmap: data.x is missing")}if(!(data.y!=null||data.ycat!=null)){d3panels.displayError("heatmap: data.y is missing")}if(data.z==null){d3panels.displayError("heatmap: data.z is missing")}if(data.xcat!=null){data.x=function(){var results;results=[];for(i in data.xcat){results.push(+i)}return results}();xlim=xlim!=null?xlim:[-.5,data.x.length-.5];chartOpts.xticks=data.x;chartOpts.xlineOpts={color:"none",width:0};chartOpts.xlab=(ref9=chartOpts!=null?chartOpts.xlab:void 0)!=null?ref9:""}if(data.ycat!=null){data.y=function(){var results;results=[];for(i in data.ycat){results.push(+i)}return results}();ylim=ylim!=null?ylim:[-.5,data.x.length-.5];chartOpts.yticks=data.y;chartOpts.ylineOpts={color:"none",width:0};chartOpts.ylab=(ref10=chartOpts!=null?chartOpts.ylab:void 0)!=null?ref10:""}nx=data.x.length;ny=data.y.length;if(data.z.length!==nx){d3panels.displayError("heatmap: data.x.length ("+nx+") != data.z.length ("+data.z.length+")")}for(i in data.z){if(data.z[i].length!==ny){d3panels.displayError("heatmap: data.y.length ("+ny+") != data.z["+i+"].length ("+data.z[i].length+")")}}cells=[];for(i in data.z){for(j in data.z[i]){cells.push({x:data.x[i],y:data.y[j],z:data.z[i][j],xindex:+i,yindex:+j})}}xmid=d3panels.calc_midpoints(d3panels.pad_vector(data.x));ymid=d3panels.calc_midpoints(d3panels.pad_vector(data.y));xlim=xlim!=null?xlim:d3.extent(xmid);ylim=ylim!=null?ylim:d3.extent(ymid);zmin=d3panels.matrixMin(data.z);zmax=d3panels.matrixMaxAbs(data.z);zlim=zlim!=null?zlim:[-zmax,0,zmax];if(zlim.length!==colors.length){d3panels.displayError("heatmap: zlim.length ("+zlim.length+") != colors.length ("+colors.length+")")}zscale=d3.scaleLinear().domain(zlim).range(colors);zthresh=zthresh!=null?zthresh:zmin-1;cells=function(){var k,len,results;results=[];for(k=0,len=cells.length;k<len;k++){cell=cells[k];if(Math.abs(cell.z)>=zthresh){results.push(cell)}}return results}();chartOpts.margin=margin;chartOpts.xlim=xlim;chartOpts.ylim=ylim;chartOpts.xNA=false;chartOpts.yNA=false;myframe=d3panels.panelframe(chartOpts);myframe(selection);svg=myframe.svg();xscale=myframe.xscale();yscale=myframe.yscale();xlabels=myframe.xlabels();ylabels=myframe.ylabels();xmid_scaled=function(){var k,len,results;results=[];for(k=0,len=xmid.length;k<len;k++){xv=xmid[k];results.push(xscale(xv))}return results}();ymid_scaled=function(){var k,len,results;results=[];for(k=0,len=ymid.length;k<len;k++){yv=ymid[k];results.push(yscale(yv))}return results}();d3panels.calc_cell_rect(cells,xmid_scaled,ymid_scaled);cellrect=svg.append("g").attr("id","cells");cellSelect=cellrect.selectAll("empty").data(cells).enter().append("rect").attr("x",function(d){return d.left}).attr("y",function(d){return d.top}).attr("width",function(d){return d.width}).attr("height",function(d){return d.height}).attr("class",function(d,i){return"cell"+i}).attr("fill",function(d){if(d.z!=null){return zscale(d.z)}else{return nullcolor}}).attr("stroke","none").attr("stroke-width","1").attr("shape-rendering","crispEdges").on("mouseover",function(event,d){d3.select(this).attr("stroke",hilitcolor).raise();if(data.xcat!=null){svg.select("text#xlab"+d.x).attr("opacity",1)}if(data.ycat!=null){return svg.select("text#ylab"+d.y).attr("opacity",1)}}).on("mouseout",function(event,d){d3.select(this).attr("stroke","none");if(data.xcat!=null){svg.select("text#xlab"+d.x).attr("opacity",0)}if(data.ycat!=null){return svg.select("text#ylab"+d.y).attr("opacity",0)}});tooltipfunc=function tooltipfunc(d,i){var x,y,z;x=d3panels.formatAxis(data.x)(d.x);y=d3panels.formatAxis(data.y)(d.y);z=d3panels.formatAxis([0,zmax/100])(d.z);if(data.xcat!=null&&data.ycat!=null){return""+z}if(data.xcat!=null){return"("+y+") &rarr; "+z}if(data.ycat!=null){return"("+x+") &rarr; "+z}return"("+x+", "+y+") &rarr; "+z};celltip=d3panels.tooltip_create(d3.select("body"),cellrect.selectAll("rect"),{tipclass:tipclass},tooltipfunc);if(data.xcat!=null){xlabels.text(function(d,i){return data.xcat[i]}).attr("opacity",0).attr("id",function(d,i){return"xlab"+data.x[i]})}if(data.ycat!=null){ylabels.text(function(d,i){return data.ycat[i]}).attr("opacity",0).attr("id",function(d,i){return"ylab"+data.y[i]})}return myframe.box().raise()};chart.xscale=function(){return xscale};chart.yscale=function(){return yscale};chart.zscale=function(){return zscale};chart.cells=function(){return cellSelect};chart.celltip=function(){return celltip};chart.svg=function(){return svg};chart.remove=function(){svg.remove();d3panels.tooltip_destroy(celltip);return null};return chart};"use strict";d3panels.lodchart=function(chartOpts){var chart,chrSelect,linecolor,linewidth,markerSelect,markertip,pointcolor,pointsize,pointstroke,ref,ref1,ref2,ref3,ref4,ref5,ref6,_svg,tipclass,_xscale,ylim,_yscale;if(chartOpts==null){chartOpts={}}linecolor=(ref=chartOpts!=null?chartOpts.linecolor:void 0)!=null?ref:"darkslateblue";linewidth=(ref1=chartOpts!=null?chartOpts.linewidth:void 0)!=null?ref1:2;pointcolor=(ref2=chartOpts!=null?chartOpts.pointcolor:void 0)!=null?ref2:"#e9cfec";pointsize=(ref3=chartOpts!=null?chartOpts.pointsize:void 0)!=null?ref3:0;pointstroke=(ref4=chartOpts!=null?chartOpts.pointstroke:void 0)!=null?ref4:"black";ylim=(ref5=chartOpts!=null?chartOpts.ylim:void 0)!=null?ref5:null;tipclass=(ref6=chartOpts!=null?chartOpts.tipclass:void 0)!=null?ref6:"tooltip";_xscale=null;_yscale=null;chrSelect=null;markerSelect=null;markertip=null;_svg=null;chart=function chart(selection,data){var add2chart,i,myframe,self_chart;if(data.chr==null){d3panels.displayError("lodchart: data.chr is missing")}if(data.pos==null){d3panels.displayError("lodchart: data.pos is missing")}if(data.lod==null){d3panels.displayError("lodchart: data.lod is missing")}if(data.marker==null){d3panels.displayError("lodchart: data.marker is missing")}if(data.pos.length!==data.chr.length){d3panels.displayError("lodchart: data.pos.length ("+data.pos.length+") != data.chr.length ("+data.chr.length+")")}if(data.lod.length!==data.chr.length){d3panels.displayError("lodchart: data.lod.length ("+data.lod.length+") != data.chr.length ("+data.chr.length+")")}if(data.marker==null){data.marker=[function(){var results;results=[];for(i in data.chr){results.push("")}return results}()]}if(data.marker.length!==data.chr.length){d3panels.displayError("lodchart: data.marker.length ("+data.marker.length+") != data.chr.length ("+data.chr.length+")")}data=d3panels.add_chrname_start_end(data);data=d3panels.reorgLodData(data);chartOpts.ylim=ylim!=null?ylim:[0,d3.max(data.lod)*1.05];myframe=d3panels.chrpanelframe(chartOpts);myframe(selection,{chr:data.chrname,start:data.chrstart,end:data.chrend});_svg=myframe.svg();_xscale=myframe.xscale();_yscale=myframe.yscale();chrSelect=myframe.chrSelect();self_chart={svg:function svg(){return _svg},xscale:function xscale(){return _xscale},yscale:function yscale(){return _yscale}};add2chart=d3panels.add_lodcurve(chartOpts);add2chart(self_chart,data);markerSelect=add2chart.markerSelect();markertip=add2chart.markertip();return myframe.box().raise()};chart.xscale=function(){return _xscale};chart.yscale=function(){return _yscale};chart.chrSelect=function(){return chrSelect};chart.markerSelect=function(){return markerSelect};chart.markertip=function(){return markertip};chart.svg=function(){return _svg};chart.remove=function(){_svg.remove();d3panels.tooltip_destroy(markertip);return null};return chart};"use strict";d3panels.add_lodcurve=function(chartOpts){var chart,g,horizontal,linecolor,linedash,linewidth,markerSelect,markertip,pointcolor,pointsize,pointstroke,ref,ref1,ref2,ref3,ref4,ref5,ref6,ref7,tipclass;if(chartOpts==null){chartOpts={}}linecolor=(ref=chartOpts!=null?chartOpts.linecolor:void 0)!=null?ref:"darkslateblue";linewidth=(ref1=chartOpts!=null?chartOpts.linewidth:void 0)!=null?ref1:2;linedash=(ref2=chartOpts!=null?chartOpts.linedash:void 0)!=null?ref2:"";pointcolor=(ref3=chartOpts!=null?chartOpts.pointcolor:void 0)!=null?ref3:"#e9cfec";pointsize=(ref4=chartOpts!=null?chartOpts.pointsize:void 0)!=null?ref4:0;pointstroke=(ref5=chartOpts!=null?chartOpts.pointstroke:void 0)!=null?ref5:"black";tipclass=(ref6=chartOpts!=null?chartOpts.tipclass:void 0)!=null?ref6:"tooltip";horizontal=(ref7=chartOpts!=null?chartOpts.horizontal:void 0)!=null?ref7:false;markerSelect=null;markertip=null;g=null;chart=function chart(prevchart,data){var bigpointsize,chr,curves,hiddenpoints,i,j,len,lodcurve,markerpoints,ref8,svg,xscale,yscale;if(data.chr==null){d3panels.displayError("add_lodcurve: data.chr is missing")}if(data.pos==null){d3panels.displayError("add_lodcurve: data.pos is missing")}if(data.lod==null){d3panels.displayError("add_lodcurve: data.lod is missing")}if(data.marker==null){d3panels.displayError("add_lodcurve: data.marker is missing")}if(data.pos.length!==data.chr.length){d3panels.displayError("add_lodcurve: data.pos.length ("+data.pos.length+") != data.chr.length ("+data.chr.length+")")}if(data.lod.length!==data.chr.length){d3panels.displayError("add_lodcurve: data.lod.length ("+data.lod.length+") != data.chr.length ("+data.chr.length+")")}if(data.marker==null){data.marker=[function(){var results;results=[];for(i in data.chr){results.push("")}return results}()]}if(data.marker.length!==data.chr.length){d3panels.displayError("add_lodcurve: data.marker.length ("+data.lod.length+") != data.chr.length ("+data.chr.length+")")}data=d3panels.add_chrname_start_end(data);if(!(data.posByChr!=null&&data.lodByChr!=null&&data.markerinfo!=null)){data=d3panels.reorgLodData(data)}svg=prevchart.svg();g=svg.append("g").attr("id","lod_curve");xscale=prevchart.xscale();yscale=prevchart.yscale();lodcurve=function lodcurve(chr){return d3.line().x(function(d,i){if(horizontal){return yscale(data.lodByChr[chr][i])}return xscale[chr](d)}).y(function(d,i){if(horizontal){return xscale[chr](d)}return yscale(data.lodByChr[chr][i])})};if(linewidth>0){curves=g.append("g").attr("id","curves");ref8=data.chrname;for(j=0,len=ref8.length;j<len;j++){chr=ref8[j];curves.append("path").datum(data.posByChr[chr]).attr("d",lodcurve(chr)).attr("stroke",linecolor).attr("fill","none").attr("stroke-width",linewidth).attr("stroke-dasharray",linedash).style("pointer-events","none")}}if(pointsize>0){markerpoints=g.append("g").attr("id","markerpoints_visible");markerpoints.selectAll("empty").data(data.markerinfo).enter().append("circle").attr("cx",function(d){if(horizontal){return yscale(d.lod)}return xscale[d.chr](d.pos)}).attr("cy",function(d){if(horizontal){return xscale[d.chr](d.pos)}return yscale(d.lod)}).attr("r",function(d){if(d.lod!=null){return pointsize}else{return null}}).attr("fill",pointcolor).attr("stroke",pointstroke).attr("pointer-events","hidden")}hiddenpoints=g.append("g").attr("id","markerpoints_hidden");bigpointsize=d3.max([2*pointsize,3]);markerSelect=hiddenpoints.selectAll("empty").data(data.markerinfo).enter().append("circle").attr("cx",function(d){if(horizontal){return yscale(d.lod)}return xscale[d.chr](d.pos)}).attr("cy",function(d){if(horizontal){return xscale[d.chr](d.pos)}return yscale(d.lod)}).attr("id",function(d){return d.name}).attr("r",function(d){if(d.lod!=null){return bigpointsize}else{return null}}).attr("opacity",0).attr("fill",pointcolor).attr("stroke",pointstroke).attr("stroke-width","1").on("mouseover",function(){return d3.select(this).attr("opacity",1)}).on("mouseout",function(){return d3.select(this).attr("opacity",0)});return markertip=d3panels.tooltip_create(d3.select("body"),markerSelect,{tipclass:tipclass},function(d,i){return[d.name," LOD = "+d3.format(".2f")(d.lod)]})};chart.markerSelect=function(){return markerSelect};chart.markertip=function(){return markertip};chart.remove=function(){g.remove();d3panels.tooltip_destroy(markertip);return null};return chart};"use strict";d3panels.add_curves=function(chartOpts){var chart,curveGroup,curves,indtip,linecolor,linecolorhilit,linewidth,linewidthhilit,ref,ref1,ref2,ref3,ref4,tipclass;if(chartOpts==null){chartOpts={}}linecolor=(ref=chartOpts!=null?chartOpts.linecolor:void 0)!=null?ref:null;linecolorhilit=(ref1=chartOpts!=null?chartOpts.linecolorhilit:void 0)!=null?ref1:null;linewidth=(ref2=chartOpts!=null?chartOpts.linewidth:void 0)!=null?ref2:2;linewidthhilit=(ref3=chartOpts!=null?chartOpts.linewidthhilit:void 0)!=null?ref3:2;tipclass=(ref4=chartOpts!=null?chartOpts.tipclass:void 0)!=null?ref4:"tooltip";curves=null;indtip=null;curveGroup=null;chart=function chart(prevchart,data){var curvefunc,dataByPoint,g,group,i,indID,j,k,n_ind,ngroup,ref5,ref6,ref7,svg,x,xscale,y,yscale;if(data.x==null){d3panels.displayError("add_curves: data.x is missing")}if(data.y==null){d3panels.displayError("add_curves: data.y is missing")}x=function(){var k,len,ref5,results;ref5=data.x;results=[];for(k=0,len=ref5.length;k<len;k++){x=ref5[k];results.push(d3panels.missing2null(x))}return results}();y=function(){var k,len,ref5,results;ref5=data.y;results=[];for(k=0,len=ref5.length;k<len;k++){y=ref5[k];results.push(d3panels.missing2null(y))}return results}();n_ind=y.length;if(x.length===1&&y.length>1){for(j=k=2,ref5=n_ind;2<=ref5?k<=ref5:k>=ref5;j=2<=ref5?++k:--k){x.push(x[0])}}if(x.length!==n_ind){d3panels.displayError("add_curves: data.x.length ("+x.length+") != data.y.length ("+n_ind+")")}indID=(ref6=data!=null?data.indID:void 0)!=null?ref6:function(){var results=[];for(var l=1;1<=n_ind?l<=n_ind:l>=n_ind;1<=n_ind?l++:l--){results.push(l)}return results}.apply(this);if(indID.length!==n_ind){d3panels.displayError("add_curves: data.indID.length ("+indID.length+") != data.y.length ("+n_ind+")")}group=(ref7=data!=null?data.group:void 0)!=null?ref7:function(){var results;results=[];for(i in y){results.push(1)}return results}();group=d3panels.expand2vector(group,n_ind);ngroup=d3.max(group);group=function(){var l,len,results;results=[];for(l=0,len=group.length;l<len;l++){g=group[l];results.push(g!=null?g-1:g)}return results}();if(d3panels.sumArray(function(){var l,len,results;results=[];for(l=0,len=group.length;l<len;l++){g=group[l];results.push(g<0||g>ngroup-1)}return results}())>0){d3panels.displayError("add_curves: group values out of range");console.log("distinct groups: "+d3panels.unique(group))}if(group.length!==n_ind){d3panels.displayError("add_curves: data.group.length ("+group.length+") != data.y.length ("+n_ind+")")}for(i in y){if(x[i].length!==y[i].length){d3panels.displayError("add_curves: length(x) ("+x[i].length+") != length(y) ("+y[i].length+") for individual "+indID[i]+" (index "+(i+1)+")")}}linecolor=linecolor!=null?linecolor:d3panels.selectGroupColors(ngroup,"pastel");linecolor=d3panels.expand2vector(linecolor,ngroup);linecolorhilit=linecolorhilit!=null?linecolorhilit:d3panels.selectGroupColors(ngroup,"dark");linecolorhilit=d3panels.expand2vector(linecolorhilit,ngroup);svg=prevchart.svg();xscale=prevchart.xscale();yscale=prevchart.yscale();dataByPoint=[];for(i in y){dataByPoint.push(function(){var results;results=[];for(j in y[i]){if(x[i][j]!=null&&y[i][j]!=null){results.push({x:x[i][j],y:y[i][j]})}}return results}())}curvefunc=d3.line().x(function(d){return xscale(d.x)}).y(function(d){return yscale(d.y)});curveGroup=svg.append("g").attr("id","curves");curves=curveGroup.selectAll("empty").data(d3.range(n_ind)).enter().append("path").datum(function(d){return dataByPoint[d]}).attr("d",curvefunc).attr("class",function(d,i){return"path"+i}).attr("fill","none").attr("stroke",function(d,i){return linecolor[group[i]]}).attr("stroke-width",linewidth).on("mouseover.panel",function(event,d){i=curves.nodes().indexOf(this);return d3.select(this).attr("stroke",linecolorhilit[group[i]]).attr("stroke-width",linewidthhilit).raise()}).on("mouseout.panel",function(event,d){var e;e=curves.nodes();i=e.indexOf(this);return d3.select(this).attr("stroke",linecolor[group[i]]).attr("stroke-width",linewidth)});indtip=d3panels.tooltip_create(d3.select("body"),curves,{tipclass:tipclass},function(d,i){return indID[i]});return prevchart.box().raise()};chart.curves=function(){return curves};chart.indtip=function(){return indtip};chart.remove=function(){curveGroup.remove();d3panels.tooltip_destroy(indtip);return null};return chart};"use strict";d3panels.add_points=function(chartOpts){var chart,indtip,jitter,pointGroup,pointcolor,points,pointsize,pointstroke,ref,ref1,ref2,ref3,ref4,tipclass;if(chartOpts==null){chartOpts={}}pointcolor=(ref=chartOpts!=null?chartOpts.pointcolor:void 0)!=null?ref:null;pointsize=(ref1=chartOpts!=null?chartOpts.pointsize:void 0)!=null?ref1:3;pointstroke=(ref2=chartOpts!=null?chartOpts.pointstroke:void 0)!=null?ref2:"black";jitter=(ref3=chartOpts!=null?chartOpts.jitter:void 0)!=null?ref3:"beeswarm";tipclass=(ref4=chartOpts!=null?chartOpts.tipclass:void 0)!=null?ref4:"tooltip";points=null;indtip=null;pointGroup=null;chart=function chart(prevchart,data){var force,g,group,i,indID,ngroup,ref5,ref6,ref7,scaledPoints,svg,ux,uy,x,xscale,xwid,y,yscale,ywid;if(data.x==null){d3panels.displayError("add_points: data.x is missing")}if(data.y==null){d3panels.displayError("add_points: data.y is missing")}x=d3panels.missing2null(data.x);y=d3panels.missing2null(data.y);if(x.length!==y.length){d3panels.displayError("add_points: x.length ("+x.length+") != y.length ("+y.length+")")}indID=(ref5=data!=null?data.indID:void 0)!=null?ref5:null;indID=indID!=null?indID:function(){var results=[];for(var j=1,ref6=x.length;1<=ref6?j<=ref6:j>=ref6;1<=ref6?j++:j--){results.push(j)}return results}.apply(this);if(indID.length!==x.length){d3panels.displayError("add_points: indID.length ("+indID.length+") != x.length ("+x.length+")")}group=(ref7=data!=null?data.group:void 0)!=null?ref7:function(){var j,len,results;results=[];for(j=0,len=x.length;j<len;j++){i=x[j];results.push(1)}return results}();group=d3panels.expand2vector(group,x.length);ngroup=d3.max(group);group=function(){var j,len,results;results=[];for(j=0,len=group.length;j<len;j++){g=group[j];results.push(g!=null?g-1:g)}return results}();if(d3panels.sumArray(function(){var j,len,results;results=[];for(j=0,len=group.length;j<len;j++){g=group[j];results.push(g<0||g>ngroup-1)}return results}())>0){d3panels.displayError("add_points: group values out of range");console.log("ngroup: "+ngroup);console.log("distinct groups: "+d3panels.unique(group))}if(group.length!==x.length){d3panels.displayError("add_points: group.length ("+group.length+") != x.length ("+x.length+")")}pointcolor=pointcolor!=null?pointcolor:d3panels.selectGroupColors(ngroup,"dark");pointcolor=d3panels.expand2vector(pointcolor,ngroup);if(pointcolor.length<ngroup){d3panels.displayError("add_points: pointcolor.length ("+pointcolor.length+") < ngroup ("+ngroup+")")}svg=prevchart.svg();xscale=prevchart.xscale();yscale=prevchart.yscale();pointGroup=svg.append("g").attr("id","points");points=pointGroup.selectAll("empty").data(d3.range(x.length)).enter().append("circle").attr("cx",function(d,i){return xscale(x[i])}).attr("cy",function(d,i){return yscale(y[i])}).attr("class",function(d,i){return"pt"+i}).attr("r",pointsize).attr("fill",function(d,i){return pointcolor[group[i]]}).attr("stroke",pointstroke).attr("stroke-width","1");indtip=d3panels.tooltip_create(d3.select("body"),points,{tipclass:tipclass},function(d,i){return indID[i]});if(prevchart.xNA()||prevchart.yNA()){if(jitter==="random"){xwid=20-pointsize-2;xwid=xwid<=2?2:xwid;ywid=20-pointsize-2;ywid=ywid<=2?2:ywid;ux=function(){var results;results=[];for(i in x){results.push((Math.random()-.5)*xwid)}return results}();uy=function(){var results;results=[];for(i in x){results.push((Math.random()-.5)*ywid)}return results}();points.attr("cx",function(d,i){if(x[i]!=null){return xscale(x[i])}return xscale(x[i])+ux[i]}).attr("cy",function(d,i){if(y[i]!=null){return yscale(y[i])}return yscale(y[i])+uy[i]})}else if(jitter==="beeswarm"){scaledPoints=function(){var results;results=[];for(i in x){results.push({x:xscale(x[i]),y:yscale(y[i]),xnull:x[i]==null,ynull:y[i]==null})}return results}();d3.range(scaledPoints.length).map(function(i){if(!scaledPoints[i].xnull){scaledPoints[i].fx=scaledPoints[i].x}if(!scaledPoints[i].ynull){return scaledPoints[i].fy=scaledPoints[i].y}});force=d3.forceSimulation(scaledPoints).force("x",d3.forceX(function(d){return d.x})).force("y",d3.forceY(function(d){return d.y})).force("collide",d3.forceCollide(pointsize*1.1)).stop();(function(){var results=[];for(var j=0;j<=30;j++){results.push(j)}return results}).apply(this).map(function(d){force.tick();return points.attr("cx",function(d,i){return scaledPoints[i].x}).attr("cy",function(d,i){return scaledPoints[i].y})})}else if(jitter!=="none"){d3panels.displayError('add_points: jitter should be "beeswarm", "random", or "none"')}}return prevchart.box().raise()};chart.points=function(){return points};chart.indtip=function(){return indtip};chart.remove=function(){pointGroup.remove();d3panels.tooltip_destroy(indtip);return null};return chart};"use strict";d3panels.lodheatmap=function(chartOpts){var cellSelect,cells,celltip,chart,chrGap,colors,equalCells,height,hilitcolor,horizontal,margin,nullcolor,ref,ref1,ref10,ref11,ref12,ref13,ref14,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,svg,tipclass,width,xlab,xscale,ylab,ylim,yscale,zlim,zscale,zthresh;if(chartOpts==null){chartOpts={}}width=(ref=chartOpts!=null?chartOpts.width:void 0)!=null?ref:800;height=(ref1=chartOpts!=null?chartOpts.height:void 0)!=null?ref1:500;margin=(ref2=chartOpts!=null?chartOpts.margin:void 0)!=null?ref2:{left:60,top:40,right:40,bottom:40};colors=(ref3=chartOpts!=null?chartOpts.colors:void 0)!=null?ref3:["slateblue","white","crimson"];nullcolor=(ref4=chartOpts!=null?chartOpts.nullcolor:void 0)!=null?ref4:"#e6e6e6";xlab=(ref5=chartOpts!=null?chartOpts.xlab:void 0)!=null?ref5:null;ylab=(ref6=chartOpts!=null?chartOpts.ylab:void 0)!=null?ref6:"";ylim=(ref7=chartOpts!=null?chartOpts.ylim:void 0)!=null?ref7:null;zlim=(ref8=chartOpts!=null?chartOpts.zlim:void 0)!=null?ref8:null;zthresh=(ref9=chartOpts!=null?chartOpts.zthresh:void 0)!=null?ref9:null;horizontal=(ref10=chartOpts!=null?chartOpts.horizontal:void 0)!=null?ref10:false;hilitcolor=(ref11=chartOpts!=null?chartOpts.hilitcolor:void 0)!=null?ref11:"black";chrGap=(ref12=chartOpts!=null?chartOpts.chrGap:void 0)!=null?ref12:6;equalCells=(ref13=chartOpts!=null?chartOpts.equalCells:void 0)!=null?ref13:false;tipclass=(ref14=chartOpts!=null?chartOpts.tipclass:void 0)!=null?ref14:"tooltip";xscale=null;yscale=null;zscale=null;cells=null;celltip=null;svg=null;cellSelect=null;chart=function chart(selection,data){var cellg,celltipfunc,chr,direction,i,j,k,l,len,len1,len2,len3,len4,lod,m,myframe,n,n_lod,n_pos,o,pos,ref15,ref16,ref17,ref18,ref19,x,xmid_scaled,y,ylabels,ymid,ymid_scaled,yv,zmax,zmin;margin=d3panels.check_listarg_v_default(margin,{left:60,top:40,right:40,bottom:40});if(data.chr==null){d3panels.displayError("lodheatmap: data.chr is missing")}if(data.pos==null){d3panels.displayError("lodheatmap: data.pos is missing")}if(data.lod==null){d3panels.displayError("lodheatmap: data.lod is missing")}if(data.ycat!=null){data.y=function(){var results;results=[];for(i in data.ycat){results.push(i+1)}return results}()}if(data.y==null){data.ycat=function(){var results;results=[];for(i in data.lod[0]){results.push(i+1)}return results}();data.y=function(){var results;results=[];for(i in data.lod[0]){results.push(i+1)}return results}()}data.y=function(){var k,len,ref15,results;ref15=data.y;results=[];for(k=0,len=ref15.length;k<len;k++){yv=ref15[k];results.push(+yv)}return results}();n_pos=data.chr.length;n_lod=data.y.length;if(n_pos!==data.pos.length){d3panels.displayError("lodheatmap: data.pos.length ("+data.pos.length+") != data.chr.length ("+n_pos+")")}if(n_pos!==data.lod.length){d3panels.displayError("lodheatmap: data.lod.length ("+data.lod.length+") != data.chr.length ("+n_pos+")")}for(i in data.lod){if(data.lod[i].length!==data.y.length){d3panels.displayError("lodheatmap: data.lod["+i+"].length ("+data.lod[i].length+") != data.y.length ("+n_lod+")")}}if(data.poslabel!=null){if(data.poslabel.length!==n_pos){d3panels.displayError("lodheatmap: data.poslabel.length ("+data.poslabel.length+") != data.chr.length ("+n_pos+")")}}else{data.poslabel=function(){var results;results=[];for(i in data.chr){results.push(data.chr[i]+"@"+d3panels.formatAxis(data.pos)(data.pos[i]))}return results}()}if(data.chrname==null){data.chrname=d3panels.unique(data.chr)}data.chrname=d3panels.forceAsArray(data.chrname);if(equalCells){data.pos=[];ref15=data.chrname;for(k=0,len=ref15.length;k<len;k++){chr=ref15[k];data.pos=data.pos.concat(function(){var results;results=[];for(i in data.chr){if(data.chr[i]===chr){results.push(+i)}}return results}())}}data=d3panels.add_chrname_start_end(data);if(equalCells){chrGap=(width-margin.left-margin.right-2*data.chrname.length)/data.chr.length+2}data=d3panels.reorgLodData(data);ymid=d3panels.calc_midpoints(d3panels.pad_vector(data.y));chartOpts.ylim=ylim!=null?ylim:d3.extent(ymid);chartOpts.horizontal=horizontal;chartOpts.xlab=xlab;chartOpts.ylab=ylab;chartOpts.chrGap=chrGap;chartOpts.width=width;chartOpts.height=height;chartOpts.margin=margin;if(data.ycat!=null){chartOpts.yticks=data.y;chartOpts.yticklab=data.ycat}myframe=d3panels.chrpanelframe(chartOpts);myframe(selection,{chr:data.chrname,start:data.chrstart,end:data.chrend});svg=myframe.svg();xscale=myframe.xscale();yscale=myframe.yscale();ylabels=myframe.ylabels();ymid_scaled=function(){var l,len1,results;results=[];for(l=0,len1=ymid.length;l<len1;l++){y=ymid[l];results.push(yscale(y))}return results}();xmid_scaled={};ref16=data.chrname;for(l=0,len1=ref16.length;l<len1;l++){chr=ref16[l];xmid_scaled[chr]=d3panels.calc_midpoints(d3panels.pad_vector(function(){var len2,m,ref17,results;ref17=data.posByChr[chr];results=[];for(m=0,len2=ref17.length;m<len2;m++){x=ref17[m];results.push(xscale[chr](x))}return results}(),(chrGap-2)/2))}zmin=d3panels.matrixMin(data.lod);zmax=d3panels.matrixMaxAbs(data.lod);zlim=zlim!=null?zlim:[-zmax,0,zmax];if(zlim.length!==colors.length){d3panels.displayError("lodheatmap: zlim.length ("+zlim.length+") != colors.length ("+colors.length+")")}zscale=d3.scaleLinear().domain(zlim).range(colors);zthresh=zthresh!=null?zthresh:zmin-1;cells=[];ref17=data.chrname;for(m=0,len2=ref17.length;m<len2;m++){chr=ref17[m];ref18=data.posByChr[chr];for(i=n=0,len3=ref18.length;n<len3;i=++n){pos=ref18[i];ref19=data.lodByChr[chr][i];for(j=o=0,len4=ref19.length;o<len4;j=++o){lod=ref19[j];if(Math.abs(lod)>=zthresh){cells.push({lod:lod,chr:chr,pos:pos,poslabel:data.poslabelByChr[chr][i],posindex:+i,lodindex:+j})}}}}d3panels.calc_chrcell_rect(cells,xmid_scaled,ymid_scaled);cellg=svg.append("g").attr("id","cells");cellSelect=cellg.selectAll("empty").data(cells).enter().append("rect").attr("x",function(d){if(horizontal){return d.top}return d.left}).attr("y",function(d){if(horizontal){return d.left}return d.top}).attr("width",function(d){if(horizontal){return d.height}return d.width}).attr("height",function(d){if(horizontal){return d.width}return d.height}).attr("class",function(d,i){return"cell"+i}).attr("fill",function(d){if(d.lod!=null){return zscale(d.lod)}else{return nullcolor}}).attr("stroke","none").attr("stroke-width","1").attr("shape-rendering","crispEdges").on("mouseover",function(event,d){d3.select(this).attr("stroke",hilitcolor).raise();if(data.ycat!=null){return svg.select("text#ylab"+d.lodindex).attr("opacity",1)}}).on("mouseout",function(event,d){d3.select(this).attr("stroke","none");if(data.ycat!=null){return svg.select("text#ylab"+d.lodindex).attr("opacity",0)}});if(data.ycat!=null){svg.selectAll("g#ylines").remove();ylabels.attr("opacity",0).attr("id",function(d,i){return"ylab"+i})}celltipfunc=function celltipfunc(d){var lodlabel,z;z=d3.format(".2f")(Math.abs(d.lod));lodlabel=data.ycat!=null?data.ycat[d.lodindex]:d3panels.formatAxis(data.y)(data.y[d.lodindex]);if(horizontal){return lodlabel+", "+d.poslabel+" &rarr; "+z}return d.poslabel+", "+lodlabel+" &rarr; "+z};direction=horizontal?"north":"east";celltip=d3panels.tooltip_create(d3.select("body"),cellg.selectAll("rect"),{direction:direction,tipclass:tipclass},celltipfunc);return myframe.box().raise()};chart.xscale=function(){return xscale};chart.yscale=function(){return yscale};chart.zscale=function(){return yscale};chart.cells=function(){return cellSelect};chart.celltip=function(){return celltip};chart.svg=function(){return svg};chart.remove=function(){svg.remove();d3panels.tooltip_destroy(celltip);return null};return chart};"use strict";d3panels.mapchart=function(chartOpts){var chart,horizontal,linecolor,linecolorhilit,linewidth,markerSelect,martip,ref,ref1,ref10,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,shiftStart,svg,tickwidth,tipclass,v_over_h,xlab,xlineOpts,xscale,ylab,yscale;if(chartOpts==null){chartOpts={}}tickwidth=(ref=chartOpts!=null?chartOpts.tickwidth:void 0)!=null?ref:10;linecolor=(ref1=chartOpts!=null?chartOpts.linecolor:void 0)!=null?ref1:"slateblue";linecolorhilit=(ref2=chartOpts!=null?chartOpts.linecolorhilit:void 0)!=null?ref2:"Orchid";linewidth=(ref3=chartOpts!=null?chartOpts.linewidth:void 0)!=null?ref3:3;xlab=(ref4=chartOpts!=null?chartOpts.xlab:void 0)!=null?ref4:"Chromosome";ylab=(ref5=chartOpts!=null?chartOpts.ylab:void 0)!=null?ref5:"Position (cM)";xlineOpts=(ref6=chartOpts!=null?chartOpts.xlineOpts:void 0)!=null?ref6:{color:"#cdcdcd",width:5};horizontal=(ref7=chartOpts!=null?chartOpts.horizontal:void 0)!=null?ref7:false;v_over_h=(ref8=chartOpts!=null?chartOpts.v_over_h:void 0)!=null?ref8:horizontal;shiftStart=(ref9=chartOpts!=null?chartOpts.shiftStart:void 0)!=null?ref9:false;tipclass=(ref10=chartOpts!=null?chartOpts.tipclass:void 0)!=null?ref10:"tooltip";xscale=null;yscale=null;markerSelect=null;martip=null;svg=null;chart=function chart(selection,data){var chr,chrscale,direction,extentByChr,i,j,k,l,len,len1,markerpos,markers,minpos,myframe,n_chr,n_pos,pos,ref11,ref12,these_index,these_pos,tipfunc,x,xlim,xticklab,xticks,ylim;xlineOpts=d3panels.check_listarg_v_default(xlineOpts,{color:"#cdcdcd",width:5});if(data.chr==null){d3panels.displayError("mapchart: data.chr is missing")}if(data.pos==null){d3panels.displayError("mapchart: data.pos is missing")}if(data.marker==null){d3panels.displayError("mapchart: data.marker is missing")}n_pos=data.pos.length;if(data.chr.length!==n_pos){d3panels.displayError("mapchart: data.chr.length ("+data.chr.length+") != data.pos.length ("+n_pos+")")}if(data.marker.length!==n_pos){d3panels.displayError("mapchart: data.marker.length ("+data.marker.length+") != data.pos.length ("+n_pos+")")}if(data.chrname==null){data.chrname=d3panels.unique(data.chr)}data.chrname=d3panels.forceAsArray(data.chrname);data.adjpos=data.pos.slice(0);if(shiftStart){ref11=data.chrname;for(k=0,len=ref11.length;k<len;k++){chr=ref11[k];these_pos=function(){var results;results=[];for(i in data.pos){if(data.chr[i]===chr){results.push(data.pos[i])}}return results}();these_index=function(){var results;results=[];for(i in data.pos){if(data.chr[i]===chr){results.push(i)}}return results}();minpos=d3.min(these_pos);these_pos=function(){var l,len1,results;results=[];for(l=0,len1=these_pos.length;l<len1;l++){x=these_pos[l];results.push(x-minpos)}return results}();for(j in these_pos){data.adjpos[these_index[j]]=these_pos[j]}}}extentByChr={};ref12=data.chrname;for(l=0,len1=ref12.length;l<len1;l++){chr=ref12[l];pos=function(){var results;results=[];for(i in data.adjpos){if(data.chr[i]===chr){results.push(data.adjpos[i])}}return results}();extentByChr[chr]=d3.extent(pos)}ylim=ylim!=null?ylim:d3.extent(data.adjpos);n_chr=data.chrname.length;xlim=[.5,n_chr+.5];xticks=function(){var len2,m,ref13,results;ref13=d3.range(n_chr);results=[];for(m=0,len2=ref13.length;m<len2;m++){i=ref13[m];results.push(i+1)}return results}();xticklab=data.chrname;chartOpts.xNA=false;chartOpts.yNA=false;if(horizontal){chartOpts.xlim=ylim;chartOpts.ylim=xlim.reverse();chartOpts.xlineOpts=chartOpts.ylineOpts;chartOpts.ylineOpts=xlineOpts;chartOpts.xlab=ylab;chartOpts.ylab=xlab;chartOpts.xticks=chartOpts.yticks;chartOpts.yticks=xticks;chartOpts.nxticks=chartOpts.nyticks;chartOpts.xticklab=chartOpts.yticklab;chartOpts.yticklab=xticklab;chartOpts.v_over_h=v_over_h}else{chartOpts.xlim=xlim;chartOpts.ylim=ylim.reverse();chartOpts.xlineOpts=xlineOpts;chartOpts.xlab=xlab;chartOpts.ylab=ylab;chartOpts.xticks=xticks;chartOpts.xticklab=xticklab;chartOpts.v_over_h=v_over_h}myframe=d3panels.panelframe(chartOpts);myframe(selection);svg=myframe.svg();xscale=myframe.xscale();yscale=myframe.yscale();chrscale=function chrscale(chr){var chrpos;chrpos=data.chrname.indexOf(chr)+1;if(!horizontal){return xscale(chrpos)}return yscale(chrpos)};svg.append("g").attr("id","chromosomes").selectAll("empty").data(data.chrname).enter().append("line").attr("x1",function(d){if(horizontal){return xscale(extentByChr[d][0])}return chrscale(d)}).attr("x2",function(d){if(horizontal){return xscale(extentByChr[d][1])}return chrscale(d)}).attr("y1",function(d){if(horizontal){return chrscale(d)}return yscale(extentByChr[d][0])}).attr("y2",function(d){if(horizontal){return chrscale(d)}return yscale(extentByChr[d][1])}).attr("fill","none").attr("stroke",linecolor).attr("stroke-width",linewidth).attr("shape-rendering","crispEdges").style("pointer-events","none");markerpos={};for(i in data.marker){markerpos[data.marker[i]]=d3.format(".1f")(data.pos[i])}markers=svg.append("g").attr("id","points");markerSelect=markers.selectAll("empty").data(data.marker).enter().append("line").attr("x1",function(d,i){if(horizontal){return xscale(data.adjpos[i])}return chrscale(data.chr[i])-tickwidth}).attr("x2",function(d,i){if(horizontal){return xscale(data.adjpos[i])}return chrscale(data.chr[i])+tickwidth}).attr("y1",function(d,i){if(horizontal){return chrscale(data.chr[i])-tickwidth}return yscale(data.adjpos[i])}).attr("y2",function(d,i){if(horizontal){return chrscale(data.chr[i])+tickwidth}return yscale(data.adjpos[i])}).attr("id",function(d){return d}).attr("fill","none").attr("stroke",linecolor).attr("stroke-width",linewidth).attr("shape-rendering","crispEdges").on("mouseover.paneltip",function(){return d3.select(this).attr("stroke",linecolorhilit)}).on("mouseout.paneltip",function(){return d3.select(this).attr("stroke",linecolor)});tipfunc=function tipfunc(d,i){return d+" ("+markerpos[d]+")"};direction=horizontal?"north":"east";martip=d3panels.tooltip_create(d3.select("body"),markers.selectAll("line"),{direction:direction,tipclass:tipclass},tipfunc);return myframe.box().raise()};chart.xscale=function(){return xscale};chart.yscale=function(){return yscale};chart.markerSelect=function(){return markerSelect};chart.martip=function(){return martip};chart.svg=function(){return svg};chart.remove=function(){svg.remove();d3panels.tooltip_destroy(martip);return null};return chart};"use strict";d3panels.scatterplot=function(chartOpts){var chart,indtip,jitter,pointcolor,points,pointsize,pointstroke,ref,ref1,ref10,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,svg,tipclass,xNA,xNA_size,xlim,xscale,yNA,yNA_size,ylim,yscale;if(chartOpts==null){chartOpts={}}xNA=(ref=chartOpts!=null?chartOpts.xNA:void 0)!=null?ref:{handle:true,force:false};yNA=(ref1=chartOpts!=null?chartOpts.yNA:void 0)!=null?ref1:{handle:true,force:false};xNA_size=(ref2=chartOpts!=null?chartOpts.xNA_size:void 0)!=null?ref2:{width:20,gap:10};yNA_size=(ref3=chartOpts!=null?chartOpts.yNA_size:void 0)!=null?ref3:{width:20,gap:10};xlim=(ref4=chartOpts!=null?chartOpts.xlim:void 0)!=null?ref4:null;ylim=(ref5=chartOpts!=null?chartOpts.ylim:void 0)!=null?ref5:null;pointcolor=(ref6=chartOpts!=null?chartOpts.pointcolor:void 0)!=null?ref6:null;pointstroke=(ref7=chartOpts!=null?chartOpts.pointstroke:void 0)!=null?ref7:"black";pointsize=(ref8=chartOpts!=null?chartOpts.pointsize:void 0)!=null?ref8:3;jitter=(ref9=chartOpts!=null?chartOpts.jitter:void 0)!=null?ref9:"beeswarm";tipclass=(ref10=chartOpts!=null?chartOpts.tipclass:void 0)!=null?ref10:"tooltip";xscale=null;yscale=null;xNA=xNA;yNA=yNA;points=null;indtip=null;svg=null;chart=function chart(selection,data){var addpts,myframe,x,y;xNA=d3panels.check_listarg_v_default(xNA,{handle:true,force:false});yNA=d3panels.check_listarg_v_default(yNA,{handle:true,force:false});xNA_size=d3panels.check_listarg_v_default(xNA,{width:20,gap:10});yNA_size=d3panels.check_listarg_v_default(yNA,{width:20,gap:10});if(data.x==null){d3panels.displayError("scatterplot: data.x is missing")}if(data.y==null){d3panels.displayError("scatterplot: data.y is missing")}x=d3panels.missing2null(data.x);y=d3panels.missing2null(data.y);if(x.length!==y.length){d3panels.displayError("scatterplot: x.length ("+x.length+") != y.length ("+y.length+")")}xNA.handle=xNA.force||xNA.handle&&!x.every(function(v){return v!=null});yNA.handle=yNA.force||yNA.handle&&!y.every(function(v){return v!=null});xlim=xlim!=null?xlim:d3panels.pad_ylim(d3.extent(x));ylim=ylim!=null?ylim:d3panels.pad_ylim(d3.extent(y));chartOpts.xlim=xlim;chartOpts.ylim=ylim;chartOpts.xNA=xNA.handle;chartOpts.yNA=yNA.handle;chartOpts.xNA_size=xNA_size;chartOpts.yNA_size=yNA_size;myframe=d3panels.panelframe(chartOpts);myframe(selection);svg=myframe.svg();xscale=myframe.xscale();yscale=myframe.yscale();addpts=d3panels.add_points({pointcolor:pointcolor,pointstroke:pointstroke,pointsize:pointsize,jitter:jitter,tipclass:tipclass});addpts(myframe,{x:x,y:y,indID:data.indID,group:data.group});points=addpts.points();return indtip=addpts.indtip()};chart.xscale=function(){return xscale};chart.yscale=function(){return yscale};chart.xNA=function(){return xNA.handle};chart.yNA=function(){return yNA.handle};chart.points=function(){return points};chart.indtip=function(){return indtip};chart.svg=function(){return svg};chart.remove=function(){svg.remove();d3panels.tooltip_destroy(indtip);return null};return chart};"use strict";d3panels.trichart=function(chartOpts){var boxcolor,boxwidth,chart,gridcolor,gridlines,gridwidth,height,indtip,labelpos,labels,margin,pointcolor,points,pointsize,pointstroke,pscale,rectcolor,ref,ref1,ref10,ref11,ref12,ref13,ref14,ref15,ref16,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,svg,tipclass,title,titlepos,width,xscale,yscale;if(chartOpts==null){chartOpts={}}width=(ref=chartOpts!=null?chartOpts.width:void 0)!=null?ref:600;height=(ref1=chartOpts!=null?chartOpts.height:void 0)!=null?ref1:520;margin=(ref2=chartOpts!=null?chartOpts.margin:void 0)!=null?ref2:{left:60,top:40,right:60,bottom:10};labelpos=(ref3=chartOpts!=null?chartOpts.labelpos:void 0)!=null?ref3:10;titlepos=(ref4=chartOpts!=null?chartOpts.titlepos:void 0)!=null?ref4:20;title=(ref5=chartOpts!=null?chartOpts.title:void 0)!=null?ref5:"";labels=(ref6=chartOpts!=null?chartOpts.labels:void 0)!=null?ref6:["(1,0,0)","(0,1,0)","(0,0,1)"];rectcolor=(ref7=chartOpts!=null?chartOpts.rectcolor:void 0)!=null?ref7:"#e6e6e6";boxcolor=(ref8=chartOpts!=null?chartOpts.boxcolor:void 0)!=null?ref8:"black";boxwidth=(ref9=chartOpts!=null?chartOpts.boxwidth:void 0)!=null?ref9:2;pointcolor=(ref10=chartOpts!=null?chartOpts.pointcolor:void 0)!=null?ref10:null;pointstroke=(ref11=chartOpts!=null?chartOpts.pointstroke:void 0)!=null?ref11:"black";pointsize=(ref12=chartOpts!=null?chartOpts.pointsize:void 0)!=null?ref12:3;gridlines=(ref13=chartOpts!=null?chartOpts.gridlines:void 0)!=null?ref13:0;gridcolor=(ref14=chartOpts!=null?chartOpts.gridcolor:void 0)!=null?ref14:"white";gridwidth=(ref15=chartOpts!=null?chartOpts.gridwidth:void 0)!=null?ref15:1;tipclass=(ref16=chartOpts!=null?chartOpts.tipclass:void 0)!=null?ref16:"tooltip";xscale=null;yscale=null;pscale=null;points=null;indtip=null;svg=null;chart=function chart(selection,data){var d,first,flag_length_not_3,flag_out_of_range,flag_sum_not_1,frame,framefunc,g,gr,group,i,indID,indices,j,len,n,ngroup,p,p1,p2,p3,p4,plot_height,plot_width,ref17,ref18,second,sum,v,vertices,vv,xlim,xy,ylim;margin=d3panels.check_listarg_v_default(margin,{left:60,top:40,right:60,bottom:10});if(data.p==null){d3panels.displayError("trichart: data.p is missing")}p=function(){var j,len,ref17,results;ref17=data.p;results=[];for(j=0,len=ref17.length;j<len;j++){v=ref17[j];results.push(d3panels.missing2null(v))}return results}();flag_length_not_3=false;flag_sum_not_1=false;flag_out_of_range=false;for(j=0,len=p.length;j<len;j++){v=p[j];if(v.length!==3){flag_length_not_3=true}sum=d3panels.sumArray(v);if(d3panels.abs(sum-1)>1e-6){flag_sum_not_1}if(d3panels.sumArray(function(){var k,len1,results;results=[];for(k=0,len1=v.length;k<len1;k++){vv=v[k];results.push(vv<0||vv>1)}return results}())>0){flag_out_of_range=true}}if(flag_length_not_3){d3panels.displayError("trichart: points not all of length 3")}if(flag_sum_not_1){d3panels.displayError("trichart: points not all summing to 1")}if(flag_out_of_range){d3panels.displayError("trichart: points not all in [0,1]")}n=p.length;indID=(ref17=data!=null?data.indID:void 0)!=null?ref17:function(){var results;results=[];for(i in p){results.push(+i+1)}return results}();if(indID.length!==n){d3panels.displayError("trichart: data.indID.length ("+indID.length+") != data.p.length ("+n+")")}group=(ref18=data!=null?data.group:void 0)!=null?ref18:function(){var results;results=[];for(i in p){results.push(1)}return results}();group=d3panels.expand2vector(group,n);ngroup=d3.max(group);group=function(){var k,len1,results;results=[];for(k=0,len1=group.length;k<len1;k++){g=group[k];results.push(g!=null?g-1:g)}return results}();if(d3panels.sumArray(function(){var k,len1,results;results=[];for(k=0,len1=group.length;k<len1;k++){g=group[k];results.push(g<0||g>ngroup-1)}return results}())>0){d3panels.displayError("add_points: group values out of range");console.log("ngroup: "+ngroup);console.log("distinct groups: "+d3panels.unique(group))}if(group.length!==n){d3panels.displayError("trichart: data.group.length ("+group.length+") != data.p.length ("+n+")")}pointcolor=pointcolor!=null?pointcolor:d3panels.selectGroupColors(ngroup,"dark");pointcolor=d3panels.expand2vector(pointcolor,ngroup);if(pointcolor.length<ngroup){d3panels.displayError("add_points: pointcolor.length ("+pointcolor.length+") < ngroup ("+ngroup+")")}xlim=[0,2/Math.sqrt(3)];ylim=[0,1];plot_height=height-margin.top-margin.bottom;plot_width=width-margin.left-margin.right;if(plot_height>plot_width/xlim[1]){d=plot_height-plot_width/xlim[1];margin.top+=d/2;margin.bottom+=d/2;plot_height-=d}else{d=plot_width-plot_height*xlim[1];margin.left+=d/2;margin.right+=d/2;plot_width-=d}xscale=d3.scaleLinear().domain(xlim).range([margin.left,margin.left+plot_width]);yscale=d3.scaleLinear().domain(ylim).range([plot_height+margin.top,margin.top]);pscale=function pscale(p){sum=d3panels.sumArray(p);return{x:xscale((p[0]*2+p[1])/Math.sqrt(3)/sum),y:yscale(p[1]/sum)}};xy=function(){var k,len1,results;results=[];for(k=0,len1=p.length;k<len1;k++){v=p[k];results.push({x:(v[0]*2+v[1])/Math.sqrt(3),y:v[1]})}return results}();svg=selection.append("svg");svg.attr("width",width).attr("height",height).attr("class","d3panels");frame=svg.append("g").attr("id","frame");vertices=[{x:xlim[0],y:ylim[0]},{x:xlim[1]/2,y:ylim[1]},{x:xlim[1],y:ylim[0]}];framefunc=d3.line().x(function(d){return xscale(vertices[d].x)}).y(function(d){return yscale(vertices[d].y)});indices=function(){var results;results=[];for(i in vertices){results.push(+i)}return results}().concat(0);frame.append("path").datum(indices).attr("d",framefunc).attr("fill",rectcolor).attr("stroke",boxcolor).attr("stroke-width",boxwidth);if(gridlines>0){gr=function(){var results=[];for(var k=1;1<=gridlines?k<=gridlines:k>=gridlines;1<=gridlines?k++:k--){results.push(k)}return results}.apply(this).map(function(i){return i/(gridlines+1)});p1=gr.map(function(x){return[x,0,1-x]});p2=gr.map(function(x){return[x,1-x,0]});p3=gr.map(function(x){return[0,1-x,x]});p4=gr.map(function(x){return[1-x,0,x]});first=p1.concat(p2).concat(p3);second=p2.concat(p3).concat(p4);g=frame.append("g").attr("class","gridlines").selectAll("empty").data(first).enter().append("line").attr("x1",function(d){return pscale(d).x}).attr("y1",function(d){return pscale(d).y}).attr("x2",function(d,i){return pscale(second[i]).x}).attr("y2",function(d,i){return pscale(second[i]).y}).attr("stroke",gridcolor).attr("stroke-width",gridwidth).attr("shape-rendering","crispEdges").style("pointer-events","none").attr("fill","none");frame.append("path").datum(indices).attr("d",framefunc).attr("fill","none").attr("stroke",boxcolor).attr("stroke-width",boxwidth)}frame.append("g").attr("class","title").append("text").text(title).attr("x",plot_width/2+margin.left).attr("y",margin.top-titlepos);frame.append("g").attr("id","labels").selectAll("empty").data(vertices).enter().append("text").attr("x",function(d,i){return xscale(d.x)+[-1,+1,+1][i]*labelpos}).attr("y",function(d){return yscale(d.y)}).style("dominant-baseline","middle").style("text-anchor",function(d,i){return["end","start","start"][i]}).text(function(d,i){return labels[i]});points=svg.append("g").attr("id","points").selectAll("empty").data(p).enter().append("circle").attr("r",pointsize).attr("cx",function(d){return pscale(d).x}).attr("cy",function(d){return pscale(d).y}).attr("fill",function(d,i){return pointcolor[group[i]]}).attr("stroke",pointstroke).attr("stroke-width",1);return indtip=d3panels.tooltip_create(d3.select("body"),points,{tipclass:tipclass},function(d,i){return indID[i]})};chart.xscale=function(){return xscale};chart.yscale=function(){return yscale};chart.pscale=function(){return pscale};chart.points=function(){return points};chart.indtip=function(){return indtip};chart.svg=function(){return svg};chart.remove=function(){svg.remove();d3panels.tooltip_destroy(indtip);return null};return chart};"use strict";d3panels.histchart=function(chartOpts){var chart,curves,density,indtip,linecolor,linecolorhilit,linewidth,linewidthhilit,ref,ref1,ref10,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,rotate_ylab,svg,tipclass,xlab,xlim,xscale,ylab,ylim,yscale;if(chartOpts==null){chartOpts={}}xlim=(ref=chartOpts!=null?chartOpts.xlim:void 0)!=null?ref:null;ylim=(ref1=chartOpts!=null?chartOpts.ylim:void 0)!=null?ref1:null;xlab=(ref2=chartOpts!=null?chartOpts.xlab:void 0)!=null?ref2:"";ylab=(ref3=chartOpts!=null?chartOpts.ylab:void 0)!=null?ref3:"";rotate_ylab=(ref4=chartOpts!=null?chartOpts.rotate_ylab:void 0)!=null?ref4:null;linecolor=(ref5=chartOpts!=null?chartOpts.linecolor:void 0)!=null?ref5:null;linecolorhilit=(ref6=chartOpts!=null?chartOpts.linecolorhilit:void 0)!=null?ref6:null;linewidth=(ref7=chartOpts!=null?chartOpts.linewidth:void 0)!=null?ref7:2;linewidthhilit=(ref8=chartOpts!=null?chartOpts.linewidthhilit:void 0)!=null?ref8:2;density=(ref9=chartOpts!=null?chartOpts.density:void 0)!=null?ref9:true;tipclass=(ref10=chartOpts!=null?chartOpts.tipclass:void 0)!=null?ref10:"tooltip";xscale=null;yscale=null;curves=null;indtip=null;svg=null;chart=function chart(selection,data){var add_curves,breaks,brlim,d,f,freq,i,j,k,l,len,len1,maxn,maxpos,myframe,n_ind,p,path_data,path_x,path_y,pt,ref11,x,xv,xx;if(data.x==null){d3panels.displayError("histchart: data.x is missing")}x=data.x;data.group=function(){var results;results=[];for(i in x){results.push(+i+1)}return results}();n_ind=x.length;if(data.breaks==null){maxn=d3.max(function(){var k,len,results;results=[];for(k=0,len=x.length;k<len;k++){xv=x[k];results.push(xv.length)}return results}());data.breaks=[2*Math.ceil(Math.sqrt(maxn)+1)]}breaks=d3panels.forceAsArray(data.breaks);xlim=xlim!=null?xlim:d3panels.matrixExtent(x);if(breaks.length===1){breaks=d3panels.calc_breaks(breaks[0],xlim[0],xlim[1])}brlim=[d3.min(breaks)-1e-6,d3.max(breaks)+1e-6];x=function(){var k,len,results;results=[];for(k=0,len=x.length;k<len;k++){xx=x[k];results.push(function(){var l,len1,results1;results1=[];for(l=0,len1=xx.length;l<len1;l++){xv=xx[l];if(xv>=brlim[0]&xv<=brlim[1]){results1.push(xv)}}return results1}())}return results}();freq=function(){var k,len,results;results=[];for(k=0,len=x.length;k<len;k++){xv=x[k];results.push(d3panels.calc_freq(xv,breaks,!density))}return results}();maxpos=[];for(k=0,len=freq.length;k<len;k++){f=freq[k];pt={x:breaks[1],y:f[0]};ref11=d3.range(f.length);for(l=0,len1=ref11.length;l<len1;l++){j=ref11[l];if(f[j]>pt.y){pt.y=f[j];pt.x=breaks[j+1]}}maxpos.push(pt)}ylim=ylim!=null?ylim:[0,d3panels.matrixMax(freq)*1.05];chartOpts.xlim=xlim;chartOpts.ylim=ylim;chartOpts.xNA=false;chartOpts.yNA=false;chartOpts.xlab=xlab;chartOpts.ylab=ylab;chartOpts.rotate_ylab=rotate_ylab;myframe=d3panels.panelframe(chartOpts);myframe(selection);svg=myframe.svg();xscale=myframe.xscale();yscale=myframe.yscale();path_data=function(){var len2,m,results;results=[];for(m=0,len2=freq.length;m<len2;m++){f=freq[m];results.push(d3panels.calc_hist_path(f,breaks))}return results}();path_x=function(){var len2,m,results;results=[];for(m=0,len2=path_data.length;m<len2;m++){p=path_data[m];results.push(function(){var len3,n,results1;results1=[];for(n=0,len3=p.length;n<len3;n++){d=p[n];results1.push(d.x)}return results1}())}return results}();path_y=function(){var len2,m,results;results=[];for(m=0,len2=path_data.length;m<len2;m++){p=path_data[m];results.push(function(){var len3,n,results1;results1=[];for(n=0,len3=p.length;n<len3;n++){d=p[n];results1.push(d.y)}return results1}())}return results}();add_curves=d3panels.add_curves({linecolor:linecolor,linecolorhilit:linecolorhilit,linewidth:linewidth,linewidthhilit:linewidthhilit,tipclass:tipclass});add_curves(myframe,{x:path_x,y:path_y,indID:data.indID,group:data.group});curves=add_curves.curves();indtip=add_curves.indtip();return myframe.box().raise()};chart.xscale=function(){return xscale};chart.yscale=function(){return yscale};chart.curves=function(){return curves};chart.indtip=function(){return indtip};chart.svg=function(){return svg};chart.remove=function(){svg.remove();d3panels.tooltip_dstroy(indtip);return null};return chart};"use strict";d3panels.slider=function(chartOpts){var buttoncolor,buttondotcolor,buttondotsize,buttonround,buttonsize,buttonstroke,_chart,height,margin,nticks,rectcolor,rectheight,ref,ref1,ref10,ref11,ref12,ref13,ref14,ref15,ref16,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,slider_svg,stopindex,textsize,tickgap,tickheight,ticks,ticks_at_stops,value,width;if(chartOpts==null){chartOpts={}}width=(ref=chartOpts!=null?chartOpts.width:void 0)!=null?ref:800;height=(ref1=chartOpts!=null?chartOpts.height:void 0)!=null?ref1:80;margin=(ref2=chartOpts!=null?chartOpts.margin:void 0)!=null?ref2:{left:25,right:25,inner:0,top:40,bottom:40};rectheight=(ref3=chartOpts!=null?chartOpts.rectheight:void 0)!=null?ref3:10;rectcolor=(ref4=chartOpts!=null?chartOpts.rectcolor:void 0)!=null?ref4:"#ccc";buttonsize=(ref5=chartOpts!=null?chartOpts.buttonsize:void 0)!=null?ref5:rectheight*2;buttoncolor=(ref6=chartOpts!=null?chartOpts.buttoncolor:void 0)!=null?ref6:"#eee";buttonstroke=(ref7=chartOpts!=null?chartOpts.buttonstroke:void 0)!=null?ref7:"black";buttonround=(ref8=chartOpts!=null?chartOpts.buttonround:void 0)!=null?ref8:buttonsize*.2;buttondotcolor=(ref9=chartOpts!=null?chartOpts.buttondotcolor:void 0)!=null?ref9:"slateblue";buttondotsize=(ref10=chartOpts!=null?chartOpts.buttondotsize:void 0)!=null?ref10:buttonsize/4;tickheight=(ref11=chartOpts!=null?chartOpts.tickheight:void 0)!=null?ref11:10;tickgap=(ref12=chartOpts!=null?chartOpts.tickgap:void 0)!=null?ref12:tickheight/2;textsize=(ref13=chartOpts!=null?chartOpts.textsize:void 0)!=null?ref13:14;nticks=(ref14=chartOpts!=null?chartOpts.nticks:void 0)!=null?ref14:5;ticks=(ref15=chartOpts!=null?chartOpts.ticks:void 0)!=null?ref15:null;ticks_at_stops=(ref16=chartOpts!=null?chartOpts.ticks_at_stops:void 0)!=null?ref16:true;value=0;stopindex=0;slider_svg=null;_chart=function chart(selection,callback,range,stops,initial_value){var button,clamp_pixels,dragged,end_drag,xcscale,xscale;margin=d3panels.check_listarg_v_default(margin,{left:25,right:25,inner:0,top:40,bottom:40});margin.left+=margin.inner;margin.right+=margin.inner;if(range==null){range=[margin.left,width-margin.right]}if(margin.top!=null&&margin.top+margin.bottom>0){margin.top=height*margin.top/(margin.top+margin.bottom)}else{margin.top=height/2}if(initial_value!=null){value=initial_value;if(value<range[0]){value=range[0]}if(value>range[1]){value=range[1]}if(stops!=null){stopindex=d3panels.index_of_nearest(value,stops)}if(stops!=null){value=stops[stopindex]}}else{if(stops!=null){stopindex=Math.floor(Math.random()*stops.length);value=stops[stopindex]}else{value=(range[1]-range[0])*Math.random()+range[0]}}slider_svg=selection.insert("svg").attr("height",height).attr("width",width);xcscale=d3.scaleLinear().range([margin.left,width-margin.right]).domain(range).clamp(true);xscale=function xscale(d){if(stops!=null){return xcscale(stops[d3panels.index_of_nearest(d,stops)])}return xcscale(d)};clamp_pixels=function clamp_pixels(pixels,interval){if(pixels<interval[0]){return interval[0]}if(pixels>interval[1]){return interval[1]}return pixels};slider_svg.insert("rect").attr("x",margin.left).attr("y",margin.top-rectheight/2).attr("rx",rectheight*.3).attr("ry",rectheight*.3).attr("width",width-margin.left-margin.right).attr("height",rectheight).attr("fill",rectcolor);if(ticks==null){ticks=xcscale.ticks(nticks)}slider_svg.selectAll("empty").data(ticks).enter().insert("line").attr("x1",function(d){return xcscale(d)}).attr("x2",function(d){return xcscale(d)}).attr("y1",margin.top+rectheight/2+tickgap).attr("y2",margin.top+rectheight/2+tickgap+tickheight).attr("stroke","black").attr("shape-rendering","crispEdges");slider_svg.selectAll("empty").data(ticks).enter().insert("text").attr("x",function(d){return xcscale(d)}).attr("y",margin.top+rectheight/2+tickgap*2+tickheight).text(function(d){return d}).style("font-size",textsize).style("dominant-baseline","hanging").style("text-anchor","middle").style("pointer-events","none").style("-webkit-user-select","none").style("-moz-user-select","none").style("-ms-user-select","none");if(stops!=null&&ticks_at_stops){slider_svg.selectAll("empty").data(stops).enter().insert("line").attr("x1",function(d){return xcscale(d)}).attr("x2",function(d){return xcscale(d)}).attr("y1",margin.top-rectheight/2-tickgap).attr("y2",margin.top-rectheight/2-tickgap-tickheight).attr("stroke","black").attr("shape-rendering","crispEdges")}button=slider_svg.insert("g").attr("id","button").attr("transform","translate("+xscale(value)+",0)");button.insert("rect").attr("x",-buttonsize/2).attr("y",margin.top-buttonsize/2).attr("height",buttonsize).attr("width",buttonsize).attr("rx",buttonround).attr("ry",buttonround).attr("stroke",buttonstroke).attr("stroke-width",2).attr("fill",buttoncolor);button.insert("circle").attr("cx",0).attr("cy",margin.top).attr("r",buttondotsize).attr("fill",buttondotcolor);dragged=function dragged(event,d){var clamped_pixels,pixel_value;pixel_value=event.x;clamped_pixels=clamp_pixels(pixel_value,[margin.left,width-margin.right]);value=xcscale.invert(clamped_pixels);d3.select(this).attr("transform","translate("+xcscale(value)+",0)");if(stops!=null){stopindex=d3panels.index_of_nearest(value,stops);value=stops[stopindex]}if(callback!=null){return callback(_chart)}};end_drag=function end_drag(event,d){var clamped_pixels,pixel_value;pixel_value=event.x;clamped_pixels=clamp_pixels(pixel_value,[margin.left,width-margin.right]);value=xcscale.invert(clamped_pixels);if(stops!=null){stopindex=d3panels.index_of_nearest(value,stops);value=stops[stopindex]}if(callback!=null){callback(_chart)}return d3.select(this).attr("transform","translate("+xcscale(value)+",0)")};button.call(d3.drag().on("drag",dragged).on("end",end_drag));if(callback!=null){return callback(_chart)}};_chart.value=function(){return value};_chart.stopindex=function(){return stopindex};_chart.remove=function(){return slider_svg.remove()};return _chart};"use strict";d3panels.double_slider=function(chartOpts){var buttoncolor,buttondotcolor,buttondotsize,buttonround,buttonsize,buttonstroke,_chart,height,margin,nticks,rectcolor,rectheight,ref,ref1,ref10,ref11,ref12,ref13,ref14,ref15,ref16,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,slider_svg,stopindex,textsize,tickgap,tickheight,ticks,ticks_at_stops,value,width;if(chartOpts==null){chartOpts={}}width=(ref=chartOpts!=null?chartOpts.width:void 0)!=null?ref:800;height=(ref1=chartOpts!=null?chartOpts.height:void 0)!=null?ref1:80;margin=(ref2=chartOpts!=null?chartOpts.margin:void 0)!=null?ref2:{left:25,right:25,inner:0,top:40,bottom:40};rectheight=(ref3=chartOpts!=null?chartOpts.rectheight:void 0)!=null?ref3:10;rectcolor=(ref4=chartOpts!=null?chartOpts.rectcolor:void 0)!=null?ref4:"#ccc";buttonsize=(ref5=chartOpts!=null?chartOpts.buttonsize:void 0)!=null?ref5:rectheight*2;buttoncolor=(ref6=chartOpts!=null?chartOpts.buttoncolor:void 0)!=null?ref6:"#eee";buttonstroke=(ref7=chartOpts!=null?chartOpts.buttonstroke:void 0)!=null?ref7:"black";buttonround=(ref8=chartOpts!=null?chartOpts.buttonround:void 0)!=null?ref8:buttonsize*.2;buttondotcolor=(ref9=chartOpts!=null?chartOpts.buttondotcolor:void 0)!=null?ref9:["slateblue","orchid"];buttondotsize=(ref10=chartOpts!=null?chartOpts.buttondotsize:void 0)!=null?ref10:buttonsize/4;tickheight=(ref11=chartOpts!=null?chartOpts.tickheight:void 0)!=null?ref11:10;tickgap=(ref12=chartOpts!=null?chartOpts.tickgap:void 0)!=null?ref12:tickheight/2;textsize=(ref13=chartOpts!=null?chartOpts.textsize:void 0)!=null?ref13:14;nticks=(ref14=chartOpts!=null?chartOpts.nticks:void 0)!=null?ref14:5;ticks=(ref15=chartOpts!=null?chartOpts.ticks:void 0)!=null?ref15:null;ticks_at_stops=(ref16=chartOpts!=null?chartOpts.ticks_at_stops:void 0)!=null?ref16:true;value=[0,0];stopindex=[0,0];slider_svg=null;if(!Array.isArray(buttoncolor)){buttoncolor=[buttoncolor,buttoncolor]}if(!Array.isArray(buttonstroke)){buttonstroke=[buttonstroke,buttonstroke]}if(!Array.isArray(buttondotcolor)){buttondotcolor=[buttondotcolor,buttondotcolor]}_chart=function chart(selection,callback1,callback2,range,stops,initial_value){var buttons,callbacks,clamp_pixels,dragged,end_drag,start_drag,xcscale,xscale;margin=d3panels.check_listarg_v_default(margin,{left:25,right:25,inner:0,top:40,bottom:40});callbacks=[callback1,callback2];margin.left+=margin.inner;margin.right+=margin.inner;if(range==null){range=[margin.left,width-margin.right]}if(margin.top!=null&&margin.top+margin.bottom>0){margin.top=height*margin.top/(margin.top+margin.bottom)}else{margin.top=height/2}if(initial_value!=null){value=initial_value.map(function(d){if(d<range[0]){return range[0]}if(d>range[1]){return range[1]}return d});if(stops!=null){stopindex=value.map(function(d){return d3panels.index_of_nearest(d,stops)})}if(stops!=null){value=stopindex.map(function(i){return stops[i]})}}else{if(stops!=null){stopindex=[0,1].map(function(i){return Math.floor(Math.random()*stops.length)});value=stopindex.map(function(i){return stops[i]})}else{value=[0,1].map(function(i){return(range[1]-range[0])*Math.random()+range[0]})}}slider_svg=selection.insert("svg").attr("height",height).attr("width",width);xcscale=d3.scaleLinear().range([margin.left,width-margin.right]).domain(range).clamp(true);xscale=function xscale(d){if(stops!=null){return xcscale(stops[d3panels.index_of_nearest(d,stops)])}return xcscale(d)};clamp_pixels=function clamp_pixels(pixels,interval){if(pixels<interval[0]){return interval[0]}if(pixels>interval[1]){return interval[1]}return pixels};slider_svg.insert("rect").attr("x",margin.left).attr("y",margin.top-rectheight/2).attr("rx",rectheight*.3).attr("ry",rectheight*.3).attr("width",width-margin.left-margin.right).attr("height",rectheight).attr("fill",rectcolor);if(ticks==null){ticks=xcscale.ticks(nticks)}slider_svg.selectAll("empty").data(ticks).enter().insert("line").attr("x1",function(d){return xcscale(d)}).attr("x2",function(d){return xcscale(d)}).attr("y1",margin.top+rectheight/2+tickgap).attr("y2",margin.top+rectheight/2+tickgap+tickheight).attr("stroke","black").attr("shape-rendering","crispEdges");slider_svg.selectAll("empty").data(ticks).enter().insert("text").attr("x",function(d){return xcscale(d)}).attr("y",margin.top+rectheight/2+tickgap*2+tickheight).text(function(d){return d}).style("font-size",textsize).style("dominant-baseline","hanging").style("text-anchor","middle").style("pointer-events","none").style("-webkit-user-select","none").style("-moz-user-select","none").style("-ms-user-select","none");if(stops!=null&&ticks_at_stops){slider_svg.selectAll("empty").data(stops).enter().insert("line").attr("x1",function(d){return xcscale(d)}).attr("x2",function(d){return xcscale(d)}).attr("y1",margin.top-rectheight/2-tickgap).attr("y2",margin.top-rectheight/2-tickgap-tickheight).attr("stroke","black").attr("shape-rendering","crispEdges")}buttons=[0,1].map(function(i){return slider_svg.insert("g").attr("id","button"+(i+1)).attr("transform",function(d){return"translate("+xscale(value[i])+",0)"})});[0,1].map(function(i){buttons[i].insert("rect").attr("x",-buttonsize/2).attr("y",margin.top-buttonsize/2).attr("height",buttonsize).attr("width",buttonsize).attr("rx",buttonround).attr("ry",buttonround).attr("stroke",buttonstroke[i]).attr("stroke-width",2).attr("fill",buttoncolor[i]);return buttons[i].insert("circle").attr("cx",0).attr("cy",margin.top).attr("r",buttondotsize).attr("fill",buttondotcolor[i])});start_drag=function start_drag(i){return function(d){return buttons[i].raise()}};dragged=function dragged(i){return function(event,d){var clamped_pixels,pixel_value;pixel_value=event.x;clamped_pixels=clamp_pixels(pixel_value,[margin.left,width-margin.right]);value[i]=xcscale.invert(clamped_pixels);d3.select(this).attr("transform","translate("+xcscale(value[i])+",0)");if(stops!=null){stopindex[i]=d3panels.index_of_nearest(value[i],stops);value[i]=stops[stopindex[i]]}if(callbacks[i]!=null){return callbacks[i](_chart)}}};end_drag=function end_drag(i){return function(event,d){var clamped_pixels,pixel_value;pixel_value=event.x;clamped_pixels=clamp_pixels(pixel_value,[margin.left,width-margin.right]);value[i]=xcscale.invert(clamped_pixels);if(stops!=null){stopindex[i]=d3panels.index_of_nearest(value[i],stops);value[i]=stops[stopindex[i]]}if(callbacks[i]!=null){callbacks[i](_chart)}return d3.select(this).attr("transform","translate("+xcscale(value[i])+",0)")}};return[0,1].map(function(i){buttons[i].call(d3.drag().on("start",start_drag(i)).on("drag",dragged(i)).on("end",end_drag(i)));if(callbacks[i]!=null){return callbacks[i](_chart)}})};_chart.value=function(){return value};_chart.stopindex=function(){return stopindex};_chart.remove=function(){return slider_svg.remove()};return _chart};"use strict";d3panels.tooltip_create=function(selection,objects,options,tooltip_func){var direction,fill,fontcolor,fontsize,in_duration,out_duration,pad,ref,ref1,ref2,ref3,ref4,tipclass,tipdiv,tipgroup,triChar,tridiv;tipclass=(ref=options!=null?options.tipclass:void 0)!=null?ref:"d3panels-tooltip";direction=(ref1=options!=null?options.direction:void 0)!=null?ref1:"east";out_duration=(ref2=options!=null?options.out_duration:void 0)!=null?ref2:1e3;in_duration=(ref3=options!=null?options.in_duration:void 0)!=null?ref3:0;pad=(ref4=options!=null?options.pad:void 0)!=null?ref4:8;fill=options!=null?options.fill:void 0;fontcolor=options!=null?options.fontcolor:void 0;fontsize=options!=null?options.fontsize:void 0;tipgroup=selection.append("g").attr("class","d3panels-tooltip "+tipclass).style("opacity",0).datum({direction:direction,pad:pad});tipdiv=tipgroup.append("div").attr("class","d3panels-tooltip "+tipclass);if(direction==="east"){triChar="◀"}else if(direction==="west"){triChar="▶"}else if(direction==="north"){triChar="▼"}else if(direction==="south"){triChar="▲"}else{d3panels.displayError("tooltip_create: invalid direction ("+direction+")")}tridiv=tipgroup.append("div").attr("class","d3panels-tooltip-tri "+tipclass).html(triChar);if(fill!=null){tipdiv.style("background",fill)}if(fontcolor!=null){tipdiv.style("color",fontcolor)}if(fontsize!=null){tipdiv.style("font-size",fontsize+"px")}if(fill!=null){tridiv.style("color",fill)}if(fontsize!=null){tridiv.style("font-size",fontsize+"px")}objects.on("mouseover."+tipclass,function(event,d){var i,mouseX,mouseY;i=objects.nodes().indexOf(this);mouseX=event.pageX*1;mouseY=event.pageY*1;tipdiv.html(tooltip_func(d,i));d3panels.tooltip_move(tipgroup,mouseX,mouseY);return d3panels.tooltip_show(tipgroup,in_duration)});objects.on("mouseout."+tipclass,function(d){return d3panels.tooltip_hide(tipgroup,out_duration)});return tipgroup};d3panels.tooltip_move=function(tipgroup,x,y){var direction,divpad,fontsize,pad,posX,posY,shiftX,shiftY,tipbox_height,tipbox_width,tipdiv,triX,triY,tridiv;tipdiv=tipgroup.select("div.d3panels-tooltip");tridiv=tipgroup.select("div.d3panels-tooltip-tri");tipbox_height=tipdiv.node().getBoundingClientRect().height*1;tipbox_width=tipdiv.node().getBoundingClientRect().width*1;fontsize=tridiv.style("font-size").replace("px","")*1;pad=tipgroup.datum().pad*1+fontsize;direction=tipgroup.datum().direction;shiftX=shiftY=0;if(direction==="east"){posX=x+pad;posY=y-tipbox_height/2;divpad=tipdiv.style("padding-left").replace("px","")*1;shiftX=-fontsize-divpad;shiftY=tipbox_height/2-fontsize/2}else if(direction==="west"){posX=x-tipbox_width*1-pad;posY=y-tipbox_height/2;divpad=tipdiv.style("padding-right").replace("px","")*1;shiftX=tipbox_width-fontsize+divpad;shiftY=tipbox_height/2-fontsize/2}else if(direction==="north"){posX=x-tipbox_width/2;posY=y-tipbox_height-pad;divpad=tipdiv.style("padding-bottom").replace("px","")*1;shiftX=tipbox_width/2-fontsize;shiftY=tipbox_height+divpad/2-fontsize/2}else if(direction==="south"){posX=x-tipbox_width/2;posY=y+pad;divpad=tipdiv.style("padding-top").replace("px","")*1;shiftX=+tipbox_width/2-fontsize;shiftY=-fontsize}tipdiv.style("left",posX+"px").style("top",posY+"px");triX=posX+shiftX;triY=posY+shiftY;return tridiv.style("left",triX+"px").style("top",triY+"px").style("width",tipbox_width).style("height",tipbox_height)};d3panels.tooltip_text=function(tipgroup,text){return tipgroup.select("div.d3panels-tooltip").html(text)};d3panels.tooltip_show=function(tipgroup,duration){return tipgroup.transition().duration(duration).style("opacity",1)};d3panels.tooltip_hide=function(tipgroup,duration){return tipgroup.transition().duration(duration).style("opacity",0)};d3panels.tooltip_destroy=function(tipgroup){return tipgroup.remove()};if(typeof define==="function"&&define.amd)this.d3panels=d3panels,define(d3panels);else if(typeof module==="object"&&module.exports)module.exports=d3panels;else this.d3panels=d3panels}();