/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.simpleDesign;

import dr.inference.distribution.DistributionLikelihood;
import dr.inference.distribution.NormalDistributionModel;
import dr.inference.distribution.ParametricDistributionModel;
import dr.inference.loggers.Loggable;
import dr.inference.model.CompoundLikelihood;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.inference.operators.AdaptationMode;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.OperatorSchedule;
import dr.inference.operators.RandomWalkOperator;
import dr.inference.operators.SimpleOperatorSchedule;
import dr.math.distributions.Distribution;
import dr.math.distributions.GammaDistribution;
import dr.math.distributions.NormalDistribution;
import dr.util.Attribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.ohdsi.likelihood.CachedModelLikelihood;
import org.ohdsi.mcmc.Analysis;
import org.ohdsi.mcmc.Runner;
import org.ohdsi.metaAnalysis.EmpiricalDataModel;
import org.ohdsi.metaAnalysis.ExtendingEmpiricalDataModel;

public class ProfileHierarchicalNormalAnalysis
implements Analysis {
    private final Likelihood likelihood;
    private final Likelihood prior;
    private final Likelihood joint;
    private final Parameter beta;
    private final Parameter mean;
    private final Parameter precision;
    private final OperatorSchedule schedule;

    public ProfileHierarchicalNormalAnalysis(List<EmpiricalDataModel> profileLikelihoods, double priorEffectMean, double priorEffectSd, double startingValue) {
        ArrayList<CachedModelLikelihood> empiricalModels = new ArrayList<CachedModelLikelihood>();
        this.beta = new CompoundParameter("beta");
        for (EmpiricalDataModel dataModel : profileLikelihoods) {
            empiricalModels.add(new CachedModelLikelihood("likelihood", dataModel));
            Parameter individualBeta = dataModel.getCompoundParameter();
            if (individualBeta.getDimension() != 1) {
                throw new RuntimeException("Not yet implemented");
            }
            individualBeta.setParameterValue(0, startingValue);
            ((CompoundParameter)this.beta).addParameter(individualBeta);
        }
        this.likelihood = new CompoundLikelihood(empiricalModels);
        this.mean = new Parameter.Default("mean", 1);
        this.mean.setParameterValue(0, 0.0);
        this.precision = new Parameter.Default("precision", 1);
        this.precision.setParameterValue(0, 1.0);
        DistributionLikelihood effectDistribution = new DistributionLikelihood((ParametricDistributionModel)new NormalDistributionModel(this.mean, this.precision, true));
        effectDistribution.addData((Attribute)this.beta);
        DistributionLikelihood meanPrior = new DistributionLikelihood((Distribution)new NormalDistribution(priorEffectMean, priorEffectSd));
        meanPrior.addData((Attribute)this.mean);
        DistributionLikelihood precisionPrior = new DistributionLikelihood((Distribution)new GammaDistribution(priorEffectMean, priorEffectSd));
        precisionPrior.addData((Attribute)this.precision);
        this.prior = new CompoundLikelihood(Arrays.asList(effectDistribution, meanPrior, precisionPrior));
        this.prior.setId("prior");
        this.joint = new CompoundLikelihood(Arrays.asList(this.likelihood, this.prior));
        this.joint.setId("joint");
        this.schedule = new SimpleOperatorSchedule(1000, 0.0);
        double defaultWeight = 1.0;
        AdaptationMode mode = AdaptationMode.ADAPTATION_ON;
        RandomWalkOperator.BoundaryCondition condition = RandomWalkOperator.BoundaryCondition.reflecting;
        for (EmpiricalDataModel dataModel : profileLikelihoods) {
            for (Parameter p : dataModel.getIndividualParameters()) {
                this.schedule.addOperator((MCMCOperator)new RandomWalkOperator(p, null, 0.75, condition, defaultWeight, mode));
            }
        }
    }

    @Override
    public List<Loggable> getLoggerColumns() {
        ArrayList<Loggable> columns = new ArrayList<Loggable>();
        columns.add((Loggable)this.likelihood);
        columns.add((Loggable)this.prior);
        columns.add((Loggable)this.beta);
        return columns;
    }

    @Override
    public Likelihood getJoint() {
        return this.joint;
    }

    @Override
    public OperatorSchedule getSchedule() {
        return this.schedule;
    }

    public static void main(String[] args) {
        int chainLength = 1100000;
        int burnIn = 100000;
        int subSampleFrequency = 1000;
        ExtendingEmpiricalDataModel dataModel = new ExtendingEmpiricalDataModel("profile.txt");
        ProfileHierarchicalNormalAnalysis analysis = new ProfileHierarchicalNormalAnalysis(Collections.singletonList(dataModel), 0.0, 10.0, 0.0);
        Runner runner = new Runner(analysis, chainLength, burnIn, subSampleFrequency, 666.0);
        runner.run();
        runner.processSamples();
    }
}

