/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.simplets.chainlinking;

import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.timeseries.TsAggregationType;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDataBlock;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import ec.tstoolkit.timeseries.simplets.YearIterator;
import ec.tstoolkit.timeseries.simplets.chainlinking.AChainLinking;
import java.util.ArrayList;

public class AnnualOverlap
extends AChainLinking {
    public static final String TOTAL_VALUES = "totalvalues";
    public static final String VALUES_PREVIOUS_PRICE = "valuesPreviousYearPrice";
    public static final String CHAIN_LINKED_INDEXES = "percPreviousYearPrice";
    public static final String REF_YEAR = "refYear";

    @Override
    public void process() {
        if (this.input == null || this.input.isEmpty()) {
            this.results = null;
            return;
        }
        this.results = new InformationSet();
        this.calculateMissingData();
        TsDomain intersection = this.intersectAllDomains(this.findSmallestDomain());
        if (intersection.getLength() == 0) {
            throw new IllegalArgumentException("The common domain is empty");
        }
        if (this.refYear == -1 || intersection.getStart().getYear() > this.refYear || intersection.getEnd().getYear() < this.refYear) {
            this.refYear = intersection.getStart().getYear();
        }
        this.results.add(REF_YEAR, Integer.valueOf(this.refYear));
        while (intersection.getStart().getYear() < this.refYear) {
            intersection = intersection.drop(1, 0);
        }
        ArrayList<AChainLinking.Product> prds = this.cloneInputList();
        for (int i = 0; i < prds.size(); ++i) {
            ((AChainLinking.Product)prds.get(i)).setQuantities(((AChainLinking.Product)prds.get(i)).getQuantities().fittoDomain(intersection));
            ((AChainLinking.Product)prds.get(i)).setPrice(((AChainLinking.Product)prds.get(i)).getPrice().fittoDomain(intersection));
            ((AChainLinking.Product)prds.get(i)).setValue(((AChainLinking.Product)prds.get(i)).getValue().fittoDomain(intersection));
        }
        ArrayList<TsData> allPricesY = new ArrayList<TsData>();
        for (int i = 0; i < prds.size(); ++i) {
            allPricesY.add(((AChainLinking.Product)prds.get(i)).getPrice().changeFrequency(TsFrequency.Yearly, TsAggregationType.Average, true));
        }
        ArrayList<TsData> allQuantitiesQ = new ArrayList<TsData>();
        for (int i = 0; i < prds.size(); ++i) {
            TsData ts = ((AChainLinking.Product)prds.get(i)).getQuantities();
            ts = ts.update(ts.changeFrequency(TsFrequency.Quarterly, TsAggregationType.Sum, true));
            ts = ts.drop(4, 0);
            allQuantitiesQ.add(ts);
        }
        TsData totalValueQ = ((AChainLinking.Product)prds.get(0)).getValue();
        for (int i = 1; i < prds.size(); ++i) {
            totalValueQ = TsData.add(totalValueQ, ((AChainLinking.Product)prds.get(i)).getValue());
        }
        this.results.add(TOTAL_VALUES, totalValueQ);
        TsData totalValueY = totalValueQ.changeFrequency(TsFrequency.Yearly, TsAggregationType.Sum, true);
        totalValueQ = totalValueQ.drop(4, 0);
        TsData Qq = new TsData(totalValueQ.getDomain());
        YearIterator yq = new YearIterator(Qq);
        ArrayList<YearIterator> iterators = new ArrayList<YearIterator>();
        for (int i = 0; i < allQuantitiesQ.size(); ++i) {
            iterators.add(new YearIterator((TsData)allQuantitiesQ.get(i)));
        }
        while (yq.hasMoreElements()) {
            TsDataBlock qcur = yq.nextElement();
            ArrayList<TsDataBlock> dataBlocks = new ArrayList<TsDataBlock>();
            for (int i = 0; i < prds.size(); ++i) {
                dataBlocks.add(((YearIterator)iterators.get(i)).nextElement());
            }
            TsPeriod prev = TsPeriod.year(qcur.start.getYear() - 1);
            qcur.data.setAY(((TsData)allPricesY.get(0)).get(prev), ((TsDataBlock)dataBlocks.get((int)0)).data);
            for (int i = 1; i < dataBlocks.size(); ++i) {
                qcur.data.addAY(((TsData)allPricesY.get(i)).get(prev), ((TsDataBlock)dataBlocks.get((int)i)).data);
            }
        }
        this.results.set(VALUES_PREVIOUS_PRICE, Qq.clone());
        double idx = 100.0;
        int ifreq = Qq.getFrequency().intValue();
        yq.reset();
        while (yq.hasMoreElements()) {
            TsDataBlock qcur = yq.nextElement();
            TsPeriod prev = TsPeriod.year(qcur.start.getYear() - 1);
            double val0 = totalValueY.get(prev);
            double val1 = qcur.data.sum();
            qcur.data.mul(idx / (val0 / (double)ifreq));
            idx *= val1 / val0;
        }
        this.results.set(CHAIN_LINKED_INDEXES, Qq);
    }

    private TsDomain findSmallestDomain() {
        TsDomain dRef = ((AChainLinking.Product)this.input.get(0)).getQuantities().fullYears().getDomain();
        for (int i = 1; i < this.input.size(); ++i) {
            TsDomain current = ((AChainLinking.Product)this.input.get(i)).getQuantities().fullYears().getDomain();
            if (dRef.getLength() > dRef.getLength()) continue;
            dRef = current;
        }
        return dRef;
    }

    private TsDomain intersectAllDomains(TsDomain ref) {
        for (int i = 0; i < this.input.size(); ++i) {
            TsDomain current = ((AChainLinking.Product)this.input.get(i)).getQuantities().getDomain();
            ref = ref.intersection(current);
        }
        return ref;
    }

    private ArrayList<AChainLinking.Product> cloneInputList() {
        ArrayList<AChainLinking.Product> products = new ArrayList<AChainLinking.Product>(this.input.size());
        try {
            for (AChainLinking.Product p : this.input) {
                products.add((AChainLinking.Product)p.clone());
            }
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalArgumentException("Impossible to clone the list of inputs !");
        }
        return products;
    }

    private void calculateMissingData() {
        for (AChainLinking.Product p : this.input) {
            p.calculateMissingTs();
        }
    }
}

