/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#if !(defined H5PB_FRIEND || defined H5PB_MODULE)
#error "Do not include this file outside the H5PB package!"
#endif

#ifndef H5PBpkg_H
#define H5PBpkg_H

#include "H5PBprivate.h"

typedef struct H5PB_entry_t {
    void          *page_buf_ptr; 
    haddr_t        addr;         
    H5F_mem_page_t type;         
    bool           is_dirty;     

    
    struct H5PB_entry_t *next; 
    struct H5PB_entry_t *prev; 
} H5PB_entry_t;

#endif 
