/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

class BeamSizes {
  static const double size0 = 0;
  static const double size1 = 1;
  static const double size2 = 2;
  static const double size3 = 3;
  static const double size4 = 4;
  static const double size6 = 6;
  static const double size7 = 7;
  static const double size8 = 8;
  static const double size10 = 10;
  static const double size12 = 12;
  static const double size16 = 16;
  static const double size18 = 18;
  static const double size20 = 20;
  static const double size24 = 24;
  static const double size30 = 30;
  static const double size32 = 32;
  static const double size36 = 36;
  static const double size40 = 40;
  static const double size64 = 64;

  static const double appBarHeight = 55;
  static const double buttonHeight = 40;
  static const double elevation = 2;
  static const double headerButtonHeight = 46;
  static const double loadingIndicator = 40;
  static const double splitViewSeparator = BeamSizes.size8;
  static const double tabBarHeight = 50;
  static const double textFieldHeight = 50;
  static const double popupWidth = 420;
}

class BeamBorderRadius {
  static const double small = BeamSizes.size4;
  static const double medium = BeamSizes.size6;
  static const double large = BeamSizes.size8;
  static const double infinite = 1000; // TODO: Use StadiumBorder
}

class BeamIconSizes {
  static const double xs = BeamSizes.size8;
  static const double small = BeamSizes.size16;
  static const double medium = BeamSizes.size24;
  static const double large = BeamSizes.size32;

  static const double largeSplashRadius = 24;
}

class BeamSpacing {
  static const double zero = BeamSizes.size0;
  static const double small = BeamSizes.size4;
  static const double medium = BeamSizes.size8;
  static const double large = BeamSizes.size12;
  static const double extraLarge = BeamSizes.size16;
  static const double extraExtraLarge = BeamSizes.size36;
}
