/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.DelegatingResultSet;
import org.apache.commons.dbcp2.TesterConnection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestDelegatingResultSet {
    private TesterConnection testConn;
    private DelegatingConnection<Connection> conn;
    private ResultSet rs;
    private DelegatingResultSet delegate;

    @BeforeEach
    public void setUp() {
        this.testConn = new TesterConnection("foo", "bar");
        this.conn = new DelegatingConnection((Connection)this.testConn);
        this.rs = (ResultSet)Mockito.mock(ResultSet.class);
        this.delegate = (DelegatingResultSet)DelegatingResultSet.wrapResultSet(this.conn, (ResultSet)this.rs);
    }

    @Test
    public void testAbsoluteInteger() throws Exception {
        try {
            this.delegate.absolute(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).absolute(1);
    }

    @Test
    public void testAbsolutes() throws Exception {
        try {
            this.delegate.absolute(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).absolute(1);
    }

    @Test
    public void testAfterLast() throws Exception {
        try {
            this.delegate.afterLast();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).afterLast();
    }

    @Test
    public void testBeforeFirst() throws Exception {
        try {
            this.delegate.beforeFirst();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).beforeFirst();
    }

    @Test
    public void testCancelRowUpdates() throws Exception {
        try {
            this.delegate.cancelRowUpdates();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).cancelRowUpdates();
    }

    @Test
    public void testClearWarnings() throws Exception {
        try {
            this.delegate.clearWarnings();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).clearWarnings();
    }

    @Test
    public void testClose() throws Exception {
        try {
            this.delegate.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testDeleteRow() throws Exception {
        try {
            this.delegate.deleteRow();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).deleteRow();
    }

    @Test
    public void testFindColumnString() throws Exception {
        try {
            this.delegate.findColumn("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).findColumn("foo");
    }

    @Test
    public void testFirst() throws Exception {
        try {
            this.delegate.first();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).first();
    }

    @Test
    public void testGetArrayInteger() throws Exception {
        try {
            this.delegate.getArray(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getArray(1);
    }

    @Test
    public void testGetArrayString() throws Exception {
        try {
            this.delegate.getArray("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getArray("foo");
    }

    @Test
    public void testGetAsciiStreamInteger() throws Exception {
        try {
            this.delegate.getAsciiStream(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getAsciiStream(1);
    }

    @Test
    public void testGetAsciiStreamString() throws Exception {
        try {
            this.delegate.getAsciiStream("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getAsciiStream("foo");
    }

    @Test
    public void testGetBigDecimalInteger() throws Exception {
        try {
            this.delegate.getBigDecimal(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getBigDecimal(1);
    }

    @Disabled
    @Test
    public void testGetBigDecimalIntegerInteger() throws Exception {
        try {
            this.delegate.getBigDecimal(1, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getBigDecimal(1, 1);
    }

    @Test
    public void testGetBigDecimalString() throws Exception {
        try {
            this.delegate.getBigDecimal("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getBigDecimal("foo");
    }

    @Disabled
    @Test
    public void testGetBigDecimalStringInteger() throws Exception {
        try {
            this.delegate.getBigDecimal("foo", 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getBigDecimal("foo", 1);
    }

    @Test
    public void testGetBinaryStreamInteger() throws Exception {
        try {
            this.delegate.getBinaryStream(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getBinaryStream(1);
    }

    @Test
    public void testGetBinaryStreamString() throws Exception {
        try {
            this.delegate.getBinaryStream("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getBinaryStream("foo");
    }

    @Test
    public void testGetBlobInteger() throws Exception {
        try {
            this.delegate.getBlob(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getBlob(1);
    }

    @Test
    public void testGetBlobString() throws Exception {
        try {
            this.delegate.getBlob("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getBlob("foo");
    }

    @Test
    public void testGetBooleanInteger() throws Exception {
        try {
            this.delegate.getBoolean(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getBoolean(1);
    }

    @Test
    public void testGetBooleanString() throws Exception {
        try {
            this.delegate.getBoolean("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getBoolean("foo");
    }

    @Test
    public void testGetByteInteger() throws Exception {
        try {
            this.delegate.getByte(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getByte(1);
    }

    @Test
    public void testGetBytesInteger() throws Exception {
        try {
            this.delegate.getBytes(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getBytes(1);
    }

    @Test
    public void testGetBytesString() throws Exception {
        try {
            this.delegate.getBytes("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getBytes("foo");
    }

    @Test
    public void testGetByteString() throws Exception {
        try {
            this.delegate.getByte("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getByte("foo");
    }

    @Test
    public void testGetCharacterStreamInteger() throws Exception {
        try {
            this.delegate.getCharacterStream(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getCharacterStream(1);
    }

    @Test
    public void testGetCharacterStreamString() throws Exception {
        try {
            this.delegate.getCharacterStream("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getCharacterStream("foo");
    }

    @Test
    public void testGetClobInteger() throws Exception {
        try {
            this.delegate.getClob(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getClob(1);
    }

    @Test
    public void testGetClobString() throws Exception {
        try {
            this.delegate.getClob("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getClob("foo");
    }

    @Test
    public void testGetConcurrency() throws Exception {
        try {
            this.delegate.getConcurrency();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getConcurrency();
    }

    @Test
    public void testGetCursorName() throws Exception {
        try {
            this.delegate.getCursorName();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getCursorName();
    }

    @Test
    public void testGetDateInteger() throws Exception {
        try {
            this.delegate.getDate(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getDate(1);
    }

    @Test
    public void testGetDateIntegerCalendar() throws Exception {
        try {
            this.delegate.getDate(1, (Calendar)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getDate(1, (Calendar)null);
    }

    @Test
    public void testGetDateString() throws Exception {
        try {
            this.delegate.getDate("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getDate("foo");
    }

    @Test
    public void testGetDateStringCalendar() throws Exception {
        try {
            this.delegate.getDate("foo", (Calendar)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getDate("foo", (Calendar)null);
    }

    @Test
    public void testGetDoubleInteger() throws Exception {
        try {
            this.delegate.getDouble(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getDouble(1);
    }

    @Test
    public void testGetDoubleString() throws Exception {
        try {
            this.delegate.getDouble("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getDouble("foo");
    }

    @Test
    public void testGetFetchDirection() throws Exception {
        try {
            this.delegate.getFetchDirection();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getFetchDirection();
    }

    @Test
    public void testGetFetchSize() throws Exception {
        try {
            this.delegate.getFetchSize();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getFetchSize();
    }

    @Test
    public void testGetFloatInteger() throws Exception {
        try {
            this.delegate.getFloat(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getFloat(1);
    }

    @Test
    public void testGetFloatString() throws Exception {
        try {
            this.delegate.getFloat("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getFloat("foo");
    }

    @Test
    public void testGetHoldability() throws Exception {
        try {
            this.delegate.getHoldability();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getHoldability();
    }

    @Test
    public void testGetIntInteger() throws Exception {
        try {
            this.delegate.getInt(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getInt(1);
    }

    @Test
    public void testGetIntString() throws Exception {
        try {
            this.delegate.getInt("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getInt("foo");
    }

    @Test
    public void testGetLongInteger() throws Exception {
        try {
            this.delegate.getLong(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getLong(1);
    }

    @Test
    public void testGetLongString() throws Exception {
        try {
            this.delegate.getLong("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getLong("foo");
    }

    @Test
    public void testGetMetaData() throws Exception {
        try {
            this.delegate.getMetaData();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getMetaData();
    }

    @Test
    public void testGetNCharacterStreamInteger() throws Exception {
        try {
            this.delegate.getNCharacterStream(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getNCharacterStream(1);
    }

    @Test
    public void testGetNCharacterStreamString() throws Exception {
        try {
            this.delegate.getNCharacterStream("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getNCharacterStream("foo");
    }

    @Test
    public void testGetNClobInteger() throws Exception {
        try {
            this.delegate.getNClob(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getNClob(1);
    }

    @Test
    public void testGetNClobString() throws Exception {
        try {
            this.delegate.getNClob("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getNClob("foo");
    }

    @Test
    public void testGetNStringInteger() throws Exception {
        try {
            this.delegate.getNString(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getNString(1);
    }

    @Test
    public void testGetNStringString() throws Exception {
        try {
            this.delegate.getNString("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getNString("foo");
    }

    @Test
    public void testGetObjectInteger() throws Exception {
        try {
            this.delegate.getObject(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getObject(1);
    }

    @Test
    public void testGetObjectIntegerClass() throws Exception {
        try {
            this.delegate.getObject(1, Object.class);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getObject(1, Object.class);
    }

    @Test
    public void testGetObjectIntegerMap() throws Exception {
        try {
            this.delegate.getObject(1, (Map)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getObject(1, (Map)null);
    }

    @Test
    public void testGetObjectString() throws Exception {
        try {
            this.delegate.getObject("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getObject("foo");
    }

    @Test
    public void testGetObjectStringClass() throws Exception {
        try {
            this.delegate.getObject("foo", Object.class);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getObject("foo", Object.class);
    }

    @Test
    public void testGetObjectStringMap() throws Exception {
        try {
            this.delegate.getObject("foo", (Map)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getObject("foo", (Map)null);
    }

    @Test
    public void testGetRefInteger() throws Exception {
        try {
            this.delegate.getRef(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getRef(1);
    }

    @Test
    public void testGetRefString() throws Exception {
        try {
            this.delegate.getRef("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getRef("foo");
    }

    @Test
    public void testGetRow() throws Exception {
        try {
            this.delegate.getRow();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getRow();
    }

    @Test
    public void testGetRowIdInteger() throws Exception {
        try {
            this.delegate.getRowId(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getRowId(1);
    }

    @Test
    public void testGetRowIdString() throws Exception {
        try {
            this.delegate.getRowId("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getRowId("foo");
    }

    @Test
    public void testGetShortInteger() throws Exception {
        try {
            this.delegate.getShort(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getShort(1);
    }

    @Test
    public void testGetShortString() throws Exception {
        try {
            this.delegate.getShort("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getShort("foo");
    }

    @Test
    public void testGetSQLXMLInteger() throws Exception {
        try {
            this.delegate.getSQLXML(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getSQLXML(1);
    }

    @Test
    public void testGetSQLXMLString() throws Exception {
        try {
            this.delegate.getSQLXML("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getSQLXML("foo");
    }

    @Test
    public void testGetStatement() throws Exception {
        try {
            this.delegate.getStatement();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)0))).getStatement();
    }

    @Test
    public void testGetStringInteger() throws Exception {
        try {
            this.delegate.getString(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getString(1);
    }

    @Test
    public void testGetStringString() throws Exception {
        try {
            this.delegate.getString("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getString("foo");
    }

    @Test
    public void testGetTimeInteger() throws Exception {
        try {
            this.delegate.getTime(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getTime(1);
    }

    @Test
    public void testGetTimeIntegerCalendar() throws Exception {
        try {
            this.delegate.getTime(1, (Calendar)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getTime(1, (Calendar)null);
    }

    @Test
    public void testGetTimestampInteger() throws Exception {
        try {
            this.delegate.getTimestamp(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getTimestamp(1);
    }

    @Test
    public void testGetTimestampIntegerCalendar() throws Exception {
        try {
            this.delegate.getTimestamp(1, (Calendar)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getTimestamp(1, (Calendar)null);
    }

    @Test
    public void testGetTimestampString() throws Exception {
        try {
            this.delegate.getTimestamp("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getTimestamp("foo");
    }

    @Test
    public void testGetTimestampStringCalendar() throws Exception {
        try {
            this.delegate.getTimestamp("foo", (Calendar)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getTimestamp("foo", (Calendar)null);
    }

    @Test
    public void testGetTimeString() throws Exception {
        try {
            this.delegate.getTime("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getTime("foo");
    }

    @Test
    public void testGetTimeStringCalendar() throws Exception {
        try {
            this.delegate.getTime("foo", (Calendar)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getTime("foo", (Calendar)null);
    }

    @Test
    public void testGetType() throws Exception {
        try {
            this.delegate.getType();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getType();
    }

    @Test
    public void testGetUnicodeStreamInteger() throws Exception {
        try {
            this.delegate.getUnicodeStream(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getUnicodeStream(1);
    }

    @Test
    public void testGetUnicodeStreamString() throws Exception {
        try {
            this.delegate.getUnicodeStream("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getUnicodeStream("foo");
    }

    @Test
    public void testGetURLInteger() throws Exception {
        try {
            this.delegate.getURL(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getURL(1);
    }

    @Test
    public void testGetURLString() throws Exception {
        try {
            this.delegate.getURL("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getURL("foo");
    }

    @Test
    public void testGetWarnings() throws Exception {
        try {
            this.delegate.getWarnings();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).getWarnings();
    }

    @Test
    public void testInsertRow() throws Exception {
        try {
            this.delegate.insertRow();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).insertRow();
    }

    @Test
    public void testIsAfterLast() throws Exception {
        try {
            this.delegate.isAfterLast();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).isAfterLast();
    }

    @Test
    public void testIsBeforeFirst() throws Exception {
        try {
            this.delegate.isBeforeFirst();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).isBeforeFirst();
    }

    @Test
    public void testIsClosed() throws Exception {
        try {
            this.delegate.isClosed();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).isClosed();
    }

    @Test
    public void testIsFirst() throws Exception {
        try {
            this.delegate.isFirst();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).isFirst();
    }

    @Test
    public void testIsLast() throws Exception {
        try {
            this.delegate.isLast();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).isLast();
    }

    @Test
    public void testLast() throws Exception {
        try {
            this.delegate.last();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).last();
    }

    @Test
    public void testMoveToCurrentRow() throws Exception {
        try {
            this.delegate.moveToCurrentRow();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).moveToCurrentRow();
    }

    @Test
    public void testMoveToInsertRow() throws Exception {
        try {
            this.delegate.moveToInsertRow();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).moveToInsertRow();
    }

    @Test
    public void testNext() throws Exception {
        try {
            this.delegate.next();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).next();
    }

    @Test
    public void testPrevious() throws Exception {
        try {
            this.delegate.previous();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).previous();
    }

    @Test
    public void testRefreshRow() throws Exception {
        try {
            this.delegate.refreshRow();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).refreshRow();
    }

    @Test
    public void testRelativeInteger() throws Exception {
        try {
            this.delegate.relative(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).relative(1);
    }

    @Test
    public void testRowDeleted() throws Exception {
        try {
            this.delegate.rowDeleted();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).rowDeleted();
    }

    @Test
    public void testRowInserted() throws Exception {
        try {
            this.delegate.rowInserted();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).rowInserted();
    }

    @Test
    public void testRowUpdated() throws Exception {
        try {
            this.delegate.rowUpdated();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).rowUpdated();
    }

    @Test
    public void testSetFetchDirectionInteger() throws Exception {
        try {
            this.delegate.setFetchDirection(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).setFetchDirection(1);
    }

    @Test
    public void testSetFetchSizeInteger() throws Exception {
        try {
            this.delegate.setFetchSize(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).setFetchSize(1);
    }

    @Test
    public void testToString() {
        String toString = this.delegate.toString();
        Assertions.assertTrue((boolean)toString.contains("DelegatingResultSet"));
        Assertions.assertTrue((boolean)toString.contains("Mock for ResultSet"));
    }

    @Test
    public void testUpdateArrayIntegerArray() throws Exception {
        try {
            this.delegate.updateArray(1, (Array)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateArray(1, (Array)null);
    }

    @Test
    public void testUpdateArrayStringArray() throws Exception {
        try {
            this.delegate.updateArray("foo", (Array)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateArray("foo", (Array)null);
    }

    @Test
    public void testUpdateAsciiStreamIntegerInputStream() throws Exception {
        try {
            this.delegate.updateAsciiStream(1, (InputStream)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateAsciiStream(1, (InputStream)null);
    }

    @Test
    public void testUpdateAsciiStreamIntegerInputStreamInteger() throws Exception {
        try {
            this.delegate.updateAsciiStream(1, (InputStream)null, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateAsciiStream(1, (InputStream)null, 1);
    }

    @Test
    public void testUpdateAsciiStreamIntegerInputStreamLong() throws Exception {
        try {
            this.delegate.updateAsciiStream(1, (InputStream)null, 1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateAsciiStream(1, (InputStream)null, 1L);
    }

    @Test
    public void testUpdateAsciiStreamStringInputStream() throws Exception {
        try {
            this.delegate.updateAsciiStream("foo", (InputStream)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateAsciiStream("foo", (InputStream)null);
    }

    @Test
    public void testUpdateAsciiStreamStringInputStreamInteger() throws Exception {
        try {
            this.delegate.updateAsciiStream("foo", (InputStream)null, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateAsciiStream("foo", (InputStream)null, 1);
    }

    @Test
    public void testUpdateAsciiStreamStringInputStreamLong() throws Exception {
        try {
            this.delegate.updateAsciiStream("foo", (InputStream)null, 1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateAsciiStream("foo", (InputStream)null, 1L);
    }

    @Test
    public void testUpdateBigDecimalIntegerBigDecimal() throws Exception {
        try {
            this.delegate.updateBigDecimal(1, BigDecimal.valueOf(1.0));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateBigDecimal(1, BigDecimal.valueOf(1.0));
    }

    @Test
    public void testUpdateBigDecimalStringBigDecimal() throws Exception {
        try {
            this.delegate.updateBigDecimal("foo", BigDecimal.valueOf(1.0));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateBigDecimal("foo", BigDecimal.valueOf(1.0));
    }

    @Test
    public void testUpdateBinaryStreamIntegerInputStream() throws Exception {
        try {
            this.delegate.updateBinaryStream(1, (InputStream)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateBinaryStream(1, (InputStream)null);
    }

    @Test
    public void testUpdateBinaryStreamIntegerInputStreamInteger() throws Exception {
        try {
            this.delegate.updateBinaryStream(1, (InputStream)null, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateBinaryStream(1, (InputStream)null, 1);
    }

    @Test
    public void testUpdateBinaryStreamIntegerInputStreamLong() throws Exception {
        try {
            this.delegate.updateBinaryStream(1, (InputStream)null, 1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateBinaryStream(1, (InputStream)null, 1L);
    }

    @Test
    public void testUpdateBinaryStreamStringInputStream() throws Exception {
        try {
            this.delegate.updateBinaryStream("foo", (InputStream)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateBinaryStream("foo", (InputStream)null);
    }

    @Test
    public void testUpdateBinaryStreamStringInputStreamInteger() throws Exception {
        try {
            this.delegate.updateBinaryStream("foo", (InputStream)null, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateBinaryStream("foo", (InputStream)null, 1);
    }

    @Test
    public void testUpdateBinaryStreamStringInputStreamLong() throws Exception {
        try {
            this.delegate.updateBinaryStream("foo", (InputStream)null, 1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateBinaryStream("foo", (InputStream)null, 1L);
    }

    @Test
    public void testUpdateBlobIntegerBlob() throws Exception {
        try {
            this.delegate.updateBlob(1, (Blob)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateBlob(1, (Blob)null);
    }

    @Test
    public void testUpdateBlobIntegerInputStream() throws Exception {
        try {
            this.delegate.updateBlob(1, (InputStream)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateBlob(1, (InputStream)null);
    }

    @Test
    public void testUpdateBlobIntegerInputStreamLong() throws Exception {
        try {
            this.delegate.updateBlob(1, (InputStream)null, 1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateBlob(1, (InputStream)null, 1L);
    }

    @Test
    public void testUpdateBlobStringBlob() throws Exception {
        try {
            this.delegate.updateBlob("foo", (Blob)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateBlob("foo", (Blob)null);
    }

    @Test
    public void testUpdateBlobStringInputStream() throws Exception {
        try {
            this.delegate.updateBlob("foo", (InputStream)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateBlob("foo", (InputStream)null);
    }

    @Test
    public void testUpdateBlobStringInputStreamLong() throws Exception {
        try {
            this.delegate.updateBlob("foo", (InputStream)null, 1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateBlob("foo", (InputStream)null, 1L);
    }

    @Test
    public void testUpdateBooleanIntegerBoolean() throws Exception {
        try {
            this.delegate.updateBoolean(1, Boolean.TRUE.booleanValue());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateBoolean(1, (boolean)Boolean.TRUE);
    }

    @Test
    public void testUpdateBooleanStringBoolean() throws Exception {
        try {
            this.delegate.updateBoolean("foo", Boolean.TRUE.booleanValue());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateBoolean("foo", (boolean)Boolean.TRUE);
    }

    @Test
    public void testUpdateByteIntegerByte() throws Exception {
        try {
            this.delegate.updateByte(1, (byte)1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateByte(1, (byte)1);
    }

    @Test
    public void testUpdateBytesIntegerByteArray() throws Exception {
        try {
            this.delegate.updateBytes(1, new byte[]{1});
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateBytes(1, new byte[]{1});
    }

    @Test
    public void testUpdateBytesStringByteArray() throws Exception {
        try {
            this.delegate.updateBytes("foo", new byte[]{1});
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateBytes("foo", new byte[]{1});
    }

    @Test
    public void testUpdateByteStringByte() throws Exception {
        try {
            this.delegate.updateByte("foo", (byte)1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateByte("foo", (byte)1);
    }

    @Test
    public void testUpdateCharacterStreamIntegerReader() throws Exception {
        try {
            this.delegate.updateCharacterStream(1, (Reader)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateCharacterStream(1, (Reader)null);
    }

    @Test
    public void testUpdateCharacterStreamIntegerReaderInteger() throws Exception {
        try {
            this.delegate.updateCharacterStream(1, (Reader)null, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateCharacterStream(1, (Reader)null, 1);
    }

    @Test
    public void testUpdateCharacterStreamIntegerReaderLong() throws Exception {
        try {
            this.delegate.updateCharacterStream(1, (Reader)null, 1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateCharacterStream(1, (Reader)null, 1L);
    }

    @Test
    public void testUpdateCharacterStreamStringReader() throws Exception {
        try {
            this.delegate.updateCharacterStream("foo", (Reader)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateCharacterStream("foo", (Reader)null);
    }

    @Test
    public void testUpdateCharacterStreamStringReaderInteger() throws Exception {
        try {
            this.delegate.updateCharacterStream("foo", (Reader)null, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateCharacterStream("foo", (Reader)null, 1);
    }

    @Test
    public void testUpdateCharacterStreamStringReaderLong() throws Exception {
        try {
            this.delegate.updateCharacterStream("foo", (Reader)null, 1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateCharacterStream("foo", (Reader)null, 1L);
    }

    @Test
    public void testUpdateClobIntegerClob() throws Exception {
        try {
            this.delegate.updateClob(1, (Clob)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateClob(1, (Clob)null);
    }

    @Test
    public void testUpdateClobIntegerReader() throws Exception {
        try {
            this.delegate.updateClob(1, (Reader)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateClob(1, (Reader)null);
    }

    @Test
    public void testUpdateClobIntegerReaderLong() throws Exception {
        try {
            this.delegate.updateClob(1, (Reader)null, 1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateClob(1, (Reader)null, 1L);
    }

    @Test
    public void testUpdateClobStringClob() throws Exception {
        try {
            this.delegate.updateClob("foo", (Clob)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateClob("foo", (Clob)null);
    }

    @Test
    public void testUpdateClobStringReader() throws Exception {
        try {
            this.delegate.updateClob("foo", (Reader)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateClob("foo", (Reader)null);
    }

    @Test
    public void testUpdateClobStringReaderLong() throws Exception {
        try {
            this.delegate.updateClob("foo", (Reader)null, 1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateClob("foo", (Reader)null, 1L);
    }

    @Test
    public void testUpdateDateIntegerSqlDate() throws Exception {
        try {
            this.delegate.updateDate(1, new Date(1529827548745L));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateDate(1, new Date(1529827548745L));
    }

    @Test
    public void testUpdateDateStringSqlDate() throws Exception {
        try {
            this.delegate.updateDate("foo", new Date(1529827548745L));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateDate("foo", new Date(1529827548745L));
    }

    @Test
    public void testUpdateDoubleIntegerDouble() throws Exception {
        try {
            this.delegate.updateDouble(1, 1.0);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateDouble(1, 1.0);
    }

    @Test
    public void testUpdateDoubleStringDouble() throws Exception {
        try {
            this.delegate.updateDouble("foo", 1.0);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateDouble("foo", 1.0);
    }

    @Test
    public void testUpdateFloatIntegerFloat() throws Exception {
        try {
            this.delegate.updateFloat(1, 1.0f);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateFloat(1, 1.0f);
    }

    @Test
    public void testUpdateFloatStringFloat() throws Exception {
        try {
            this.delegate.updateFloat("foo", 1.0f);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateFloat("foo", 1.0f);
    }

    @Test
    public void testUpdateIntIntegerInteger() throws Exception {
        try {
            this.delegate.updateInt(1, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateInt(1, 1);
    }

    @Test
    public void testUpdateIntStringInteger() throws Exception {
        try {
            this.delegate.updateInt("foo", 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateInt("foo", 1);
    }

    @Test
    public void testUpdateLongIntegerLong() throws Exception {
        try {
            this.delegate.updateLong(1, 1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateLong(1, 1L);
    }

    @Test
    public void testUpdateLongStringLong() throws Exception {
        try {
            this.delegate.updateLong("foo", 1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateLong("foo", 1L);
    }

    @Test
    public void testUpdateNCharacterStreamIntegerReader() throws Exception {
        try {
            this.delegate.updateNCharacterStream(1, (Reader)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateNCharacterStream(1, (Reader)null);
    }

    @Test
    public void testUpdateNCharacterStreamIntegerReaderLong() throws Exception {
        try {
            this.delegate.updateNCharacterStream(1, (Reader)null, 1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateNCharacterStream(1, (Reader)null, 1L);
    }

    @Test
    public void testUpdateNCharacterStreamStringReader() throws Exception {
        try {
            this.delegate.updateNCharacterStream("foo", (Reader)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateNCharacterStream("foo", (Reader)null);
    }

    @Test
    public void testUpdateNCharacterStreamStringReaderLong() throws Exception {
        try {
            this.delegate.updateNCharacterStream("foo", (Reader)null, 1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateNCharacterStream("foo", (Reader)null, 1L);
    }

    @Test
    public void testUpdateNClobIntegerNClob() throws Exception {
        try {
            this.delegate.updateNClob(1, (NClob)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateNClob(1, (NClob)null);
    }

    @Test
    public void testUpdateNClobIntegerReader() throws Exception {
        try {
            this.delegate.updateNClob(1, (Reader)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateNClob(1, (Reader)null);
    }

    @Test
    public void testUpdateNClobIntegerReaderLong() throws Exception {
        try {
            this.delegate.updateNClob(1, (Reader)null, 1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateNClob(1, (Reader)null, 1L);
    }

    @Test
    public void testUpdateNClobStringNClob() throws Exception {
        try {
            this.delegate.updateNClob("foo", (NClob)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateNClob("foo", (NClob)null);
    }

    @Test
    public void testUpdateNClobStringReader() throws Exception {
        try {
            this.delegate.updateNClob("foo", (Reader)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateNClob("foo", (Reader)null);
    }

    @Test
    public void testUpdateNClobStringReaderLong() throws Exception {
        try {
            this.delegate.updateNClob("foo", (Reader)null, 1L);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateNClob("foo", (Reader)null, 1L);
    }

    @Test
    public void testUpdateNStringIntegerString() throws Exception {
        try {
            this.delegate.updateNString(1, "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateNString(1, "foo");
    }

    @Test
    public void testUpdateNStringStringString() throws Exception {
        try {
            this.delegate.updateNString("foo", "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateNString("foo", "foo");
    }

    @Test
    public void testUpdateNullInteger() throws Exception {
        try {
            this.delegate.updateNull(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateNull(1);
    }

    @Test
    public void testUpdateNullString() throws Exception {
        try {
            this.delegate.updateNull("foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateNull("foo");
    }

    @Test
    public void testUpdateObjectIntegerObject() throws Exception {
        try {
            this.delegate.updateObject(1, (Object)System.err);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateObject(1, (Object)System.err);
    }

    @Disabled
    @Test
    public void testUpdateObjectIntegerObjectInteger() throws Exception {
        try {
            this.delegate.updateObject(1, (Object)System.err, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateObject(1, (Object)System.err, 1);
    }

    @Test
    public void testUpdateObjectIntegerObjectSQLType() throws Exception {
        try {
            this.delegate.updateObject(1, (Object)System.err, (SQLType)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateObject(1, (Object)System.err, (SQLType)null);
    }

    @Test
    public void testUpdateObjectIntegerObjectSQLTypeInteger() throws Exception {
        try {
            this.delegate.updateObject(1, (Object)System.err, (SQLType)null, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateObject(1, (Object)System.err, (SQLType)null, 1);
    }

    @Test
    public void testUpdateObjectStringObject() throws Exception {
        try {
            this.delegate.updateObject("foo", (Object)System.err);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateObject("foo", (Object)System.err);
    }

    @Disabled
    @Test
    public void testUpdateObjectStringObjectInteger() throws Exception {
        try {
            this.delegate.updateObject("foo", (Object)System.err, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateObject("foo", (Object)System.err, 1);
    }

    @Test
    public void testUpdateObjectStringObjectSQLType() throws Exception {
        try {
            this.delegate.updateObject("foo", (Object)System.err, (SQLType)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateObject("foo", (Object)System.err, (SQLType)null);
    }

    @Test
    public void testUpdateObjectStringObjectSQLTypeInteger() throws Exception {
        try {
            this.delegate.updateObject("foo", (Object)System.err, (SQLType)null, 1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateObject("foo", (Object)System.err, (SQLType)null, 1);
    }

    @Test
    public void testUpdateRefIntegerRef() throws Exception {
        try {
            this.delegate.updateRef(1, (Ref)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateRef(1, (Ref)null);
    }

    @Test
    public void testUpdateRefStringRef() throws Exception {
        try {
            this.delegate.updateRef("foo", (Ref)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateRef("foo", (Ref)null);
    }

    @Test
    public void testUpdateRow() throws Exception {
        try {
            this.delegate.updateRow();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateRow();
    }

    @Test
    public void testUpdateRowIdIntegerRowId() throws Exception {
        try {
            this.delegate.updateRowId(1, (RowId)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateRowId(1, (RowId)null);
    }

    @Test
    public void testUpdateRowIdStringRowId() throws Exception {
        try {
            this.delegate.updateRowId("foo", (RowId)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateRowId("foo", (RowId)null);
    }

    @Test
    public void testUpdateShortIntegerShort() throws Exception {
        try {
            this.delegate.updateShort(1, (short)1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateShort(1, (short)1);
    }

    @Test
    public void testUpdateShortStringShort() throws Exception {
        try {
            this.delegate.updateShort("foo", (short)1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateShort("foo", (short)1);
    }

    @Test
    public void testUpdateSQLXMLIntegerSQLXML() throws Exception {
        try {
            this.delegate.updateSQLXML(1, (SQLXML)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateSQLXML(1, (SQLXML)null);
    }

    @Test
    public void testUpdateSQLXMLStringSQLXML() throws Exception {
        try {
            this.delegate.updateSQLXML("foo", (SQLXML)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateSQLXML("foo", (SQLXML)null);
    }

    @Test
    public void testUpdateStringIntegerString() throws Exception {
        try {
            this.delegate.updateString(1, "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateString(1, "foo");
    }

    @Test
    public void testUpdateStringStringString() throws Exception {
        try {
            this.delegate.updateString("foo", "foo");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateString("foo", "foo");
    }

    @Test
    public void testUpdateTimeIntegerTime() throws Exception {
        try {
            this.delegate.updateTime(1, (Time)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateTime(1, (Time)null);
    }

    @Test
    public void testUpdateTimestampIntegerTimestamp() throws Exception {
        try {
            this.delegate.updateTimestamp(1, (Timestamp)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateTimestamp(1, (Timestamp)null);
    }

    @Test
    public void testUpdateTimestampStringTimestamp() throws Exception {
        try {
            this.delegate.updateTimestamp("foo", (Timestamp)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateTimestamp("foo", (Timestamp)null);
    }

    @Test
    public void testUpdateTimeStringTime() throws Exception {
        try {
            this.delegate.updateTime("foo", (Time)null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).updateTime("foo", (Time)null);
    }

    @Test
    public void testWasNull() throws Exception {
        try {
            this.delegate.wasNull();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ResultSet)Mockito.verify((Object)this.rs, (VerificationMode)Mockito.times((int)1))).wasNull();
    }

    @Test
    public void testWrap() throws SQLException {
        DelegatingResultSet delegate = (DelegatingResultSet)DelegatingResultSet.wrapResultSet(this.conn, (ResultSet)this.rs);
        Assertions.assertEquals((Object)delegate, (Object)delegate.unwrap(ResultSet.class));
        Assertions.assertEquals((Object)delegate, (Object)delegate.unwrap(DelegatingResultSet.class));
        Assertions.assertEquals((Object)this.rs, (Object)delegate.unwrap(this.rs.getClass()));
        Assertions.assertNull((Object)delegate.unwrap(String.class));
        Assertions.assertTrue((boolean)delegate.isWrapperFor(ResultSet.class));
        Assertions.assertTrue((boolean)delegate.isWrapperFor(DelegatingResultSet.class));
        Assertions.assertTrue((boolean)delegate.isWrapperFor(this.rs.getClass()));
        Assertions.assertFalse((boolean)delegate.isWrapperFor(String.class));
    }
}

