/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.datasources;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.util.ArrayList;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.DelegatingStatement;
import org.apache.commons.dbcp2.TestConnectionPool;
import org.apache.commons.dbcp2.TesterDriver;
import org.apache.commons.dbcp2.cpdsadapter.DriverAdapterCPDS;
import org.apache.commons.dbcp2.datasources.SharedPoolDataSource;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestSharedPoolDataSource
extends TestConnectionPool {
    private DriverAdapterCPDS pcds;
    private DataSource ds;

    private void doTestPoolCallableStatements(AbstractPrepareCallCallback callBack) throws Exception {
        DriverAdapterCPDS myPcds = new DriverAdapterCPDS();
        myPcds.setDriver("org.apache.commons.dbcp2.TesterDriver");
        myPcds.setUrl("jdbc:apache:commons:testdriver");
        myPcds.setUser("foo");
        myPcds.setPassword("bar");
        myPcds.setPoolPreparedStatements(true);
        myPcds.setMaxPreparedStatements(10);
        try (SharedPoolDataSource spDs = new SharedPoolDataSource();){
            ResultSet rset;
            CallableStatement stmt;
            spDs.setConnectionPoolDataSource((ConnectionPoolDataSource)myPcds);
            spDs.setMaxTotal(this.getMaxTotal());
            spDs.setDefaultMaxWait(this.getMaxWaitDuration());
            spDs.setDefaultTransactionIsolation(2);
            SharedPoolDataSource myDs = spDs;
            try (Connection conn = this.ds.getConnection();){
                long l2HashCode;
                long l1HashCode;
                callBack.setConnection(conn);
                Assertions.assertNotNull((Object)conn);
                stmt = callBack.getCallableStatement();
                try {
                    Assertions.assertNotNull((Object)stmt);
                    l1HashCode = this.getDelegateHashCode(stmt);
                    rset = stmt.executeQuery();
                    try {
                        Assertions.assertNotNull((Object)rset);
                        Assertions.assertTrue((boolean)rset.next());
                    }
                    finally {
                        if (rset != null) {
                            rset.close();
                        }
                    }
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                stmt = callBack.getCallableStatement();
                try {
                    Assertions.assertNotNull((Object)stmt);
                    l2HashCode = this.getDelegateHashCode(stmt);
                    rset = stmt.executeQuery();
                    try {
                        Assertions.assertNotNull((Object)rset);
                        Assertions.assertTrue((boolean)rset.next());
                    }
                    finally {
                        if (rset != null) {
                            rset.close();
                        }
                    }
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                Assertions.assertTrue((l1HashCode != l2HashCode ? 1 : 0) != 0);
            }
            conn = myDs.getConnection();
            try {
                long l4HashCode;
                long l3HashCode;
                callBack.setConnection(conn);
                stmt = callBack.getCallableStatement();
                try {
                    Assertions.assertNotNull((Object)stmt);
                    l3HashCode = this.getDelegateHashCode(stmt);
                    rset = stmt.executeQuery();
                    try {
                        Assertions.assertNotNull((Object)rset);
                        Assertions.assertTrue((boolean)rset.next());
                    }
                    finally {
                        if (rset != null) {
                            rset.close();
                        }
                    }
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                stmt = callBack.getCallableStatement();
                try {
                    Assertions.assertNotNull((Object)stmt);
                    l4HashCode = this.getDelegateHashCode(stmt);
                    rset = stmt.executeQuery();
                    try {
                        Assertions.assertNotNull((Object)rset);
                        Assertions.assertTrue((boolean)rset.next());
                    }
                    finally {
                        if (rset != null) {
                            rset.close();
                        }
                    }
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                Assertions.assertEquals((long)l3HashCode, (long)l4HashCode);
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
    }

    private void doTestPoolPreparedStatements(AbstractPrepareStatementCallback psCallBack) throws Exception {
        DriverAdapterCPDS mypcds = new DriverAdapterCPDS();
        mypcds.setDriver("org.apache.commons.dbcp2.TesterDriver");
        mypcds.setUrl("jdbc:apache:commons:testdriver");
        mypcds.setUser("foo");
        mypcds.setPassword("bar");
        mypcds.setPoolPreparedStatements(true);
        mypcds.setMaxPreparedStatements(10);
        try (SharedPoolDataSource tds = new SharedPoolDataSource();){
            ResultSet resultSet;
            PreparedStatement stmt;
            tds.setConnectionPoolDataSource((ConnectionPoolDataSource)mypcds);
            tds.setMaxTotal(this.getMaxTotal());
            tds.setDefaultMaxWait(this.getMaxWaitDuration());
            tds.setDefaultTransactionIsolation(2);
            SharedPoolDataSource myDs = tds;
            try (Connection conn = this.ds.getConnection();){
                long l2HashCode;
                long l1HashCode;
                Assertions.assertNotNull((Object)conn);
                psCallBack.setConnection(conn);
                stmt = psCallBack.prepareStatement();
                try {
                    Assertions.assertNotNull((Object)stmt);
                    l1HashCode = this.getDelegateHashCode(stmt);
                    resultSet = stmt.executeQuery();
                    try {
                        Assertions.assertNotNull((Object)resultSet);
                        Assertions.assertTrue((boolean)resultSet.next());
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                stmt = psCallBack.prepareStatement();
                try {
                    Assertions.assertNotNull((Object)stmt);
                    l2HashCode = this.getDelegateHashCode(stmt);
                    resultSet = stmt.executeQuery();
                    try {
                        Assertions.assertNotNull((Object)resultSet);
                        Assertions.assertTrue((boolean)resultSet.next());
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                Assertions.assertTrue((l1HashCode != l2HashCode ? 1 : 0) != 0);
            }
            conn = myDs.getConnection();
            try {
                long l4HashCode;
                long l3HashCode;
                Assertions.assertNotNull((Object)conn);
                psCallBack.setConnection(conn);
                stmt = psCallBack.prepareStatement();
                try {
                    Assertions.assertNotNull((Object)stmt);
                    l3HashCode = this.getDelegateHashCode(stmt);
                    resultSet = stmt.executeQuery();
                    try {
                        Assertions.assertNotNull((Object)resultSet);
                        Assertions.assertTrue((boolean)resultSet.next());
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                stmt = psCallBack.prepareStatement();
                try {
                    Assertions.assertNotNull((Object)stmt);
                    l4HashCode = this.getDelegateHashCode(stmt);
                    resultSet = stmt.executeQuery();
                    try {
                        Assertions.assertNotNull((Object)resultSet);
                        Assertions.assertTrue((boolean)resultSet.next());
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                Assertions.assertEquals((long)l3HashCode, (long)l4HashCode);
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
    }

    @Override
    protected Connection getConnection() throws Exception {
        return this.ds.getConnection("foo", "bar");
    }

    private int getDelegateHashCode(Statement stmt) {
        return ((DelegatingStatement)stmt).getDelegate().hashCode();
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.pcds = new DriverAdapterCPDS();
        this.pcds.setDriver("org.apache.commons.dbcp2.TesterDriver");
        this.pcds.setUrl("jdbc:apache:commons:testdriver");
        this.pcds.setUser("foo");
        this.pcds.setPassword("bar");
        this.pcds.setPoolPreparedStatements(false);
        this.pcds.setAccessToUnderlyingConnectionAllowed(true);
        SharedPoolDataSource tds = new SharedPoolDataSource();
        tds.setConnectionPoolDataSource((ConnectionPoolDataSource)this.pcds);
        tds.setMaxTotal(this.getMaxTotal());
        tds.setDefaultMaxWait(this.getMaxWaitDuration());
        tds.setDefaultTransactionIsolation(2);
        tds.setDefaultAutoCommit(Boolean.TRUE);
        this.ds = tds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChangePassword() throws Exception {
        Assertions.assertThrows(SQLException.class, () -> this.ds.getConnection("foo", "bay"));
        Connection con1 = this.ds.getConnection("foo", "bar");
        Connection con2 = this.ds.getConnection("foo", "bar");
        Connection con3 = this.ds.getConnection("foo", "bar");
        con1.close();
        con2.close();
        TesterDriver.addUser("foo", "bay");
        try (Connection con4 = this.ds.getConnection("foo", "bay");){
            Assertions.assertEquals((int)0, (int)((SharedPoolDataSource)this.ds).getNumIdle(), (String)"Should be no idle connections in the pool");
            con4.close();
            Assertions.assertEquals((int)1, (int)((SharedPoolDataSource)this.ds).getNumIdle(), (String)"Should be one idle connection in the pool");
            Assertions.assertThrows(SQLException.class, () -> this.ds.getConnection("foo", "bar"));
            try (Connection con5 = this.ds.getConnection("foo", "bay");){
                con3.close();
                this.ds.getConnection("foo", "bay").close();
                Assertions.assertEquals((int)1, (int)((SharedPoolDataSource)this.ds).getNumIdle(), (String)"Should be one idle connection in the pool");
            }
        }
        finally {
            TesterDriver.addUser("foo", "bar");
        }
    }

    @Test
    public void testClosePool() throws Exception {
        ((SharedPoolDataSource)this.ds).close();
        SharedPoolDataSource tds = new SharedPoolDataSource();
        tds.close();
    }

    @Override
    @Test
    public void testClosing() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.ds.getConnection();
        }
        c[0].close();
        Assertions.assertTrue((boolean)c[0].isClosed());
        c[0] = this.ds.getConnection();
        for (Connection element : c) {
            element.close();
        }
    }

    @Test
    public void testClosingWithUserName() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.ds.getConnection("u1", "p1");
        }
        c[0].close();
        Assertions.assertTrue((boolean)c[0].isClosed());
        c[0] = this.ds.getConnection("u1", "p1");
        for (Connection element : c) {
            element.close();
        }
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.ds.getConnection("u1", "p1");
        }
        for (Connection element : c) {
            element.close();
        }
    }

    @Test
    public void testDbcp369() {
        ArrayList<SharedPoolDataSource> dataSources = new ArrayList<SharedPoolDataSource>();
        for (int j = 0; j < 10000; ++j) {
            dataSources.add(new SharedPoolDataSource());
        }
        Thread t1 = new Thread(() -> {
            for (SharedPoolDataSource dataSource : dataSources) {
                dataSource.setDataSourceName("a");
            }
        });
        Thread t2 = new Thread(() -> {
            for (SharedPoolDataSource dataSource : dataSources) {
                try {
                    dataSource.close();
                }
                catch (Exception exception) {}
            }
        });
        t1.start();
        t2.start();
        try {
            t1.join();
            t2.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Test
    public void testIncorrectPassword() throws SQLException {
        Connection c2;
        block33: {
            this.ds.getConnection("u2", "p2").close();
            try {
                c2 = this.ds.getConnection("u1", "zlsafjk");
                try {
                    Assertions.fail((String)"Able to retrieve connection with incorrect password");
                }
                finally {
                    if (c2 != null) {
                        c2.close();
                    }
                }
            }
            catch (SQLException c2) {
                // empty catch block
            }
            this.ds.getConnection("u1", "p1").close();
            try {
                c2 = this.ds.getConnection("u1", "x");
                try {
                    Assertions.fail((String)"Able to retrieve connection with incorrect password");
                }
                finally {
                    if (c2 != null) {
                        c2.close();
                    }
                }
            }
            catch (SQLException e) {
                if (e.getMessage().startsWith("Given password did not match")) break block33;
                throw e;
            }
        }
        this.ds.getConnection("u1", "p1").close();
        this.ds.getConnection("foo", "bar").close();
        try {
            c2 = this.ds.getConnection("u1", "ar");
            try {
                Assertions.fail((String)"Should have caused an SQLException");
            }
            finally {
                if (c2 != null) {
                    c2.close();
                }
            }
        }
        catch (SQLException c3) {
            // empty catch block
        }
        try {
            c2 = this.ds.getConnection("u1", "baz");
            try {
                Assertions.fail((String)"Should have generated SQLException");
            }
            finally {
                if (c2 != null) {
                    c2.close();
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    @Test
    public void testMaxTotal() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.ds.getConnection();
            Assertions.assertNotNull((Object)c[i]);
        }
        Assertions.assertThrows(SQLException.class, this.ds::getConnection, (String)"Allowed to open more than DefaultMaxTotal connections.");
        for (Connection element : c) {
            element.close();
        }
    }

    @Test
    public void testMaxWaitMillis() throws Exception {
        int maxWaitMillis = 1000;
        int theadCount = 20;
        ((SharedPoolDataSource)this.ds).setDefaultMaxWait(Duration.ofMillis(1000L));
        Connection[] c = new Connection[this.getMaxTotal()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.ds.getConnection("foo", "bar");
            Assertions.assertNotNull((Object)c[i]);
        }
        long startMillis = System.currentTimeMillis();
        TestConnectionPool.PoolTest[] pts = new TestConnectionPool.PoolTest[20];
        ThreadGroup threadGroup = new ThreadGroup("testMaxWaitMillis");
        for (int i = 0; i < pts.length; ++i) {
            pts[i] = new TestConnectionPool.PoolTest(threadGroup, Duration.ofMillis(1L), true);
            pts[i].start();
        }
        for (TestConnectionPool.PoolTest poolTest : pts) {
            poolTest.getThread().join();
        }
        long endMillis = System.currentTimeMillis();
        Assertions.assertTrue((endMillis - startMillis < 2000L ? 1 : 0) != 0);
        for (Connection element : c) {
            element.close();
        }
    }

    @Test
    public void testMultipleThreads1() throws Exception {
        Duration defaultMaxWaitDuration = Duration.ofMillis(430L);
        ((SharedPoolDataSource)this.ds).setDefaultMaxWait(defaultMaxWaitDuration);
        this.multipleThreads(Duration.ofMillis(1L), false, false, defaultMaxWaitDuration);
    }

    @Test
    public void testMultipleThreads2() throws Exception {
        Duration defaultMaxWaitDuration = Duration.ofMillis(500L);
        ((SharedPoolDataSource)this.ds).setDefaultMaxWait(defaultMaxWaitDuration);
        this.multipleThreads(defaultMaxWaitDuration.multipliedBy(2L), true, true, defaultMaxWaitDuration);
    }

    @Override
    @Test
    public void testOpening() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.ds.getConnection();
            Assertions.assertNotNull((Object)c[i]);
            for (int j = 0; j <= i; ++j) {
                Assertions.assertFalse((boolean)c[j].isClosed());
            }
        }
        for (Connection element : c) {
            element.close();
        }
    }

    @Test
    public void testPoolPrepareCall() throws SQLException {
        this.pcds.setPoolPreparedStatements(true);
        try (Connection conn = this.ds.getConnection();){
            Assertions.assertNotNull((Object)conn);
            try (CallableStatement stmt = conn.prepareCall("{call home()}");){
                Assertions.assertNotNull((Object)stmt);
                try (ResultSet rset = stmt.executeQuery();){
                    Assertions.assertNotNull((Object)rset);
                    Assertions.assertTrue((boolean)rset.next());
                }
            }
        }
    }

    @Test
    public void testPoolPreparedCalls() throws Exception {
        this.doTestPoolCallableStatements(new CscbString());
        this.doTestPoolCallableStatements(new CscbStringIntInt());
        this.doTestPoolCallableStatements(new CscbStringIntIntInt());
    }

    @Test
    public void testPoolPreparedStatements() throws Exception {
        this.doTestPoolPreparedStatements(new PscbString());
        this.doTestPoolPreparedStatements(new PscbStringIntInt());
        this.doTestPoolPreparedStatements(new PscbStringInt());
        this.doTestPoolPreparedStatements(new PscbStringIntArray());
        this.doTestPoolPreparedStatements(new PscbStringStringArray());
        this.doTestPoolPreparedStatements(new PscbStringIntIntInt());
    }

    @Test
    public void testPoolPrepareStatement() throws SQLException {
        this.pcds.setPoolPreparedStatements(true);
        try (Connection conn = this.ds.getConnection();){
            Assertions.assertNotNull((Object)conn);
            try (PreparedStatement stmt = conn.prepareStatement("select * from dual");){
                Assertions.assertNotNull((Object)stmt);
                try (ResultSet rset = stmt.executeQuery();){
                    Assertions.assertNotNull((Object)rset);
                    Assertions.assertTrue((boolean)rset.next());
                }
            }
        }
    }

    @Override
    @Test
    public void testSimple() throws Exception {
        try (Connection conn = this.ds.getConnection();){
            Assertions.assertNotNull((Object)conn);
            try (PreparedStatement stmt = conn.prepareStatement("select * from dual");){
                Assertions.assertNotNull((Object)stmt);
                try (ResultSet rset = stmt.executeQuery();){
                    Assertions.assertNotNull((Object)rset);
                    Assertions.assertTrue((boolean)rset.next());
                }
            }
        }
    }

    @Override
    @Test
    public void testSimple2() throws SQLException {
        ResultSet rset;
        Connection conn = this.ds.getConnection();
        Assertions.assertNotNull((Object)conn);
        try (PreparedStatement stmt = conn.prepareStatement("select * from dual");){
            Assertions.assertNotNull((Object)stmt);
            rset = stmt.executeQuery();
            try {
                Assertions.assertNotNull((Object)rset);
                Assertions.assertTrue((boolean)rset.next());
            }
            finally {
                if (rset != null) {
                    rset.close();
                }
            }
        }
        stmt = conn.prepareStatement("select * from dual");
        try {
            Assertions.assertNotNull((Object)stmt);
            rset = stmt.executeQuery();
            try {
                Assertions.assertNotNull((Object)rset);
                Assertions.assertTrue((boolean)rset.next());
            }
            finally {
                if (rset != null) {
                    rset.close();
                }
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        conn.close();
        Assertions.assertThrows(SQLException.class, () -> conn.createStatement(), (String)"Can't use closed connections");
        conn = this.ds.getConnection();
        try {
            Assertions.assertNotNull((Object)conn);
            stmt = conn.prepareStatement("select * from dual");
            try {
                Assertions.assertNotNull((Object)stmt);
                rset = stmt.executeQuery();
                try {
                    Assertions.assertNotNull((Object)rset);
                    Assertions.assertTrue((boolean)rset.next());
                }
                finally {
                    if (rset != null) {
                        rset.close();
                    }
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
            stmt = conn.prepareStatement("select * from dual");
            try {
                Assertions.assertNotNull((Object)stmt);
                rset = stmt.executeQuery();
                try {
                    Assertions.assertNotNull((Object)rset);
                    Assertions.assertTrue((boolean)rset.next());
                }
                finally {
                    if (rset != null) {
                        rset.close();
                    }
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Test
    public void testSimpleWithUsername() throws Exception {
        try (Connection conn = this.ds.getConnection("u1", "p1");){
            Assertions.assertNotNull((Object)conn);
            try (PreparedStatement stmt = conn.prepareStatement("select * from dual");){
                Assertions.assertNotNull((Object)stmt);
                try (ResultSet rset = stmt.executeQuery();){
                    Assertions.assertNotNull((Object)rset);
                    Assertions.assertTrue((boolean)rset.next());
                }
            }
        }
    }

    @Test
    public void testTransactionIsolationBehavior() throws Exception {
        try (Connection conn = this.getConnection();){
            Assertions.assertNotNull((Object)conn);
            Assertions.assertEquals((int)2, (int)conn.getTransactionIsolation());
            conn.setTransactionIsolation(1);
        }
        Connection conn2 = this.getConnection();
        Assertions.assertEquals((int)2, (int)conn2.getTransactionIsolation());
        Connection conn3 = this.getConnection();
        Assertions.assertEquals((int)2, (int)conn3.getTransactionIsolation());
        conn2.close();
        conn3.close();
    }

    private static abstract class AbstractPrepareCallCallback {
        protected Connection conn;

        private AbstractPrepareCallCallback() {
        }

        abstract CallableStatement getCallableStatement() throws SQLException;

        void setConnection(Connection conn) {
            this.conn = conn;
        }
    }

    private static abstract class AbstractPrepareStatementCallback {
        protected Connection conn;

        private AbstractPrepareStatementCallback() {
        }

        abstract PreparedStatement prepareStatement() throws SQLException;

        void setConnection(Connection conn) {
            this.conn = conn;
        }
    }

    private static final class CscbString
    extends AbstractPrepareCallCallback {
        private CscbString() {
        }

        @Override
        CallableStatement getCallableStatement() throws SQLException {
            return this.conn.prepareCall("{call home()}");
        }
    }

    private static final class CscbStringIntInt
    extends AbstractPrepareCallCallback {
        private CscbStringIntInt() {
        }

        @Override
        CallableStatement getCallableStatement() throws SQLException {
            return this.conn.prepareCall("{call home()}", 0, 0);
        }
    }

    private static final class CscbStringIntIntInt
    extends AbstractPrepareCallCallback {
        private CscbStringIntIntInt() {
        }

        @Override
        CallableStatement getCallableStatement() throws SQLException {
            return this.conn.prepareCall("{call home()}", 0, 0, 0);
        }
    }

    private static final class PscbString
    extends AbstractPrepareStatementCallback {
        private PscbString() {
        }

        @Override
        PreparedStatement prepareStatement() throws SQLException {
            return this.conn.prepareStatement("select * from dual");
        }
    }

    private static final class PscbStringIntInt
    extends AbstractPrepareStatementCallback {
        private PscbStringIntInt() {
        }

        @Override
        PreparedStatement prepareStatement() throws SQLException {
            return this.conn.prepareStatement("select * from dual", 0, 0);
        }
    }

    private static final class PscbStringInt
    extends AbstractPrepareStatementCallback {
        private PscbStringInt() {
        }

        @Override
        PreparedStatement prepareStatement() throws SQLException {
            return this.conn.prepareStatement("select * from dual", 0);
        }
    }

    private static final class PscbStringIntArray
    extends AbstractPrepareStatementCallback {
        private PscbStringIntArray() {
        }

        @Override
        PreparedStatement prepareStatement() throws SQLException {
            return this.conn.prepareStatement("select * from dual", ArrayUtils.EMPTY_INT_ARRAY);
        }
    }

    private static final class PscbStringStringArray
    extends AbstractPrepareStatementCallback {
        private PscbStringStringArray() {
        }

        @Override
        PreparedStatement prepareStatement() throws SQLException {
            return this.conn.prepareStatement("select * from dual", ArrayUtils.EMPTY_STRING_ARRAY);
        }
    }

    private static final class PscbStringIntIntInt
    extends AbstractPrepareStatementCallback {
        private PscbStringIntIntInt() {
        }

        @Override
        PreparedStatement prepareStatement() throws SQLException {
            return this.conn.prepareStatement("select * from dual", 0, 0, 0);
        }
    }
}

