/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.commons.jxpath.issues;

import static org.junit.jupiter.api.Assertions.assertEquals;

import java.util.Iterator;

import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.junit.jupiter.api.Test;

/**
 * Testcase proving JXPATH-118 issue with asPath() returning wrong names.
 */
public class JXPath118Test {

    public static class SomeChildClass {

        private int foo = 1;
        private int bar = 2;
        private int baz = 3;

        public int getBar() {
            return bar;
        }

        public int getBaz() {
            return baz;
        }

        public int getFoo() {
            return foo;
        }

        public void setBar(final int bar) {
            this.bar = bar;
        }

        public void setBaz(final int baz) {
            this.baz = baz;
        }

        public void setFoo(final int foo) {
            this.foo = foo;
        }
    }

    @Test
    public void testJXPATH118IssueWithAsPath() throws Exception {
        final Object contextBean = new SomeChildClass();
        final JXPathContext context = JXPathContext.newContext(contextBean);
        final Iterator<Pointer> iteratePointers = context.iteratePointers("//*");
        assertEquals("/bar", iteratePointers.next().asPath());
        assertEquals("/baz", iteratePointers.next().asPath());
        assertEquals("/foo", iteratePointers.next().asPath());
    }
}
