/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.commandline;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.AlreadySelectedException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DeprecatedAttributes;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.function.IOSupplier;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.rat.ConfigurationException;
import org.apache.rat.Defaults;
import org.apache.rat.ReportConfiguration;
import org.apache.rat.commandline.ArgumentContext;
import org.apache.rat.commandline.Converters;
import org.apache.rat.commandline.StyleSheets;
import org.apache.rat.config.AddLicenseHeaders;
import org.apache.rat.config.exclusion.ExclusionUtils;
import org.apache.rat.config.exclusion.StandardCollection;
import org.apache.rat.document.DocumentNameMatcher;
import org.apache.rat.license.LicenseSetFactory;
import org.apache.rat.report.claim.ClaimStatistic;
import org.apache.rat.utils.DefaultLog;
import org.apache.rat.utils.Log;

public enum Arg {
    EDIT_COPYRIGHT(new OptionGroup().addOption(Option.builder("c").longOpt("copyright").hasArg().deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("0.17").setDescription(StdMsgs.useMsg("--edit-copyright")).get()).desc("The copyright message to use in the license headers.").build()).addOption(Option.builder().longOpt("edit-copyright").hasArg().desc("The copyright message to use in the license headers. Usually in the form of \"Copyright 2008 Foo\".  Only valid with --edit-license").build())),
    EDIT_OVERWRITE(new OptionGroup().addOption(Option.builder("f").longOpt("force").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("0.17").setDescription(StdMsgs.useMsg("--edit-overwrite")).get()).desc("Forces any changes in files to be written directly to the source files so that new files are not created.").build()).addOption(Option.builder().longOpt("edit-overwrite").desc("Forces any changes in files to be written directly to the source files so that new files are not created. Only valid with --edit-license.").build())),
    EDIT_ADD(new OptionGroup().addOption(Option.builder("a").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("0.17").setDescription(StdMsgs.useMsg("--edit-license")).get()).build()).addOption(Option.builder("A").longOpt("addLicense").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("0.17").setDescription(StdMsgs.useMsg("--edit-license")).get()).desc("Add the Apache-2.0 license header to any file with an unknown license that is not in the exclusion list.").build()).addOption(Option.builder().longOpt("edit-license").desc("Add the Apache-2.0 license header to any file with an unknown license that is not in the exclusion list. By default new files will be created with the license header, to force the modification of existing files use the --edit-overwrite option.").build())),
    CONFIGURATION(new OptionGroup().addOption(Option.builder().longOpt("config").hasArgs().argName("File").desc("File names for system configuration.").converter(Converters.FILE_CONVERTER).type(File.class).build()).addOption(Option.builder().longOpt("licenses").hasArgs().argName("File").desc("File names for system configuration.").deprecated(DeprecatedAttributes.builder().setSince("0.17").setForRemoval(true).setDescription(StdMsgs.useMsg("--config")).get()).converter(Converters.FILE_CONVERTER).type(File.class).build())),
    CONFIGURATION_NO_DEFAULTS(new OptionGroup().addOption(Option.builder().longOpt("configuration-no-defaults").desc("Ignore default configuration.").build()).addOption(Option.builder().longOpt("no-default-licenses").deprecated(DeprecatedAttributes.builder().setSince("0.17").setForRemoval(true).setDescription(StdMsgs.useMsg("--configuration-no-defaults")).get()).desc("Ignore default configuration.").build())),
    LICENSES_APPROVED(new OptionGroup().addOption(Option.builder().longOpt("licenses-approved").hasArg().argName("LicenseID").desc("A comma separated list of approved License IDs. These licenses will be added to the list of approved licenses.").converter(Converters.TEXT_LIST_CONVERTER).type(String[].class).build())),
    LICENSES_APPROVED_FILE(new OptionGroup().addOption(Option.builder().longOpt("licenses-approved-file").hasArg().argName("File").desc("Name of file containing comma separated lists of approved License IDs.").converter(Converters.FILE_CONVERTER).type(File.class).build())),
    FAMILIES_APPROVED(new OptionGroup().addOption(Option.builder().longOpt("license-families-approved").hasArg().argName("FamilyID").desc("A comma separated list of approved license family IDs. These license families will be added to the list of approved license families.").converter(Converters.TEXT_LIST_CONVERTER).type(String[].class).build())),
    FAMILIES_APPROVED_FILE(new OptionGroup().addOption(Option.builder().longOpt("license-families-approved-file").hasArg().argName("File").desc("Name of file containing comma separated lists of approved family IDs.").converter(Converters.FILE_CONVERTER).type(File.class).build())),
    LICENSES_DENIED(new OptionGroup().addOption(Option.builder().longOpt("licenses-denied").hasArg().argName("LicenseID").desc("A comma separated list of denied License IDs. These licenses will be removed from the list of approved licenses. Once licenses are removed they can not be added back.").converter(Converters.TEXT_LIST_CONVERTER).type(String[].class).build())),
    LICENSES_DENIED_FILE(new OptionGroup().addOption(Option.builder().longOpt("licenses-denied-file").hasArg().argName("File").type(File.class).converter(Converters.FILE_CONVERTER).desc("Name of file containing comma separated lists of the denied license IDs. These licenses will be removed from the list of approved licenses. Once licenses are removed they can not be added back.").build())),
    FAMILIES_DENIED(new OptionGroup().addOption(Option.builder().longOpt("license-families-denied").hasArg().argName("FamilyID").desc("A comma separated list of denied License family IDs. These license families will be removed from the list of approved licenses. Once license families are removed they can not be added back.").converter(Converters.TEXT_LIST_CONVERTER).type(String[].class).build())),
    FAMILIES_DENIED_FILE(new OptionGroup().addOption(Option.builder().longOpt("license-families-denied-file").hasArg().argName("File").desc("Name of file containing comma separated lists of denied license IDs. These license families will be removed from the list of approved licenses. Once license families are removed they can not be added back.").type(File.class).converter(Converters.FILE_CONVERTER).build())),
    COUNTER_MAX(new OptionGroup().addOption(Option.builder().longOpt("counter-max").hasArgs().argName("CounterPattern").desc("The acceptable maximum number for the specified counter. A value of '-1' specifies an unlimited number.").converter(Converters.COUNTER_CONVERTER).type(Pair.class).build())),
    COUNTER_MIN(new OptionGroup().addOption(Option.builder().longOpt("counter-min").hasArgs().argName("CounterPattern").desc("The minimum number for the specified counter.").converter(Converters.COUNTER_CONVERTER).type(Pair.class).build())),
    SOURCE(new OptionGroup().addOption(Option.builder().longOpt("input-source").hasArgs().argName("File").desc("A file containing file names to process. File names must use linux directory separator ('/') or none at all. File names that do not start with '/' are relative to the directory where the argument is located.").converter(Converters.FILE_CONVERTER).type(File.class).build())),
    EXCLUDE(new OptionGroup().addOption(Option.builder("e").longOpt("exclude").hasArgs().argName("Expression").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("0.17").setDescription(StdMsgs.useMsg("--input-exclude")).get()).desc("Excludes files matching <Expression>.").build()).addOption(Option.builder().longOpt("input-exclude").hasArgs().argName("Expression").desc("Excludes files matching <Expression>.").build())),
    EXCLUDE_FILE(new OptionGroup().addOption(Option.builder("E").longOpt("exclude-file").argName("File").hasArg().type(File.class).converter(Converters.FILE_CONVERTER).deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("0.17").setDescription(StdMsgs.useMsg("--input-exclude-file")).get()).desc("Reads <Expression> entries from a file. Entries will be excluded from processing.").build()).addOption(Option.builder().longOpt("input-exclude-file").argName("File").hasArg().type(File.class).converter(Converters.FILE_CONVERTER).desc("Reads <Expression> entries from a file. Entries will be excluded from processing.").build())),
    EXCLUDE_STD(new OptionGroup().addOption(Option.builder().longOpt("input-exclude-std").argName("StandardCollection").hasArgs().converter(s -> StandardCollection.valueOf(s.toUpperCase())).desc("Excludes files defined in standard collections based on commonly occurring groups. Excludes any path matcher actions but DOES NOT exclude any file processor actions.").type(StandardCollection.class).build())),
    EXCLUDE_SIZE(new OptionGroup().addOption(Option.builder().longOpt("input-exclude-size").argName("Integer").hasArg().type(Integer.class).desc("Excludes files with sizes less than the number of bytes specified.").build())),
    INCLUDE(new OptionGroup().addOption(Option.builder().longOpt("input-include").hasArgs().argName("Expression").desc("Includes files matching <Expression>. Will override excluded files.").build()).addOption(Option.builder().longOpt("include").hasArgs().argName("Expression").desc("Includes files matching <Expression>. Will override excluded files.").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("0.17").setDescription(StdMsgs.useMsg("--input-include")).get()).build())),
    INCLUDE_FILE(new OptionGroup().addOption(Option.builder().longOpt("input-include-file").argName("File").hasArg().type(File.class).converter(Converters.FILE_CONVERTER).desc("Reads <Expression> entries from a file. Entries will override excluded files.").build()).addOption(Option.builder().longOpt("includes-file").argName("File").hasArg().type(File.class).converter(Converters.FILE_CONVERTER).desc("Reads <Expression> entries from a file. Entries will be excluded from processing.").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("0.17").setDescription(StdMsgs.useMsg("--input-include-file")).get()).build())),
    INCLUDE_STD(new OptionGroup().addOption(Option.builder().longOpt("input-include-std").argName("StandardCollection").hasArgs().converter(s -> StandardCollection.valueOf(s.toUpperCase())).desc("Includes files defined in standard collections based on commonly occurring groups. Includes any path matcher actions but DOES NOT include any file processor actions.").type(StandardCollection.class).build()).addOption(Option.builder().longOpt("scan-hidden-directories").desc("Scans hidden directories.").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("0.17").setDescription(StdMsgs.useMsg("--input-include-std with 'HIDDEN_DIR' argument")).get()).build())),
    EXCLUDE_PARSE_SCM(new OptionGroup().addOption(Option.builder().longOpt("input-exclude-parsed-scm").argName("StandardCollection").hasArgs().converter(s -> StandardCollection.valueOf(s.toUpperCase())).desc("Parse SCM based exclusion files to exclude specified files and directories. This action can apply to any standard collection that implements a file processor.").type(StandardCollection.class).build())),
    DIR(new OptionGroup().addOption(Option.builder().option("d").longOpt("dir").hasArg().type(File.class).desc("Used to indicate end of list when using options that take multiple arguments.").argName("DirOrArchive").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("0.17").setDescription("Use the standard '--' to signal the end of arguments.").get()).build())),
    OUTPUT_STYLE(new OptionGroup().addOption(Option.builder().longOpt("output-style").hasArg().argName("StyleSheet").desc("XSLT stylesheet to use when creating the report. Either an external xsl file may be specified or one of the internal named sheets.").build()).addOption(Option.builder("s").longOpt("stylesheet").hasArg().argName("StyleSheet").deprecated(DeprecatedAttributes.builder().setSince("0.17").setForRemoval(true).setDescription(StdMsgs.useMsg("--output-style")).get()).desc("XSLT stylesheet to use when creating the report.").build()).addOption(Option.builder("x").longOpt("xml").deprecated(DeprecatedAttributes.builder().setSince("0.17").setForRemoval(true).setDescription(StdMsgs.useMsg("--output-style with the 'xml' argument")).get()).desc("forces XML output rather than the textual report.").build())),
    OUTPUT_LICENSES(new OptionGroup().addOption(Option.builder().longOpt("output-licenses").hasArg().argName("LicenseFilter").desc("List the defined licenses.").converter(s -> LicenseSetFactory.LicenseFilter.valueOf(s.toUpperCase())).build()).addOption(Option.builder().longOpt("list-licenses").hasArg().argName("LicenseFilter").desc("List the defined licenses.").converter(s -> LicenseSetFactory.LicenseFilter.valueOf(s.toUpperCase())).deprecated(DeprecatedAttributes.builder().setSince("0.17").setForRemoval(true).setDescription(StdMsgs.useMsg("--output-licenses")).get()).build())),
    OUTPUT_FAMILIES(new OptionGroup().addOption(Option.builder().longOpt("output-families").hasArg().argName("LicenseFilter").desc("List the defined license families.").converter(s -> LicenseSetFactory.LicenseFilter.valueOf(s.toUpperCase())).build()).addOption(Option.builder().longOpt("list-families").hasArg().argName("LicenseFilter").desc("List the defined license families.").converter(s -> LicenseSetFactory.LicenseFilter.valueOf(s.toUpperCase())).deprecated(DeprecatedAttributes.builder().setSince("0.17").setForRemoval(true).setDescription(StdMsgs.useMsg("--output-families")).get()).build())),
    LOG_LEVEL(new OptionGroup().addOption(Option.builder().longOpt("log-level").hasArg().argName("LogLevel").desc("Sets the log level.").converter(s -> Log.Level.valueOf(s.toUpperCase())).build())),
    DRY_RUN(new OptionGroup().addOption(Option.builder().longOpt("dry-run").desc("If set do not update the files but generate the reports.").build())),
    OUTPUT_FILE(new OptionGroup().addOption(Option.builder().option("o").longOpt("out").hasArg().argName("File").desc("Define the output file where to write a report to.").deprecated(DeprecatedAttributes.builder().setSince("0.17").setForRemoval(true).setDescription(StdMsgs.useMsg("--output-file")).get()).type(File.class).converter(Converters.FILE_CONVERTER).build()).addOption(Option.builder().longOpt("output-file").hasArg().argName("File").desc("Define the output file where to write a report to.").type(File.class).converter(Converters.FILE_CONVERTER).build())),
    OUTPUT_ARCHIVE(new OptionGroup().addOption(Option.builder().longOpt("output-archive").hasArg().argName("ProcessingType").desc("Specifies the level of detail in ARCHIVE file reporting.").converter(s -> ReportConfiguration.Processing.valueOf(s.toUpperCase())).build())),
    OUTPUT_STANDARD(new OptionGroup().addOption(Option.builder().longOpt("output-standard").hasArg().argName("ProcessingType").desc("Specifies the level of detail in STANDARD file reporting.").converter(s -> ReportConfiguration.Processing.valueOf(s.toUpperCase())).build())),
    HELP_LICENSES(new OptionGroup().addOption(Option.builder().longOpt("help-licenses").desc("Print information about registered licenses.").build()));

    private final OptionGroup group;
    private static final Map<Arg, String> DEFAULT_VALUES;

    private Arg(OptionGroup group) {
        this.group = group;
    }

    public boolean isSelected() {
        return this.group.getSelected() != null;
    }

    public Option getSelected() {
        String s = this.group.getSelected();
        if (s != null) {
            for (Option result : this.group.getOptions()) {
                if (!result.getKey().equals(s)) continue;
                return result;
            }
        }
        return null;
    }

    public Option find(String key) {
        for (Option result : this.group.getOptions()) {
            if (!key.equals(result.getKey()) && !key.equals(result.getLongOpt())) continue;
            return result;
        }
        throw new IllegalArgumentException("Can not find " + key);
    }

    public String defaultValue() {
        return DEFAULT_VALUES.get((Object)this);
    }

    public OptionGroup group() {
        return this.group;
    }

    public Option option() {
        for (Option result : this.group.getOptions()) {
            if (result.isDeprecated()) continue;
            return result;
        }
        return null;
    }

    public static Options getOptions() {
        Options options = new Options();
        for (Arg arg : Arg.values()) {
            options.addOptionGroup(arg.group);
        }
        return options;
    }

    private static void processEditArgs(ArgumentContext context) {
        if (EDIT_ADD.isSelected()) {
            context.getCommandLine().hasOption(EDIT_ADD.getSelected());
            boolean force = EDIT_OVERWRITE.isSelected();
            if (force) {
                context.getCommandLine().hasOption(EDIT_OVERWRITE.getSelected());
            }
            context.getConfiguration().setAddLicenseHeaders(force ? AddLicenseHeaders.FORCED : AddLicenseHeaders.TRUE);
            if (EDIT_COPYRIGHT.isSelected()) {
                context.getConfiguration().setCopyrightMessage(context.getCommandLine().getOptionValue(EDIT_COPYRIGHT.getSelected()));
            }
        }
    }

    private static List<String> processArrayArg(ArgumentContext context, Arg arg) throws ParseException {
        String[] ids = (String[])context.getCommandLine().getParsedOptionValue(arg.getSelected());
        return Arrays.asList(ids);
    }

    private static List<String> processArrayFile(ArgumentContext context, Arg arg) throws ParseException {
        ArrayList<String> arrayList;
        block9: {
            ArrayList<String> result = new ArrayList<String>();
            File file = (File)context.getCommandLine().getParsedOptionValue(arg.getSelected());
            InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);
            try {
                for (String line : IOUtils.readLines(in, StandardCharsets.UTF_8)) {
                    String[] ids = Converters.TEXT_LIST_CONVERTER.apply(line);
                    result.addAll(Arrays.asList(ids));
                }
                arrayList = result;
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ConfigurationException(e);
                }
            }
            in.close();
        }
        return arrayList;
    }

    private static void processConfigurationArgs(ArgumentContext context) throws ConfigurationException {
        try {
            Pair<ClaimStatistic.Counter, Integer> pair;
            Defaults.Builder defaultBuilder = Defaults.builder();
            if (CONFIGURATION.isSelected()) {
                File[] files;
                File[] fileArray = files = (File[])CONFIGURATION.getParsedOptionValues(context.getCommandLine());
                int n = fileArray.length;
                for (int i = 0; i < n; ++i) {
                    File file = fileArray[i];
                    defaultBuilder.add(file);
                }
            }
            if (CONFIGURATION_NO_DEFAULTS.isSelected()) {
                context.getCommandLine().hasOption(CONFIGURATION_NO_DEFAULTS.getSelected());
                defaultBuilder.noDefault();
            }
            context.getConfiguration().setFrom(defaultBuilder.build());
            if (FAMILIES_APPROVED.isSelected()) {
                context.getConfiguration().addApprovedLicenseCategories(Arg.processArrayArg(context, FAMILIES_APPROVED));
            }
            if (FAMILIES_APPROVED_FILE.isSelected()) {
                context.getConfiguration().addApprovedLicenseCategories(Arg.processArrayFile(context, FAMILIES_APPROVED_FILE));
            }
            if (FAMILIES_DENIED.isSelected()) {
                context.getConfiguration().removeApprovedLicenseCategories(Arg.processArrayArg(context, FAMILIES_DENIED));
            }
            if (FAMILIES_DENIED_FILE.isSelected()) {
                context.getConfiguration().removeApprovedLicenseCategories(Arg.processArrayFile(context, FAMILIES_DENIED_FILE));
            }
            if (LICENSES_APPROVED.isSelected()) {
                context.getConfiguration().addApprovedLicenseIds(Arg.processArrayArg(context, LICENSES_APPROVED));
            }
            if (LICENSES_APPROVED_FILE.isSelected()) {
                context.getConfiguration().addApprovedLicenseIds(Arg.processArrayFile(context, LICENSES_APPROVED_FILE));
            }
            if (LICENSES_DENIED.isSelected()) {
                context.getConfiguration().removeApprovedLicenseIds(Arg.processArrayArg(context, LICENSES_DENIED));
            }
            if (LICENSES_DENIED_FILE.isSelected()) {
                context.getConfiguration().removeApprovedLicenseIds(Arg.processArrayFile(context, LICENSES_DENIED_FILE));
            }
            if (COUNTER_MAX.isSelected()) {
                for (String arg : context.getCommandLine().getOptionValues(COUNTER_MAX.getSelected())) {
                    pair = Converters.COUNTER_CONVERTER.apply(arg);
                    int limit = pair.getValue();
                    context.getConfiguration().getClaimValidator().setMax(pair.getKey(), limit < 0 ? Integer.MAX_VALUE : limit);
                }
            }
            if (COUNTER_MIN.isSelected()) {
                for (String arg : context.getCommandLine().getOptionValues(COUNTER_MIN.getSelected())) {
                    pair = Converters.COUNTER_CONVERTER.apply(arg);
                    context.getConfiguration().getClaimValidator().setMin(pair.getKey(), pair.getValue());
                }
            }
        }
        catch (Exception e) {
            throw ConfigurationException.from(e);
        }
    }

    private static void processInputArgs(ArgumentContext context) throws ConfigurationException {
        try {
            File includeFileName;
            String[] includes;
            String[] excludeFileName;
            String[] excludes;
            int n;
            if (SOURCE.isSelected()) {
                File[] files = (File[])SOURCE.getParsedOptionValues(context.getCommandLine());
                Object[] objectArray = files;
                int n2 = objectArray.length;
                for (n = 0; n < n2; ++n) {
                    File f = objectArray[n];
                    context.getConfiguration().addSource(f);
                }
            }
            if (EXCLUDE.isSelected() && (excludes = context.getCommandLine().getOptionValues(EXCLUDE.getSelected())) != null) {
                context.getConfiguration().addExcludedPatterns(Arrays.asList(excludes));
            }
            if (EXCLUDE_FILE.isSelected() && (excludeFileName = (String[])context.getCommandLine().getParsedOptionValue(EXCLUDE_FILE.getSelected())) != null) {
                context.getConfiguration().addExcludedPatterns(ExclusionUtils.asIterable((File)excludeFileName, "#"));
            }
            if (EXCLUDE_STD.isSelected()) {
                for (String s : context.getCommandLine().getOptionValues(EXCLUDE_STD.getSelected())) {
                    context.getConfiguration().addExcludedCollection(StandardCollection.valueOf(s));
                }
            }
            if (EXCLUDE_PARSE_SCM.isSelected()) {
                StandardCollection[] collections = (StandardCollection[])EXCLUDE_PARSE_SCM.getParsedOptionValues(context.getCommandLine());
                ReportConfiguration configuration = context.getConfiguration();
                StandardCollection[] standardCollectionArray = collections;
                n = standardCollectionArray.length;
                for (int f = 0; f < n; ++f) {
                    StandardCollection collection = standardCollectionArray[f];
                    if (collection == StandardCollection.ALL) {
                        Arrays.asList(StandardCollection.values()).forEach(configuration::addExcludedFileProcessor);
                        Arrays.asList(StandardCollection.values()).forEach(configuration::addExcludedCollection);
                        continue;
                    }
                    configuration.addExcludedFileProcessor(collection);
                    configuration.addExcludedCollection(collection);
                }
            }
            if (EXCLUDE_SIZE.isSelected()) {
                int maxSize = (Integer)EXCLUDE_SIZE.getParsedOptionValue(context.getCommandLine());
                DocumentNameMatcher matcher = new DocumentNameMatcher(String.format("File size < %s bytes", maxSize), documentName -> {
                    File f = new File(documentName.getName());
                    return f.isFile() && f.length() < (long)maxSize;
                });
                context.getConfiguration().addExcludedMatcher(matcher);
            }
            if (INCLUDE.isSelected() && (includes = context.getCommandLine().getOptionValues(INCLUDE.getSelected())) != null) {
                context.getConfiguration().addIncludedPatterns(Arrays.asList(includes));
            }
            if (INCLUDE_FILE.isSelected() && (includeFileName = (File)context.getCommandLine().getParsedOptionValue(INCLUDE_FILE.getSelected())) != null) {
                context.getConfiguration().addIncludedPatterns(ExclusionUtils.asIterable(includeFileName, "#"));
            }
            if (INCLUDE_STD.isSelected()) {
                Option selected = INCLUDE_STD.getSelected();
                if (context.getCommandLine().hasOption("scan-hidden-directories")) {
                    context.getConfiguration().addIncludedCollection(StandardCollection.HIDDEN_DIR);
                } else {
                    for (String s : context.getCommandLine().getOptionValues(selected)) {
                        context.getConfiguration().addIncludedCollection(StandardCollection.valueOf(s));
                    }
                }
            }
        }
        catch (Exception e) {
            throw ConfigurationException.from(e);
        }
    }

    private static void logParseException(Log log, ParseException exception, Option opt, CommandLine cl, Object defaultValue) {
        log.warn(String.format("Invalid %s specified: %s ", opt.getOpt(), cl.getOptionValue(opt)));
        log.warn(String.format("%s set to: %s", opt.getOpt(), defaultValue));
        log.debug(exception);
    }

    public static void processLogLevel(CommandLine commandLine) {
        if (LOG_LEVEL.getSelected() != null) {
            Log dLog = DefaultLog.getInstance();
            try {
                dLog.setLevel((Log.Level)((Object)commandLine.getParsedOptionValue(LOG_LEVEL.getSelected())));
            }
            catch (ParseException e) {
                Arg.logParseException(DefaultLog.getInstance(), e, LOG_LEVEL.getSelected(), commandLine, (Object)dLog.getLevel());
            }
        }
    }

    public static void processArgs(ArgumentContext context) throws ConfigurationException {
        Converters.FILE_CONVERTER.setWorkingDirectory(context.getWorkingDirectory());
        Arg.processOutputArgs(context);
        Arg.processEditArgs(context);
        Arg.processInputArgs(context);
        Arg.processConfigurationArgs(context);
    }

    private static void processOutputArgs(ArgumentContext context) {
        context.getConfiguration().setDryRun(DRY_RUN.isSelected());
        if (OUTPUT_FAMILIES.isSelected()) {
            try {
                context.getConfiguration().listFamilies((LicenseSetFactory.LicenseFilter)((Object)context.getCommandLine().getParsedOptionValue(OUTPUT_FAMILIES.getSelected())));
            }
            catch (ParseException e) {
                context.logParseException(e, OUTPUT_FAMILIES.getSelected(), (Object)Defaults.LIST_FAMILIES);
            }
        }
        if (OUTPUT_LICENSES.isSelected()) {
            try {
                context.getConfiguration().listLicenses((LicenseSetFactory.LicenseFilter)((Object)context.getCommandLine().getParsedOptionValue(OUTPUT_LICENSES.getSelected())));
            }
            catch (ParseException e) {
                context.logParseException(e, OUTPUT_LICENSES.getSelected(), (Object)Defaults.LIST_LICENSES);
            }
        }
        if (OUTPUT_ARCHIVE.isSelected()) {
            try {
                context.getConfiguration().setArchiveProcessing((ReportConfiguration.Processing)((Object)context.getCommandLine().getParsedOptionValue(OUTPUT_ARCHIVE.getSelected())));
            }
            catch (ParseException e) {
                context.logParseException(e, OUTPUT_ARCHIVE.getSelected(), (Object)Defaults.ARCHIVE_PROCESSING);
            }
        }
        if (OUTPUT_STANDARD.isSelected()) {
            try {
                context.getConfiguration().setStandardProcessing((ReportConfiguration.Processing)((Object)context.getCommandLine().getParsedOptionValue(OUTPUT_STANDARD.getSelected())));
            }
            catch (ParseException e) {
                context.logParseException(e, OUTPUT_STANDARD.getSelected(), (Object)Defaults.STANDARD_PROCESSING);
            }
        }
        if (OUTPUT_FILE.isSelected()) {
            try {
                File file = (File)context.getCommandLine().getParsedOptionValue(OUTPUT_FILE.getSelected());
                File parent = file.getParentFile();
                if (!parent.mkdirs() && !parent.isDirectory()) {
                    DefaultLog.getInstance().error("Could not create report parent directory " + file);
                }
                context.getConfiguration().setOut(file);
            }
            catch (ParseException e) {
                context.logParseException(e, OUTPUT_FILE.getSelected(), "System.out");
                context.getConfiguration().setOut((IOSupplier<OutputStream>)null);
            }
        }
        if (OUTPUT_STYLE.isSelected()) {
            String selected = OUTPUT_STYLE.getSelected().getKey();
            if ("x".equals(selected)) {
                context.getCommandLine().hasOption("x");
                context.getConfiguration().setStyleSheet(StyleSheets.getStyleSheet("xml"));
            } else {
                String[] style = context.getCommandLine().getOptionValues(OUTPUT_STYLE.getSelected());
                if (style.length != 1) {
                    DefaultLog.getInstance().error("Please specify a single stylesheet");
                    throw new ConfigurationException("Please specify a single stylesheet");
                }
                context.getConfiguration().setStyleSheet(StyleSheets.getStyleSheet(style[0]));
            }
        }
    }

    public static void reset() {
        for (Arg a : Arg.values()) {
            try {
                a.group.setSelected(null);
            }
            catch (AlreadySelectedException e) {
                throw new RuntimeException("Should not happen", e);
            }
        }
    }

    public static Arg findArg(Option optionToFind) {
        if (optionToFind != null) {
            for (Arg arg : Arg.values()) {
                for (Option candidate : arg.group.getOptions()) {
                    if (!optionToFind.equals(candidate)) continue;
                    return arg;
                }
            }
        }
        return null;
    }

    public static Arg findArg(String key) {
        if (key != null) {
            for (Arg arg : Arg.values()) {
                for (Option candidate : arg.group.getOptions()) {
                    if (!key.equals(candidate.getKey()) && !key.equals(candidate.getLongOpt())) continue;
                    return arg;
                }
            }
        }
        return null;
    }

    private <T> T getParsedOptionValue(CommandLine commandLine) throws ParseException {
        return commandLine.getParsedOptionValue(this.getSelected());
    }

    private String getOptionValue(CommandLine commandLine) {
        return commandLine.getOptionValue(this.getSelected());
    }

    private String[] getOptionValues(CommandLine commandLine) {
        return commandLine.getOptionValues(this.getSelected());
    }

    private <T> T[] getParsedOptionValues(CommandLine commandLine) {
        Option option = this.getSelected();
        try {
            Class clazz = (Class)option.getType();
            String[] values = commandLine.getOptionValues(option);
            Object[] result = (Object[])Array.newInstance(clazz, values.length);
            for (int i = 0; i < values.length; ++i) {
                result[i] = clazz.cast(option.getConverter().apply(values[i]));
            }
            return result;
        }
        catch (Throwable t) {
            throw new ConfigurationException(String.format("'%s' converter for %s '%s' does not produce a class of type %s", new Object[]{this, option.getKey(), option.getConverter().getClass().getName(), option.getType()}), t);
        }
    }

    static {
        DEFAULT_VALUES = new HashMap<Arg, String>();
        DEFAULT_VALUES.put(OUTPUT_FILE, "System.out");
        DEFAULT_VALUES.put(LOG_LEVEL, Log.Level.WARN.name());
        DEFAULT_VALUES.put(OUTPUT_ARCHIVE, Defaults.ARCHIVE_PROCESSING.name());
        DEFAULT_VALUES.put(OUTPUT_STANDARD, Defaults.STANDARD_PROCESSING.name());
        DEFAULT_VALUES.put(OUTPUT_LICENSES, Defaults.LIST_LICENSES.name());
        DEFAULT_VALUES.put(OUTPUT_FAMILIES, Defaults.LIST_FAMILIES.name());
    }

    public static final class StdMsgs {
        private StdMsgs() {
        }

        public static String useMsg(String name) {
            return String.format("Use %s instead.", name);
        }
    }
}

