/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster.quorum;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.client.impl.Topology;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.cluster.quorum.BooleanVote;
import org.apache.activemq.artemis.core.server.cluster.quorum.QuorumVote;
import org.apache.activemq.artemis.core.server.cluster.quorum.ServerConnectVote;
import org.apache.activemq.artemis.core.server.cluster.quorum.Vote;

public class QuorumVoteServerConnect
extends QuorumVote<ServerConnectVote, Boolean> {
    public static final SimpleString PRIMARY_FAILOVER_VOTE = SimpleString.of((String)"PrimaryFailoverQuorumVote");
    private final CountDownLatch voteCompleted;
    private final String targetNodeId;
    private final String connector;
    private int votesNeeded;
    private final boolean requestToStayActive;

    public QuorumVoteServerConnect(int size, String targetNodeId, boolean requestToStayActive, String connector) {
        super(PRIMARY_FAILOVER_VOTE);
        this.targetNodeId = targetNodeId;
        this.connector = connector;
        double majority = size <= 2 ? (double)size / 2.0 : (double)size / 2.0 + 1.0;
        this.votesNeeded = (int)majority;
        this.voteCompleted = new CountDownLatch(1);
        if (this.votesNeeded == 0) {
            this.voteCompleted.countDown();
        }
        this.requestToStayActive = requestToStayActive;
    }

    public QuorumVoteServerConnect(int size, String targetNodeId) {
        this(size, targetNodeId, false, null);
    }

    @Override
    public Vote connected() {
        return new ServerConnectVote(this.targetNodeId, this.requestToStayActive, null);
    }

    @Override
    public Vote notConnected() {
        return new BooleanVote(false);
    }

    @Override
    public synchronized void vote(ServerConnectVote vote) {
        if (this.voteCompleted.getCount() == 0L) {
            ActiveMQServerLogger.LOGGER.ignoredQuorumVote(vote);
            return;
        }
        if (vote.getVote().booleanValue()) {
            if (!this.requestToStayActive) {
                this.acceptPositiveVote();
            } else if (this.connector.equals(vote.getTransportConfiguration())) {
                this.acceptPositiveVote();
            } else {
                ActiveMQServerLogger.LOGGER.quorumBackupIsActive(vote.getTransportConfiguration());
            }
        }
    }

    private synchronized void acceptPositiveVote() {
        if (this.voteCompleted.getCount() == 0L) {
            throw new IllegalStateException("Cannot accept any new positive vote if the vote is completed or the decision is already taken");
        }
        --this.votesNeeded;
        if (this.votesNeeded == 0) {
            this.voteCompleted.countDown();
        }
    }

    @Override
    public synchronized void allVotesCast(Topology voteTopology) {
        if (this.voteCompleted.getCount() > 0L) {
            this.voteCompleted.countDown();
        }
    }

    @Override
    public synchronized Boolean getDecision() {
        return this.votesNeeded == 0;
    }

    public void await(int latchTimeout, TimeUnit unit) throws InterruptedException {
        ActiveMQServerLogger.LOGGER.waitingForQuorumVoteResults(latchTimeout, unit.toString().toLowerCase());
        if (this.voteCompleted.await(latchTimeout, unit)) {
            ActiveMQServerLogger.LOGGER.receivedAllQuorumVotes();
        } else {
            ActiveMQServerLogger.LOGGER.timeoutWaitingForQuorumVoteResponses();
        }
    }

    public boolean isRequestToStayActive() {
        return this.requestToStayActive;
    }
}

