/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.postoffice.impl;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.BindingType;
import org.apache.activemq.artemis.core.server.Bindable;
import org.apache.activemq.artemis.core.server.Divert;
import org.apache.activemq.artemis.core.server.RoutingContext;

public class DivertBinding
implements Binding {
    private final SimpleString address;
    private final Divert divert;
    private final SimpleString uniqueName;
    private final SimpleString routingName;
    private final boolean exclusive;
    private final Long id;

    public DivertBinding(long id, SimpleString address, Divert divert) {
        this.id = id;
        this.address = address;
        this.divert = divert;
        this.uniqueName = divert.getUniqueName();
        this.routingName = divert.getRoutingName();
        this.exclusive = divert.isExclusive();
    }

    @Override
    public Long getID() {
        return this.id;
    }

    @Override
    public Filter getFilter() {
        return this.divert.getFilter();
    }

    @Override
    public SimpleString getAddress() {
        return this.address;
    }

    @Override
    public Bindable getBindable() {
        return this.divert;
    }

    @Override
    public SimpleString getRoutingName() {
        return this.routingName;
    }

    @Override
    public SimpleString getUniqueName() {
        return this.uniqueName;
    }

    @Override
    public SimpleString getClusterName() {
        return this.uniqueName;
    }

    @Override
    public boolean isExclusive() {
        return this.exclusive;
    }

    @Override
    public boolean isHighAcceptPriority(Message message) {
        return true;
    }

    @Override
    public void route(Message message, RoutingContext context) throws Exception {
        this.divert.route(message, context);
    }

    @Override
    public int getDistance() {
        return 0;
    }

    @Override
    public BindingType getType() {
        return BindingType.DIVERT;
    }

    @Override
    public void unproposed(SimpleString groupID) {
    }

    public String toString() {
        return "DivertBinding [id=" + this.id + ", address=" + this.address + ", divert=" + this.divert + ", filter=" + this.divert.getFilter() + ", uniqueName=" + this.uniqueName + ", routingName=" + this.routingName + ", exclusive=" + this.exclusive + "]";
    }

    @Override
    public String toManagementString() {
        return this.getClass().getSimpleName() + " [id=" + this.id + "]";
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public void routeWithAck(Message message, RoutingContext context) {
    }

    @Override
    public void close() throws Exception {
    }

    public Divert getDivert() {
        return this.divert;
    }
}

