/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.journal;

import java.util.Arrays;
import org.apache.activemq.artemis.api.core.ActiveMQIOErrorException;
import org.apache.activemq.artemis.journal.ActiveMQJournalBundle;
import org.slf4j.Logger;
import org.slf4j.helpers.MessageFormatter;

public class ActiveMQJournalBundle_impl
implements ActiveMQJournalBundle {
    private final Logger logger;

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    public ActiveMQJournalBundle_impl(Logger logger) {
        this.logger = logger;
    }

    @Override
    public ActiveMQIOErrorException ioRenameFileError(String name, String newFileName) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ149000: failed to rename file {} to {}", (Object[])new Object[]{name, newFileName}).getMessage();
        ActiveMQIOErrorException objReturn_ioRenameFileError = new ActiveMQIOErrorException(returnString);
        ActiveMQJournalBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_ioRenameFileError);
        return objReturn_ioRenameFileError;
    }

    @Override
    public ActiveMQIOErrorException journalDifferentVersion() {
        String returnString = "AMQ149001: Journal data belong to a different version";
        ActiveMQIOErrorException objReturn_journalDifferentVersion = new ActiveMQIOErrorException(returnString);
        ActiveMQJournalBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_journalDifferentVersion);
        return objReturn_journalDifferentVersion;
    }

    @Override
    public ActiveMQIOErrorException journalFileMisMatch() {
        String returnString = "AMQ149002: Journal files version mismatch. You should export the data from the previous version and import it as explained on the user's manual";
        ActiveMQIOErrorException objReturn_journalFileMisMatch = new ActiveMQIOErrorException(returnString);
        ActiveMQJournalBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_journalFileMisMatch);
        return objReturn_journalFileMisMatch;
    }

    @Override
    public ActiveMQIOErrorException fileNotOpened() {
        String returnString = "AMQ149003: File not opened";
        ActiveMQIOErrorException objReturn_fileNotOpened = new ActiveMQIOErrorException(returnString);
        ActiveMQJournalBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_fileNotOpened);
        return objReturn_fileNotOpened;
    }

    @Override
    public String unableToOpenFile() {
        String returnString = "AMQ149004: unable to open file";
        return returnString;
    }

    @Override
    public ActiveMQIOErrorException recordLargerThanStoreMax(long recordSize, long maxRecordSize) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ149005: Message of {} bytes is bigger than the max record size of {} bytes. You should try to move large application properties to the message body.", (Object[])new Object[]{recordSize, maxRecordSize}).getMessage();
        ActiveMQIOErrorException objReturn_recordLargerThanStoreMax = new ActiveMQIOErrorException(returnString);
        ActiveMQJournalBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_recordLargerThanStoreMax);
        return objReturn_recordLargerThanStoreMax;
    }

    @Override
    public ActiveMQIOErrorException unexpectedFileSize(String fileName, long expectedSize, long returnedSize) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ149006: The file system returned a file {} with unexpected file size. The broker requested a file sized as {} but the system returned a file sized as {}", (Object[])new Object[]{fileName, expectedSize, returnedSize}).getMessage();
        ActiveMQIOErrorException objReturn_unexpectedFileSize = new ActiveMQIOErrorException(returnString);
        ActiveMQJournalBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_unexpectedFileSize);
        return objReturn_unexpectedFileSize;
    }

    @Override
    public String threadDumpAfterFileOpenTimeout() {
        String returnString = "AMQ149007: Thread dump being generated as the asynchronous file.open is not responding fast enough.";
        return returnString;
    }
}

