/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.websocket.jetty12;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http_jetty.JettyHTTPDestination;
import org.apache.cxf.transport.http_jetty.JettyHTTPHandler;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngineFactory;
import org.apache.cxf.transport.websocket.InvalidPathException;
import org.apache.cxf.transport.websocket.WebSocketDestinationService;
import org.apache.cxf.transport.websocket.WebSocketUtils;
import org.apache.cxf.transport.websocket.jetty.WebSocketServletHolder;
import org.apache.cxf.transport.websocket.jetty.WebSocketVirtualServletRequest;
import org.apache.cxf.transport.websocket.jetty.WebSocketVirtualServletResponse;
import org.apache.cxf.transport.websocket.jetty12.JettyWebSocketHandler;
import org.apache.cxf.workqueue.WorkQueueManager;
import org.eclipse.jetty.ee10.websocket.server.JettyServerUpgradeRequest;
import org.eclipse.jetty.ee10.websocket.server.JettyServerUpgradeResponse;
import org.eclipse.jetty.ee10.websocket.server.JettyWebSocketCreator;
import org.eclipse.jetty.ee10.websocket.server.JettyWebSocketServerContainer;
import org.eclipse.jetty.websocket.api.Callback;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketOpen;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;

public class Jetty12WebSocketDestination
extends JettyHTTPDestination
implements WebSocketDestinationService {
    private static final Logger LOG = LogUtils.getL7dLogger(Jetty12WebSocketDestination.class);
    private static final String REQUEST_ID_KEY = "requestId";
    private static final String RESPONSE_ID_KEY = "responseId";
    private final Executor executor;
    private JettyWebSocketServerContainer webSocketServerContainer;
    private Object address;

    public Jetty12WebSocketDestination(Bus bus, DestinationRegistry registry, EndpointInfo ei, JettyHTTPServerEngineFactory serverEngineFactory) throws IOException {
        super(bus, registry, ei, serverEngineFactory == null ? null : new URL(Jetty12WebSocketDestination.getNonWSAddress(ei)), serverEngineFactory);
        this.executor = ((WorkQueueManager)bus.getExtension(WorkQueueManager.class)).getAutomaticWorkQueue();
    }

    @Override
    public void invokeInternal(ServletConfig config, ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        super.invoke(config, context, req, resp);
    }

    public void invoke(ServletConfig config, ServletContext context, HttpServletRequest request, HttpServletResponse response) throws IOException {
        JettyWebSocketServerContainer wssc = this.getWebSocketContainer(context);
        JettyWebSocketCreator creator = this.getCreator();
        this.address = request.getAttribute("org.apache.cxf.transport.endpoint.address");
        try {
            if (wssc.upgrade(creator, request, response)) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.address != null) {
            request.setAttribute("org.apache.cxf.transport.endpoint.address", this.address);
        }
        super.invoke(config, context, request, response);
    }

    private static String getNonWSAddress(EndpointInfo endpointInfo) {
        Object address = endpointInfo.getAddress();
        if (((String)address).startsWith("ws")) {
            address = "http" + ((String)address).substring(2);
        }
        return address;
    }

    protected String getAddress(EndpointInfo endpointInfo) {
        return Jetty12WebSocketDestination.getNonWSAddress(endpointInfo);
    }

    public JettyWebSocketCreator getCreator() {
        return new Creator();
    }

    public synchronized JettyWebSocketServerContainer getWebSocketContainer(ServletContext context) {
        if (this.webSocketServerContainer == null) {
            this.webSocketServerContainer = JettyWebSocketServerContainer.getContainer((ServletContext)context);
            if (this.webSocketServerContainer == null) {
                this.webSocketServerContainer = JettyWebSocketServerContainer.ensureContainer((ServletContext)context);
            }
            return this.webSocketServerContainer;
        }
        return this.webSocketServerContainer;
    }

    protected JettyHTTPHandler createJettyHTTPHandler(JettyHTTPDestination jhd, boolean cmExact) {
        return new JettyWebSocketHandler(jhd, cmExact, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate() {
        Jetty12WebSocketDestination jetty12WebSocketDestination = this;
        synchronized (jetty12WebSocketDestination) {
            if (this.registry != null) {
                this.registry.addDestination((AbstractHTTPDestination)this);
            }
        }
        LOG.log(Level.FINE, "Activating receipt of incoming messages");
        if (this.engine != null) {
            this.handler = this.createJettyHTTPHandler(this, this.contextMatchOnExact());
            this.engine.addServant(this.nurl, this.handler);
            ((JettyWebSocketHandler)this.handler).initHandler(this.engine.getServer());
        }
    }

    public void shutdown() {
        super.shutdown();
    }

    private void invoke(final byte[] data, final int offset, final int length, final Session session) {
        this.executeServiceTask(new Runnable(){

            @Override
            public void run() {
                WebSocketVirtualServletResponse response = null;
                try {
                    Jetty12WebSocketHolder holder = new Jetty12WebSocketHolder(session);
                    response = Jetty12WebSocketDestination.this.createServletResponse(holder);
                    WebSocketVirtualServletRequest request = Jetty12WebSocketDestination.this.createServletRequest(data, offset, length, holder, session);
                    String reqid = request.getHeader(Jetty12WebSocketDestination.REQUEST_ID_KEY);
                    if (reqid != null) {
                        if (WebSocketUtils.isContainingCRLF(reqid)) {
                            LOG.warning("Invalid characters (CR/LF) in header requestId");
                        } else {
                            response.setHeader(Jetty12WebSocketDestination.RESPONSE_ID_KEY, reqid);
                        }
                    }
                    Jetty12WebSocketDestination.this.invoke(null, null, request, response);
                }
                catch (InvalidPathException ex) {
                    Jetty12WebSocketDestination.this.reportErrorStatus(session, 400, response);
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Failed to invoke service", e);
                    Jetty12WebSocketDestination.this.reportErrorStatus(session, 500, response);
                }
            }
        });
    }

    private void executeServiceTask(Runnable r) {
        try {
            this.executor.execute(r);
        }
        catch (RejectedExecutionException e) {
            LOG.warning("Executor queue is full, run the service invocation task in caller thread.  Users can specify a larger executor queue to avoid this.");
            r.run();
        }
    }

    private void reportErrorStatus(Session session, int i, HttpServletResponse resp) {
        try {
            resp.sendError(i);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private WebSocketVirtualServletRequest createServletRequest(byte[] data, int offset, int length, WebSocketServletHolder holder, Session session) throws IOException {
        return new WebSocketVirtualServletRequest(holder, new ByteArrayInputStream(data, offset, length), session);
    }

    private WebSocketVirtualServletResponse createServletResponse(WebSocketServletHolder holder) throws IOException {
        return new WebSocketVirtualServletResponse(holder);
    }

    private final class Creator
    implements JettyWebSocketCreator {
        private Creator() {
        }

        public Object createWebSocket(JettyServerUpgradeRequest req, JettyServerUpgradeResponse resp) {
            return new Jetty12WebSocket();
        }
    }

    @WebSocket
    public class Jetty12WebSocket {
        volatile Session session;

        @OnWebSocketOpen
        public void onOpen(Session sess) {
            this.session = sess;
        }

        @OnWebSocketMessage
        public void onMessage(String message) {
            try {
                byte[] bdata = message.getBytes("utf-8");
                this.onBinaryMessage(ByteBuffer.wrap(bdata), null);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }

        @OnWebSocketMessage
        public void onBinaryMessage(ByteBuffer message, Callback callback) {
            byte[] payload = new byte[message.remaining()];
            message.get(payload);
            Jetty12WebSocketDestination.this.invoke(payload, 0, payload.length, this.session);
        }

        @OnWebSocketClose
        public void onClose(int code, String message) {
        }
    }

    class Jetty12WebSocketHolder
    implements WebSocketServletHolder {
        final Session session;

        Jetty12WebSocketHolder(Session s) {
            this.session = s;
        }

        @Override
        public String getAuthType() {
            return null;
        }

        @Override
        public String getContextPath() {
            return this.getHttpServletRequest(this.session.getUpgradeRequest()).getContextPath();
        }

        @Override
        public String getLocalAddr() {
            return null;
        }

        @Override
        public String getLocalName() {
            return null;
        }

        @Override
        public int getLocalPort() {
            return 0;
        }

        @Override
        public Locale getLocale() {
            return null;
        }

        @Override
        public Enumeration<Locale> getLocales() {
            return null;
        }

        @Override
        public String getProtocol() {
            return null;
        }

        @Override
        public String getRemoteAddr() {
            return null;
        }

        @Override
        public String getRemoteHost() {
            return null;
        }

        @Override
        public int getRemotePort() {
            return 0;
        }

        @Override
        public String getRequestURI() {
            return this.session.getUpgradeRequest().getRequestURI().getPath();
        }

        @Override
        public StringBuffer getRequestURL() {
            return new StringBuffer(this.session.getUpgradeRequest().getRequestURI().toString());
        }

        @Override
        public DispatcherType getDispatcherType() {
            return null;
        }

        @Override
        public boolean isSecure() {
            return false;
        }

        @Override
        public String getPathInfo() {
            return this.session.getUpgradeRequest().getRequestURI().getPath();
        }

        @Override
        public String getPathTranslated() {
            return this.session.getUpgradeRequest().getRequestURI().getPath();
        }

        @Override
        public String getScheme() {
            return "ws";
        }

        @Override
        public String getServerName() {
            return null;
        }

        @Override
        public String getServletPath() {
            return "";
        }

        @Override
        public ServletContext getServletContext() {
            return null;
        }

        @Override
        public int getServerPort() {
            return ((InetSocketAddress)this.session.getLocalSocketAddress()).getPort();
        }

        @Override
        public Principal getUserPrincipal() {
            return null;
        }

        @Override
        public Object getAttribute(String name) {
            try {
                UpgradeRequest upgradeRequest = this.session.getUpgradeRequest();
                return this.getHttpServletRequest(upgradeRequest).getAttribute(name);
            }
            catch (Exception ex) {
                if (name.equals("org.apache.cxf.transport.endpoint.address")) {
                    return Jetty12WebSocketDestination.this.address;
                }
                return null;
            }
        }

        @Override
        public void write(byte[] data, int offset, int length) throws IOException {
            this.session.sendBinary(ByteBuffer.wrap(data, offset, length), null);
        }

        private HttpServletRequest getHttpServletRequest(UpgradeRequest upgradeRequest) {
            if (upgradeRequest instanceof JettyServerUpgradeRequest) {
                return ((JettyServerUpgradeRequest)upgradeRequest).getHttpServletRequest();
            }
            throw new IllegalStateException("Unsupported upgrade request class: " + upgradeRequest.getClass());
        }
    }
}

