/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;

public class ExecutableFunctionLibrary
implements FunctionLibrary {
    private final transient Configuration config;
    private HashMap<SymbolicName, UserFunction> functions = new HashMap(20);

    public ExecutableFunctionLibrary(Configuration config) {
        this.config = config;
    }

    public void addFunction(UserFunction fn) {
        this.functions.put(fn.getSymbolicName(), fn);
    }

    @Override
    public Expression bind(SymbolicName.F functionName, Expression[] staticArgs, Map<StructuredQName, Integer> keywords, StaticContext env, List<String> reasons) {
        UserFunction fn = this.functions.get(functionName);
        if (fn == null) {
            return null;
        }
        UserFunctionCall fc = new UserFunctionCall();
        fc.setFunctionName(functionName.getComponentName());
        fc.setArguments(staticArgs);
        fc.setFunction(fn);
        fc.setStaticType(fn.getResultType());
        return fc;
    }

    @Override
    public FunctionItem getFunctionItem(SymbolicName.F functionName, StaticContext staticContext) throws XPathException {
        UserFunction fn = this.functions.get(functionName);
        if (fn != null && fn.isUpdating()) {
            throw new XPathException("Cannot bind a function item to an updating function");
        }
        return fn;
    }

    @Override
    public boolean isAvailable(SymbolicName.F functionName, int languageLevel) {
        return this.functions.get(functionName) != null;
    }

    @Override
    public FunctionLibrary copy() {
        ExecutableFunctionLibrary efl = new ExecutableFunctionLibrary(this.config);
        efl.functions = new HashMap<SymbolicName, UserFunction>(this.functions);
        return efl;
    }

    public Iterable<UserFunction> getAllFunctions() {
        return this.functions.values();
    }
}

