/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.req;

import java.util.List;
import org.apache.datasketches.req.ReqCompactor;
import org.apache.datasketches.req.ReqDebug;
import org.apache.datasketches.req.ReqSketch;

public class ReqDebugImplTest
implements ReqDebug {
    private static final String LS = System.getProperty("line.separator");
    private static final String TAB = "\t";
    private ReqSketch sk;
    final int debugLevel;
    final String fmt;

    public ReqDebugImplTest(int debugLevel, String fmt) {
        this.debugLevel = debugLevel;
        this.fmt = fmt;
    }

    public void emitStart(ReqSketch sk) {
        if (this.debugLevel == 0) {
            return;
        }
        this.sk = sk;
        ReqDebugImplTest.println("START");
    }

    public void emitStartCompress() {
        if (this.debugLevel == 0) {
            return;
        }
        int retItems = this.sk.getNumRetained();
        int maxNomSize = this.sk.getMaxNomSize();
        long totalN = this.sk.getN();
        StringBuilder sb = new StringBuilder();
        sb.append("COMPRESS: ");
        sb.append("skRetItems: ").append(retItems).append(" >= ");
        sb.append("MaxNomSize: ").append(maxNomSize);
        sb.append("  N: ").append(totalN);
        ReqDebugImplTest.println(sb.toString());
        this.emitAllHorizList();
    }

    public void emitCompressDone() {
        if (this.debugLevel == 0) {
            return;
        }
        int retItems = this.sk.getNumRetained();
        int maxNomSize = this.sk.getMaxNomSize();
        this.emitAllHorizList();
        ReqDebugImplTest.println("COMPRESS: DONE: SketchSize: " + retItems + TAB + " MaxNomSize: " + maxNomSize + LS + LS);
    }

    public void emitAllHorizList() {
        if (this.debugLevel == 0) {
            return;
        }
        List compactors = this.sk.getCompactors();
        for (int h = 0; h < this.sk.getCompactors().size(); ++h) {
            ReqCompactor c = (ReqCompactor)compactors.get(h);
            ReqDebugImplTest.println(c.toListPrefix());
            if (this.debugLevel > 1) {
                ReqDebugImplTest.print(c.getBuffer().toHorizList(this.fmt, 20) + LS);
                continue;
            }
            ReqDebugImplTest.print(LS);
        }
    }

    public void emitMustAddCompactor() {
        if (this.debugLevel == 0) {
            return;
        }
        int curLevels = this.sk.getNumLevels();
        List compactors = this.sk.getCompactors();
        ReqCompactor topC = (ReqCompactor)compactors.get(curLevels - 1);
        byte lgWt = topC.getLgWeight();
        int retCompItems = topC.getBuffer().getCount();
        int nomCap = topC.getNomCapacity();
        StringBuilder sb = new StringBuilder();
        sb.append("  ");
        sb.append("Must Add Compactor: len(c[").append(lgWt).append("]): ");
        sb.append(retCompItems).append(" >= c[").append(lgWt).append("].nomCapacity(): ").append(nomCap);
        ReqDebugImplTest.println(sb.toString());
    }

    public void emitCompactingStart(byte lgWeight) {
        if (this.debugLevel == 0) {
            return;
        }
        List compactors = this.sk.getCompactors();
        ReqCompactor comp = (ReqCompactor)compactors.get(lgWeight);
        int nomCap = comp.getNomCapacity();
        int secSize = comp.getSectionSize();
        int numSec = comp.getNumSections();
        long state = comp.getState();
        int bufCap = comp.getBuffer().getCapacity();
        StringBuilder sb = new StringBuilder();
        sb.append(LS + "  ");
        sb.append("COMPACTING[").append(lgWeight).append("] ");
        sb.append("NomCapacity: ").append(nomCap);
        sb.append("\t SectionSize: ").append(secSize);
        sb.append("\t NumSections: ").append(numSec);
        sb.append("\t State(bin): ").append(Long.toBinaryString(state));
        sb.append("\t BufCapacity: ").append(bufCap);
        ReqDebugImplTest.println(sb.toString());
    }

    public void emitNewCompactor(byte lgWeight) {
        if (this.debugLevel == 0) {
            return;
        }
        List compactors = this.sk.getCompactors();
        ReqCompactor comp = (ReqCompactor)compactors.get(lgWeight);
        ReqDebugImplTest.println("    New Compactor: lgWeight: " + comp.getLgWeight() + TAB + "sectionSize: " + comp.getSectionSize() + TAB + "numSections: " + comp.getNumSections());
    }

    public void emitAdjSecSizeNumSec(byte lgWeight) {
        if (this.debugLevel == 0) {
            return;
        }
        List compactors = this.sk.getCompactors();
        ReqCompactor comp = (ReqCompactor)compactors.get(lgWeight);
        int secSize = comp.getSectionSize();
        int numSec = comp.getNumSections();
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("Adjust: SectionSize: ").append(secSize);
        sb.append(" NumSections: ").append(numSec);
        ReqDebugImplTest.println(sb.toString());
    }

    public void emitCompactionDetail(int compactionStart, int compactionEnd, int secsToCompact, int promoteLen, boolean coin) {
        if (this.debugLevel == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("SecsToCompact: ").append(secsToCompact);
        sb.append("\t CompactStart: ").append(compactionStart);
        sb.append("\t CompactEnd: ").append(compactionEnd).append(LS);
        int delete = compactionEnd - compactionStart;
        String oddOrEven = coin ? "Odds" : "Evens";
        sb.append("    ");
        sb.append("Promote: ").append(promoteLen);
        sb.append("\t Delete: ").append(delete);
        sb.append("\t Choose: ").append(oddOrEven);
        ReqDebugImplTest.println(sb.toString());
    }

    public void emitCompactionDone(byte lgWeight) {
        if (this.debugLevel == 0) {
            return;
        }
        List compactors = this.sk.getCompactors();
        ReqCompactor comp = (ReqCompactor)compactors.get(lgWeight);
        long state = comp.getState();
        ReqDebugImplTest.println("  COMPACTING DONE: NumCompactions: " + state + LS);
    }

    static final void printf(String format, Object ... args) {
        System.out.printf(format, args);
    }

    static final void print(Object o) {
        System.out.print(o.toString());
    }

    static final void println(Object o) {
        System.out.println(o.toString());
    }
}

