/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.source;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.SourceElementAttributePointer;

public class SourceElementAttributeIterator
implements NodeIterator {
    private final NodePointer parent;
    private final SourceElement sourceElement;
    private final String name;
    private final List<String> names;
    private int position = 0;

    public SourceElementAttributeIterator(NodePointer parent, QName qName) {
        this.parent = parent;
        this.name = qName.getName();
        this.names = new ArrayList<String>();
        this.sourceElement = (SourceElement)parent.getNode();
        if (!this.name.equals("*")) {
            Object attr = this.sourceElement.getAttribute(this.name);
            if (attr != null) {
                this.names.add(this.name);
            }
        } else {
            Set<String> attributeNames = this.sourceElement.getAttributeNames();
            for (String attributeName : attributeNames) {
                Object value = this.sourceElement.getAttribute(attributeName);
                if (!this.testAttr(attributeName)) continue;
                this.names.add(this.name);
            }
        }
    }

    private boolean testAttr(String attributeName) {
        return this.name.equals("*") || this.name.equals(attributeName);
    }

    public NodePointer getNodePointer() {
        int index;
        if (this.position == 0) {
            if (!this.setPosition(1)) {
                return null;
            }
            this.position = 0;
        }
        if ((index = this.position - 1) < 0) {
            index = 0;
        }
        return new SourceElementAttributePointer(this.parent, this.sourceElement, this.names.get(index));
    }

    public int getPosition() {
        return this.position;
    }

    public boolean setPosition(int position) {
        this.position = position;
        return position >= 1 && position <= this.names.size();
    }
}

