/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.rest;

import jakarta.servlet.http.HttpServletRequest;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.model.FortRequest;
import org.apache.directory.fortress.core.model.FortResponse;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.realm.J2eePolicyMgr;
import org.apache.directory.fortress.realm.J2eePolicyMgrFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SecUtils {
    private static final Logger LOG = LoggerFactory.getLogger((String)SecUtils.class.getName());
    private static J2eePolicyMgr j2eePolicyMgr;

    static FortResponse initializeSession(FortRequest fortRequest, HttpServletRequest httpRequest) {
        FortResponse fortResponse = null;
        if (Config.getInstance().getBoolean("is.arbac02")) {
            if (httpRequest == null) {
                fortResponse = SecUtils.createError((int)10110, (String)"initializeSession detected null HTTP Request", (int)403);
            } else {
                try {
                    String szPrincipal = httpRequest.getUserPrincipal().toString();
                    Session realmSession = j2eePolicyMgr.deserialize(szPrincipal);
                    if (realmSession != null) {
                        fortRequest.setSession(realmSession);
                    } else {
                        fortResponse = SecUtils.createError((int)1030, (String)"initializeSession couldn't get a Security Session.", (int)403);
                    }
                }
                catch (SecurityException se) {
                    fortResponse = SecUtils.createError((int)se.getErrorId(), (String)("initializeSession caught SecurityException=" + se.getMessage()), (int)se.getHttpStatus());
                }
            }
        }
        return fortResponse;
    }

    private static FortResponse createError(int errId, String errMsg, int hCode) {
        FortResponse fortResponse = new FortResponse();
        fortResponse.setErrorCode(errId);
        fortResponse.setErrorMessage(errMsg);
        fortResponse.setHttpStatus(hCode);
        LOG.info(errMsg);
        return fortResponse;
    }

    static {
        try {
            j2eePolicyMgr = J2eePolicyMgrFactory.createInstance();
        }
        catch (SecurityException se) {
            String error = "initializeSession caught SecurityException in static block=" + se.getMessage();
            LOG.warn(error);
        }
    }
}

