/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.azure.blobstore;

import java.util.Date;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Optional;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

class AzfsResourceId
implements ResourceId {
    static final @UnknownKeyFor @NonNull @Initialized String SCHEME = "azfs";
    private static final @UnknownKeyFor @NonNull @Initialized Pattern AZFS_URI = Pattern.compile("(?<SCHEME>[^:]+)://(?<ACCOUNT>[^/]+)/(?<CONTAINER>[^/]+)(?:/(?<BLOB>.*))?");
    private static final @UnknownKeyFor @NonNull @Initialized Pattern GLOB_PREFIX = Pattern.compile("(?<PREFIX>[^\\[*?]*)[\\[*?].*");
    private final @UnknownKeyFor @NonNull @Initialized String account;
    private final @UnknownKeyFor @NonNull @Initialized String container;
    private final @UnknownKeyFor @NonNull @Initialized String blob;
    private final @UnknownKeyFor @NonNull @Initialized Long size;
    private final @UnknownKeyFor @NonNull @Initialized Date lastModified;

    private AzfsResourceId(@UnknownKeyFor @NonNull @Initialized String account, @UnknownKeyFor @NonNull @Initialized String container, @Nullable @UnknownKeyFor @Initialized String blob, @Nullable @UnknownKeyFor @Initialized Long size, @Nullable @UnknownKeyFor @Initialized Date lastModified) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)container) ? 1 : 0) != 0, (Object)"container");
        Preconditions.checkArgument((!container.contains("/") ? 1 : 0) != 0, (String)"container must not contain '/': [%s]", (Object)container);
        this.account = account;
        this.container = container;
        this.blob = blob == null || blob.isEmpty() ? null : blob;
        this.size = size;
        this.lastModified = lastModified;
    }

    static @UnknownKeyFor @NonNull @Initialized AzfsResourceId fromComponents(@UnknownKeyFor @NonNull @Initialized String account, @UnknownKeyFor @NonNull @Initialized String container, @UnknownKeyFor @NonNull @Initialized String blob) {
        return new AzfsResourceId(account, container, blob, null, null);
    }

    static @UnknownKeyFor @NonNull @Initialized AzfsResourceId fromComponents(@UnknownKeyFor @NonNull @Initialized String account, @UnknownKeyFor @NonNull @Initialized String container) {
        return new AzfsResourceId(account, container, null, null, null);
    }

    static @UnknownKeyFor @NonNull @Initialized AzfsResourceId fromUri(@UnknownKeyFor @NonNull @Initialized String uri) {
        Matcher m = AZFS_URI.matcher(uri);
        Preconditions.checkArgument((boolean)m.matches(), (String)"Invalid AZFS URI: [%s]", (Object)uri);
        Preconditions.checkArgument((boolean)m.group("SCHEME").equalsIgnoreCase(SCHEME), (String)"Invalid AZFS URI scheme: [%s]", (Object)uri);
        String account = m.group("ACCOUNT");
        String container = m.group("CONTAINER");
        String blob = m.group("BLOB");
        return AzfsResourceId.fromComponents(account, container, blob);
    }

    public @UnknownKeyFor @NonNull @Initialized String getAccount() {
        return this.account;
    }

    public @UnknownKeyFor @NonNull @Initialized String getContainer() {
        return this.container;
    }

    public @UnknownKeyFor @NonNull @Initialized String getBlob() {
        return this.blob;
    }

    public @UnknownKeyFor @NonNull @Initialized String getScheme() {
        return SCHEME;
    }

    @UnknownKeyFor @NonNull @Initialized Long getSize() {
        return this.size;
    }

    @UnknownKeyFor @NonNull @Initialized AzfsResourceId withSize(@UnknownKeyFor @NonNull @Initialized long size) {
        return new AzfsResourceId(this.account, this.container, this.blob, size, this.lastModified);
    }

    @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Date> getLastModified() {
        return Optional.fromNullable((Object)this.lastModified);
    }

    @UnknownKeyFor @NonNull @Initialized AzfsResourceId withLastModified(@UnknownKeyFor @NonNull @Initialized Date lastModified) {
        return new AzfsResourceId(this.account, this.container, this.blob, this.size, lastModified);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isDirectory() {
        return this.blob == null || this.blob.endsWith("/");
    }

    @UnknownKeyFor @NonNull @Initialized boolean isWildcard() {
        if (this.blob == null) {
            return false;
        }
        return GLOB_PREFIX.matcher(this.blob).matches();
    }

    @UnknownKeyFor @NonNull @Initialized String getBlobNonWildcardPrefix() {
        Matcher m = GLOB_PREFIX.matcher(this.getBlob());
        Preconditions.checkArgument((boolean)m.matches(), (Object)String.format("Glob expression: [%s] is not expandable.", this.getBlob()));
        return m.group("PREFIX");
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isContainer() {
        return this.blob == null;
    }

    public @UnknownKeyFor @NonNull @Initialized ResourceId getCurrentDirectory() {
        if (this.isDirectory()) {
            return this;
        }
        if (this.blob.lastIndexOf(47) == -1) {
            return AzfsResourceId.fromComponents(this.account, this.container);
        }
        return AzfsResourceId.fromComponents(this.account, this.container, this.blob.substring(0, this.blob.lastIndexOf(47) + 1));
    }

    public @Nullable @UnknownKeyFor @Initialized String getFilename() {
        if (this.blob == null) {
            return null;
        }
        if (!this.isDirectory()) {
            return this.blob.substring(this.blob.lastIndexOf(47) + 1);
        }
        String blobWithoutTrailingSlash = this.blob.substring(0, this.blob.length() - 1);
        return blobWithoutTrailingSlash.substring(blobWithoutTrailingSlash.lastIndexOf(47) + 1);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        if (this.blob != null) {
            return String.format("%s://%s/%s/%s", SCHEME, this.account, this.container, this.blob);
        }
        return String.format("%s://%s/%s/", SCHEME, this.account, this.container);
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@UnknownKeyFor @NonNull @Initialized Object obj) {
        if (!(obj instanceof AzfsResourceId)) {
            return false;
        }
        return this.account.equals(((AzfsResourceId)obj).account) && this.container.equals(((AzfsResourceId)obj).container) && Objects.equals(this.blob, ((AzfsResourceId)obj).blob);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.account, this.container, this.blob);
    }

    public @UnknownKeyFor @NonNull @Initialized ResourceId resolve(@UnknownKeyFor @NonNull @Initialized String other, @UnknownKeyFor @NonNull @Initialized ResolveOptions resolveOptions) {
        Preconditions.checkState((boolean)this.isDirectory(), (String)"Expected this resource to be a directory, but was [%s]", (Object)this.toString());
        if (resolveOptions == ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY) {
            if ("..".equals(other)) {
                if ("/".equals(this.blob)) {
                    return this;
                }
                int parentStopsAt = this.blob.substring(0, this.blob.length() - 1).lastIndexOf(47);
                return AzfsResourceId.fromComponents(this.account, this.container, this.blob.substring(0, parentStopsAt + 1));
            }
            if ("".equals(other)) {
                return this;
            }
            if (!other.endsWith("/")) {
                other = other + "/";
            }
            if (AZFS_URI.matcher(other).matches()) {
                return AzfsResourceId.fromUri(other);
            }
            if (this.blob == null) {
                return AzfsResourceId.fromComponents(this.account, this.container, other);
            }
            return AzfsResourceId.fromComponents(this.account, this.container, this.blob + other);
        }
        if (resolveOptions == ResolveOptions.StandardResolveOptions.RESOLVE_FILE) {
            Preconditions.checkArgument((!other.endsWith("/") ? 1 : 0) != 0, (String)"Cannot resolve a file with a directory path: [%s]", (Object)other);
            Preconditions.checkArgument((!"..".equals(other) ? 1 : 0) != 0, (String)"Cannot resolve parent as file: [%s]", (Object)other);
            if (AZFS_URI.matcher(other).matches()) {
                return AzfsResourceId.fromUri(other);
            }
            if (this.blob == null) {
                return AzfsResourceId.fromComponents(this.account, this.container, other);
            }
            return AzfsResourceId.fromComponents(this.account, this.container, this.blob + other);
        }
        throw new UnsupportedOperationException(String.format("Unexpected StandardResolveOptions [%s]", resolveOptions));
    }
}

