/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.primitive.ImmutableByteSet;
import org.eclipse.collections.impl.set.immutable.primitive.AbstractImmutableByteSet;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableByteSetSerializationProxy;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;

class ImmutableByteMapKeySet
extends AbstractImmutableByteSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final byte EMPTY_KEY = 0;
    private static final byte REMOVED_KEY = 1;
    private static final int CACHE_LINE_SIZE = 64;
    private static final int KEY_SIZE = 1;
    private static final int INITIAL_LINEAR_PROBE = 32;
    private final byte[] keys;
    private final int occupiedWithData;
    private final boolean containsZeroKey;
    private final boolean containsOneKey;

    ImmutableByteMapKeySet(byte[] keys, int occupiedWithData, boolean containsZeroKey, boolean containsOneKey) {
        this.keys = keys;
        this.occupiedWithData = occupiedWithData;
        this.containsZeroKey = containsZeroKey;
        this.containsOneKey = containsOneKey;
    }

    private static boolean isEmptyKey(byte key) {
        return key == 0;
    }

    private static boolean isRemovedKey(byte key) {
        return key == 1;
    }

    private static boolean isNonSentinel(byte key) {
        return !ImmutableByteMapKeySet.isEmptyKey(key) && !ImmutableByteMapKeySet.isRemovedKey(key);
    }

    @Override
    public int hashCode() {
        int result = 0;
        if (this.containsZeroKey) {
            result += 0;
        }
        if (this.containsOneKey) {
            ++result;
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableByteMapKeySet.isNonSentinel(this.keys[i])) continue;
                result += this.keys[i];
            }
        }
        return result;
    }

    public int size() {
        return this.occupiedWithData + (this.containsOneKey ? 1 : 0) + (this.containsZeroKey ? 1 : 0);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            int count = 0;
            if (this.containsZeroKey) {
                appendable.append(String.valueOf(0));
                ++count;
            }
            if (this.containsOneKey) {
                if (count > 0) {
                    appendable.append(separator);
                }
                ++count;
                appendable.append(String.valueOf(1));
            }
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableByteMapKeySet.isNonSentinel(this.keys[i])) continue;
                if (count > 0) {
                    appendable.append(separator);
                }
                ++count;
                appendable.append(String.valueOf(this.keys[i]));
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ByteIterator byteIterator() {
        return new InternalByteIterator();
    }

    public byte[] toArray() {
        byte[] array = new byte[this.size()];
        int index = 0;
        if (this.containsZeroKey) {
            array[index] = 0;
            ++index;
        }
        if (this.containsOneKey) {
            array[index] = 1;
            ++index;
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableByteMapKeySet.isNonSentinel(this.keys[i])) continue;
                array[index] = this.keys[i];
                ++index;
            }
        }
        return array;
    }

    public byte[] toArray(byte[] array) {
        if (array.length < this.size()) {
            array = new byte[this.size()];
        }
        int index = 0;
        if (this.containsZeroKey) {
            array[index] = 0;
            ++index;
        }
        if (this.containsOneKey) {
            array[index] = 1;
            ++index;
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableByteMapKeySet.isNonSentinel(this.keys[i])) continue;
                array[index] = this.keys[i];
                ++index;
            }
        }
        return array;
    }

    public boolean contains(byte value) {
        if (value == 0) {
            return this.containsZeroKey;
        }
        if (value == 1) {
            return this.containsOneKey;
        }
        return this.keys[this.probe(value)] == value;
    }

    public void forEach(ByteProcedure procedure) {
        this.each(procedure);
    }

    public void each(ByteProcedure procedure) {
        if (this.containsZeroKey) {
            procedure.value((byte)0);
        }
        if (this.containsOneKey) {
            procedure.value((byte)1);
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableByteMapKeySet.isNonSentinel(this.keys[i])) continue;
                procedure.value(this.keys[i]);
            }
        }
    }

    public ImmutableByteSet select(BytePredicate predicate) {
        ByteHashSet result = new ByteHashSet();
        if (this.containsZeroKey && predicate.accept((byte)0)) {
            result.add((byte)0);
        }
        if (this.containsOneKey && predicate.accept((byte)1)) {
            result.add((byte)1);
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableByteMapKeySet.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i])) continue;
            result.add(this.keys[i]);
        }
        return result.toImmutable();
    }

    public ImmutableByteSet reject(BytePredicate predicate) {
        ByteHashSet result = new ByteHashSet();
        if (this.containsZeroKey && !predicate.accept((byte)0)) {
            result.add((byte)0);
        }
        if (this.containsOneKey && !predicate.accept((byte)1)) {
            result.add((byte)1);
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableByteMapKeySet.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i])) continue;
            result.add(this.keys[i]);
        }
        return result.toImmutable();
    }

    public <V> ImmutableSet<V> collect(ByteToObjectFunction<? extends V> function) {
        UnifiedSet target = UnifiedSet.newSet(this.size());
        if (this.containsZeroKey) {
            target.add(function.valueOf((byte)0));
        }
        if (this.containsOneKey) {
            target.add(function.valueOf((byte)1));
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableByteMapKeySet.isNonSentinel(this.keys[i])) continue;
                target.add(function.valueOf(this.keys[i]));
            }
        }
        return target.toImmutable();
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        if (this.containsZeroKey && predicate.accept((byte)0)) {
            return 0;
        }
        if (this.containsOneKey && predicate.accept((byte)1)) {
            return 1;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableByteMapKeySet.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i])) continue;
            return this.keys[i];
        }
        return ifNone;
    }

    public int count(BytePredicate predicate) {
        int count = 0;
        if (this.containsZeroKey && predicate.accept((byte)0)) {
            ++count;
        }
        if (this.containsOneKey && predicate.accept((byte)1)) {
            ++count;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableByteMapKeySet.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i])) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(BytePredicate predicate) {
        if (this.containsZeroKey && predicate.accept((byte)0)) {
            return true;
        }
        if (this.containsOneKey && predicate.accept((byte)1)) {
            return true;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableByteMapKeySet.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i])) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(BytePredicate predicate) {
        if (this.containsZeroKey && !predicate.accept((byte)0)) {
            return false;
        }
        if (this.containsOneKey && !predicate.accept((byte)1)) {
            return false;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableByteMapKeySet.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i])) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(BytePredicate predicate) {
        if (this.containsZeroKey && predicate.accept((byte)0)) {
            return false;
        }
        if (this.containsOneKey && predicate.accept((byte)1)) {
            return false;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableByteMapKeySet.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i])) continue;
            return false;
        }
        return true;
    }

    public long sum() {
        long nextSum;
        long adjustedValue;
        long result = 0L;
        long compensation = 0L;
        if (this.containsZeroKey) {
            adjustedValue = 0L - compensation;
            nextSum = result + adjustedValue;
            compensation = nextSum - result - adjustedValue;
            result = nextSum;
        }
        if (this.containsOneKey) {
            adjustedValue = 1L - compensation;
            nextSum = result + adjustedValue;
            compensation = nextSum - result - adjustedValue;
            result = nextSum;
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableByteMapKeySet.isNonSentinel(this.keys[i])) continue;
                long adjustedValue2 = (long)this.keys[i] - compensation;
                long nextSum2 = result + adjustedValue2;
                compensation = nextSum2 - result - adjustedValue2;
                result = nextSum2;
            }
        }
        return result;
    }

    public byte max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        byte max = 0;
        boolean isMaxSet = false;
        if (this.containsZeroKey) {
            max = 0;
            isMaxSet = true;
        }
        if (this.containsOneKey && (!isMaxSet || max < 1)) {
            max = 1;
            isMaxSet = true;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableByteMapKeySet.isNonSentinel(this.keys[i]) || isMaxSet && max >= this.keys[i]) continue;
            max = this.keys[i];
            isMaxSet = true;
        }
        return max;
    }

    public byte min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        byte min = 0;
        boolean isMinSet = false;
        if (this.containsZeroKey) {
            min = 0;
            isMinSet = true;
        }
        if (this.containsOneKey && (!isMinSet || 1 < min)) {
            min = 1;
            isMinSet = true;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableByteMapKeySet.isNonSentinel(this.keys[i]) || isMinSet && this.keys[i] >= min) continue;
            min = this.keys[i];
            isMinSet = true;
        }
        return min;
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        Object result = injectedValue;
        if (this.containsZeroKey) {
            result = function.valueOf(result, (byte)0);
        }
        if (this.containsOneKey) {
            result = function.valueOf(result, (byte)1);
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableByteMapKeySet.isNonSentinel(this.keys[i])) continue;
                result = function.valueOf(result, this.keys[i]);
            }
        }
        return result;
    }

    private Object writeReplace() {
        return new ImmutableByteSetSerializationProxy(this);
    }

    int probe(byte element) {
        int index = this.spreadAndMask(element);
        byte keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == 0) {
            return index;
        }
        int removedIndex = keyAtIndex == 1 ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (this.keys[nextIndex &= this.keys.length - 1] == element) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == 1) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (this.keys[nextIndex] == 0) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spreadAndMask(byte element) {
        return this.mask(element);
    }

    private int mask(int spread) {
        return spread & this.keys.length - 1;
    }

    private class InternalByteIterator
    implements ByteIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private InternalByteIterator() {
        }

        public boolean hasNext() {
            return this.count < ImmutableByteMapKeySet.this.size();
        }

        public byte next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (ImmutableByteMapKeySet.this.containsZeroKey) {
                    return 0;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (ImmutableByteMapKeySet.this.containsOneKey) {
                    return 1;
                }
            }
            byte[] keys = ImmutableByteMapKeySet.this.keys;
            while (!ImmutableByteMapKeySet.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            byte result = ImmutableByteMapKeySet.this.keys[this.position];
            ++this.position;
            return result;
        }
    }
}

