/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.protobuf;

import com.google.cloud.storage.Blob;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import com.squareup.wire.schema.internal.parser.ProtoParser;
import io.apicurio.registry.utils.protobuf.schema.FileDescriptorUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.extensions.protobuf.ProtoDomain;
import org.apache.beam.sdk.extensions.protobuf.ProtoDynamicMessageSchema;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Splitter;
import org.apache.commons.compress.utils.IOUtils;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoByteUtils {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ProtoByteUtils.class);
    private static final @UnknownKeyFor @NonNull @Initialized Location LOCATION = Location.get((String)"");

    public static @UnknownKeyFor @NonNull @Initialized Schema getBeamSchemaFromProto(@UnknownKeyFor @NonNull @Initialized String fileDescriptorPath, @UnknownKeyFor @NonNull @Initialized String messageName) {
        ProtoSchemaInfo dpd = ProtoByteUtils.getProtoDomain(fileDescriptorPath, messageName);
        ProtoDomain protoDomain = dpd.getProtoDomain();
        return ProtoDynamicMessageSchema.forDescriptor(protoDomain, messageName).getSchema();
    }

    public static @UnknownKeyFor @NonNull @Initialized Schema getBeamSchemaFromProtoSchema(@UnknownKeyFor @NonNull @Initialized String schemaString, @UnknownKeyFor @NonNull @Initialized String messageName) {
        Descriptors.Descriptor descriptor = ProtoByteUtils.getDescriptorFromProtoSchema(schemaString, messageName);
        return ProtoDynamicMessageSchema.forDescriptor(ProtoDomain.buildFrom(descriptor), descriptor).getSchema();
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor getDescriptorFromProtoSchema(@UnknownKeyFor @NonNull @Initialized String schemaString, @UnknownKeyFor @NonNull @Initialized String messageName) {
        ProtoFileElement result = ProtoParser.Companion.parse(LOCATION, schemaString);
        try {
            Descriptors.FileDescriptor fileDescriptor = FileDescriptorUtils.protoFileToFileDescriptor((ProtoFileElement)result);
            List messageElements = Splitter.on((char)'.').splitToList((CharSequence)messageName);
            String messageTypeByName = (String)messageElements.get(messageElements.size() - 1);
            return fileDescriptor.findMessageTypeByName(messageTypeByName);
        }
        catch (Descriptors.DescriptorValidationException e) {
            throw new RuntimeException(e);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Row> getProtoBytesToRowFromSchemaFunction(final @UnknownKeyFor @NonNull @Initialized String schemaString, final @UnknownKeyFor @NonNull @Initialized String messageName) {
        Descriptors.Descriptor descriptor = ProtoByteUtils.getDescriptorFromProtoSchema(schemaString, messageName);
        final ProtoDynamicMessageSchema<DynamicMessage> protoDynamicMessageSchema = ProtoDynamicMessageSchema.forDescriptor(ProtoDomain.buildFrom(descriptor), descriptor);
        return new SimpleFunction<byte[], Row>(){

            public @UnknownKeyFor @NonNull @Initialized Row apply(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] input) {
                try {
                    Descriptors.Descriptor descriptorFunction = ProtoByteUtils.getDescriptorFromProtoSchema(schemaString, messageName);
                    DynamicMessage dynamicMessage = DynamicMessage.parseFrom((Descriptors.Descriptor)descriptorFunction, (byte[])input);
                    SerializableFunction res = protoDynamicMessageSchema.getToRowFunction();
                    return (Row)res.apply((Object)dynamicMessage);
                }
                catch (InvalidProtocolBufferException e) {
                    LOG.error("Error parsing to DynamicMessage", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Row> getProtoBytesToRowFunction(@UnknownKeyFor @NonNull @Initialized String fileDescriptorPath, final @UnknownKeyFor @NonNull @Initialized String messageName) {
        final ProtoSchemaInfo dynamicProtoDomain = ProtoByteUtils.getProtoDomain(fileDescriptorPath, messageName);
        final ProtoDomain protoDomain = dynamicProtoDomain.getProtoDomain();
        final ProtoDynamicMessageSchema protoDynamicMessageSchema = ProtoDynamicMessageSchema.forDescriptor(protoDomain, messageName);
        return new SimpleFunction<byte[], Row>(){

            public @UnknownKeyFor @NonNull @Initialized Row apply(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] input) {
                try {
                    List messageElements = Splitter.on((char)'.').splitToList((CharSequence)messageName);
                    String messageTypeByName = (String)messageElements.get(messageElements.size() - 1);
                    Descriptors.Descriptor descriptor = protoDomain.getFileDescriptor(dynamicProtoDomain.getFileName()).findMessageTypeByName(messageTypeByName);
                    DynamicMessage dynamicMessage = DynamicMessage.parseFrom((Descriptors.Descriptor)descriptor, (byte[])input);
                    SerializableFunction res = protoDynamicMessageSchema.getToRowFunction();
                    return (Row)res.apply((Object)dynamicMessage);
                }
                catch (InvalidProtocolBufferException e) {
                    LOG.error("Error parsing to DynamicMessage", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> getRowToProtoBytesFromSchema(@UnknownKeyFor @NonNull @Initialized String schemaString, @UnknownKeyFor @NonNull @Initialized String messageName) {
        Descriptors.Descriptor descriptor = ProtoByteUtils.getDescriptorFromProtoSchema(schemaString, messageName);
        final ProtoDynamicMessageSchema<DynamicMessage> protoDynamicMessageSchema = ProtoDynamicMessageSchema.forDescriptor(ProtoDomain.buildFrom(descriptor), descriptor);
        return new SimpleFunction<Row, byte[]>(){

            public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] apply(@UnknownKeyFor @NonNull @Initialized Row input) {
                SerializableFunction res = protoDynamicMessageSchema.getFromRowFunction();
                return ((DynamicMessage)res.apply((Object)input)).toByteArray();
            }
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> getRowToProtoBytes(@UnknownKeyFor @NonNull @Initialized String fileDescriptorPath, @UnknownKeyFor @NonNull @Initialized String messageName) {
        ProtoSchemaInfo dynamicProtoDomain = ProtoByteUtils.getProtoDomain(fileDescriptorPath, messageName);
        ProtoDomain protoDomain = dynamicProtoDomain.getProtoDomain();
        final ProtoDynamicMessageSchema protoDynamicMessageSchema = ProtoDynamicMessageSchema.forDescriptor(protoDomain, messageName);
        return new SimpleFunction<Row, byte[]>(){

            public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] apply(@UnknownKeyFor @NonNull @Initialized Row input) {
                SerializableFunction res = protoDynamicMessageSchema.getFromRowFunction();
                return ((DynamicMessage)res.apply((Object)input)).toByteArray();
            }
        };
    }

    private static @UnknownKeyFor @NonNull @Initialized ProtoSchemaInfo getProtoDomain(@UnknownKeyFor @NonNull @Initialized String fileDescriptorPath, @UnknownKeyFor @NonNull @Initialized String messageName) {
        byte[] from = ProtoByteUtils.getFileAsBytes(fileDescriptorPath);
        try {
            List messageElements = Splitter.on((char)'.').splitToList((CharSequence)messageName);
            String messageTypeByName = (String)messageElements.get(messageElements.size() - 1);
            DescriptorProtos.FileDescriptorSet descriptorSet = DescriptorProtos.FileDescriptorSet.parseFrom((byte[])from);
            ProtoDomain protoDomain = ProtoDomain.buildFrom(descriptorSet);
            ArrayList fileProtoNames = new ArrayList();
            descriptorSet.getFileList().forEach(fileDescriptorProto -> fileProtoNames.add(fileDescriptorProto.getName()));
            String fullName = fileProtoNames.stream().filter(name -> protoDomain.getFileDescriptor((String)name).findMessageTypeByName(messageTypeByName) != null).findFirst().orElseThrow(() -> new NullPointerException("Couldn't locate the proto for that message name"));
            return new ProtoSchemaInfo(fullName, protoDomain);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getFileAsBytes(@UnknownKeyFor @NonNull @Initialized String fileDescriptorPath) {
        ReadableByteChannel channel = ProtoByteUtils.getFileByteChannel(fileDescriptorPath);
        try (InputStream inputStream = Channels.newInputStream(channel);){
            byte[] byArray = IOUtils.toByteArray((InputStream)inputStream);
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Error when reading: " + fileDescriptorPath, e);
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized ReadableByteChannel getFileByteChannel(@UnknownKeyFor @NonNull @Initialized String filePath) {
        if (ProtoByteUtils.isGcsPath(filePath)) {
            return ProtoByteUtils.openGcsFile(filePath);
        }
        return ProtoByteUtils.openLocalFile(filePath);
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isGcsPath(@UnknownKeyFor @NonNull @Initialized String filePath) {
        return filePath.startsWith("gs://");
    }

    private static @UnknownKeyFor @NonNull @Initialized ReadableByteChannel openGcsFile(@UnknownKeyFor @NonNull @Initialized String filePath) {
        Storage storage = (Storage)StorageOptions.getDefaultInstance().getService();
        String bucketName = ProtoByteUtils.getBucketName(filePath);
        String objectName = ProtoByteUtils.getObjectName(filePath);
        Blob blob = storage.get(bucketName, objectName, new Storage.BlobGetOption[0]);
        return blob.reader(new Blob.BlobSourceOption[0]);
    }

    private static @UnknownKeyFor @NonNull @Initialized ReadableByteChannel openLocalFile(@UnknownKeyFor @NonNull @Initialized String filePath) {
        try {
            MatchResult result = FileSystems.match((String)filePath);
            Preconditions.checkArgument((result.status() == MatchResult.Status.OK && !result.metadata().isEmpty() ? 1 : 0) != 0, (Object)("Failed to match any files with the pattern: " + filePath));
            List rId = result.metadata().stream().map(MatchResult.Metadata::resourceId).collect(Collectors.toList());
            Preconditions.checkArgument((rId.size() == 1 ? 1 : 0) != 0, (Object)("Expected exactly 1 file, but got " + rId.size() + " files."));
            return FileSystems.open((ResourceId)((ResourceId)rId.get(0)));
        }
        catch (IOException e) {
            throw new RuntimeException("Error when finding: " + filePath, e);
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized String getBucketName(@UnknownKeyFor @NonNull @Initialized String gcsPath) {
        int startIndex = "gs://".length();
        int endIndex = gcsPath.indexOf(47, startIndex);
        return gcsPath.substring(startIndex, endIndex);
    }

    private static @UnknownKeyFor @NonNull @Initialized String getObjectName(@UnknownKeyFor @NonNull @Initialized String gcsPath) {
        int startIndex = gcsPath.indexOf(47, "gs://".length()) + 1;
        return gcsPath.substring(startIndex);
    }

    static class ProtoSchemaInfo
    implements Serializable {
        private @UnknownKeyFor @NonNull @Initialized String fileName;
        private @UnknownKeyFor @NonNull @Initialized ProtoDomain protoDomain;

        public ProtoSchemaInfo(@UnknownKeyFor @NonNull @Initialized String fileName, @UnknownKeyFor @NonNull @Initialized ProtoDomain protoDomain) {
            this.fileName = fileName;
            this.protoDomain = protoDomain;
        }

        public void setProtoDomain(@UnknownKeyFor @NonNull @Initialized ProtoDomain protoDomain) {
            this.protoDomain = protoDomain;
        }

        public @UnknownKeyFor @NonNull @Initialized ProtoDomain getProtoDomain() {
            return this.protoDomain;
        }

        public @UnknownKeyFor @NonNull @Initialized String getFileName() {
            return this.fileName;
        }

        public void setFileName(@UnknownKeyFor @NonNull @Initialized String fileName) {
            this.fileName = fileName;
        }
    }
}

