/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.integration.impl;

import org.mvel2.DataConversion;
import org.mvel2.integration.VariableResolver;

public class SimpleSTValueResolver
implements VariableResolver {
    private Object value;
    private Class type;
    private boolean updated = false;

    public SimpleSTValueResolver(Object value, Class type) {
        this.value = SimpleSTValueResolver.handleTypeCoercion(type, value);
        this.type = type;
    }

    public SimpleSTValueResolver(Object value, Class type, boolean updated) {
        this.value = SimpleSTValueResolver.handleTypeCoercion(type, value);
        this.type = type;
        this.updated = updated;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public Class getType() {
        return this.type;
    }

    @Override
    public void setStaticType(Class type) {
        this.type = type;
    }

    @Override
    public int getFlags() {
        return this.updated ? -1 : 0;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        this.updated = true;
        this.value = SimpleSTValueResolver.handleTypeCoercion(this.type, value);
    }

    private static Object handleTypeCoercion(Class type, Object value) {
        if (type != null && value != null && value.getClass() != type) {
            if (!DataConversion.canConvert(type, value.getClass())) {
                throw new RuntimeException("cannot assign " + value.getClass().getName() + " to type: " + type.getName());
            }
            try {
                return DataConversion.convert(value, type);
            }
            catch (Exception e) {
                throw new RuntimeException("cannot convert value of " + value.getClass().getName() + " to: " + type.getName());
            }
        }
        return value;
    }
}

