/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.html2text;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.html2text.Html2TextMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class Html2TextDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = Html2TextDialog.class;
    private final Html2TextMeta input;
    private boolean gotPreviousFields = false;
    private CCombo wHtmlFieldName;
    private CCombo wSafelistType;
    private TextVar wOutputField;
    private Button wCleanOnly;
    private Button wNormalisedText;
    private Button wParallelism;

    public Html2TextDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (ITransformMeta)((BaseTransformMeta)in), pipelineMeta, sname);
        this.input = (Html2TextMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"Html2TextDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wCleanOnly = new Button((Composite)this.shell, 32);
        this.wCleanOnly.setSelection(this.input.isCleanOnly());
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"Html2TextDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label wlHtmlFieldName = new Label((Composite)this.shell, 131072);
        wlHtmlFieldName.setText(BaseMessages.getString(PKG, (String)"Html2TextDialog.HtmlFieldName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlHtmlFieldName);
        FormData fdlHtmlFieldName = new FormData();
        fdlHtmlFieldName.left = new FormAttachment(0, 0);
        fdlHtmlFieldName.right = new FormAttachment(middle, -margin);
        fdlHtmlFieldName.top = new FormAttachment((Control)this.wTransformName, margin);
        wlHtmlFieldName.setLayoutData((Object)fdlHtmlFieldName);
        this.wHtmlFieldName = new CCombo((Composite)this.shell, 2056);
        PropsUi.setLook((Widget)this.wHtmlFieldName);
        this.wHtmlFieldName.addModifyListener(lsMod);
        FormData fdHtmlFieldName = new FormData();
        fdHtmlFieldName.left = new FormAttachment(middle, 0);
        fdHtmlFieldName.top = new FormAttachment((Control)this.wTransformName, margin);
        fdHtmlFieldName.right = new FormAttachment(100, -margin);
        this.wHtmlFieldName.setLayoutData((Object)fdHtmlFieldName);
        this.wHtmlFieldName.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)Html2TextDialog.this.shell.getDisplay(), 1);
                Html2TextDialog.this.shell.setCursor(busy);
                Html2TextDialog.this.get();
                Html2TextDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        Label wlOutputField = new Label((Composite)this.shell, 131072);
        wlOutputField.setText(BaseMessages.getString(PKG, (String)"Html2TextDialog.OutputField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlOutputField);
        FormData fdlOutputField = new FormData();
        fdlOutputField.left = new FormAttachment(0, 0);
        fdlOutputField.right = new FormAttachment(middle, -margin);
        fdlOutputField.top = new FormAttachment((Control)this.wHtmlFieldName, margin);
        wlOutputField.setLayoutData((Object)fdlOutputField);
        this.wOutputField = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.wOutputField.setText("");
        PropsUi.setLook((Widget)this.wOutputField);
        this.wOutputField.addModifyListener(lsMod);
        FormData fdOutputField = new FormData();
        fdOutputField.left = new FormAttachment(middle, 0);
        fdOutputField.top = new FormAttachment((Control)this.wHtmlFieldName, margin);
        fdOutputField.right = new FormAttachment(100, 0);
        this.wOutputField.setLayoutData((Object)fdOutputField);
        final Label wlNormalisedText = new Label((Composite)this.shell, 131072);
        wlNormalisedText.setVisible(!this.wCleanOnly.getSelection());
        wlNormalisedText.setText(BaseMessages.getString(PKG, (String)"Html2TextDialog.NormalisedText.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlNormalisedText);
        FormData fdlNormalisedText = new FormData();
        fdlNormalisedText.left = new FormAttachment(0, 0);
        fdlNormalisedText.top = new FormAttachment((Control)this.wOutputField, margin);
        fdlNormalisedText.right = new FormAttachment(middle, -2 * margin);
        wlNormalisedText.setLayoutData((Object)fdlNormalisedText);
        this.wNormalisedText = new Button((Composite)this.shell, 32);
        this.wNormalisedText.setSelection(this.input.isNormalisedText());
        this.wNormalisedText.setVisible(!this.wCleanOnly.getSelection());
        PropsUi.setLook((Widget)this.wNormalisedText);
        this.wNormalisedText.setToolTipText(BaseMessages.getString(PKG, (String)"Html2TextDialog.NormalisedText.Tooltip", (String[])new String[0]));
        FormData fdNormalisedText = new FormData();
        fdNormalisedText.left = new FormAttachment(middle, -margin);
        fdNormalisedText.top = new FormAttachment((Control)this.wOutputField, margin * 2);
        fdNormalisedText.right = new FormAttachment(100, 0);
        this.wNormalisedText.setLayoutData((Object)fdNormalisedText);
        this.wNormalisedText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Html2TextDialog.this.input.setChanged();
            }
        });
        Label wlCleanOnly = new Label((Composite)this.shell, 131072);
        wlCleanOnly.setText(BaseMessages.getString(PKG, (String)"Html2TextDialog.CleanOnly.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCleanOnly);
        FormData fdlCleanOnly = new FormData();
        fdlCleanOnly.left = new FormAttachment(0, 0);
        fdlCleanOnly.top = new FormAttachment((Control)this.wNormalisedText, margin);
        fdlCleanOnly.right = new FormAttachment(middle, -2 * margin);
        wlCleanOnly.setLayoutData((Object)fdlCleanOnly);
        PropsUi.setLook((Widget)this.wCleanOnly);
        FormData fdCleanOnly = new FormData();
        fdCleanOnly.left = new FormAttachment(middle, -margin);
        fdCleanOnly.top = new FormAttachment((Control)this.wNormalisedText, margin * 2);
        fdCleanOnly.right = new FormAttachment(100, 0);
        this.wCleanOnly.setLayoutData((Object)fdCleanOnly);
        final Label wlSafelistType = new Label((Composite)this.shell, 131072);
        wlSafelistType.setVisible(this.wCleanOnly.getSelection());
        this.wCleanOnly.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Html2TextDialog.this.input.setChanged();
                Html2TextDialog.this.wSafelistType.setEnabled(Html2TextDialog.this.wCleanOnly.getSelection());
                Html2TextDialog.this.wSafelistType.setVisible(Html2TextDialog.this.wCleanOnly.getSelection());
                wlSafelistType.setVisible(Html2TextDialog.this.wCleanOnly.getSelection());
                wlNormalisedText.setVisible(!Html2TextDialog.this.wCleanOnly.getSelection());
                Html2TextDialog.this.wNormalisedText.setVisible(!Html2TextDialog.this.wCleanOnly.getSelection());
            }
        });
        wlSafelistType.setText(BaseMessages.getString(PKG, (String)"Html2TextDialog.SafelistType.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSafelistType);
        FormData fdSafelistType = new FormData();
        fdSafelistType.left = new FormAttachment(0, 0);
        fdSafelistType.right = new FormAttachment(middle, -margin);
        fdSafelistType.top = new FormAttachment((Control)this.wCleanOnly, margin);
        wlSafelistType.setLayoutData((Object)fdSafelistType);
        this.wSafelistType = new CCombo((Composite)this.shell, 2060);
        this.wSafelistType.setEnabled(this.wCleanOnly.getSelection());
        this.wSafelistType.setVisible(this.wCleanOnly.getSelection());
        this.wSafelistType.setItems(Html2TextMeta.SafelistType.getDescriptions());
        this.wSafelistType.select(0);
        PropsUi.setLook((Widget)this.wSafelistType);
        FormData fdType = new FormData();
        fdType.left = new FormAttachment(middle, 0);
        fdType.top = new FormAttachment((Control)this.wCleanOnly, margin);
        fdType.right = new FormAttachment(100, 0);
        this.wSafelistType.setLayoutData((Object)fdType);
        this.wSafelistType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Html2TextDialog.this.input.setChanged();
            }
        });
        Label wlParallelism = new Label((Composite)this.shell, 131072);
        wlParallelism.setText(BaseMessages.getString(PKG, (String)"Html2TextDialog.Parallelism.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlParallelism);
        FormData fdlParallelism = new FormData();
        fdlParallelism.left = new FormAttachment(0, 0);
        fdlParallelism.top = new FormAttachment((Control)this.wSafelistType, margin);
        fdlParallelism.right = new FormAttachment(middle, -2 * margin);
        wlParallelism.setLayoutData((Object)fdlParallelism);
        this.wParallelism = new Button((Composite)this.shell, 32);
        this.wParallelism.setSelection(this.input.isParallelism());
        PropsUi.setLook((Widget)this.wParallelism);
        this.wParallelism.setToolTipText(BaseMessages.getString(PKG, (String)"Html2TextDialog.Parallelism.Tooltip", (String[])new String[0]));
        FormData fdParallelism = new FormData();
        fdParallelism.left = new FormAttachment(middle, -margin);
        fdParallelism.top = new FormAttachment((Control)this.wSafelistType, margin * 2);
        fdParallelism.right = new FormAttachment(100, 0);
        this.wParallelism.setLayoutData((Object)fdParallelism);
        this.wParallelism.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Html2TextDialog.this.input.setChanged();
            }
        });
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, (Control)this.wParallelism);
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel.addListener(13, e -> this.cancel());
        this.getData();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        if (this.input.getHtmlField() != null) {
            this.wHtmlFieldName.setText(this.input.getHtmlField());
        }
        if (this.input.isParallelism()) {
            this.wParallelism.setEnabled(this.input.isParallelism());
        }
        if (this.input.isCleanOnly()) {
            this.wCleanOnly.setEnabled(this.input.isCleanOnly());
        }
        if (this.input.isNormalisedText()) {
            this.wNormalisedText.setEnabled(this.input.isNormalisedText());
        }
        if (this.input.getSafelistType() != null) {
            String d = Html2TextMeta.SafelistType.valueOf(this.input.getSafelistType()).getDescription();
            this.wSafelistType.setText(d);
        }
        this.wOutputField.setText(String.valueOf(this.input.getOutputField()));
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.input.setHtmlField(this.wHtmlFieldName.getText());
        this.input.setSafelistType(Html2TextMeta.SafelistType.getTypeFromDescription(this.wSafelistType.getText()).getCode());
        this.input.setOutputField(this.wOutputField.getText());
        this.input.setCleanOnly(this.wCleanOnly.getSelection());
        this.input.setNormalisedText(this.wNormalisedText.getSelection());
        this.input.setParallelism(this.wParallelism.getSelection());
        this.transformName = this.wTransformName.getText();
        this.dispose();
    }

    private void get() {
        if (!this.gotPreviousFields) {
            try {
                String htmlField = null;
                if (this.wHtmlFieldName.getText() != null) {
                    htmlField = this.wHtmlFieldName.getText();
                }
                this.wHtmlFieldName.removeAll();
                IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
                if (r != null) {
                    this.wHtmlFieldName.setItems(r.getFieldNames());
                }
                if (htmlField != null) {
                    this.wHtmlFieldName.setText(htmlField);
                }
                this.gotPreviousFields = true;
            }
            catch (HopException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Html2TextDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Html2TextDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
        }
    }
}

