/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.bind;

import com.sforce.ws.ConnectionException;
import com.sforce.ws.ConnectorConfig;
import com.sforce.ws.bind.CalendarCodec;
import com.sforce.ws.bind.DateCodec;
import com.sforce.ws.bind.HTMLResponseException;
import com.sforce.ws.bind.NameMapper;
import com.sforce.ws.bind.TypeInfo;
import com.sforce.ws.bind.XMLizable;
import com.sforce.ws.parser.XmlInputStream;
import com.sforce.ws.parser.XmlOutputStream;
import com.sforce.ws.types.OffsetDate;
import com.sforce.ws.types.Time;
import com.sforce.ws.util.Base64;
import com.sforce.ws.wsdl.Restriction;
import com.sforce.ws.wsdl.SfdcApiType;
import com.sforce.ws.wsdl.SimpleType;
import com.sforce.ws.wsdl.Types;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.namespace.QName;

public class TypeMapper {
    public static final String HTML = "html";
    private static HashMap<QName, String> nillableJavaMapping = TypeMapper.getNillableXmlJavaMapping();
    private static final HashSet<String> keywords = TypeMapper.getKeyWords();
    private static HashMap<String, Class<?>> primitiveClassCache = TypeMapper.getPrimitiveClassCache();
    private boolean generateInterfaces;
    private boolean generateExtendedErrorCodes;
    private String packagePrefix;
    private String interfacePackagePrefix;
    private final Map<QName, String> xmlJavaMapping;
    private final Map<String, QName> javaXmlMapping;
    private CalendarCodec calendarCodec = new CalendarCodec();
    private DateCodec dateCodec = new DateCodec();
    private HashMap<QName, Class<?>> typeCache = new HashMap();
    private ConnectorConfig config;
    public boolean writeFieldXsiType = false;

    private Map<String, QName> getJavaXmlMapping(boolean javaTime) {
        HashMap<String, QName> map = new HashMap<String, QName>();
        map.put(String.class.getName(), new QName("http://www.w3.org/2001/XMLSchema", "string"));
        map.put(Integer.TYPE.getName(), new QName("http://www.w3.org/2001/XMLSchema", "int"));
        map.put(Integer.class.getName(), new QName("http://www.w3.org/2001/XMLSchema", "int"));
        map.put(Boolean.TYPE.getName(), new QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        map.put(Boolean.class.getName(), new QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        map.put(Long.TYPE.getName(), new QName("http://www.w3.org/2001/XMLSchema", "long"));
        map.put(Long.class.getName(), new QName("http://www.w3.org/2001/XMLSchema", "long"));
        map.put(Float.TYPE.getName(), new QName("http://www.w3.org/2001/XMLSchema", "float"));
        map.put(Float.class.getName(), new QName("http://www.w3.org/2001/XMLSchema", "float"));
        if (javaTime) {
            map.put(OffsetDate.class.getName(), new QName("http://www.w3.org/2001/XMLSchema", "date"));
            map.put(OffsetDateTime.class.getName(), new QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
            map.put(OffsetTime.class.getName(), new QName("http://www.w3.org/2001/XMLSchema", "time"));
        } else {
            map.put(Date.class.getName(), new QName("http://www.w3.org/2001/XMLSchema", "date"));
            map.put(Calendar.class.getName(), new QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
            map.put(GregorianCalendar.class.getName(), new QName("http://www.w3.org/2001/XMLSchema", "dateTime"));
            map.put(Time.class.getName(), new QName("http://www.w3.org/2001/XMLSchema", "time"));
        }
        map.put("[B", new QName("http://www.w3.org/2001/XMLSchema", "base64Binary"));
        map.put(Double.TYPE.getName(), new QName("http://www.w3.org/2001/XMLSchema", "double"));
        map.put(Double.class.getName(), new QName("http://www.w3.org/2001/XMLSchema", "double"));
        map.put(Object.class.getName(), new QName("http://www.w3.org/2001/XMLSchema", "anyType"));
        map.put(BigDecimal.class.getName(), new QName("http://www.w3.org/2001/XMLSchema", "decimal"));
        return map;
    }

    private Map<QName, String> getXmlJavaMapping(boolean javaTime) {
        HashMap<QName, String> map = new HashMap<QName, String>();
        map.put(new QName("http://www.w3.org/2001/XMLSchema", "string"), String.class.getName());
        map.put(new QName("http://www.w3.org/2001/XMLSchema", "int"), Integer.TYPE.getName());
        map.put(new QName("http://www.w3.org/2001/XMLSchema", "long"), Long.TYPE.getName());
        map.put(new QName("http://www.w3.org/2001/XMLSchema", "float"), Float.TYPE.getName());
        map.put(new QName("http://www.w3.org/2001/XMLSchema", "boolean"), Boolean.TYPE.getName());
        if (javaTime) {
            map.put(new QName("http://www.w3.org/2001/XMLSchema", "date"), OffsetDate.class.getName());
            map.put(new QName("http://www.w3.org/2001/XMLSchema", "dateTime"), OffsetDateTime.class.getName());
            map.put(new QName("http://www.w3.org/2001/XMLSchema", "time"), OffsetTime.class.getName());
        } else {
            map.put(new QName("http://www.w3.org/2001/XMLSchema", "date"), Calendar.class.getName());
            map.put(new QName("http://www.w3.org/2001/XMLSchema", "dateTime"), Calendar.class.getName());
            map.put(new QName("http://www.w3.org/2001/XMLSchema", "time"), Time.class.getName());
        }
        map.put(new QName("http://www.w3.org/2001/XMLSchema", "base64Binary"), "byte[]");
        map.put(new QName("http://www.w3.org/2001/XMLSchema", "double"), Double.TYPE.getName());
        map.put(new QName("http://www.w3.org/2001/XMLSchema", "decimal"), BigDecimal.class.getName());
        map.put(new QName("http://www.w3.org/2001/XMLSchema", "anyType"), Object.class.getName());
        SfdcApiType[] sfdcApiTypeArray = SfdcApiType.values();
        int n = sfdcApiTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SfdcApiType type = sfdcApiTypeArray[n2];
            map.put(new QName(type.getNamespace(), "ID"), String.class.getName());
            map.put(new QName(type.getNamespace(), "QueryLocator"), String.class.getName());
            ++n2;
        }
        return map;
    }

    private static HashMap<QName, String> getNillableXmlJavaMapping() {
        HashMap<QName, String> map = new HashMap<QName, String>();
        map.put(new QName("http://www.w3.org/2001/XMLSchema", "int"), Integer.class.getName());
        map.put(new QName("http://www.w3.org/2001/XMLSchema", "boolean"), Boolean.class.getName());
        map.put(new QName("http://www.w3.org/2001/XMLSchema", "double"), Double.class.getName());
        map.put(new QName("http://www.w3.org/2001/XMLSchema", "decimal"), BigDecimal.class.getName());
        map.put(new QName("http://www.w3.org/2001/XMLSchema", "long"), Long.class.getName());
        map.put(new QName("http://www.w3.org/2001/XMLSchema", "float"), Float.class.getName());
        return map;
    }

    private static HashMap<String, Class<?>> getPrimitiveClassCache() {
        HashMap map = new HashMap();
        map.put("boolean", Boolean.TYPE);
        map.put("int", Integer.TYPE);
        map.put("float", Float.TYPE);
        map.put("double", Double.TYPE);
        map.put("byte", Byte.TYPE);
        map.put("long", Long.TYPE);
        map.put("short", Short.TYPE);
        return map;
    }

    public TypeMapper() {
        this(null, null, false);
    }

    public TypeMapper(String packagePrefix, String interfacePackagePrefix, boolean javaTime) {
        this.packagePrefix = packagePrefix;
        this.interfacePackagePrefix = interfacePackagePrefix;
        this.xmlJavaMapping = this.getXmlJavaMapping(javaTime);
        this.javaXmlMapping = this.getJavaXmlMapping(javaTime);
    }

    public void writeFieldXsiType(boolean flag) {
        this.writeFieldXsiType = flag;
    }

    public void setPackagePrefix(String packagePrefix) {
        this.packagePrefix = packagePrefix;
    }

    public String getPackagePrefix() {
        return this.packagePrefix;
    }

    public String getInterfacePackagePrefix() {
        return this.interfacePackagePrefix;
    }

    public void setInterfacePackagePrefix(String interfacePackagePrefix) {
        this.interfacePackagePrefix = interfacePackagePrefix;
    }

    public boolean isKeyWord(String token) {
        return keywords.contains(token);
    }

    public void setConfig(ConnectorConfig config) {
        this.config = config;
    }

    public boolean isWellKnownType(String namespace, String name) {
        if (this.isSObject(namespace, name)) {
            return true;
        }
        if ("AggregateResult".equals(name) && (SfdcApiType.Enterprise.getSobjectNamespace().equals(namespace) || SfdcApiType.Tooling.getSobjectNamespace().equals(namespace))) {
            return true;
        }
        if ("extendedErrorDetails".equalsIgnoreCase(name) && SfdcApiType.getFromNamespace(namespace) != null) {
            this.setGenerateExtendedErrorCodes(true);
            return true;
        }
        QName type = new QName(namespace, name);
        return this.xmlJavaMapping.containsKey(type);
    }

    public boolean isSObject(String namespace, String name) {
        return "sObject".equals(name) && (SfdcApiType.Partner.getSobjectNamespace().equals(namespace) || SfdcApiType.CrossInstance.getSobjectNamespace().equals(namespace) || SfdcApiType.Internal.getSobjectNamespace().equals(namespace) || SfdcApiType.ClientSync.getSobjectNamespace().equals(namespace) || SfdcApiType.SyncApi.getSobjectNamespace().equals(namespace));
    }

    public String getJavaClassName(QName xmltype, Types types, boolean nillable) {
        SimpleType simpleType;
        String clazz = null;
        if (nillable) {
            clazz = nillableJavaMapping.get(xmltype);
        }
        if (clazz == null) {
            clazz = this.xmlJavaMapping.get(xmltype);
        }
        if (clazz != null) {
            return clazz;
        }
        String prefix = this.packagePrefix;
        if (types != null && (simpleType = types.getSimpleTypeAllowNull(xmltype)) != null) {
            Restriction rest = simpleType.getRestriction();
            if (rest != null && rest.getNumEnumerations() == 0) {
                return this.xmlJavaMapping.get(rest.getBase());
            }
            prefix = this.interfacePackagePrefix;
        }
        String packageName = NameMapper.getPackageName(xmltype.getNamespaceURI(), prefix);
        return String.valueOf(packageName) + "." + NameMapper.getClassName(xmltype.getLocalPart());
    }

    public QName getXmlType(String javaType) {
        return this.javaXmlMapping.get(javaType);
    }

    public void writeXsiType(XmlOutputStream out, String typeNS, String type) throws IOException {
        String prefix = out.getPrefix(typeNS);
        if (prefix == null || "".equals(prefix)) {
            out.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", type);
        } else {
            out.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", String.valueOf(prefix) + ":" + type);
        }
    }

    public void writeString(XmlOutputStream out, TypeInfo info, String value, boolean isSet) throws IOException {
        this.writeSimpleType(out, info, value, isSet, String.class.getName());
    }

    private void writeSimpleType(XmlOutputStream out, TypeInfo info, String value, boolean isSet, String javaType) throws IOException {
        if (!isSet && info.getMinOcc() == 0) {
            return;
        }
        if (value == null) {
            this.writeNull(out, info);
        } else {
            out.writeStartTag(this.getNamespace(info), info.getName());
            if (this.writeFieldXsiType) {
                this.writeXsiType(out, info.getTypeNS(), info.getType());
            } else if ("anyType".equals(info.getType()) && "http://www.w3.org/2001/XMLSchema".equals(info.getTypeNS())) {
                QName xmlType = this.getXmlType(javaType);
                if (xmlType == null) {
                    throw new IOException("Failed to find xml type for java type: " + javaType);
                }
                this.writeXsiType(out, xmlType.getNamespaceURI(), xmlType.getLocalPart());
            }
            out.writeText(value);
            out.writeEndTag(this.getNamespace(info), info.getName());
        }
    }

    private String getNamespace(TypeInfo info) {
        return info.isElementFormQualified() ? info.getNamespace() : null;
    }

    public void writeBoolean(XmlOutputStream out, TypeInfo info, boolean value, boolean isSet) throws IOException {
        this.writeSimpleType(out, info, "" + value, isSet, Boolean.TYPE.getName());
    }

    public void writeInt(XmlOutputStream out, TypeInfo info, int value, boolean isSet) throws IOException {
        this.writeSimpleType(out, info, "" + value, isSet, Integer.TYPE.getName());
    }

    public void writeLong(XmlOutputStream out, TypeInfo info, long value, boolean isSet) throws IOException {
        this.writeSimpleType(out, info, "" + value, isSet, Long.TYPE.getName());
    }

    public void writeFloat(XmlOutputStream out, TypeInfo info, float value, boolean isSet) throws IOException {
        this.writeSimpleType(out, info, "" + value, isSet, Float.TYPE.getName());
    }

    public void writeDouble(XmlOutputStream out, TypeInfo info, double value, boolean isSet) throws IOException {
        String strValue = this.writeDouble(value);
        this.writeSimpleType(out, info, strValue, isSet, Double.TYPE.getName());
    }

    private void writeBigDecimal(XmlOutputStream out, TypeInfo info, BigDecimal value, boolean isSet) throws IOException {
        String strValue = value.toPlainString();
        this.writeSimpleType(out, info, strValue, isSet, BigDecimal.class.getName());
    }

    public String writeDouble(double value) {
        String strValue = Double.isNaN(value) ? "NaN" : (value == Double.POSITIVE_INFINITY ? "INF" : (value == Double.NEGATIVE_INFINITY ? "-INF" : Double.toString(value)));
        return strValue;
    }

    public void writeObject(XmlOutputStream out, TypeInfo info, Object value, boolean isSet) throws IOException {
        if (!isSet && info.getMinOcc() == 0) {
            return;
        }
        if (value == null) {
            this.writeNull(out, info);
            return;
        }
        if (info.getMaxOcc() == 1) {
            this.writeSingleObject(out, info, value);
        } else {
            this.writeArrayObject(out, info, value);
        }
    }

    private void writeArrayObject(XmlOutputStream out, TypeInfo info, Object value) throws IOException {
        int length = Array.getLength(value);
        int i = 0;
        while (i < length) {
            Object o = Array.get(value, i);
            this.writeSingleObject(out, info, o);
            ++i;
        }
    }

    private void writeSingleObject(XmlOutputStream out, TypeInfo info, Object value) throws IOException {
        if (value == null) {
            this.writeSimpleType(out, info, null, true, String.class.getName());
        } else if (value instanceof XMLizable) {
            XMLizable xmlObject = (XMLizable)value;
            xmlObject.write(new QName(this.getNamespace(info), info.getName()), out, this);
        } else if (value instanceof Time) {
            this.writeSimpleType(out, info, value.toString(), true, Time.class.getName());
        } else if (value instanceof Calendar || value instanceof Date) {
            String s = this.calendarCodec.getValueAsString(value);
            this.writeSimpleType(out, info, s, true, Calendar.class.getName());
        } else if (value instanceof OffsetDateTime) {
            this.writeSimpleType(out, info, value.toString(), true, OffsetDateTime.class.getName());
        } else if (value instanceof OffsetDate) {
            this.writeSimpleType(out, info, value.toString(), true, OffsetDate.class.getName());
        } else if (value instanceof OffsetTime) {
            this.writeSimpleType(out, info, value.toString(), true, OffsetTime.class.getName());
        } else if (value instanceof byte[]) {
            String s = new String(Base64.encode((byte[])value));
            this.writeSimpleType(out, info, s, true, "[B");
        } else if (value instanceof Double) {
            this.writeDouble(out, info, (Double)value, true);
        } else if (value instanceof Float) {
            this.writeFloat(out, info, ((Float)value).floatValue(), true);
        } else if (value instanceof Long) {
            this.writeLong(out, info, (Long)value, true);
        } else if (value instanceof Integer) {
            this.writeInt(out, info, (Integer)value, true);
        } else if (value instanceof Boolean) {
            this.writeBoolean(out, info, (Boolean)value, true);
        } else if (value instanceof BigDecimal) {
            this.writeBigDecimal(out, info, (BigDecimal)value, true);
        } else {
            this.writeString(out, info, value.toString(), true);
        }
    }

    private void writeNull(XmlOutputStream out, TypeInfo info) throws IOException {
        out.writeStartTag(this.getNamespace(info), info.getName());
        out.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "nil", "true");
        out.writeEndTag(this.getNamespace(info), info.getName());
    }

    public void verifyTag(String namespace1, String name1, String namespace2, String name2) throws ConnectionException {
        if (!this.sameTag(namespace1, name1, namespace2, name2)) {
            if (namespace2 != null && namespace2.isEmpty() && HTML.equalsIgnoreCase(name2)) {
                throw new HTMLResponseException(String.format("Encountered HTML Content when looking for %s:%s", namespace1, name1));
            }
            throw new ConnectionException("Unexpected element. Parser was expecting element '" + namespace1 + ":" + name1 + "' but found '" + namespace2 + ":" + name2 + "'");
        }
    }

    public void consumeStartTag(XmlInputStream in) throws IOException, ConnectionException {
        if (2 != in.nextTag()) {
            throw new ConnectionException("unable to find start tag at: " + in);
        }
    }

    public void consumeEndTag(XmlInputStream in) throws IOException, ConnectionException {
        if (3 != in.nextTag()) {
            throw new ConnectionException("unable to find end tag at: " + in);
        }
    }

    private boolean sameTag(String namespace1, String name1, String namespace2, String name2) {
        if (namespace1 == null) {
            return (namespace2 == null || "".equals(namespace2)) && name1.equals(name2);
        }
        return namespace1.equals(namespace2) && name1.equals(name2);
    }

    public boolean verifyElement(XmlInputStream in, TypeInfo info) throws ConnectionException {
        if (this.config != null && !this.config.isValidateSchema()) {
            return this.isElement(in, info);
        }
        try {
            this.verifyTag(this.getNamespace(info), info.getName(), in.getNamespace(), in.getName());
        }
        catch (ConnectionException ce) {
            return false;
        }
        return true;
    }

    public boolean isElement(XmlInputStream in, TypeInfo info) throws ConnectionException {
        if (in.getEventType() != 2) {
            return false;
        }
        return this.sameTag(this.getNamespace(info), info.getName(), in.getNamespace(), in.getName());
    }

    public String readString(XmlInputStream in, TypeInfo info, Class<?> type) throws IOException, ConnectionException {
        boolean isNull = this.isXsiNilTrue(in);
        this.consumeStartTag(in);
        String strValue = in.nextText();
        return isNull ? null : strValue;
    }

    public int readInt(XmlInputStream in, TypeInfo info, Class<?> type) throws IOException, ConnectionException {
        return Integer.parseInt(this.readString(in, info, type));
    }

    public long readLong(XmlInputStream in, TypeInfo info, Class<?> type) throws IOException, ConnectionException {
        return Long.parseLong(this.readString(in, info, type));
    }

    public float readFloat(XmlInputStream in, TypeInfo info, Class<?> type) throws IOException, ConnectionException {
        return Float.parseFloat(this.readString(in, info, type));
    }

    public boolean readBoolean(XmlInputStream in, TypeInfo info, Class<?> type) throws IOException, ConnectionException {
        return Boolean.parseBoolean(this.readString(in, info, type));
    }

    public double readDouble(XmlInputStream in, TypeInfo info, Class<?> type) throws IOException, ConnectionException {
        String strValue = this.readString(in, info, type);
        return this.parseDouble(strValue);
    }

    public BigDecimal readDecimal(XmlInputStream in, TypeInfo info, Class<?> type) throws IOException, ConnectionException {
        String strValue = this.readString(in, info, type);
        return this.parseBigDecimal(strValue);
    }

    public double parseDouble(String strValue) {
        double value = "NaN".equals(strValue) ? Double.NaN : ("INF".equals(strValue) ? Double.POSITIVE_INFINITY : ("-INF".equals(strValue) ? Double.NEGATIVE_INFINITY : Double.parseDouble(strValue)));
        return value;
    }

    public Object deserialize(String value, QName type) {
        String localType;
        String string = localType = type == null ? "string" : type.getLocalPart();
        if ("string".equals(localType)) {
            return value;
        }
        if ("int".equals(localType)) {
            return Integer.parseInt(value);
        }
        if ("double".equals(localType)) {
            return this.parseDouble(value);
        }
        if ("decimal".equals(localType)) {
            return this.parseBigDecimal(value);
        }
        if ("long".equals(localType)) {
            return Long.parseLong(value);
        }
        if ("time".equals(localType)) {
            return new Time(value);
        }
        if ("date".equals(localType)) {
            return this.dateCodec.deserialize(value).getTime();
        }
        if ("dateTime".equals(localType)) {
            return this.calendarCodec.deserialize(value);
        }
        if ("boolean".equals(localType)) {
            return Boolean.parseBoolean(value);
        }
        if ("base64Binary".equals(localType)) {
            return Base64.decode(value.getBytes());
        }
        return value;
    }

    private BigDecimal parseBigDecimal(String value) {
        return new BigDecimal(value);
    }

    public Object readObject(XmlInputStream in, TypeInfo info, Class<?> type) throws ConnectionException, IOException {
        Object result = info.getMaxOcc() == 1 ? this.readSingle(in, info, type) : this.readArray(in, info, type, false);
        return result;
    }

    public Object readPartialArray(XmlInputStream in, TypeInfo result__typeInfo, Class<?> type) throws ConnectionException, IOException {
        return this.readArray(in, result__typeInfo, type, true);
    }

    private Object readArray(XmlInputStream in, TypeInfo result__typeInfo, Class<?> type, boolean partialArray) throws IOException, ConnectionException {
        ArrayList<Object> results = new ArrayList<Object>();
        Class<?> component = type.getComponentType();
        boolean failed = true;
        Exception exception = null;
        try {
            while (true) {
                in.peekTag();
                if (!this.isElement(in, result__typeInfo)) break;
                Object o = this.readSingle(in, result__typeInfo, component);
                results.add(o);
            }
            failed = false;
        }
        catch (ConnectionException | IOException e) {
            if (!partialArray) {
                throw e;
            }
            exception = e;
        }
        Object array = Array.newInstance(component, results.size());
        int i = 0;
        while (i < results.size()) {
            Array.set(array, i, results.get(i));
            ++i;
        }
        if (failed) {
            throw new PartialArrayException(exception.getMessage(), exception, array);
        }
        return array;
    }

    boolean isXsiNilTrue(XmlInputStream in) {
        String nil = in.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "nil");
        return "true".equals(nil);
    }

    Object readSingle(XmlInputStream in, TypeInfo typeInfo, Class type) throws IOException, ConnectionException {
        TemporalAccessor temporal;
        if (this.isXsiNilTrue(in)) {
            this.consumeStartTag(in);
            this.consumeEndTag(in);
            return null;
        }
        QName xsiType = this.getXsiType(in);
        if (xsiType != null) {
            Class<?> newType = this.getJavaType(xsiType);
            if (type.isAssignableFrom(newType)) {
                type = newType;
            } else {
                throw new ConnectionException("Incompatible type '" + newType + "' specified as xsi:type. It must " + "be a subclass of '" + type + "'");
            }
        }
        if (type == Calendar.class) {
            if ("date".equals(typeInfo.getType()) || xsiType != null && "date".equals(xsiType.getLocalPart())) {
                return this.dateCodec.deserialize(this.readString(in, typeInfo, type));
            }
            return this.calendarCodec.deserialize(this.readString(in, typeInfo, type));
        }
        if (type == Date.class) {
            return this.dateCodec.deserialize(this.readString(in, typeInfo, type));
        }
        if (type == Time.class) {
            return new Time(this.readString(in, typeInfo, type));
        }
        if (type == OffsetDateTime.class) {
            temporal = DateTimeFormatter.ISO_DATE_TIME.parseBest(this.readString(in, typeInfo, type), OffsetDateTime::from, LocalDateTime::from);
            return temporal instanceof OffsetDateTime ? temporal : ((LocalDateTime)temporal).atOffset(ZoneOffset.UTC);
        }
        if (type == OffsetDate.class) {
            temporal = DateTimeFormatter.ISO_DATE.parse(this.readString(in, typeInfo, type));
            ZoneOffset offset = temporal.query(TemporalQueries.offset());
            if (offset == null) {
                offset = ZoneOffset.UTC;
            }
            return new OffsetDate(LocalDate.from(temporal), offset);
        }
        if (type == OffsetTime.class) {
            temporal = DateTimeFormatter.ISO_TIME.parseBest(this.readString(in, typeInfo, type), OffsetTime::from, LocalTime::from);
            return temporal instanceof OffsetTime ? temporal : ((LocalTime)temporal).atOffset(ZoneOffset.UTC);
        }
        if (type == String.class) {
            return this.readString(in, typeInfo, type);
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return this.readInt(in, typeInfo, type);
        }
        if (type == Long.TYPE || type == Long.class) {
            return this.readLong(in, typeInfo, type);
        }
        if (type == Float.TYPE || type == Float.class) {
            return Float.valueOf(this.readFloat(in, typeInfo, type));
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return this.readBoolean(in, typeInfo, type);
        }
        if (type == Double.TYPE || type == Double.class) {
            return this.readDouble(in, typeInfo, type);
        }
        if (type == BigDecimal.class) {
            return this.readDecimal(in, typeInfo, type);
        }
        if (type == byte[].class) {
            String str = this.readString(in, typeInfo, type);
            str = str == null ? "" : str;
            return Base64.decode(str.getBytes());
        }
        if (type.isEnum()) {
            String value = this.readEnum(in, typeInfo, type);
            try {
                return Enum.valueOf(type, value);
            }
            catch (IllegalArgumentException e) {
                throw new ConnectionException(String.valueOf(value) + "Not a valid enumeration for type: " + type);
            }
        }
        try {
            XMLizable result = (XMLizable)type.newInstance();
            result.load(in, this);
            return result;
        }
        catch (InstantiationException e) {
            throw new ConnectionException("Failed to create object", e);
        }
        catch (IllegalAccessException e) {
            throw new ConnectionException("Failed to create object", e);
        }
    }

    public QName getXsiType(XmlInputStream in) {
        QName xsiTypeQName = null;
        String xsiType = in.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type");
        if (xsiType != null && !"".equals(xsiType)) {
            String prefix = TypeMapper.getPrefix(xsiType);
            String name = TypeMapper.getType(xsiType);
            String namespace = in.getNamespace(prefix);
            xsiTypeQName = new QName(namespace, name);
        }
        return xsiTypeQName;
    }

    private String readEnum(XmlInputStream in, TypeInfo typeInfo, Class<?> type) throws IOException, ConnectionException {
        int index;
        String s = this.readString(in, typeInfo, type);
        try {
            Field valuesToEnumsField = type.getDeclaredField("valuesToEnums");
            Map valuesToEnums = (Map)valuesToEnumsField.get(null);
            String enumStrValue = (String)valuesToEnums.get(s);
            if (enumStrValue != null) {
                s = enumStrValue;
            }
        }
        catch (NoSuchFieldException valuesToEnumsField) {
        }
        catch (Exception e) {
            throw new ConnectionException("Failed to read enum", e);
        }
        String token = (index = s.indexOf(":")) == -1 ? s : s.substring(index + 1);
        return this.isKeyWord(token) ? "_" + token : token;
    }

    Class<?> getJavaType(QName qName) throws ConnectionException {
        Class<?> c = this.typeCache.get(qName);
        if (c == null) {
            String type = nillableJavaMapping.get(qName);
            if (type == null) {
                type = this.xmlJavaMapping.get(qName);
            }
            if (type == null) {
                type = String.valueOf(NameMapper.getPackageName(qName.getNamespaceURI(), this.packagePrefix)) + "." + NameMapper.getClassName(qName.getLocalPart());
            }
            c = this.load(type);
            this.typeCache.put(qName, c);
        }
        return c;
    }

    private Class<?> load(String type) throws ConnectionException {
        Class<?> clazz;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        if ((clazz = primitiveClassCache.get(type)) != null) {
            return clazz;
        }
        try {
            return cl.loadClass(type);
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName(type);
            }
            catch (ClassNotFoundException cnfe) {
                throw new ConnectionException("Failed to load class: " + type, cnfe);
            }
        }
    }

    public static String getType(String xsiType) {
        int index = xsiType.indexOf(":");
        return index == -1 ? xsiType : xsiType.substring(index + 1, xsiType.length());
    }

    public static String getPrefix(String xsiType) {
        int index = xsiType.indexOf(":");
        return index == -1 ? null : xsiType.substring(0, index);
    }

    private static HashSet<String> getKeyWords() {
        HashSet<String> keywords = new HashSet<String>();
        keywords.add("int");
        keywords.add("double");
        keywords.add("boolean");
        keywords.add("byte");
        keywords.add("short");
        keywords.add("long");
        keywords.add("float");
        keywords.add("char");
        return keywords;
    }

    public void setGenerateInterfaces(boolean generateInterfaces) {
        this.generateInterfaces = generateInterfaces;
    }

    public boolean generateInterfaces() {
        return this.generateInterfaces;
    }

    public void setGenerateExtendedErrorCodes(boolean generateExtendedErrorCodes) {
        this.generateExtendedErrorCodes = generateExtendedErrorCodes;
    }

    public boolean getGenerateExtendedErrorCodes() {
        return this.generateExtendedErrorCodes;
    }

    public static class PartialArrayException
    extends ConnectionException {
        private Object arrayResult;

        public PartialArrayException(String message, Throwable th, Object arrayResult) {
            super(message, th);
            this.arrayResult = arrayResult;
        }

        public Object getArrayResult() {
            return this.arrayResult;
        }
    }
}

