/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.sqlfileoutput;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.DatabaseImpact;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.sqlfileoutput.SQLFileOutput;
import org.apache.hop.pipeline.transforms.sqlfileoutput.SQLFileOutputData;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;
import org.w3c.dom.Node;

@Transform(id="SQLFileOutput", image="sqlfileoutput.svg", name="i18n::SQLFileOutput.Name", description="i18n::SQLFileOutput.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Output", keywords={"i18n::SQLFileOutputMeta.keyword"}, documentationUrl="/pipeline/transforms/sqlfileoutput.html")
public class SQLFileOutputMeta
extends BaseTransformMeta<SQLFileOutput, SQLFileOutputData> {
    private static final Class<?> PKG = SQLFileOutputMeta.class;
    private static final String CONST_SPACE = "      ";
    private static final String CONST_SPACE_SHORT = "    ";
    private String connection;
    private String schemaName;
    private String tableName;
    private boolean truncateTable;
    private boolean addToResult;
    private boolean createTable;
    private String fileName;
    private String extension;
    private int splitEvery;
    private boolean fileAppended;
    private boolean transformNrInFilename;
    private boolean partNrInFilename;
    private boolean dateInFilename;
    private boolean timeInFilename;
    private String encoding;
    private String dateformat;
    private boolean startNewLine;
    private boolean createparentfolder;
    private boolean doNotOpenNewFileInit;

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode, metadataProvider);
    }

    public Object clone() {
        return (SQLFileOutputMeta)((Object)super.clone());
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public boolean isFileAppended() {
        return this.fileAppended;
    }

    public void setFileAppended(boolean fileAppended) {
        this.fileAppended = fileAppended;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getSplitEvery() {
        return this.splitEvery;
    }

    public void setSplitEvery(int splitEvery) {
        this.splitEvery = splitEvery;
    }

    public boolean isTransformNrInFilename() {
        return this.transformNrInFilename;
    }

    public void setTransformNrInFilename(boolean transformNrInFilename) {
        this.transformNrInFilename = transformNrInFilename;
    }

    public boolean isTimeInFilename() {
        return this.timeInFilename;
    }

    public boolean isDateInFilename() {
        return this.dateInFilename;
    }

    public void setDateInFilename(boolean dateInFilename) {
        this.dateInFilename = dateInFilename;
    }

    public void setTimeInFilename(boolean timeInFilename) {
        this.timeInFilename = timeInFilename;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getDateFormat() {
        return this.dateformat;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setDateFormat(String dateFormat) {
        this.dateformat = dateFormat;
    }

    public String getTablename() {
        return this.tableName;
    }

    public void setTablename(String tableName) {
        this.tableName = tableName;
    }

    public boolean truncateTable() {
        return this.truncateTable;
    }

    public boolean AddToResult() {
        return this.addToResult;
    }

    public boolean StartNewLine() {
        return this.startNewLine;
    }

    public boolean isDoNotOpenNewFileInit() {
        return this.doNotOpenNewFileInit;
    }

    public void setDoNotOpenNewFileInit(boolean doNotOpenNewFileInit) {
        this.doNotOpenNewFileInit = doNotOpenNewFileInit;
    }

    public boolean createTable() {
        return this.createTable;
    }

    public void setTruncateTable(boolean truncateTable) {
        this.truncateTable = truncateTable;
    }

    public void setAddToResult(boolean addToResult) {
        this.addToResult = addToResult;
    }

    public void setStartNewLine(boolean startNewLine) {
        this.startNewLine = startNewLine;
    }

    public void setCreateTable(boolean createTable) {
        this.createTable = createTable;
    }

    public boolean isCreateParentFolder() {
        return this.createparentfolder;
    }

    public void setCreateParentFolder(boolean createparentfolder) {
        this.createparentfolder = createparentfolder;
    }

    public String[] getFiles(IVariables variables, String fileName) {
        int nr;
        int copies = 1;
        int splits = 1;
        int parts = 1;
        if (this.transformNrInFilename) {
            copies = 3;
        }
        if (this.partNrInFilename) {
            parts = 3;
        }
        if (this.splitEvery != 0) {
            splits = 3;
        }
        if ((nr = copies * parts * splits) > 1) {
            ++nr;
        }
        String[] retval = new String[nr];
        int i = 0;
        for (int copy = 0; copy < copies; ++copy) {
            for (int part = 0; part < parts; ++part) {
                for (int split = 0; split < splits; ++split) {
                    retval[i] = this.buildFilename(variables, fileName, copy, split);
                    ++i;
                }
            }
        }
        if (i < nr) {
            retval[i] = "...";
        }
        return retval;
    }

    public String buildFilename(IVariables variables, String fileName, int transformnr, int splitnr) {
        SimpleDateFormat daf = new SimpleDateFormat();
        Object retval = fileName;
        Date now = new Date();
        if (this.dateInFilename) {
            daf.applyPattern("yyyMMdd");
            String d = daf.format(now);
            retval = (String)retval + "_" + d;
        }
        if (this.timeInFilename) {
            daf.applyPattern("HHmmss");
            String t = daf.format(now);
            retval = (String)retval + "_" + t;
        }
        if (this.transformNrInFilename) {
            retval = (String)retval + "_" + transformnr;
        }
        if (this.splitEvery > 0) {
            retval = (String)retval + "_" + splitnr;
        }
        if (this.extension != null && this.extension.length() != 0) {
            retval = (String)retval + "." + variables.resolve(this.extension);
        }
        return retval;
    }

    private void readData(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            this.connection = XmlHandler.getTagValue((Node)transformNode, (String)"connection");
            this.schemaName = XmlHandler.getTagValue((Node)transformNode, (String)"schema");
            this.tableName = XmlHandler.getTagValue((Node)transformNode, (String)"table");
            this.truncateTable = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"truncate"));
            this.createTable = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"create"));
            this.encoding = XmlHandler.getTagValue((Node)transformNode, (String)"encoding");
            this.dateformat = XmlHandler.getTagValue((Node)transformNode, (String)"dateformat");
            this.addToResult = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"AddToResult"));
            this.startNewLine = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"StartNewLine"));
            this.fileName = XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"name");
            this.createparentfolder = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"create_parent_folder"));
            this.extension = XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"extention");
            this.fileAppended = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"append"));
            this.transformNrInFilename = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"split"));
            this.partNrInFilename = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"haspartno"));
            this.dateInFilename = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"add_date"));
            this.timeInFilename = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"add_time"));
            this.splitEvery = Const.toInt((String)XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"splitevery"), (int)0);
            this.doNotOpenNewFileInit = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"DoNotOpenNewFileInit"));
        }
        catch (Exception e) {
            throw new HopXmlException("Unable to load transform info from XML", (Throwable)e);
        }
    }

    public void setDefault() {
        this.connection = "";
        this.tableName = "";
        this.createparentfolder = false;
        this.doNotOpenNewFileInit = false;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder();
        retval.append(CONST_SPACE_SHORT + XmlHandler.addTagValue((String)"connection", (String)this.connection));
        retval.append(CONST_SPACE_SHORT + XmlHandler.addTagValue((String)"schema", (String)this.schemaName));
        retval.append(CONST_SPACE_SHORT + XmlHandler.addTagValue((String)"table", (String)this.tableName));
        retval.append(CONST_SPACE_SHORT + XmlHandler.addTagValue((String)"truncate", (boolean)this.truncateTable));
        retval.append(CONST_SPACE_SHORT + XmlHandler.addTagValue((String)"create", (boolean)this.createTable));
        retval.append(CONST_SPACE_SHORT + XmlHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append(CONST_SPACE_SHORT + XmlHandler.addTagValue((String)"dateformat", (String)this.dateformat));
        retval.append(CONST_SPACE_SHORT + XmlHandler.addTagValue((String)"addtoresult", (boolean)this.addToResult));
        retval.append(CONST_SPACE_SHORT + XmlHandler.addTagValue((String)"startnewline", (boolean)this.startNewLine));
        retval.append("    <file>" + Const.CR);
        retval.append(CONST_SPACE + XmlHandler.addTagValue((String)"name", (String)this.fileName));
        retval.append(CONST_SPACE + XmlHandler.addTagValue((String)"extention", (String)this.extension));
        retval.append(CONST_SPACE + XmlHandler.addTagValue((String)"append", (boolean)this.fileAppended));
        retval.append(CONST_SPACE + XmlHandler.addTagValue((String)"split", (boolean)this.transformNrInFilename));
        retval.append(CONST_SPACE + XmlHandler.addTagValue((String)"haspartno", (boolean)this.partNrInFilename));
        retval.append(CONST_SPACE + XmlHandler.addTagValue((String)"add_date", (boolean)this.dateInFilename));
        retval.append(CONST_SPACE + XmlHandler.addTagValue((String)"add_time", (boolean)this.timeInFilename));
        retval.append(CONST_SPACE + XmlHandler.addTagValue((String)"splitevery", (int)this.splitEvery));
        retval.append(CONST_SPACE + XmlHandler.addTagValue((String)"create_parent_folder", (boolean)this.createparentfolder));
        retval.append(CONST_SPACE + XmlHandler.addTagValue((String)"DoNotOpenNewFileInit", (boolean)this.doNotOpenNewFileInit));
        retval.append("      </file>" + Const.CR);
        return retval.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        block27: {
            Database db = null;
            try {
                DatabaseMeta databaseMeta = (DatabaseMeta)metadataProvider.getSerializer(DatabaseMeta.class).load(variables.resolve(this.connection));
                if (databaseMeta != null) {
                    CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.CheckResult.ConnectionExists", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                    db = new Database(loggingObject, variables, databaseMeta);
                    try {
                        db.connect();
                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.CheckResult.ConnectionOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                        if (!Utils.isEmpty((CharSequence)this.tableName)) {
                            String schemaTable = databaseMeta.getQuotedSchemaTableCombination(variables, this.schemaName, this.tableName);
                            if (db.checkTableExists(this.schemaName, this.tableName)) {
                                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.CheckResult.TableAccessible", (String[])new String[]{schemaTable}), (ICheckResultSource)transformMeta);
                                remarks.add((ICheckResult)cr);
                                IRowMeta r = db.getTableFieldsMeta(this.schemaName, this.tableName);
                                if (r != null) {
                                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.CheckResult.TableOk", (String[])new String[]{schemaTable}), (ICheckResultSource)transformMeta);
                                    remarks.add((ICheckResult)cr);
                                    Object errorMessage = "";
                                    boolean errorFound = false;
                                    if (prev != null && prev.size() > 0) {
                                        int idx;
                                        int i;
                                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
                                        remarks.add((ICheckResult)cr);
                                        for (i = 0; i < prev.size(); ++i) {
                                            IValueMeta pv = prev.getValueMeta(i);
                                            idx = r.indexOfValue(pv.getName());
                                            if (idx >= 0) continue;
                                            errorMessage = (String)errorMessage + "\t\t" + pv.getName() + " (" + pv.getTypeDesc() + ")" + Const.CR;
                                            errorFound = true;
                                        }
                                        if (errorFound) {
                                            errorMessage = BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.CheckResult.FieldsNotFoundInOutput", (String[])new String[]{errorMessage});
                                            cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                                            remarks.add((ICheckResult)cr);
                                        } else {
                                            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.CheckResult.AllFieldsFoundInOutput", (String[])new String[0]), (ICheckResultSource)transformMeta);
                                            remarks.add((ICheckResult)cr);
                                        }
                                        for (i = 0; i < r.size(); ++i) {
                                            IValueMeta rv = r.getValueMeta(i);
                                            idx = prev.indexOfValue(rv.getName());
                                            if (idx >= 0) continue;
                                            errorMessage = (String)errorMessage + "\t\t" + rv.getName() + " (" + rv.getTypeDesc() + ")" + Const.CR;
                                            errorFound = true;
                                        }
                                        if (errorFound) {
                                            errorMessage = BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.CheckResult.FieldsNotFound", (String[])new String[]{errorMessage});
                                            cr = new CheckResult(3, (String)errorMessage, (ICheckResultSource)transformMeta);
                                            remarks.add((ICheckResult)cr);
                                        } else {
                                            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                                            remarks.add((ICheckResult)cr);
                                        }
                                    } else {
                                        cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.CheckResult.NoFields", (String[])new String[0]), (ICheckResultSource)transformMeta);
                                        remarks.add((ICheckResult)cr);
                                    }
                                } else {
                                    cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.CheckResult.TableNotAccessible", (String[])new String[0]), (ICheckResultSource)transformMeta);
                                    remarks.add((ICheckResult)cr);
                                }
                            } else {
                                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.CheckResult.TableError", (String[])new String[]{schemaTable}), (ICheckResultSource)transformMeta);
                                remarks.add((ICheckResult)cr);
                            }
                        } else {
                            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.CheckResult.NoTableName", (String[])new String[0]), (ICheckResultSource)transformMeta);
                            remarks.add((ICheckResult)cr);
                        }
                        break block27;
                    }
                    catch (HopException e) {
                        cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.CheckResult.UndefinedError", (String[])new String[]{e.getMessage()}), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                        break block27;
                    }
                    finally {
                        db.disconnect();
                    }
                }
                CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.CheckResult.NoConnection", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            catch (HopException e) {
                String errorMessage = BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.CheckResult.DatabaseErrorOccurred", (String[])new String[0]) + e.getMessage();
                CheckResult cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            finally {
                db.disconnect();
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public void analyseImpact(IVariables variables, List<DatabaseImpact> impact, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IHopMetadataProvider metadataProvider) throws HopTransformException {
        DatabaseMeta databaseMeta = null;
        try {
            databaseMeta = (DatabaseMeta)metadataProvider.getSerializer(DatabaseMeta.class).load(variables.resolve(this.connection));
            if (this.truncateTable) {
                DatabaseImpact ii = new DatabaseImpact(4, pipelineMeta.getName(), transformMeta.getName(), databaseMeta.getDatabaseName(), this.tableName, "", "", "", "", "Truncate of table");
                impact.add(ii);
            }
            if (prev != null) {
                for (int i = 0; i < prev.size(); ++i) {
                    IValueMeta v = prev.getValueMeta(i);
                    DatabaseImpact ii = new DatabaseImpact(2, pipelineMeta.getName(), transformMeta.getName(), databaseMeta.getDatabaseName(), this.tableName, v.getName(), v.getName(), v != null ? v.getOrigin() : "?", "", "Type = " + v.toStringMeta());
                    impact.add(ii);
                }
            }
        }
        catch (HopException e) {
            throw new HopTransformException("Unable to get databaseMeta for connection: " + Const.CR + variables.resolve(this.connection));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlStatement getSqlStatements(IVariables variables, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, IHopMetadataProvider metadataProvider) {
        SqlStatement retVal;
        block11: {
            retVal = null;
            try {
                DatabaseMeta databaseMeta = (DatabaseMeta)metadataProvider.getSerializer(DatabaseMeta.class).load(variables.resolve(this.connection));
                retVal = new SqlStatement(transformMeta.getName(), databaseMeta, null);
                if (databaseMeta != null) {
                    if (prev != null && prev.size() > 0) {
                        if (!Utils.isEmpty((CharSequence)this.tableName)) {
                            Database db = new Database(loggingObject, variables, databaseMeta);
                            try {
                                db.connect();
                                String schemaTable = databaseMeta.getQuotedSchemaTableCombination(variables, this.schemaName, this.tableName);
                                String crTable = db.getDDL(schemaTable, prev);
                                if (crTable == null || crTable.length() == 0) {
                                    crTable = null;
                                }
                                retVal.setSql(crTable);
                                break block11;
                            }
                            catch (HopDatabaseException dbe) {
                                retVal.setError(BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.Error.ErrorConnecting", (String[])new String[]{dbe.getMessage()}));
                                break block11;
                            }
                            finally {
                                db.disconnect();
                            }
                        }
                        retVal.setError(BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.Exception.TableNotSpecified", (String[])new String[0]));
                        break block11;
                    }
                    retVal.setError(BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.Error.NoInput", (String[])new String[0]));
                    break block11;
                }
                retVal.setError(BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.Error.NoConnection", (String[])new String[0]));
            }
            catch (HopException e) {
                retVal.setError(BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.CheckResult.DatabaseErrorOccurred", (String[])new String[0]));
            }
        }
        return retVal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IRowMeta getRequiredFields(IVariables variables) throws HopException {
        String realTableName = variables.resolve(this.tableName);
        String realSchemaName = variables.resolve(this.schemaName);
        DatabaseMeta databaseMeta = this.getParentTransformMeta().getParentPipelineMeta().findDatabase(this.connection, variables);
        if (databaseMeta == null) throw new HopException(BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.Exception.ConnectionNotDefined", (String[])new String[0]));
        Database db = new Database(loggingObject, variables, databaseMeta);
        try {
            db.connect();
            if (Utils.isEmpty((CharSequence)realTableName)) throw new HopException(BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.Exception.TableNotSpecified", (String[])new String[0]));
            if (db.checkTableExists(realSchemaName, realTableName)) {
                IRowMeta iRowMeta = db.getTableFieldsMeta(realSchemaName, realTableName);
                return iRowMeta;
            }
            try {
                throw new HopException(BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.Exception.TableNotFound", (String[])new String[0]));
            }
            catch (Exception e) {
                throw new HopException(BaseMessages.getString(PKG, (String)"SQLFileOutputMeta.Exception.ErrorGettingFields", (String[])new String[0]), (Throwable)e);
            }
        }
        finally {
            db.disconnect();
        }
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming iResourceNaming, IHopMetadataProvider metadataProvider) throws HopException {
        try {
            FileObject fileObject = HopVfs.getFileObject((String)variables.resolve(this.fileName), (IVariables)variables);
            if (fileObject.exists()) {
                this.fileName = iResourceNaming.nameResource(fileObject, variables, true);
                return this.fileName;
            }
            return null;
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }
}

