/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.io.VersionedIOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;

public class TypeSerializerSnapshotSerializationUtil {
    public static <T> void writeSerializerSnapshot(DataOutputView out, TypeSerializerSnapshot<T> serializerSnapshot, TypeSerializer<T> serializer) throws IOException {
        new TypeSerializerSnapshotSerializationProxy<T>(serializerSnapshot, serializer).write(out);
    }

    public static <T> TypeSerializerSnapshot<T> readSerializerSnapshot(DataInputView in, ClassLoader userCodeClassLoader, @Nullable TypeSerializer<T> existingPriorSerializer) throws IOException {
        TypeSerializerSnapshotSerializationProxy<T> proxy = new TypeSerializerSnapshotSerializationProxy<T>(userCodeClassLoader, existingPriorSerializer);
        proxy.read(in);
        return proxy.getSerializerSnapshot();
    }

    public static <T> TypeSerializerSnapshot<T> readAndInstantiateSnapshotClass(DataInputView in, ClassLoader cl) throws IOException {
        Class<TypeSerializerSnapshot> clazz = InstantiationUtil.resolveClassByName(in, cl, TypeSerializerSnapshot.class);
        return InstantiationUtil.instantiate(clazz);
    }

    static final class TypeSerializerSnapshotSerializationProxy<T>
    extends VersionedIOReadableWritable {
        private static final int VERSION = 2;
        private ClassLoader userCodeClassLoader;
        private TypeSerializerSnapshot<T> serializerSnapshot;
        @Nullable
        private TypeSerializer<T> serializer;

        TypeSerializerSnapshotSerializationProxy(ClassLoader userCodeClassLoader, @Nullable TypeSerializer<T> existingPriorSerializer) {
            this.userCodeClassLoader = Preconditions.checkNotNull(userCodeClassLoader);
            this.serializer = existingPriorSerializer;
        }

        TypeSerializerSnapshotSerializationProxy(TypeSerializerSnapshot<T> serializerConfigSnapshot, TypeSerializer<T> serializer) {
            this.serializerSnapshot = Preconditions.checkNotNull(serializerConfigSnapshot);
            this.serializer = Preconditions.checkNotNull(serializer);
        }

        @Override
        public void write(DataOutputView out) throws IOException {
            TypeSerializerSnapshotSerializationProxy.setSerializerForWriteIfOldPath(this.serializerSnapshot, this.serializer);
            super.write(out);
            TypeSerializerSnapshot.writeVersionedSnapshot(out, this.serializerSnapshot);
        }

        @Override
        public void read(DataInputView in) throws IOException {
            super.read(in);
            int version = this.getReadVersion();
            switch (version) {
                case 2: {
                    this.serializerSnapshot = TypeSerializerSnapshotSerializationProxy.deserializeV2(in, this.userCodeClassLoader);
                    break;
                }
                case 1: {
                    this.serializerSnapshot = TypeSerializerSnapshotSerializationProxy.deserializeV1(in, this.userCodeClassLoader, this.serializer);
                    break;
                }
                default: {
                    throw new IOException("Unrecognized version for TypeSerializerSnapshot format: " + version);
                }
            }
        }

        @Override
        public int getVersion() {
            return 2;
        }

        @Override
        public int[] getCompatibleVersions() {
            return new int[]{2, 1};
        }

        TypeSerializerSnapshot<T> getSerializerSnapshot() {
            return this.serializerSnapshot;
        }

        @VisibleForTesting
        static <T> TypeSerializerSnapshot<T> deserializeV2(DataInputView in, ClassLoader cl) throws IOException {
            return TypeSerializerSnapshot.readVersionedSnapshot(in, cl);
        }

        @VisibleForTesting
        static <T> TypeSerializerSnapshot<T> deserializeV1(DataInputView in, ClassLoader cl, @Nullable TypeSerializer<T> serializer) throws IOException {
            TypeSerializerSnapshot snapshot = TypeSerializerSnapshotSerializationUtil.readAndInstantiateSnapshotClass(in, cl);
            if (snapshot instanceof TypeSerializerConfigSnapshot) {
                TypeSerializerConfigSnapshot oldTypeSnapshot = (TypeSerializerConfigSnapshot)snapshot;
                oldTypeSnapshot.setPriorSerializer(serializer);
                oldTypeSnapshot.setUserCodeClassLoader(cl);
                oldTypeSnapshot.read(in);
            } else {
                int readVersion = in.readInt();
                snapshot.readSnapshot(readVersion, in, cl);
            }
            return snapshot;
        }

        private static <T> void setSerializerForWriteIfOldPath(TypeSerializerSnapshot<T> serializerSnapshot, TypeSerializer<T> serializer) {
            if (serializerSnapshot instanceof TypeSerializerConfigSnapshot) {
                Preconditions.checkState(serializer != null);
                ((TypeSerializerConfigSnapshot)serializerSnapshot).setPriorSerializer(serializer);
            }
        }
    }
}

