/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.format;

import com.clickhouse.data.ClickHouseByteBuffer;
import com.clickhouse.data.ClickHouseByteUtils;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseDataType;
import com.clickhouse.data.ClickHouseInputStream;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.data.ClickHouseValues;
import com.clickhouse.data.value.ClickHouseBitmap;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public final class BinaryStreamUtils {
    public static final int U_INT8_MAX = 255;
    public static final int U_INT16_MAX = 65535;
    public static final long U_INT32_MAX = 0xFFFFFFFFL;
    public static final BigInteger U_INT64_MAX = new BigInteger(1, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1});
    public static final BigInteger U_INT128_MAX = new BigInteger(1, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1});
    public static final BigInteger U_INT256_MAX = new BigInteger(1, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1});
    public static final int DATE32_MAX = (int)LocalDate.of(2299, 12, 31).toEpochDay();
    public static final int DATE32_MIN = (int)LocalDate.of(1900, 1, 1).toEpochDay();
    public static final BigDecimal DECIMAL32_MAX = new BigDecimal("1000000000");
    public static final BigDecimal DECIMAL32_MIN = new BigDecimal("-1000000000");
    public static final BigDecimal DECIMAL64_MAX = new BigDecimal("1000000000000000000");
    public static final BigDecimal DECIMAL64_MIN = new BigDecimal("-1000000000000000000");
    public static final BigDecimal DECIMAL128_MAX = new BigDecimal("100000000000000000000000000000000000000");
    public static final BigDecimal DECIMAL128_MIN = new BigDecimal("-100000000000000000000000000000000000000");
    public static final BigDecimal DECIMAL256_MAX = new BigDecimal("10000000000000000000000000000000000000000000000000000000000000000000000000000");
    public static final BigDecimal DECIMAL256_MIN = new BigDecimal("-10000000000000000000000000000000000000000000000000000000000000000000000000000");
    public static final long DATETIME64_MAX = LocalDateTime.of(LocalDate.of(2299, 12, 31), LocalTime.MAX).toEpochSecond(ZoneOffset.UTC);
    public static final long DATETIME64_9_MAX = LocalDateTime.of(2262, 4, 11, 23, 47, 16, 0).toEpochSecond(ZoneOffset.UTC);
    public static final long DATETIME64_MIN = LocalDateTime.of(LocalDate.of(1900, 1, 1), LocalTime.MIN).toEpochSecond(ZoneOffset.UTC);
    public static final long MILLIS_IN_DAY = TimeUnit.DAYS.toMillis(1L);
    public static final long DATETIME_MAX = 4294967295000L;
    public static final BigDecimal NANOS = new BigDecimal(BigInteger.TEN.pow(9));
    private static final int[] BASES = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};

    private static <T extends Enum<T>> T toEnum(int value, Class<T> enumType) {
        for (Enum t : (Enum[])ClickHouseChecker.nonNull(enumType, "enumType").getEnumConstants()) {
            if (t.ordinal() != value) continue;
            return (T)t;
        }
        throw new IllegalArgumentException(ClickHouseUtils.format("Enum [%s] does not contain value [%d]", enumType, value));
    }

    public static int toInt32(ClickHouseByteBuffer byteBuffer) {
        return BinaryStreamUtils.toInt32(byteBuffer.array(), byteBuffer.position());
    }

    public static int toInt32(byte[] bytes, int offset) {
        return ClickHouseByteUtils.getInt32(bytes, offset);
    }

    public static long toInt64(ClickHouseByteBuffer byteBuffer) {
        return BinaryStreamUtils.toInt64(byteBuffer.array(), byteBuffer.position());
    }

    public static long toInt64(byte[] bytes, int offset) {
        return ClickHouseByteUtils.getInt64(bytes, offset);
    }

    public static void setInt32(byte[] bytes, int offset, int value) {
        ClickHouseByteUtils.setInt32(bytes, offset, value);
    }

    public static void setInt64(byte[] bytes, int offset, long value) {
        ClickHouseByteUtils.setInt64(bytes, offset, value);
    }

    public static byte[] reverse(byte[] bytes) {
        int l;
        int n = l = bytes != null ? bytes.length : 0;
        if (l > 1) {
            int len = l / 2;
            for (int i = 0; i < len; ++i) {
                byte b = bytes[i];
                bytes[i] = bytes[--l];
                bytes[l] = b;
            }
        }
        return bytes;
    }

    public static int getVarIntSize(int value) {
        int result = 0;
        do {
            ++result;
        } while ((value >>>= 7) != 0);
        return result;
    }

    public static int getVarLongSize(long value) {
        int result = 0;
        do {
            ++result;
        } while ((value >>>= 7) != 0L);
        return result;
    }

    public static void writeByteBuffer(OutputStream output, ByteBuffer buffer) throws IOException {
        Channels.newChannel(output).write(buffer);
    }

    public static ClickHouseBitmap readBitmap(ClickHouseInputStream input, ClickHouseDataType dataType) throws IOException {
        return ClickHouseBitmap.deserialize(input, dataType);
    }

    public static void writeBitmap(OutputStream output, ClickHouseBitmap bitmap) throws IOException {
        BinaryStreamUtils.writeByteBuffer(output, bitmap.toByteBuffer());
    }

    public static void writeBytes(OutputStream output, byte[] bytes) throws IOException {
        output.write(bytes);
    }

    public static char[] readCharacters(Reader input, int length) throws IOException {
        int n;
        char[] chars = new char[length];
        for (int count = 0; count < length; count += n) {
            n = input.read(chars, count, length - count);
            if (n >= 0) continue;
            try {
                input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw count == 0 ? new EOFException() : new IOException(ClickHouseUtils.format("Reached end of reader after reading %d of %d characters", count, length));
        }
        return chars;
    }

    public static boolean readBoolean(ClickHouseInputStream input) throws IOException {
        return ClickHouseChecker.between((int)input.readByte(), "boolean", 0, 1) == 1;
    }

    public static void writeBoolean(OutputStream output, boolean value) throws IOException {
        output.write(value ? 1 : 0);
    }

    public static void writeBoolean(OutputStream output, int value) throws IOException {
        output.write(ClickHouseChecker.between(value, "int", 0, 1) == 1 ? 1 : 0);
    }

    public static <T extends Enum<T>> T readEnum8(ClickHouseInputStream input, Class<T> enumType) throws IOException {
        return BinaryStreamUtils.toEnum(BinaryStreamUtils.readEnum8(input), enumType);
    }

    public static byte readEnum8(ClickHouseInputStream input) throws IOException {
        return BinaryStreamUtils.readInt8(input);
    }

    public static void writeEnum8(OutputStream output, byte value) throws IOException {
        BinaryStreamUtils.writeInt8(output, value);
    }

    public static <T extends Enum<T>> void writeEnum8(OutputStream output, T value) throws IOException {
        BinaryStreamUtils.writeEnum8(output, (byte)ClickHouseChecker.nonNull(value, "enum value").ordinal());
    }

    public static <T extends Enum<T>> T readEnum16(ClickHouseInputStream input, Class<T> enumType) throws IOException {
        return BinaryStreamUtils.toEnum(BinaryStreamUtils.readEnum16(input), enumType);
    }

    public static short readEnum16(ClickHouseInputStream input) throws IOException {
        return BinaryStreamUtils.readInt16(input);
    }

    public static void writeEnum16(OutputStream output, int value) throws IOException {
        BinaryStreamUtils.writeInt16(output, value);
    }

    public static <T extends Enum<T>> void writeEnum16(OutputStream output, T value) throws IOException {
        BinaryStreamUtils.writeEnum16(output, ClickHouseChecker.nonNull(value, "enum value").ordinal());
    }

    public static double[] readGeoPoint(ClickHouseInputStream input) throws IOException {
        return new double[]{BinaryStreamUtils.readFloat64(input), BinaryStreamUtils.readFloat64(input)};
    }

    public static void writeGeoPoint(OutputStream output, double[] value) throws IOException {
        if (value == null || value.length != 2) {
            throw new IllegalArgumentException("Non-null X and Y coordinates are required");
        }
        BinaryStreamUtils.writeGeoPoint(output, value[0], value[1]);
    }

    public static void writeGeoPoint(OutputStream output, double x, double y) throws IOException {
        BinaryStreamUtils.writeFloat64(output, x);
        BinaryStreamUtils.writeFloat64(output, y);
    }

    public static double[][] readGeoRing(ClickHouseInputStream input) throws IOException {
        int count = BinaryStreamUtils.readVarInt(input);
        double[][] value = new double[count][2];
        for (int i = 0; i < count; ++i) {
            value[i] = BinaryStreamUtils.readGeoPoint(input);
        }
        return value;
    }

    public static void writeGeoRing(OutputStream output, double[][] value) throws IOException {
        BinaryStreamUtils.writeVarInt(output, (long)value.length);
        for (double[] v : value) {
            BinaryStreamUtils.writeGeoPoint(output, v);
        }
    }

    public static double[][][] readGeoPolygon(ClickHouseInputStream input) throws IOException {
        int count = BinaryStreamUtils.readVarInt(input);
        double[][][] value = new double[count][][];
        for (int i = 0; i < count; ++i) {
            value[i] = BinaryStreamUtils.readGeoRing(input);
        }
        return value;
    }

    public static void writeGeoPolygon(OutputStream output, double[][][] value) throws IOException {
        BinaryStreamUtils.writeVarInt(output, (long)value.length);
        for (double[][] v : value) {
            BinaryStreamUtils.writeGeoRing(output, v);
        }
    }

    public static double[][][][] readGeoMultiPolygon(ClickHouseInputStream input) throws IOException {
        int count = BinaryStreamUtils.readVarInt(input);
        double[][][][] value = new double[count][][][];
        for (int i = 0; i < count; ++i) {
            value[i] = BinaryStreamUtils.readGeoPolygon(input);
        }
        return value;
    }

    public static void writeGeoMultiPolygon(OutputStream output, double[][][][] value) throws IOException {
        BinaryStreamUtils.writeVarInt(output, (long)value.length);
        for (double[][][] v : value) {
            BinaryStreamUtils.writeGeoPolygon(output, v);
        }
    }

    public static boolean readNull(ClickHouseInputStream input) throws IOException {
        return BinaryStreamUtils.readBoolean(input);
    }

    public static void writeNull(OutputStream output) throws IOException {
        BinaryStreamUtils.writeBoolean(output, true);
    }

    public static void writeNonNull(OutputStream output) throws IOException {
        BinaryStreamUtils.writeBoolean(output, false);
    }

    public static Inet4Address readInet4Address(ClickHouseInputStream input) throws IOException {
        return (Inet4Address)InetAddress.getByAddress(BinaryStreamUtils.reverse(input.readBytes(4)));
    }

    public static void writeInet4Address(OutputStream output, Inet4Address value) throws IOException {
        output.write(BinaryStreamUtils.reverse(value.getAddress()));
    }

    public static Inet6Address readInet6Address(ClickHouseInputStream input) throws IOException {
        return Inet6Address.getByAddress(null, input.readBytes(16), null);
    }

    public static void writeInet6Address(OutputStream output, Inet6Address value) throws IOException {
        output.write(value.getAddress());
    }

    public static byte readInt8(ClickHouseInputStream input) throws IOException {
        return input.readByte();
    }

    public static void writeInt8(OutputStream output, byte value) throws IOException {
        output.write(value);
    }

    public static void writeInt8(OutputStream output, int value) throws IOException {
        output.write(ClickHouseChecker.between(value, "int", -128, 127));
    }

    public static short readUnsignedInt8(ClickHouseInputStream input) throws IOException {
        return (short)(input.readByte() & 0xFF);
    }

    public static void writeUnsignedInt8(OutputStream output, int value) throws IOException {
        output.write((byte)(0xFF & ClickHouseChecker.between(value, "int", 0, 255)));
    }

    public static short readInt16(ClickHouseInputStream input) throws IOException {
        return input.readBuffer(2).asShort();
    }

    public static void writeInt16(OutputStream output, short value) throws IOException {
        output.write(new byte[]{(byte)(0xFF & value), (byte)(0xFF & value >> 8)});
    }

    public static void writeInt16(OutputStream output, int value) throws IOException {
        BinaryStreamUtils.writeInt16(output, (short)ClickHouseChecker.between(value, "int", Short.MIN_VALUE, Short.MAX_VALUE));
    }

    public static int readUnsignedInt16(ClickHouseInputStream input) throws IOException {
        return input.readBuffer(2).asUnsignedShort();
    }

    public static void writeUnsignedInt16(OutputStream output, int value) throws IOException {
        BinaryStreamUtils.writeInt16(output, (short)((long)ClickHouseChecker.between(value, "int", 0, 65535) & 0xFFFFL));
    }

    public static int readInt32(ClickHouseInputStream input) throws IOException {
        return input.readBuffer(4).asInteger();
    }

    public static void writeInt32(OutputStream output, int value) throws IOException {
        output.write(new byte[]{(byte)(0xFF & value), (byte)(0xFF & value >> 8), (byte)(0xFF & value >> 16), (byte)(0xFF & value >> 24)});
    }

    public static long readUnsignedInt32(ClickHouseInputStream input) throws IOException {
        return input.readBuffer(4).asUnsignedInteger();
    }

    public static void writeUnsignedInt32(OutputStream output, long value) throws IOException {
        BinaryStreamUtils.writeInt32(output, (int)(ClickHouseChecker.between(value, "long", 0L, 0xFFFFFFFFL) & 0xFFFFFFFFL));
    }

    public static long readInt64(ClickHouseInputStream input) throws IOException {
        return input.readBuffer(8).asLong();
    }

    public static void writeInt64(OutputStream output, long value) throws IOException {
        byte[] bytes = new byte[8];
        BinaryStreamUtils.setInt64(bytes, 0, value);
        output.write(bytes);
    }

    public static BigInteger readUnsignedInt64(ClickHouseInputStream input) throws IOException {
        return input.readBuffer(8).asUnsignedLong();
    }

    public static void writeUnsignedInt64(OutputStream output, long value) throws IOException {
        BinaryStreamUtils.writeInt64(output, value);
    }

    public static void writeUnsignedInt64(OutputStream output, BigInteger value) throws IOException {
        BinaryStreamUtils.writeInt64(output, ClickHouseChecker.between(value, "BigInteger", BigInteger.ZERO, U_INT64_MAX).longValue());
    }

    public static BigInteger readInt128(ClickHouseInputStream input) throws IOException {
        return input.readBuffer(16).asBigInteger();
    }

    public static void writeInt128(OutputStream output, BigInteger value) throws IOException {
        BinaryStreamUtils.writeBigInteger(output, value, 16);
    }

    public static BigInteger readUnsignedInt128(ClickHouseInputStream input) throws IOException {
        return input.readBuffer(16).asUnsignedBigInteger();
    }

    public static void writeUnsignedInt128(OutputStream output, BigInteger value) throws IOException {
        BinaryStreamUtils.writeInt128(output, ClickHouseChecker.between(value, "BigInteger", BigInteger.ZERO, U_INT128_MAX));
    }

    public static BigInteger readInt256(ClickHouseInputStream input) throws IOException {
        return input.readBuffer(32).asBigInteger();
    }

    public static void writeInt256(OutputStream output, BigInteger value) throws IOException {
        BinaryStreamUtils.writeBigInteger(output, value, 32);
    }

    public static BigInteger readUnsignedInt256(ClickHouseInputStream input) throws IOException {
        return input.readBuffer(32).asUnsignedBigInteger();
    }

    public static void writeUnsignedInt256(OutputStream output, BigInteger value) throws IOException {
        BinaryStreamUtils.writeInt256(output, ClickHouseChecker.between(value, "BigInteger", BigInteger.ZERO, U_INT256_MAX));
    }

    public static float readFloat32(ClickHouseInputStream input) throws IOException {
        return Float.intBitsToFloat(BinaryStreamUtils.readInt32(input));
    }

    public static void writeFloat32(OutputStream output, float value) throws IOException {
        BinaryStreamUtils.writeInt32(output, Float.floatToIntBits(value));
    }

    public static double readFloat64(ClickHouseInputStream input) throws IOException {
        return Double.longBitsToDouble(BinaryStreamUtils.readInt64(input));
    }

    public static void writeFloat64(OutputStream output, double value) throws IOException {
        BinaryStreamUtils.writeInt64(output, Double.doubleToLongBits(value));
    }

    public static UUID readUuid(ClickHouseInputStream input) throws IOException {
        return input.readBuffer(16).asUuid();
    }

    public static void writeUuid(OutputStream output, UUID value) throws IOException {
        BinaryStreamUtils.writeInt64(output, value.getMostSignificantBits());
        BinaryStreamUtils.writeInt64(output, value.getLeastSignificantBits());
    }

    public static void writeBigInteger(OutputStream output, BigInteger value, int length) throws IOException {
        int i;
        int endIndex;
        int empty = value.signum() == -1 ? -1 : 0;
        byte[] bytes = value.toByteArray();
        int n = endIndex = bytes.length == length + 1 && bytes[0] == 0 ? 1 : 0;
        if (bytes.length - endIndex > length) {
            throw new IllegalArgumentException(ClickHouseUtils.format("Expected %d bytes but got %d from: %s", length, bytes.length, value));
        }
        for (i = bytes.length - 1; i >= endIndex; --i) {
            output.write(bytes[i]);
        }
        for (i = length - bytes.length; i > 0; --i) {
            output.write(empty);
        }
    }

    public static BigDecimal readDecimal(ClickHouseInputStream input, int precision, int scale) throws IOException {
        BigDecimal v = precision <= ClickHouseDataType.Decimal32.getMaxScale() ? BinaryStreamUtils.readDecimal32(input, scale) : (precision <= ClickHouseDataType.Decimal64.getMaxScale() ? BinaryStreamUtils.readDecimal64(input, scale) : (precision <= ClickHouseDataType.Decimal128.getMaxScale() ? BinaryStreamUtils.readDecimal128(input, scale) : BinaryStreamUtils.readDecimal256(input, scale)));
        return v;
    }

    public static void writeDecimal(OutputStream output, BigDecimal value, int precision, int scale) throws IOException {
        if (precision > ClickHouseDataType.Decimal128.getMaxScale()) {
            BinaryStreamUtils.writeDecimal256(output, value, scale);
        } else if (precision > ClickHouseDataType.Decimal64.getMaxScale()) {
            BinaryStreamUtils.writeDecimal128(output, value, scale);
        } else if (precision > ClickHouseDataType.Decimal32.getMaxScale()) {
            BinaryStreamUtils.writeDecimal64(output, value, scale);
        } else {
            BinaryStreamUtils.writeDecimal32(output, value, scale);
        }
    }

    public static BigDecimal readDecimal32(ClickHouseInputStream input, int scale) throws IOException {
        return BigDecimal.valueOf(BinaryStreamUtils.readInt32(input), ClickHouseChecker.between(scale, "scale", 0, ClickHouseDataType.Decimal32.getMaxScale()));
    }

    public static void writeDecimal32(OutputStream output, BigDecimal value, int scale) throws IOException {
        BinaryStreamUtils.writeInt32(output, ClickHouseChecker.between(value.multiply(BigDecimal.TEN.pow(ClickHouseChecker.between(scale, "scale", 0, ClickHouseDataType.Decimal32.getMaxScale()))), "BigDecimal", DECIMAL32_MIN, DECIMAL32_MAX).intValue());
    }

    public static BigDecimal readDecimal64(ClickHouseInputStream input, int scale) throws IOException {
        return BigDecimal.valueOf(BinaryStreamUtils.readInt64(input), ClickHouseChecker.between(scale, "scale", 0, ClickHouseDataType.Decimal64.getMaxScale()));
    }

    public static void writeDecimal64(OutputStream output, BigDecimal value, int scale) throws IOException {
        BinaryStreamUtils.writeInt64(output, ClickHouseChecker.between(ClickHouseChecker.between(scale, "scale", 0, ClickHouseDataType.Decimal64.getMaxScale()) == 0 ? value : value.multiply(BigDecimal.TEN.pow(scale)), "BigDecimal", DECIMAL64_MIN, DECIMAL64_MAX).longValue());
    }

    public static BigDecimal readDecimal128(ClickHouseInputStream input, int scale) throws IOException {
        return new BigDecimal(BinaryStreamUtils.readInt128(input), ClickHouseChecker.between(scale, "scale", 0, ClickHouseDataType.Decimal128.getMaxScale()));
    }

    public static void writeDecimal128(OutputStream output, BigDecimal value, int scale) throws IOException {
        BinaryStreamUtils.writeInt128(output, ClickHouseChecker.between(ClickHouseChecker.between(scale, "scale", 0, ClickHouseDataType.Decimal128.getMaxScale()) == 0 ? value : value.multiply(BigDecimal.TEN.pow(scale)), "BigDecimal", DECIMAL128_MIN, DECIMAL128_MAX).toBigInteger());
    }

    public static BigDecimal readDecimal256(ClickHouseInputStream input, int scale) throws IOException {
        return new BigDecimal(BinaryStreamUtils.readInt256(input), ClickHouseChecker.between(scale, "scale", 0, ClickHouseDataType.Decimal256.getMaxScale()));
    }

    public static void writeDecimal256(OutputStream output, BigDecimal value, int scale) throws IOException {
        BinaryStreamUtils.writeInt256(output, ClickHouseChecker.between(ClickHouseChecker.between(scale, "scale", 0, ClickHouseDataType.Decimal256.getMaxScale()) == 0 ? value : value.multiply(BigDecimal.TEN.pow(scale)), "BigDecimal", DECIMAL256_MIN, DECIMAL256_MAX).toBigInteger());
    }

    public static LocalDate readDate(ClickHouseInputStream input, TimeZone tz) throws IOException {
        LocalDate d = BinaryStreamUtils.readDate(input);
        if (tz != null && !tz.toZoneId().equals(ClickHouseValues.SYS_ZONE)) {
            d = d.atStartOfDay(ClickHouseValues.SYS_ZONE).withZoneSameInstant(tz.toZoneId()).toLocalDate();
        }
        return d;
    }

    public static LocalDate readDate(ClickHouseInputStream input) throws IOException {
        return LocalDate.ofEpochDay(BinaryStreamUtils.readUnsignedInt16(input));
    }

    public static void writeDate(OutputStream output, LocalDate value, TimeZone tz) throws IOException {
        if (tz != null && !tz.toZoneId().equals(ClickHouseValues.SYS_ZONE)) {
            value = value.atStartOfDay(tz.toZoneId()).withZoneSameInstant(ClickHouseValues.SYS_ZONE).toLocalDate();
        }
        BinaryStreamUtils.writeDate(output, value);
    }

    public static void writeDate(OutputStream output, LocalDate value) throws IOException {
        int days = (int)value.toEpochDay();
        BinaryStreamUtils.writeUnsignedInt16(output, ClickHouseChecker.between(days, "Date", 0, 65535));
    }

    public static LocalDate readDate32(ClickHouseInputStream input, TimeZone tz) throws IOException {
        LocalDate d = BinaryStreamUtils.readDate32(input);
        if (tz != null && !tz.toZoneId().equals(ClickHouseValues.SYS_ZONE)) {
            d = d.atStartOfDay(ClickHouseValues.SYS_ZONE).withZoneSameInstant(tz.toZoneId()).toLocalDate();
        }
        return d;
    }

    public static LocalDate readDate32(ClickHouseInputStream input) throws IOException {
        return LocalDate.ofEpochDay(BinaryStreamUtils.readInt32(input));
    }

    public static void writeDate32(OutputStream output, LocalDate value, TimeZone tz) throws IOException {
        if (tz != null && !tz.toZoneId().equals(ClickHouseValues.SYS_ZONE)) {
            value = value.atStartOfDay(tz.toZoneId()).withZoneSameInstant(ClickHouseValues.SYS_ZONE).toLocalDate();
        }
        BinaryStreamUtils.writeDate32(output, value);
    }

    public static void writeDate32(OutputStream output, LocalDate value) throws IOException {
        BinaryStreamUtils.writeInt32(output, ClickHouseChecker.between((int)value.toEpochDay(), "Date", DATE32_MIN, DATE32_MAX));
    }

    public static LocalDateTime readDateTime(ClickHouseInputStream input, TimeZone tz) throws IOException {
        return BinaryStreamUtils.readDateTime(input, 0, tz);
    }

    public static LocalDateTime readDateTime(ClickHouseInputStream input, int scale, TimeZone tz) throws IOException {
        return ClickHouseChecker.between(scale, "scale", 0, ClickHouseDataType.DateTime64.getMaxScale()) == 0 ? BinaryStreamUtils.readDateTime32(input, tz) : BinaryStreamUtils.readDateTime64(input, scale, tz);
    }

    public static void writeDateTime(OutputStream output, LocalDateTime value, TimeZone tz) throws IOException {
        BinaryStreamUtils.writeDateTime(output, value, 0, tz);
    }

    public static void writeDateTime(OutputStream output, LocalDateTime value, int scale, TimeZone tz) throws IOException {
        if (ClickHouseChecker.between(scale, "scale", 0, ClickHouseDataType.DateTime64.getMaxScale()) == 0) {
            BinaryStreamUtils.writeDateTime32(output, value, tz);
        } else {
            BinaryStreamUtils.writeDateTime64(output, value, scale, tz);
        }
    }

    public static LocalDateTime readDateTime32(ClickHouseInputStream input, TimeZone tz) throws IOException {
        long time = BinaryStreamUtils.readUnsignedInt32(input);
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(time < 0L ? 0L : time), tz != null ? tz.toZoneId() : ClickHouseValues.UTC_ZONE);
    }

    public static void writeDateTime32(OutputStream output, LocalDateTime value, TimeZone tz) throws IOException {
        long time = tz == null || tz.equals(ClickHouseValues.UTC_TIMEZONE) ? value.toEpochSecond(ZoneOffset.UTC) : value.atZone(tz.toZoneId()).toEpochSecond();
        BinaryStreamUtils.writeUnsignedInt32(output, ClickHouseChecker.between(time, "DateTime", 0L, 4294967295000L));
    }

    public static LocalDateTime readDateTime64(ClickHouseInputStream input, TimeZone tz) throws IOException {
        return BinaryStreamUtils.readDateTime64(input, 3, tz);
    }

    public static LocalDateTime readDateTime64(ClickHouseInputStream input, int scale, TimeZone tz) throws IOException {
        long value = BinaryStreamUtils.readInt64(input);
        int nanoSeconds = 0;
        if (ClickHouseChecker.between(scale, "scale", 0, 9) > 0) {
            int factor = BASES[scale];
            nanoSeconds = (int)(value % (long)factor);
            value /= (long)factor;
            if (nanoSeconds < 0) {
                nanoSeconds += factor;
                --value;
            }
            if ((long)nanoSeconds > 0L) {
                nanoSeconds *= BASES[9 - scale];
            }
        }
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(value, nanoSeconds), tz != null ? tz.toZoneId() : ClickHouseValues.UTC_ZONE);
    }

    public static void writeDateTime64(OutputStream output, LocalDateTime value, TimeZone tz) throws IOException {
        BinaryStreamUtils.writeDateTime64(output, value, 3, tz);
    }

    public static void writeDateTime64(OutputStream output, LocalDateTime value, int scale, TimeZone tz) throws IOException {
        long v = ClickHouseChecker.between(tz == null || tz.equals(ClickHouseValues.UTC_TIMEZONE) ? value.toEpochSecond(ZoneOffset.UTC) : value.atZone(tz.toZoneId()).toEpochSecond(), "DateTime", DATETIME64_MIN, scale == 9 ? DATETIME64_9_MAX : DATETIME64_MAX);
        if (ClickHouseChecker.between(scale, "scale", 0, 9) > 0) {
            v *= (long)BASES[scale];
            int nanoSeconds = value.getNano();
            if ((long)nanoSeconds > 0L) {
                v += (long)(nanoSeconds / BASES[9 - scale]);
            }
        }
        BinaryStreamUtils.writeInt64(output, v);
    }

    public static String readFixedString(ClickHouseInputStream input, int length) throws IOException {
        return BinaryStreamUtils.readFixedString(input, length, null);
    }

    public static String readFixedString(ClickHouseInputStream input, int length, Charset charset) throws IOException {
        return input.readBuffer(length).asString(charset);
    }

    public static void writeFixedString(OutputStream output, String value, int length) throws IOException {
        BinaryStreamUtils.writeFixedString(output, value, length, null);
    }

    public static void writeFixedString(OutputStream output, String value, int length, Charset charset) throws IOException {
        byte[] src = ClickHouseChecker.notLongerThan(value.getBytes(charset == null ? StandardCharsets.UTF_8 : charset), "value", length);
        byte[] bytes = new byte[length];
        System.arraycopy(src, 0, bytes, 0, src.length);
        output.write(bytes);
    }

    public static String readString(Reader input, int length) throws IOException {
        return new String(BinaryStreamUtils.readCharacters(input, length));
    }

    public static void writeString(OutputStream output, String value) throws IOException {
        BinaryStreamUtils.writeString(output, value, null);
    }

    public static void writeString(OutputStream output, String value, Charset charset) throws IOException {
        byte[] bytes = value.getBytes(charset == null ? StandardCharsets.UTF_8 : charset);
        BinaryStreamUtils.writeVarInt(output, (long)bytes.length);
        output.write(bytes);
    }

    public static void writeString(OutputStream output, byte[] value) throws IOException {
        BinaryStreamUtils.writeVarInt(output, (long)value.length);
        output.write(value);
    }

    public static int readVarInt(InputStream input) throws IOException {
        long result = 0L;
        int shift = 0;
        for (int i = 0; i < 9; ++i) {
            int b = input.read();
            if (b == -1) {
                try {
                    input.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new EOFException();
            }
            result |= (long)((b & 0x7F) << shift);
            if ((b & 0x80) == 0) break;
            shift += 7;
        }
        return (int)result;
    }

    public static int readVarInt(ByteBuffer buffer) {
        long result = 0L;
        int shift = 0;
        for (int i = 0; i < 9; ++i) {
            byte b = buffer.get();
            result |= (long)((b & 0x7F) << shift);
            if ((b & 0x80) == 0) break;
            shift += 7;
        }
        return (int)result;
    }

    public static void writeVarInt(OutputStream output, long value) throws IOException {
        for (int i = 0; i < 9; ++i) {
            byte b = (byte)(value & 0x7FL);
            if (value > 127L) {
                b = (byte)(b | 0x80);
            }
            output.write(b);
            if ((value >>= 7) != 0L) continue;
            return;
        }
    }

    public static void writeVarInt(ByteBuffer buffer, int value) {
        while ((value & 0xFFFFFF80) != 0) {
            buffer.put((byte)(value & 0x7F | 0x80));
            value >>>= 7;
        }
        buffer.put((byte)(value & 0x7F));
    }

    private BinaryStreamUtils() {
    }
}

