/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Iterator;
import net.sf.saxon.Controller;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Value;

public abstract class SimpleExpression
extends ComputedExpression {
    public static final Expression[] NO_ARGUMENTS = new Expression[0];
    protected Expression[] arguments = NO_ARGUMENTS;

    public void setArguments(Expression[] expressionArray) {
        this.arguments = expressionArray;
        for (int i = 0; i < expressionArray.length; ++i) {
            this.adoptChildExpression(expressionArray[i]);
        }
    }

    public Iterator iterateSubExpressions() {
        return Arrays.asList(this.arguments).iterator();
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        for (int i = 0; i < this.arguments.length; ++i) {
            if (this.arguments[i] == null) continue;
            this.arguments[i] = this.arguments[i].simplify(staticContext);
        }
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        for (int i = 0; i < this.arguments.length; ++i) {
            if (this.arguments[i] == null) continue;
            this.arguments[i] = this.arguments[i].typeCheck(staticContext, itemType);
        }
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        for (int i = 0; i < this.arguments.length; ++i) {
            if (this.arguments[i] == null) continue;
            this.arguments[i] = this.arguments[i].optimize(optimizer, staticContext, itemType);
        }
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        for (int i = 0; i < this.arguments.length; ++i) {
            if (this.arguments[i] == null) continue;
            this.arguments[i] = this.doPromotion(this.arguments[i], promotionOffer);
        }
        return this;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return Type.ITEM_TYPE;
    }

    public int computeCardinality() {
        if ((this.getImplementationMethod() & 1) == 0) {
            return 49152;
        }
        return 24576;
    }

    public int computeDependencies() {
        return super.computeDependencies();
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        int n = this.getImplementationMethod();
        if ((n & 1) == 0) {
            if ((n & 2) != 0) {
                return this.iterate(xPathContext).next();
            }
            Controller controller = xPathContext.getController();
            XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
            xPathContextMinor.setOrigin(this);
            SequenceOutputter sequenceOutputter = new SequenceOutputter(1);
            sequenceOutputter.setPipelineConfiguration(controller.makePipelineConfiguration());
            xPathContextMinor.setTemporaryReceiver(sequenceOutputter);
            this.process(xPathContextMinor);
            return sequenceOutputter.getFirstItem();
        }
        this.dynamicError("evaluateItem() is not implemented in the subclass " + this.getClass(), xPathContext);
        return null;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        int n = this.getImplementationMethod();
        if ((n & 1) != 0) {
            Item item = this.evaluateItem(xPathContext);
            if (item == null) {
                return EmptyIterator.getInstance();
            }
            return SingletonIterator.makeIterator(item);
        }
        if ((n & 2) == 0) {
            Controller controller = xPathContext.getController();
            XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
            xPathContextMinor.setOrigin(this);
            SequenceOutputter sequenceOutputter = new SequenceOutputter();
            sequenceOutputter.setPipelineConfiguration(controller.makePipelineConfiguration());
            xPathContextMinor.setTemporaryReceiver(sequenceOutputter);
            this.process(xPathContextMinor);
            return Value.getIterator(sequenceOutputter.getSequence());
        }
        this.dynamicError("iterate() is not implemented in the subclass " + this.getClass(), xPathContext);
        return null;
    }

    public void process(XPathContext xPathContext) throws XPathException {
        int n = this.getImplementationMethod();
        if ((n & 1) == 0) {
            Item item;
            SequenceIterator sequenceIterator = this.iterate(xPathContext);
            while ((item = sequenceIterator.next()) != null) {
                xPathContext.getReceiver().append(item, this.locationId, 2);
            }
        } else {
            Item item = this.evaluateItem(xPathContext);
            xPathContext.getReceiver().append(item, this.locationId, 2);
        }
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + this.getExpressionType());
        for (int i = 0; i < this.arguments.length; ++i) {
            this.arguments[i].display(n + 1, namePool, printStream);
        }
    }

    public String getExpressionType() {
        return this.getClass().getName();
    }
}

