/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.algo.sequence.rmq;

import java.util.Comparator;
import org.psjava.algo.sequence.rmq.RangeMinimumQuery;
import org.psjava.algo.sequence.rmq.RangeMinimumQuerySession;
import org.psjava.algo.sequence.rmq.RangeMinimumQueryUtil;
import org.psjava.ds.array.Array;
import org.psjava.ds.array.MutableArray;
import org.psjava.ds.array.MutableArrayFactory;
import org.psjava.ds.math.BinaryOperator;
import org.psjava.ds.tree.segmenttree.SegmentTree;
import org.psjava.ds.tree.segmenttree.SegmentTreeFactory;
import org.psjava.util.AssertStatus;
import org.psjava.util.ZeroTo;

public class RangeMinimumQueryUsingSegmentTree {
    public static RangeMinimumQuery getInstance(final SegmentTreeFactory treeFactory) {
        return new RangeMinimumQuery(){

            @Override
            public <T> RangeMinimumQuerySession preprocess(final Array<T> a, final Comparator<T> comp) {
                MutableArray<Integer> indexes = MutableArrayFactory.create(a.size(), 0);
                for (int i : ZeroTo.get(a.size())) {
                    indexes.set(i, i);
                }
                final SegmentTree<Integer> tree = treeFactory.create(indexes, new BinaryOperator<Integer>(){

                    @Override
                    public Integer calc(Integer i1, Integer i2) {
                        return RangeMinimumQueryUtil.selectSmallestIndex(a, i1, i2, comp);
                    }
                });
                return new RangeMinimumQuerySession(){

                    @Override
                    public int getIndex(int start, int end) {
                        AssertStatus.assertTrue(start < end);
                        return (Integer)tree.query(start, end);
                    }
                };
            }
        };
    }

    private RangeMinimumQueryUsingSegmentTree() {
    }
}

