/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.projects.xp;

import java.util.Collections;
import org.apache.hop.core.config.HopConfig;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.projects.config.ProjectsConfig;
import org.apache.hop.projects.config.ProjectsConfigSingleton;
import org.apache.hop.projects.project.Project;
import org.apache.hop.projects.project.ProjectConfig;
import org.apache.hop.ui.hopgui.HopGui;

@ExtensionPoint(id="HopImportCreateProject", description="Creates a new project for a project path specified in Hop Import", extensionPointId="HopImportCreateProject")
public class HopImportCreateProjectIfNotExists
implements IExtensionPoint<String> {
    public void callExtensionPoint(ILogChannel iLogChannel, IVariables variables, String projectPath) throws HopException {
        String projectName = "Hop Import Project";
        String envName = "Hop Import Environment";
        HopGui hopGui = HopGui.getInstance();
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        if (!StringUtil.isEmpty((String)projectPath)) {
            String defaultProjectConfigFilename = variables.resolve(config.getDefaultProjectConfigFile());
            ProjectConfig projectConfig = new ProjectConfig(projectName, projectPath, defaultProjectConfigFilename);
            Project project = new Project();
            project.getDescribedVariables().clear();
            project.modifyVariables(variables, projectConfig, Collections.emptyList(), null);
            project.setConfigFilename(projectPath + System.getProperty("file.separator") + "project-config.json");
            config.addProjectConfig(projectConfig);
            HopConfig.getInstance().saveToFile();
            project.saveToFile();
        }
    }
}

