/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.providers;

import com.google.auto.service.AutoService;
import com.google.auto.value.AutoValue;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.GenerateSequence;
import org.apache.beam.sdk.providers.AutoValue_GenerateSequenceSchemaTransformProvider_GenerateSequenceConfiguration;
import org.apache.beam.sdk.providers.AutoValue_GenerateSequenceSchemaTransformProvider_GenerateSequenceConfiguration_Rate;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

@AutoService(value={SchemaTransformProvider.class})
public class GenerateSequenceSchemaTransformProvider
extends TypedSchemaTransformProvider<GenerateSequenceConfiguration> {
    public static final @UnknownKeyFor @NonNull @Initialized String OUTPUT_ROWS_TAG = "output";
    public static final @UnknownKeyFor @NonNull @Initialized Schema OUTPUT_SCHEMA = Schema.builder().addInt64Field("value").build();

    @Override
    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "beam:schematransform:org.apache.beam:generate_sequence:v1";
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Collections.emptyList();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Collections.singletonList(OUTPUT_ROWS_TAG);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String description() {
        return String.format("Outputs a PCollection of Beam Rows, each containing a single INT64 number called \"value\". The count is produced from the given \"start\" value and either up to the given \"end\" or until 2^63 - 1.%nTo produce an unbounded PCollection, simply do not specify an \"end\" value. Unbounded sequences can specify a \"rate\" for output elements.%nIn all cases, the sequence of numbers is generated in parallel, so there is no inherent ordering between the generated values", new Object[0]);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized GenerateSequenceConfiguration> configurationClass() {
        return GenerateSequenceConfiguration.class;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized GenerateSequenceConfiguration configuration) {
        return new GenerateSequenceSchemaTransform(configuration);
    }

    protected static class GenerateSequenceSchemaTransform
    extends SchemaTransform {
        private final @UnknownKeyFor @NonNull @Initialized GenerateSequenceConfiguration configuration;

        GenerateSequenceSchemaTransform(@UnknownKeyFor @NonNull @Initialized GenerateSequenceConfiguration configuration) {
            configuration.validate();
            this.configuration = configuration;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
            Preconditions.checkArgument((boolean)input.getAll().isEmpty(), (String)"Expected no inputs but got: %s", input.getAll().keySet());
            Long end = Optional.ofNullable(this.configuration.getEnd()).orElse(-1L);
            GenerateSequenceConfiguration.Rate rate = this.configuration.getRate();
            GenerateSequence sequence = GenerateSequence.from(this.configuration.getStart()).to(end);
            if (rate != null) {
                sequence = sequence.withRate(rate.getElements(), Duration.standardSeconds((long)Optional.ofNullable(rate.getSeconds()).orElse(1L)));
            }
            return PCollectionRowTuple.of(GenerateSequenceSchemaTransformProvider.OUTPUT_ROWS_TAG, ((PCollection)((Object)input.getPipeline().apply(sequence).apply(MapElements.into(TypeDescriptors.rows()).via(l -> Row.withSchema(OUTPUT_SCHEMA).withFieldValue("value", l).build())))).setRowSchema(OUTPUT_SCHEMA));
        }
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    public static abstract class GenerateSequenceConfiguration {
        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_GenerateSequenceSchemaTransformProvider_GenerateSequenceConfiguration.Builder();
        }

        @SchemaFieldDescription(value="The minimum number to generate (inclusive).")
        public abstract @UnknownKeyFor @NonNull @Initialized Long getStart();

        @SchemaFieldDescription(value="The maximum number to generate (exclusive). Will be an unbounded sequence if left unspecified.")
        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Long getEnd();

        @SchemaFieldDescription(value="Specifies the rate to generate a given number of elements per a given number of seconds. Applicable only to unbounded sequences.")
        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Rate getRate();

        public void validate() {
            Rate rate;
            Preconditions.checkNotNull((Object)this.getStart(), (Object)"Must specify a starting point \"start\".");
            Long start = this.getStart();
            Long end = this.getEnd();
            if (end != null) {
                Preconditions.checkArgument((end == -1L || end >= start ? 1 : 0) != 0, (String)"Invalid range [%s, %s)", (Object)start, (Object)end);
            }
            if ((rate = this.getRate()) != null) {
                Preconditions.checkArgument((rate.getElements() > 0L ? 1 : 0) != 0, (String)"Invalid rate specification. Expected positive elements component but received %s.", (Object)rate.getElements());
                Preconditions.checkArgument((Optional.ofNullable(rate.getSeconds()).orElse(1L) > 0L ? 1 : 0) != 0, (String)"Invalid rate specification. Expected positive seconds component but received %s.", (Object)rate.getSeconds());
            }
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setStart(@UnknownKeyFor @NonNull @Initialized Long var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setEnd(@UnknownKeyFor @NonNull @Initialized Long var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setRate(@UnknownKeyFor @NonNull @Initialized Rate var1);

            public abstract @UnknownKeyFor @NonNull @Initialized GenerateSequenceConfiguration build();
        }

        @AutoValue
        public static abstract class Rate {
            @SchemaFieldDescription(value="Number of elements component of the rate.")
            public abstract @UnknownKeyFor @NonNull @Initialized Long getElements();

            @SchemaFieldDescription(value="Number of seconds component of the rate.")
            @Nullable
            public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Long getSeconds();

            public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
                return new AutoValue_GenerateSequenceSchemaTransformProvider_GenerateSequenceConfiguration_Rate.Builder();
            }

            @AutoValue.Builder
            public static abstract class Builder {
                public abstract @UnknownKeyFor @NonNull @Initialized Builder setElements(@UnknownKeyFor @NonNull @Initialized Long var1);

                public abstract @UnknownKeyFor @NonNull @Initialized Builder setSeconds(@UnknownKeyFor @NonNull @Initialized Long var1);

                public abstract @UnknownKeyFor @NonNull @Initialized Rate build();
            }
        }
    }
}

