/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.reads.thresholds;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.ParamType;
import org.apache.cassandra.service.reads.thresholds.WarnAbortCounter;
import org.apache.cassandra.service.reads.thresholds.WarningsSnapshot;

public class WarningContext {
    private static EnumSet<ParamType> SUPPORTED = EnumSet.of(ParamType.TOMBSTONE_WARNING, new ParamType[]{ParamType.TOMBSTONE_FAIL, ParamType.LOCAL_READ_SIZE_WARN, ParamType.LOCAL_READ_SIZE_FAIL, ParamType.ROW_INDEX_READ_SIZE_WARN, ParamType.ROW_INDEX_READ_SIZE_FAIL});
    final WarnAbortCounter tombstones = new WarnAbortCounter();
    final WarnAbortCounter localReadSize = new WarnAbortCounter();
    final WarnAbortCounter rowIndexReadSize = new WarnAbortCounter();

    public static boolean isSupported(Set<ParamType> keys) {
        return !Collections.disjoint(keys, SUPPORTED);
    }

    public RequestFailureReason updateCounters(Map<ParamType, Object> params, InetAddressAndPort from) {
        for (Map.Entry<ParamType, Object> entry : params.entrySet()) {
            WarnAbortCounter counter = null;
            RequestFailureReason reason = null;
            switch (entry.getKey()) {
                case ROW_INDEX_READ_SIZE_FAIL: {
                    reason = RequestFailureReason.READ_SIZE;
                }
                case ROW_INDEX_READ_SIZE_WARN: {
                    counter = this.rowIndexReadSize;
                    break;
                }
                case LOCAL_READ_SIZE_FAIL: {
                    reason = RequestFailureReason.READ_SIZE;
                }
                case LOCAL_READ_SIZE_WARN: {
                    counter = this.localReadSize;
                    break;
                }
                case TOMBSTONE_FAIL: {
                    reason = RequestFailureReason.READ_TOO_MANY_TOMBSTONES;
                }
                case TOMBSTONE_WARNING: {
                    counter = this.tombstones;
                }
            }
            if (reason != null) {
                counter.addAbort(from, ((Number)entry.getValue()).longValue());
                return reason;
            }
            if (counter == null) continue;
            counter.addWarning(from, ((Number)entry.getValue()).longValue());
        }
        return null;
    }

    public WarningsSnapshot snapshot() {
        return WarningsSnapshot.create(this.tombstones.snapshot(), this.localReadSize.snapshot(), this.rowIndexReadSize.snapshot());
    }
}

