/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.code;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JavaScriptCodeFixer {
    private static final Logger log = LoggerFactory.getLogger(JavaScriptCodeFixer.class);

    JavaScriptCodeFixer() {
    }

    static String fixIfNoLogToConsole(String code) {
        if (code.contains("\n")) {
            return JavaScriptCodeFixer.fixIfNoLogToConsole(code, "\n");
        }
        return JavaScriptCodeFixer.fixIfNoLogToConsole(code, " ");
    }

    private static String fixIfNoLogToConsole(String code, String separator) {
        CharSequence[] parts = code.split(separator);
        String lastPart = parts[parts.length - 1];
        if (lastPart.startsWith("console.log")) {
            return code;
        }
        parts[parts.length - 1] = "console.log(" + lastPart.replace(";", "") + ");";
        String fixedCode = String.join((CharSequence)separator, parts);
        log.debug("The following code \"{}\" was fixed: \"{}\"", (Object)code, (Object)fixedCode);
        return fixedCode;
    }
}

