/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import com.google.common.base.Objects;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.streaming.PreviewKind;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.TimeUUID;
import org.apache.commons.lang3.ArrayUtils;

public class RepairJobDesc {
    public static final IVersionedSerializer<RepairJobDesc> serializer = new RepairJobDescSerializer();
    public final TimeUUID parentSessionId;
    public final TimeUUID sessionId;
    public final String keyspace;
    public final String columnFamily;
    public final Collection<Range<Token>> ranges;

    public RepairJobDesc(TimeUUID parentSessionId, TimeUUID sessionId, String keyspace, String columnFamily, Collection<Range<Token>> ranges) {
        this.parentSessionId = parentSessionId;
        this.sessionId = sessionId;
        this.keyspace = keyspace;
        this.columnFamily = columnFamily;
        this.ranges = ranges;
    }

    public UUID determanisticId() {
        byte[] bytes = ByteBufferUtil.getArray(ByteBufferUtil.bytes(this.parentSessionId));
        bytes = ArrayUtils.addAll((byte[])bytes, (byte[])ByteBufferUtil.getArray(ByteBufferUtil.bytes(this.sessionId)));
        bytes = ArrayUtils.addAll((byte[])bytes, (byte[])this.keyspace.getBytes(StandardCharsets.UTF_8));
        bytes = ArrayUtils.addAll((byte[])bytes, (byte[])this.columnFamily.getBytes(StandardCharsets.UTF_8));
        bytes = ArrayUtils.addAll((byte[])bytes, (byte[])this.ranges.toString().getBytes(StandardCharsets.UTF_8));
        return UUID.nameUUIDFromBytes(bytes);
    }

    public String toString() {
        return "[repair #" + this.sessionId + " on " + this.keyspace + "/" + this.columnFamily + ", " + this.ranges + "]";
    }

    public String toString(PreviewKind previewKind) {
        return '[' + previewKind.logPrefix() + " #" + this.sessionId + " on " + this.keyspace + "/" + this.columnFamily + ", " + this.ranges + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepairJobDesc that = (RepairJobDesc)o;
        if (!this.columnFamily.equals(that.columnFamily)) {
            return false;
        }
        if (!this.keyspace.equals(that.keyspace)) {
            return false;
        }
        if (this.ranges != null ? that.ranges == null || this.ranges.size() != that.ranges.size() || this.ranges.size() == that.ranges.size() && !this.ranges.containsAll(that.ranges) : that.ranges != null) {
            return false;
        }
        if (!this.sessionId.equals(that.sessionId)) {
            return false;
        }
        return !(this.parentSessionId != null ? !this.parentSessionId.equals(that.parentSessionId) : that.parentSessionId != null);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.sessionId, this.keyspace, this.columnFamily, this.ranges});
    }

    private static class RepairJobDescSerializer
    implements IVersionedSerializer<RepairJobDesc> {
        private RepairJobDescSerializer() {
        }

        @Override
        public void serialize(RepairJobDesc desc, DataOutputPlus out, int version) throws IOException {
            out.writeBoolean(desc.parentSessionId != null);
            if (desc.parentSessionId != null) {
                desc.parentSessionId.serialize(out);
            }
            desc.sessionId.serialize(out);
            out.writeUTF(desc.keyspace);
            out.writeUTF(desc.columnFamily);
            IPartitioner.validate(desc.ranges);
            out.writeInt(desc.ranges.size());
            for (Range<Token> rt : desc.ranges) {
                AbstractBounds.tokenSerializer.serialize(rt, out, version);
            }
        }

        @Override
        public RepairJobDesc deserialize(DataInputPlus in, int version) throws IOException {
            TimeUUID parentSessionId = null;
            if (in.readBoolean()) {
                parentSessionId = TimeUUID.deserialize(in);
            }
            TimeUUID sessionId = TimeUUID.deserialize(in);
            String keyspace = in.readUTF();
            String columnFamily = in.readUTF();
            int nRanges = in.readInt();
            ArrayList<Range<Token>> ranges = new ArrayList<Range<Token>>(nRanges);
            for (int i = 0; i < nRanges; ++i) {
                Range range = (Range)AbstractBounds.tokenSerializer.deserialize(in, IPartitioner.global(), version);
                ranges.add(range);
            }
            return new RepairJobDesc(parentSessionId, sessionId, keyspace, columnFamily, ranges);
        }

        @Override
        public long serializedSize(RepairJobDesc desc, int version) {
            int size = TypeSizes.sizeof(desc.parentSessionId != null);
            if (desc.parentSessionId != null) {
                size = (int)((long)size + TimeUUID.sizeInBytes());
            }
            size = (int)((long)size + TimeUUID.sizeInBytes());
            size += TypeSizes.sizeof(desc.keyspace);
            size += TypeSizes.sizeof(desc.columnFamily);
            size += TypeSizes.sizeof(desc.ranges.size());
            for (Range<Token> rt : desc.ranges) {
                size = (int)((long)size + AbstractBounds.tokenSerializer.serializedSize(rt, version));
            }
            return size;
        }
    }
}

